/*
**  Public domain by Jeff Dunlop & Bob Stout
*/

#if !defined(__TURBOC__) && !defined(__SC__) && !defined(__POWERC)

#include "ftime.h"

#ifdef __ZTC__
 #pragma ZTC align 1
 #define DOS_GETFTIME dos_getftime
 #define DOS_SETFTIME dos_setftime
#else
 #pragma pack(1)
 #define DOS_GETFTIME _dos_getftime
 #define DOS_SETFTIME _dos_setftime
 #ifdef __WATCOMC__
  typedef unsigned short FTIME_T_;
 #else
  typedef unsigned FTIME_T_;
 #endif
#endif

int getftime (int handle, struct ftime *ftimep)
{
      int retval = 0;
      union
      {
            struct
            {
                  unsigned time;
                  unsigned date;
            } msc_time;
            struct ftime bc_time;
      } FTIME;

      if (0 == (retval = DOS_GETFTIME(handle,
            (FTIME_T_ *)&FTIME.msc_time.date,
            (FTIME_T_ *)&FTIME.msc_time.time)))
      {
            *ftimep = FTIME.bc_time;
      }
      return retval;
}

int setftime (int handle, struct ftime *ftimep)
{
      union
      {
            struct
            {
                  unsigned time;
                  unsigned date;
            } msc_time;
            struct ftime bc_time;
      } FTIME;

      FTIME.bc_time = *ftimep;

      return DOS_SETFTIME(handle, FTIME.msc_time.date, FTIME.msc_time.time);
}

#endif
