/****************************************************************/
/* Name: noctrl()                                               */
/* Desc: captures interrupt 9 so as to ignore ctrl-c,ctrl-break,*/
/*       ctrl-alt-del                                           */
/****************************************************************/

#include <dos.h>
#include "pchwio.h"

extern void (INTERRUPT FAR *oldint9)(void);     /* Caller must set this */

void INTERRUPT FAR noctrl(void)
{
      unsigned char byte;
      static int flag;
 
      enable();
 
      if ((byte = (unsigned char)inp(0x60)) == 29)
            flag = 1;
 
      if (byte == 157)
            flag = 0;
 
      if (!flag)
            (*oldint9)();
      else  switch (byte)
      {
      case 46 :   /* yeah, these should be #defined! */
      case 70 :
      case 56 :
      case 83 :
            byte = (unsigned char)inp(0x61);
            outp(0x61,byte | 0x80);
            outp(0x61,byte);
            outp(0x20,0x20);
            break;
      default :
            (*oldint9)();
      }
}
