/*==========================================================================
 *
 *  !BESTLIB.H  360 functions                        Friday, August 26, 1994
 *
 *  Definitions for The BESTLibrary v2.31
 *  Designed for the Large memory model
 *
 *  Authored independently by George Vanous
 *  Email any comments, compliments, or suggestions to vanous@helix.net
 *
 *==========================================================================*/


/*  TABLE OF CONTENTS
------------------------
= FILE
    INI FILE
= KEYBOARD
= LINKED LIST
= MATH
    MATRIX
    2D VECTORS
    3D VECTORS
= MISCELLANEOUS
= MOUSE
= STRING
    CHARACTER
    CONVERSION
= TEXT MODE
    ANIMATION
    ATTRIBUTE
    CHARACTER
    CURSOR
    GET
    STRING
    WINDOW
= VGA
    VGA16
      IMAGE
        COMPRESS IMAGE
        PIXEL IMAGE
        PLANE IMAGE
    VGA256
------------------------*/

#if     !defined(__BESTLIB_DEF_)
#define __BESTLIB_DEF_

#include <stdio.h>         /* necessary for "fil_count" and "fil_count_reg" */

/* ------------------------------------------------------------------------ */
/* ---------------------------  COLOR CONSTANTS  -------------------------- */

#define BLACK        0x0                                              /* 00 */
#define BLUE         0x1                                              /* 01 */
#define GREEN        0x2                                              /* 02 */
#define CYAN         0x3                                              /* 03 */
#define RED          0x4                                              /* 04 */
#define MAGENTA      0x5                                              /* 05 */
#define BROWN        0x6                                              /* 06 */
#define LIGHTGREY    0x7                                              /* 07 */
#define DARKGREY     0x8                                              /* 08 */
#define LIGHTBLUE    0x9                                              /* 09 */
#define LIGHTGREEN   0xA                                              /* 10 */
#define LIGHTCYAN    0xB                                              /* 11 */
#define LIGHTRED     0xC                                              /* 12 */
#define LIGHTMAGENTA 0xD                                              /* 13 */
#define YELLOW       0xE                                              /* 14 */
#define WHITE        0xF                                              /* 15 */
#define BLINKCHAR    0x8   /* value to add to background color for blinking */

/* ------------------------------------------------------------------------ */
/* --------------------------  NUMBER CONSTANTS  -------------------------- */

#define ZERO      0x0                                                 /* 00 */
#define ONE       0x1                                                 /* 01 */
#define TWO       0x2                                                 /* 02 */
#define THREE     0x3                                                 /* 03 */
#define FOUR      0x4                                                 /* 04 */
#define FIVE      0x5                                                 /* 05 */
#define SIX       0x6                                                 /* 06 */
#define SEVEN     0x7                                                 /* 07 */
#define EIGHT     0x8                                                 /* 08 */
#define NINE      0x9                                                 /* 09 */
#define TEN       0xA                                                 /* 10 */
#define ELEVEN    0xB                                                 /* 11 */
#define TWELVE    0xC                                                 /* 12 */
#define THIRTEEN  0xD                                                 /* 13 */
#define FOURTEEN  0xE                                                 /* 14 */
#define FIFTEEN   0xF                                                 /* 15 */
#define SIXTEEN   0x10                                                /* 16 */
#define SEVENTEEN 0x11                                                /* 17 */
#define EIGHTEEN  0x12                                                /* 18 */
#define NINETEEN  0x13                                                /* 19 */
#define TWENTY    0x14                                                /* 20 */

#define PI        3.14159265358979323846    /* the venerable pi             */
#define PIby2     1.57079632679489661923    /* pi / 2 (180 degrees)         */
#define PIby4     0.785398163397448309616   /* pi / 4 ( 45 degrees)         */
#define E         2.71828182845904523536    /* the venerable e              */
#define SQRT2     1.41421356237309504880    /* sqrt(2)                      */
#define bySQRT2   0.707106781186547524401   /* 1 / sqrt(2)                  */
#define DtoR      0.017453292519943295769   /* convert degrees to radians   */
#define RtoD     57.2957795130823208768     /* convert radians to degrees   */

/* ------------------------------------------------------------------------ */
/* ----------------------  GENERAL-PURPOSE CONSTANTS  --------------------- */

#define BYTE_MAX     255   /* maximum value taken on by type "byte"         */
#define INT_MAX      32767 /* maximum value taken on by type "int"          */
#define SHORTINT_MAX 127   /* maximum value taken on by type "shortint"     */
#define WORD_MAX     65535L/* maximum value taken on by type "word"         */
#define LONGU_MAX 4294967295 /* max value taken on by type "unsigned long"  */
#define LONG_MAX  2147483647 /* maximum value taken on by type "long"       */
#define CR '\r'            /* carriage return character                     */
#define LF '\n'            /* linefeed character                            */
#define NO  -1             /* logical constant                              */
#define YES +1             /* logical constant                              */
#define NONE      0        /* logical constant                              */
#define OFF       0        /* logical constant                              */
#define ON       +1        /* logical constant                              */
#define BOTH     +2        /* logical constant                              */
#define UNMODIFY +2        /* logical constant                              */
#define FALSE 0            /* logical constant                              */
#define TRUE !(FALSE)      /* logical constant                              */
#define BACKWARD -1        /* logical constant                              */
#define FORWARD  +1        /* logical constant                              */
#define WARM 0x1234        /* warm boot identifier (like ctrl-alt-del)      */
#define COLD 0             /* cold boot identifier (like pressing reset)    */
#define MAX -1             /* logical constant                              */
#define MIN -2             /* logical constant                              */
#define MAXX        640    /* total screen x-length                         */
#define MAXXHALF    320    /* half screen x-length                          */
#define MAXMAXX     640    /* total (screen)+(virtual screen) x-length      */
#define MAXMAXXHALF 320    /* half (screen)+(virtual screen) x-length       */
#define MAXY        480    /* total screen y-height                         */
#define MAXYHALF    240    /* half screen y-height                          */
#define MAXMAXY     816    /* total (screen)+(virtual screen) y-height      */
#define MAXMAXYHALF 408    /* half (screen)+(virtual screen) y-height       */
#define WATCH_MAX   100    /* maximum number of stopwatches                 */
#define SIGNED  -1         /* signed number                                 */
#define UNSIGNED 1         /* unsigned number                               */
#define TCUR 255           /* text cursor                                   */
#define MCUR 254           /* mouse cursor                                  */
#define MEM  253           /* memory cursor
                              (coordinates are stored in memory)            */
#define TEXTSAVE  0        /* store text video memory                       */
#define TEXTSHOW  1        /* restore text video memory                     */
#define TEXT      1        /* text mode                                     */
#define TEXT25    3        /* 25-line text mode                             */
#define TEXT50    2        /* 50-line text mode                             */
#define TEXT25F  -1        /* forced 25-line text mode                      */
#define TEXT50F  -2        /* forced 50-line text mode                      */
#define VGA16    18        /* 640x480x16 graphics mode                      */
#define VGA256   19        /* 320x200x256 graphics mode                     */
#define TEXTPAGE1 0        /* text video page 1                             */
#define TEXTPAGE2 1        /* text video page 2                             */
#define TEXTPAGE3 2        /* text video page 3                             */
#define TEXTPAGE4 3        /* text video page 4                             */
#define TEXTPAGE5 4        /* text video page 5                             */
#define TEXTPAGE6 5        /* text video page 6                             */
#define TEXTPAGE7 6        /* text video page 7                             */
#define TEXTPAGE8 7        /* text video page 8                             */
#define TEXTPAGELAST   16  /* last video page: 4 for 50 line, 8 for 25 line */
#define TEXTPAGEACTIVE -1  /* current active text video page                */
#define TEXTPAGEVISUAL -2  /* current visual text video page                */
#define TEXTIMAGE_OVERHEAD 8 /* byte overhead in "textimagedata"ed objects  */
#define TOP    1           /* top (same as up)                              */
#define UP     1           /* upward direction                              */
#define LEFT   2           /* leftward direction                            */
#define RIGHT  4           /* rightward direction                           */
#define DOWN   8           /* downward direction                            */
#define BOTTOM 8           /* bottom (same as down)                         */
#define ALIGN_NONE  -1	   /* perform no alignment when outputting text     */
#define ALIGN_HORZ   0	   /* horizontal center, shifting odd length left   */
#define ALIGN_VERT   1	   /* vertical center, shifting odd length up	    */
#define ALIGN_CENTER 2	   /* horizontal and vertical center                */
#define ALIGN_RIGHT  3     /* right justify text                            */
#define COPY_IMAGE 0x0003  /* hexadecimal code for performing a direct copy */
#define AND_IMAGE  0x0803  /* hexadecimal code for performing a logical AND */
#define OR_IMAGE   0x1003  /* hexadecimal code for performing a locical OR  */
#define XOR_IMAGE  0x1803  /* hexadecimal code for doing an eXclusive OR    */
#define COPY_IMAGE_SET 0x0013  /* perform a direct copy and set to scroll   */
#define AND_IMAGE_SET  0x0813  /* perform a logical AND and set to scroll   */
#define OR_IMAGE_SET   0x1013  /* perform a locical OR  and set to scroll   */
#define XOR_IMAGE_SET  0x1813  /* perform an eXclusive OR and set to scroll */

/* ------------------------------------------------------------------------ */
/* ------------------------  ASCII CODE CONSTANTS  ------------------------ */

#define BACKSPACE   0x08                              /* backspace keypress */
#define ESC         0x1B                                    /* ESC keypress */
#define SPACE       0x20                                               /*   */
#define QUOTE       0x22                                               /* " */
#define APOSTROPHE  0x27                                               /* ' */
#define HYPHEN      0x2D                                               /* - */
#define BLOCK_SOLID 0xDB                                               /*  */

/* ------------------------------------------------------------------------ */
/* -------------------------  SCAN CODE CONSTANTS  ------------------------ */

#define SCAN_NONE                  0x00                              /*   0 */
#define SCAN_ESC                   0x01                              /*   1 */
#define SCAN_1                     0x02                              /*   2 */
#define SCAN_2                     0x03                              /*   3 */
#define SCAN_3                     0x04                              /*   4 */
#define SCAN_4                     0x05                              /*   5 */
#define SCAN_5                     0x06                              /*   6 */
#define SCAN_6                     0x07                              /*   7 */
#define SCAN_7                     0x08                              /*   8 */
#define SCAN_8                     0x09                              /*   9 */
#define SCAN_9                     0x0A                              /*  10 */
#define SCAN_0                     0x0B                              /*  11 */
#define SCAN_HYPHEN                0x0C                              /*  12 */
#define SCAN_EQUAL                 0x0D                              /*  13 */
#define SCAN_BACKSPACE             0x0E                              /*  14 */
#define SCAN_TAB                   0x0F                              /*  15 */
#define SCAN_Q                     0x10                              /*  16 */
#define SCAN_W                     0x11                              /*  17 */
#define SCAN_E                     0x12                              /*  18 */
#define SCAN_R                     0x13                              /*  19 */
#define SCAN_T                     0x14                              /*  20 */
#define SCAN_Y                     0x15                              /*  21 */
#define SCAN_U                     0x16                              /*  22 */
#define SCAN_I                     0x17                              /*  23 */
#define SCAN_O                     0x18                              /*  24 */
#define SCAN_P                     0x19                              /*  25 */
#define SCAN_BRACKET_LEFT          0x1A                              /*  26 */
#define SCAN_BRACKET_RIGHT         0x1B                              /*  27 */
#define SCAN_ENTER                 0x1C                              /*  28 */
#define SCAN_CTRL                  0x1D                              /*  29 */
#define SCAN_A                     0x1E                              /*  30 */
#define SCAN_S                     0x1F                              /*  31 */
#define SCAN_D                     0x20                              /*  32 */
#define SCAN_F                     0x21                              /*  33 */
#define SCAN_G                     0x22                              /*  34 */
#define SCAN_H                     0x23                              /*  35 */
#define SCAN_J                     0x24                              /*  36 */
#define SCAN_K                     0x25                              /*  37 */
#define SCAN_L                     0x26                              /*  38 */
#define SCAN_SEMICOLON             0x27                              /*  39 */
#define SCAN_QUOTE                 0x28                              /*  40 */
#define SCAN_BACKQUOTE             0x29                              /*  41 */
#define SCAN_SHIFT_LEFT            0x2A                              /*  42 */
#define SCAN_BACKSLASH             0x2B                              /*  43 */
#define SCAN_Z                     0x2C                              /*  44 */
#define SCAN_X                     0x2D                              /*  45 */
#define SCAN_C                     0x2E                              /*  46 */
#define SCAN_V                     0x2F                              /*  47 */
#define SCAN_B                     0x30                              /*  48 */
#define SCAN_N                     0x31                              /*  49 */
#define SCAN_M                     0x32                              /*  50 */
#define SCAN_COMMA                 0x33                              /*  51 */
#define SCAN_PERIOD                0x34                              /*  52 */
#define SCAN_SLASH                 0x35                              /*  53 */
#define SCAN_SHIFT_RIGHT           0x36                              /*  54 */
#define SCAN_KEYPAD_ASTERISK       0x37                              /*  55 */
#define SCAN_ALT                   0x38                              /*  56 */
#define SCAN_SPACE                 0x39                              /*  57 */
#define SCAN_CAPSLOCK              0x3A                              /*  58 */
#define SCAN_F1                    0x3B                              /*  59 */
#define SCAN_F2                    0x3C                              /*  60 */
#define SCAN_F3                    0x3D                              /*  61 */
#define SCAN_F4                    0x3E                              /*  62 */
#define SCAN_F5                    0x3F                              /*  63 */
#define SCAN_F6                    0x40                              /*  64 */
#define SCAN_F7                    0x41                              /*  65 */
#define SCAN_F8                    0x42                              /*  66 */
#define SCAN_F9                    0x43                              /*  67 */
#define SCAN_F10                   0x44                              /*  68 */
#define SCAN_NUMLOCK               0x45                              /*  69 */
#define SCAN_SCROLLOCK             0x46                              /*  70 */
#define SCAN_HOME                  0x47                              /*  71 */
#define SCAN_UP                    0x48                              /*  72 */
#define SCAN_PGUP                  0x49                              /*  73 */
#define SCAN_KEYPAD_MINUS          0x4A                              /*  74 */
#define SCAN_LEFT                  0x4B                              /*  75 */
#define SCAN_KEYPAD_5              0x4C                              /*  76 */
#define SCAN_RIGHT                 0x4D                              /*  77 */
#define SCAN_KEYPAD_PLUS           0x4E                              /*  78 */
#define SCAN_END                   0x4F                              /*  79 */
#define SCAN_DOWN                  0x50                              /*  80 */
#define SCAN_PGDN                  0x51                              /*  81 */
#define SCAN_INSERT                0x52                              /*  82 */
#define SCAN_DELETE                0x53                              /*  83 */
#define SCAN_SHIFT_F1              0x54                              /*  84 */
#define SCAN_SHIFT_F2              0x55                              /*  85 */
#define SCAN_SHIFT_F3              0x56                              /*  86 */
#define SCAN_SHIFT_F4              0x57                              /*  87 */
#define SCAN_SHIFT_F5              0x58                              /*  88 */
#define SCAN_SHIFT_F6              0x59                              /*  89 */
#define SCAN_SHIFT_F7              0x5A                              /*  90 */
#define SCAN_SHIFT_F8              0x5B                              /*  91 */
#define SCAN_SHIFT_F9              0x5C                              /*  92 */
#define SCAN_SHIFT_F10             0x5D                              /*  93 */
#define SCAN_CTRL_F1               0x5E                              /*  94 */
#define SCAN_CTRL_F2               0x5F                              /*  95 */
#define SCAN_CTRL_F3               0x60                              /*  96 */
#define SCAN_CTRL_F4               0x61                              /*  97 */
#define SCAN_CTRL_F5               0x62                              /*  98 */
#define SCAN_CTRL_F6               0x63                              /*  99 */
#define SCAN_CTRL_F7               0x64                              /* 100 */
#define SCAN_CTRL_F8               0x65                              /* 101 */
#define SCAN_CTRL_F9               0x66                              /* 102 */
#define SCAN_CTRL_F10              0x67                              /* 103 */
#define SCAN_ALT_F1                0x68                              /* 104 */
#define SCAN_ALT_F2                0x69                              /* 105 */
#define SCAN_ALT_F3                0x6A                              /* 106 */
#define SCAN_ALT_F4                0x6B                              /* 107 */
#define SCAN_ALT_F5                0x6C                              /* 108 */
#define SCAN_ALT_F6                0x6D                              /* 109 */
#define SCAN_ALT_F7                0x6E                              /* 110 */
#define SCAN_ALT_F8                0x6F                              /* 111 */
#define SCAN_ALT_F9                0x70                              /* 112 */
#define SCAN_ALT_F10               0x71                              /* 113 */
#define SCAN_CTRL_PRTSC            0x72                              /* 114 */
#define SCAN_CTRL_LEFT             0x73                              /* 115 */
#define SCAN_CTRL_RIGHT            0x74                              /* 116 */
#define SCAN_CTRL_END              0x75                              /* 117 */
#define SCAN_CTRL_PGDN             0x76                              /* 118 */
#define SCAN_CTRL_HOME             0x77                              /* 119 */
#define SCAN_ALT_1                 0x78                              /* 120 */
#define SCAN_ALT_2                 0x79                              /* 121 */
#define SCAN_ALT_3                 0x7A                              /* 122 */
#define SCAN_ALT_4                 0x7B                              /* 123 */
#define SCAN_ALT_5                 0x7C                              /* 124 */
#define SCAN_ALT_6                 0x7D                              /* 125 */
#define SCAN_ALT_7                 0x7E                              /* 126 */
#define SCAN_ALT_8                 0x7F                              /* 127 */
#define SCAN_ALT_9                 0x80                              /* 128 */
#define SCAN_ALT_0                 0x81                              /* 129 */
#define SCAN_ALT_HYPHEN            0x82                              /* 130 */
#define SCAN_ALT_EQUAL             0x83                              /* 131 */
#define SCAN_CTRL_PGUP             0x84                              /* 132 */
#define SCAN_F11                   0x85                              /* 133 */
#define SCAN_F12                   0x86                              /* 134 */
#define SCAN_SHIFT_F11             0x87                              /* 135 */
#define SCAN_SHIFT_F12             0x88                              /* 136 */
#define SCAN_CTRL_F11              0x89                              /* 137 */
#define SCAN_CTRL_F12              0x8A                              /* 138 */
#define SCAN_ALT_F11               0x8B                              /* 139 */
#define SCAN_ALT_F12               0x8C                              /* 140 */
#define SCAN_CTRL_UP               0x8D                              /* 141 */
#define SCAN_CTRL_KEYPAD_MINUS     0x8E                              /* 142 */
#define SCAN_CTRL_KEYPAD_5         0x8F                              /* 143 */
#define SCAN_CTRL_KEYPAD_PLUS      0x90                              /* 144 */
#define SCAN_CTRL_DOWN             0x91                              /* 145 */
#define SCAN_CTRL_INS              0x92                              /* 146 */
#define SCAN_CTRL_DEL              0x93                              /* 147 */
#define SCAN_CTRL_TAB              0x94                              /* 148 */
#define SCAN_CTRL_KEYPAD_SLASH     0x95                              /* 149 */
#define SCAN_CTRL_KEYPAD_ASTERISK  0x96                              /* 150 */
#define SCAN_ALT_HOME              0x97                              /* 151 */
#define SCAN_ALT_UP                0x98                              /* 152 */
#define SCAN_ALT_PGUP              0x99                              /* 153 */
//                                 0x9A                              /* 154 */
#define SCAN_ALT_LEFT              0x9B                              /* 155 */
//                                 0x9C                              /* 156 */
#define SCAN_ALT_RIGHT             0x9D                              /* 157 */
//                                 0x9E                              /* 158 */
#define SCAN_ALT_END               0x9F                              /* 159 */
#define SCAN_ALT_DOWN              0xA0                              /* 160 */
#define SCAN_ALT_PGDN              0xA1                              /* 161 */
#define SCAN_ALT_INS               0xA2                              /* 162 */
#define SCAN_ALT_DEL               0xA3                              /* 163 */
#define SCAN_ALT_SLASH             0xA4                              /* 164 */
#define SCAN_ALT_TAB               0xA5                              /* 165 */
#define SCAN_ALT_ENTER             0xA6                              /* 166 */
//                                 0xA7                              /* 167 */
//                                                                   /*     */
#define SCAN_CTRL_ENTER            0xE0                              /* 224 */

/* ------------------------------------------------------------------------ */
/* -----------------------  ASCII GRAPHIC CONSTANTS  ---------------------- */

#define HOUSE1L  0                                    /* house #1[left]     */
#define HOUSE1R  1                                    /* house #1[right]    */
#define TREE1    2                                    /* tree #1            */
#define CAR1L    3                                    /* car #1[left]       */
#define CAR1R    4                                    /* car #2[right]      */
#define DINO1L   5                                    /* dinosaur #1[left]  */
#define DINO1R   6                                    /* dinosaur #1[right] */
#define SHIP1N   7                                    /* ship #1[N]         */
#define SHIP1NE  8                                    /* ship #1[NE]        */
#define SHIP1E   9                                    /* ship #1[E]         */
#define SHIP1SE 10                                    /* ship #1[SE]        */
#define SHIP1S  11                                    /* ship #1[S]         */
#define SHIP1SW 12                                    /* ship #1[SW]        */
#define SHIP1W  13                                    /* ship #1[W]         */
#define SHIP1NW 14                                    /* ship #1[NW]        */
#define BIRD1   15                                    /* bird #1            */
#define DIAMON1 16                                    /* diamond #1         */
#define EXPLOS1 17                                    /* explosion #1       */
#define TOOTHG1 18                                    /* toothgrin #1       */
#define HOURGL1 19                                    /* hourglass #1       */
#define METEOR1 20                                    /* meteor #1          */
#define SPACES1 21                                    /* spaceship #1       */
#define BIKERL1 22                                    /* biker #1[left]     */
#define BIKERR1 23                                    /* biker #1[right]    */
#define FROWN1  24                                    /* frown #1           */
#define GRIN1   25                                    /* grin #1            */
#define LAMP1L  26                                    /* lamp #1[left]      */
#define LAMP1R  27                                    /* lamp #1[right]     */
#define SAILB1L 28                                    /* sailboat #1[left]  */
#define SAILB1R 29                                    /* sailboat #1[right] */
#define SHARK1L 30                                    /* shark #1[left]     */
#define SHARK1R 31                                    /* shark #1[right]    */
#define TARGET1 32                                    /* target #1          */
#define TRUCK1L 33                                    /* truck #1[left]     */
#define TRUCK1R 34                                    /* truck #1[right]    */
#define VAN1L   35                                    /* van #1[left]       */
#define VAN1R   36                                    /* van #1[right]      */
#define BALLO11 37                                    /* balloon #1[1]      */
#define BALLO12 38                                    /* balloon #1[2]      */
#define BALLO13 39                                    /* balloon #1[3]      */
#define SUN1    40                                    /* sun #1             */
#define FIGUR3L 41                                    /* figure #3[left]    */
#define FIGUR3R 42                                    /* figure #3[right]   */
#define FIGUR41 43                                    /* figure #4[1]       */
#define FIGUR42 44                                    /* figure #4[2]       */
#define FIGUR52 45                                    /* figure #5[2]       */
#define FISH1L  46                                    /* fish #1[left]      */
#define FISH1R  47                                    /* fish #1[right]     */
#define FISH2L  48                                    /* fish #2[left]      */
#define FISH2R  49                                    /* fish #2[right]     */
#define PLANE1L 50                                    /* plane #1[left]     */
#define PLANE1R 51                                    /* plane #1[right]    */
#define JET1L   52                                    /* jet #1[left]       */
#define JET1R   53                                    /* jet #1[right]      */

#define TARGET2 54                                    /* target #2          */
#define BOTTLE1 55                                    /* bottle #1          */
#define FIGUR1L 56                                    /* figure #1[left]    */
#define FIGUR1R 57                                    /* figure #1[right]   */
#define FIGUR2L 58                                    /* figure #2[left]    */
#define FIGUR2R 59                                    /* figure #2[right]   */
#define FIGUR51 60                                    /* figure #5[1]       */
#define FIGUR6L 61                                    /* figure #6[left]    */
#define FIGUR6R 62                                    /* figure #6[right]   */
#define MOON1L  63                                    /* moon #1[left]      */
#define MOON1R  64                                    /* moon #1[right]     */

/* ------------------------------------------------------------------------ */
/* ----------------------  ASCII GRAPHIC DEFINITIONS  --------------------- */

/*                           paste this array into the program that uses it
byte codes[] = {
  (word)HOUSE1L, 192,126,                             /* house #1[left]     */
  (word)HOUSE1R, 193,127,                             /* house #1[right]    */
  (word)TREE1  , 194,145,                             /* tree #1            */
  (word)CAR1L  , 195,146,                             /* car #1[left]       */
  (word)CAR1R  , 196,164,                             /* car #2[right]      */
  (word)DINO1L , 197,165,                             /* dinosaur #1[left]  */
  (word)DINO1R , 198,166,                             /* dinosaur #1[right] */
  (word)SHIP1N , 199,167,                             /* ship #1[N]         */
  (word)SHIP1NE, 200,168,                             /* ship #1[NE]        */
  (word)SHIP1E , 201,169,                             /* ship #1[E]         */
  (word)SHIP1SE, 202,170,                             /* ship #1[SE]        */
  (word)SHIP1S , 203,171,                             /* ship #1[S]         */
  (word)SHIP1SW, 204,172,                             /* ship #1[SW]        */
  (word)SHIP1W , 205,173,                             /* ship #1[W]         */
  (word)SHIP1NW, 206,174,                             /* ship #1[NW]        */
  (word)BIRD1  , 207,175,                             /* bird #1            */
  (word)DIAMON1, 208,179,                             /* diamond #1         */
  (word)EXPLOS1, 209,180,                             /* explosion #1       */
  (word)TOOTHG1, 210,181,                             /* toothgrin #1       */
  (word)HOURGL1, 211,182,                             /* hourglass #1       */
  (word)METEOR1, 212,183,                             /* meteor #1          */
  (word)SPACES1, 213,184,                             /* spaceship #1       */
  (word)BIKERL1, 214,185,                             /* biker #1[left]     */
  (word)BIKERR1, 215,186,                             /* biker #1[right]    */
  (word)FROWN1 , 216,187,                             /* frown #1           */
  (word)GRIN1  , 217,188,                             /* grin #1            */
  (word)LAMP1L , 218,189,                             /* lamp #1[left]      */
  (word)LAMP1R , 219,190,                             /* lamp #1[right]     */
  (word)SAILB1L, 220,191,                             /* sailboat #1[left]  */
  (word)SAILB1R, 221,224,                             /* sailboat #1[right] */
  (word)SHARK1L, 222,225,                             /* shark #1[left]     */
  (word)SHARK1R, 223,226,                             /* shark #1[right]    */

  (word)TARGET1, 192,126,                             /* target #1          */
  (word)TRUCK1L, 193,127,                             /* truck #1[left]     */
  (word)TRUCK1R, 194,145,                             /* truck #1[right]    */
  (word)VAN1L  , 195,146,                             /* van #1[left]       */
  (word)VAN1R  , 196,164,                             /* van #1[right]      */
  (word)BALLO11, 197,165,                             /* balloon #1[1]      */
  (word)BALLO12, 198,166,                             /* balloon #1[2]      */
  (word)BALLO13, 199,167,                             /* balloon #1[3]      */
  (word)SUN1   , 200,168,                             /* sun #1             */
  (word)FIGUR3L, 201,169,                             /* figure #3[left]    */
  (word)FIGUR3R, 202,170,                             /* figure #3[right]   */
  (word)FIGUR41, 203,171,                             /* figure #4[1]       */
  (word)FIGUR42, 204,172,                             /* figure #4[2]       */
  (word)FIGUR52, 205,173,                             /* figure #5[2]       */
  (word)FISH1L , 206,174,                             /* fish #1[left]      */
  (word)FISH1R , 207,175,                             /* fish #1[right]     */
  (word)FISH2L , 208,179,                             /* fish #2[left]      */
  (word)FISH2R , 209,180,                             /* fish #2[right]     */
  (word)PLANE1L, 210,181,                             /* plane #1[left]     */
  (word)PLANE1R, 211,182,                             /* plane #1[right]    */
  (word)JET1L  , 212,183,                             /* jet #1[left]       */
  (word)JET1R  , 213,184,                             /* jet #1[right]      */

  (word)TARGET2, 255,                                 /* target #2          */
  (word)BOTTLE1, 254,                                 /* bottle #1          */
  (word)FIGUR1L, 253,                                 /* figure #1[left]    */
  (word)FIGUR1R, 252,                                 /* figure #1[right]   */
  (word)FIGUR2L, 251,                                 /* figure #2[left]    */
  (word)FIGUR2R, 250,                                 /* figure #2[right]   */
  (word)FIGUR51, 249,                                 /* figure #5[1]       */
  (word)FIGUR6L, 248,                                 /* figure #6[left]    */
  (word)FIGUR6R, 247,                                 /* figure #6[right]   */
  (word)MOON1L , 246,                                 /* moon #1[left]      */
  (word)MOON1R , 245                                  /* moon #1[right]     */
}; */

/* ------------------------------------------------------------------------ */
/* ------------------------------  MESSAGES  ------------------------------ */

#define DASHES printf("\n--------------------------------------------------------------------------------")
#define DISTRIBUTE printf("\n-------------------------  DISTRIBUTION IS ENCOURAGED  -------------------------")
#define DOUBLESPACE printf("\n\n")
#define SINGLESPACE printf("\n")

/* ------------------------------------------------------------------------ */
/* -------------------------------  MACROS  ------------------------------- */

#define ischar(ch) (((ch >= 'A' && ch <= 'Z') || (ch >= 'a' && ch <= 'z') || ch == APOSTROPHE || ch == HYPHEN) ? TRUE : FALSE)
/* RETURNS:  TRUE if 'ch' is a valid character used in words
            FALSE if 'ch' is not a valid character used in words            */

/*----------------------------------------------------------------------------
 * ONE-ARGUMENT MACROS                                                      */

/* absolute value of a */
#define ABS(a)     (((a)<0) ? -(a) : (a))

/* round a to nearest integer towards 0 */
#define FLOOR(a)   ((a)>0 ? (int)(a) : -(int)(-a))

/* round a to nearest integer away from 0 */
#define CEILING(a) ( (a) == (int)(a) ? (a) \
                   : (a) > 0 ? 1+(int)(a) : -( 1+(int)(-a) ))

/* round a to nearest int */
#define ROUND(a)   (((a) > 0) ? (int)(a+0.5) : -(int)(0.5-a))

/* take sign of a, either -1, 0, or 1 */
#define ZSGN(a)    (((a) < 0) ? -1 : (a) > 0 ? 1 : 0)

/* take binary sign of a, either -1, or 1 if >= 0 */
#define SGN(a)     (((a) < 0) ? -1 : 1)

/* shout if something that should be true isn't */
#define ASSERT(x)  if (!(x)) fprintf(stderr," Assert failed: x\n");

/* square a */
#define SQR(a)     ((a)*(a))

/*----------------------------------------------------------------------------
 * TWO-ARGUMENT MACROS                                                      */

/* return minimum of a and b */
#define MINIMUM(a,b)    ( ((a) < (b)) ? (a) : (b) )

/* return maximum of a and b */
#define MAXIMUM(a,b)    ( ((a) > (b)) ? (a) : (b) )

/* swap a and b (see Gem by Wyvill) */
#define SWAP(a,b)       { a^=b; b^=a; a^=b; }

/* linear interpolation from l (when a=0) to h (when a=1) */
/* (equal to (a*h) + ( (1-a) * l)                         */
#define LERP(a,l,h)     ( (l) + (((h)-(l)) * (a)) )

/* clamp the input to the specified range */
#define CLAMP(v,l,h)    ( (v) < (l) ? (l) : (v) > (h) ? (h) : v)

/*----------------------------------------------------------------------------
 * MEMORY ALLOCATION MACROS                                                 */

/* create a new instance of a structure (see Gem by Hultquist) */
#define NEWSTRUCT(x) (struct x *) (malloc( (unsigned)sizeof(struct x) ))

/* create a new instance of a type */
#define NEWTYPE(x) (x *) (malloc( (unsigned)sizeof(x) ))

/* ------------------------------------------------------------------------ */
/* --------------------------  TYPE DEFINITIONS  -------------------------- */

typedef unsigned char boolean;          /* TRUE or FALSE type as in Pascal  */
typedef boolean flag;                   /* flag data type                   */
typedef unsigned char byte;             /* (0-255) type as in Pascal        */
typedef signed char shortint;           /* (-128 to +127) type as in Pascal */
typedef unsigned int word;              /* (0-65535) type as in Pascal      */

typedef struct {
  char ascii;          /* ASCII code of character pressed                   */
  byte scan;           /* SCAN code of character pressed                    */
} asciiscan;

typedef struct {
  byte y;              /* ordinate                                          */
  byte x;              /* abscissa                                          */
  byte start;          /* starting scan line                                */
  byte end;            /* ending scan line                                  */
  boolean on;          /* TRUE if text cursor is on, FALSE if it is not on  */
} cursordata;

typedef struct document_def {
  char  *line;                  /* pointer to a line of the document        */
  struct document_def *prev;    /* pointer to previous line                 */
  struct document_def *next;    /* pointer to next line                     */
} document;

typedef struct {
  shortint fgclr;      /* foreground color or NO if no color fill           */
  shortint bgclr;      /* background color or NO if no color fill           */
  char fillchar;       /* character to fill with or NO if no character fill */
  byte x;              /* abscissa (if TCUR, uses text cursor abscissa
                                    if MCUR, uses mouse cursor abscissa)    */
  byte y;              /* ordinate (if TCUR, uses text cursor ordinate
                                    if MCUR, uses mouse cursor ordinate)    */
  shortint length;     /* x-length                                          */
  shortint height;     /* y-height                                          */
  char *overwrite;     /* text to overwrite or NULL if overwrite all        */
  char *text;          /* text to print or NULL if no text                  */
} filldata;

typedef struct {
  word size;           /* size of image in bytes                            */
  byte tclr;           /* transparency color of image
           * or number of 8-pixel groups per row if image is "_16_i_save"ed */
  int x;               /* abscissa (if MCUR, uses mouse abscissa)           */
  int y;               /* abscissa (if MCUR, uses mouse ordinate)           */
  int length;          /* x-length (do not modify)                          */
  int height;          /* y-height (do not modify)                          */
  int how : 1;         /* relative to current scroll (TRUE) or not (FALSE)  */
  int for_future : 15; /* no current purpose other than filling the integer */
} imagedata;

typedef struct linked_list {
  struct linked_list *next;     /* pointer to next node                     */
} llist;

typedef struct linked_list_s {
  struct linked_list_s *next;   /* pointer to next node                     */
} llist_single;

typedef struct linked_list_d {
  struct linked_list_d *prev;   /* pointer to previous node                 */
  struct linked_list_d *next;   /* pointer to next node                     */
} llist_double;

typedef struct {
  byte update;         /*  TRUE "ms_stat" has updated structure "mousedata" */
                       /* FALSE no structure variables have been updated    */
  int pos[2];          /* old mouse cursor x,y position                     */
  int buts[2];         /* old left,right button  0 not pressed  1 pressed   */
  int npos[2];         /* new mouse cursor x,y position                     */
  int nbuts[2];        /* new left,right button  0 not pressed  1 pressed   */
  int butlr[2];        /* x,y position of last left button release          */
  int butlp[2];        /* x,y position of last left button press            */
  int butrr[2];        /* x,y position of last right button release         */
  int butrp[2];        /* x,y position of last right button press           */
} mousedata;

typedef struct {
  shortint fgclr;      /* foreground color or NO if no color fill           */
  shortint bgclr;      /* background color or NO if no color fill           */
  byte command;  /* ALIGN_NONE   - no command
                  * ALIGN_HORZ   - horizontal center; shifts odd lengths left
                  * ALIGN_VERT   - vertical center; shifts odd lengths up
                  * ALIGN_CENTER - horizontal and vertical center
                  * ALIGN_RIGHT  - right justify; flush to right margin     */
  byte x;              /* abscissa (if TCUR, uses text cursor abscissa
                                    if MCUR, uses mouse cursor abscissa)    */
  byte y;              /* ordinate (if TCUR, uses text cursor ordinate
                                    if MCUR, uses mouse cursor ordinate)    */
  char *text;          /* text to print                                     */
} printdata;

typedef struct {
  word size;           /* size of image in bytes                            */
  shortint fgclr;      /* NO if no color fill                               */
  shortint bgclr;      /* NO if no color fill                               */
  byte x;              /* abscissa (if TCUR, uses text cursor abscissa
                                    if MCUR, uses mouse cursor abscissa)    */
  byte y;              /* ordinate (if TCUR, uses text cursor ordinate
                                    if MCUR, uses mouse cursor ordinate)    */
  byte length;         /* x-length (do not modify)                          */
  byte height;         /* y-height (do not modify)                          */
} textimagedata;

typedef struct {
  shortint fgclr;      /* foreground color or NO if no color fill           */
  shortint bgclr;      /* background color or NO if no color fill           */
  byte x;              /* abscissa (if TCUR, uses text cursor abscissa
                                    if MCUR, uses mouse cursor abscissa)    */
  byte y;              /* ordinate (if TCUR, uses text cursor ordinate
                                    if MCUR, uses mouse cursor ordinate)    */
} textstr;

typedef struct {
  byte  fgclr, bgclr,                /* color of text inside window         */
        x, y,                        /* top,left coordinates of window      */
        length, height,              /* length and height of window         */
        parts,                       /* window parts to use                 */
        shadow_style,                /* shadow style                        */
        border_fgclr, border_bgclr,  /* color of border                     */
        shadow_fgclr, shadow_bgclr,  /* color of shadow                     */
        title_fgclr, title_bgclr;    /* color of title                      */
  char *border,                      /* border characters                   */
       *shadow,                      /* shadow characters                   */
       *title;                       /* window title                        */
  document *text;                    /* pointer to text of window           */
} windowdata;

/* Valid shadow styles are any combination of directions, like BOTTOM+RIGHT */

/* WINDOW PARTS */
#define CLOSE        1               /* close window button                 */
#define ZOOM         2               /* zoom window button                  */
#define RESIZE       4               /* resize window button                */
#define HORIZ_SCROLL 8               /* horizontal scroll bar               */
#define VERT_SCROLL  16              /* vertical scroll bar                 */
#define COORDS       32              /* display cursor coordinates          */

/* WINDOW BORDER DEFINITIONS */
#define SINGLE      "
#define SINGLE_SIDE "
#define SINGLE_TOP  "
#define DOUBLE      "
#define DOUBLE_SIDE "
#define DOUBLE_TOP  "

/*----------------------------------------------------------------------------
 * 2-D GEOMETRY TYPES                                                       */

typedef struct point2_struct {         /* 2d point                          */
  double x, y;
} point2;

typedef point2 vector2;

typedef struct point2_int_struct {     /* 2d integer point                  */
  int x, y;
} point2_int;

typedef struct matrix3_struct {        /* 3-by-3 matrix                     */
  double element[3][3];
} matrix3;

typedef struct box2d_struct {          /* 2d box                            */
  point2 min, max;
} box2;

/*----------------------------------------------------------------------------
 * 3-D GEOMETRY TYPES                                                       */

typedef struct point3_struct {         /* 3d point                          */
  double x, y, z;
} point3;

typedef point3 vector3;

typedef struct point3_int_struct {     /* 3d integer point                  */
  int x, y, z;
} point3_int;

typedef struct matrix4_struct {        /* 4-by-4 matrix                     */
  double element[4][4];
} matrix4;

typedef struct box3d_struct {          /* 3d box                            */
  point3 min, max;
} box3;

/* ------------------------------------------------------------------------ */
/* ---------------------  GLOBAL VARIABLE DEFINITIONS  -------------------- */

volatile extern boolean blink;                          /* default is TRUE  */
/*      blink = TRUE  if blinking characters and 8 background colors
   else blink = FALSE if no blinking characters and 16 background colors    */

volatile extern boolean mousepresent;                   /* default is FALSE */
/*      mousepresent = TRUE if mouse is detected by function "ms_init"
   else mousepresent = FALSE if mouse is not found by function "ms_init"    */

volatile extern word chr_output;                        /* default is MAX   */
/* chr_output = maximum number of characters to print with any output
                subroutine (useful for windowing text)
              = MAX for no limit on the number of characters to print       */

volatile extern boolean txt_cur_move;                   /* default is TRUE  */
/*      txt_cur_move = TRUE  if text cursor will move if x = y = TCUR
   else txt_cur_move = FALSE if text cursor will not move if x = y = TCUR   */

volatile extern word txt_length;                        /* default is 80    */
/* character length of virtual text screen (used when smooth scrolling)     */

/* ------------------------------------------------------------------------ */
/* ----------------------  FILE FUNCTION PROTOTYPES  ---------------------- */

FILE *fil_count(char *filename,
                 char *title, char *author, char *msgs[], word msg_num);
/* opens text data file "filename" and records number of program executions
 * uses program name "title" and author name "author"
 * must be in a text mode or nothing will print
 * prints one random comment from "msgs", holding "msg_num" messages
 * prints amount of memory available to program
 * NOTE #include <alloc.h> must be present or free memory will be inaccurate
 * RETURNS: file handle to data file                                        */

FILE *fil_count_reg(char *filename, char *title,
                    char *author, char *registree);
/* counter registered
 * opens text data file "filename" and records number of program executions
 * uses program name "title" and author name "author"
 * must be in a text mode or nothing will print
 * prints to whom the program is registered to
 * prints amount of memory available to program
 * NOTE #include <alloc.h> must be present or free memory will be inaccurate
 * RETURNS: file handle to data file                                        */

long fil_len(FILE *f);
/* RETURNS: byte length of file "f"                                         */

char *fil_next_str(word *size, FILE *f);
/* read next string from file position "f" (a string can consist of
   alphanumeric characters, hyphens, apostrophes, or text surrounded in
   quotes, like "It is: 04/12/94" -- nothing else)
 * initially allocates an input buffer of "size" bytes -- if needs more,
     allocates "size" more bytes, and so on (modifies "size")
 * RETURNS: pointer to next string (file pointer is set to byte following
              string)
 *          NULL if no string was found (file pointer is set to EOF)        */

char *fil_next_word(word *size, FILE *f);
/* read next word from file position "f" (a word can consist of alphabet
   letters, hyphens, or apostrophes) -- nothing else
 * initially allocates an input buffer of "size" bytes -- if needs more,
     allocates "size" more bytes, and so on (modifies "size")
 * RETURNS: pointer to next word (file pointer is set to byte following word)
 *          NULL if no word was found (file pointer is set to EOF)          */

char *fil_read_to(char *str, word *size, FILE *f);
/* read from file position "f" upto first occurrence of "str"
 * initially allocates an input buffer of "size" bytes -- if needs more,
     allocates "size" more bytes, and so on (modifies "size")
 * RETURNS: pointer to contents of file read in (file pointer is set to byte
              just beyond match
 *          NULL if no match was found (file pointer is set to EOF)         */

char *fil_read_to_strip(char *str, word *size, FILE *f);
/* read from file position "f" upto first occurrence of "str"
 * initially allocates an input buffer of "size" bytes -- if needs more,
     allocates "size" more bytes, and so on (modifies "size")
 * all comments (beginning with a ';'), blank lines, and extra spaces are
     stripped, and '=' are moved directly adjacent to text to conserve memory.
 * for example, the following passage:


       This   is  "not; [I] =  say"      ;he said
     [not ["I"] say]

      to  = this.

   becomes:

   This is "not; [I] =  say"
   [not ["I"] say]
   to=this.

   NOTE - text inside quotation marks (ie. string) is unaltered (and '[' ']'
          are also considered to be quotation marks)
 * RETURNS: pointer to contents of file read in (file pointer is set to byte
              just beyond match
 *          NULL if no match was found (file pointer is set to EOF)         */

word fil_skip_past(char *str, FILE *f);
/* Search file "f" for "str" and set file pointer to just past it (or to EOF
     if no match found).
 * RETURNS: number of bytes scanned upto (and including) last byte of match
 *          FALSE if no match was found                                     */

word fil_skip_to(char *str, FILE *f);
/* Search file "f" for "str" and set file pointer to beginning of it (or to
     EOF if no match found).
 * RETURNS: number of bytes scanned upto (and including) first byte of match
 *          FALSE if no match was found                                     */

/* ------------------------------------------------------------------------ */
/* --------------------  INI FILE FUNCTION PROTOTYPES  -------------------- */

boolean ini_get_boolean(char *section, char *section_title, char *option);
/* read parameter from text "section", title, "section_title", option "option"
 * RETURNS: TRUE  if "TRUE"
            FALSE if "FALSE"                                                */

byte ini_get_color(char *section, char *section_title, char *option);
/* read parameter from text "section", title, "section_title", option "option"
 * valid colors are "BLACK", "BLUE", "GREEN", "CYAN", "RED", "MAGENTA",
   "BROWN", "LIGHTGREY", "DARKGREY", "LIGHTBLUE", "LIGHTGREEN", "LIGHTCYAN",
   "LIGHTRED", "LIGHTMAGENTA", "YELLOW", "WHITE"
 * RETURNS: color                                                           */

int ini_get_number(char *section, char *section_title, char *option);
/* reads from .INI text "section", "section_title"
 * RETURNS: number                                                          */

int ini_get_position(char *section, char *section_title, char *option);
/* read parameter from text "section", title, "section_title", option "option"
 * valid screen positions are "TOP", "BOTTOM"
 * RETURNS: screen row number                                               */

int ini_get_rows(char *section, char *section_title, char *option);
/* read parameter from text "section", title, "section_title", option "option"
 * valid rows-per-screen are "25", "50", "UNMODIFY"
 * RETURNS: rows-per-screen                                                 */

byte ini_get_state(char *section, char *section_title, char *option);
/* read parameter from text "section", title, "section_title", option "option"
 * valid keyboard states are "ON", "OFF", "UNMODIFY"
 * RETURNS: 0 if "OFF"
            1 if "ON"
            2 if "UNMODIFY"                                                 */

char *ini_get_text(char *section, char *section_title, char *option);
/* read parameter from text "section", title, "section_title", option "option"
 * valid text must be enclosed within quotes
 * RETURNS: text string                                                     */

boolean ini_get_yesno(char *section, char *section_title, char *option);
/* reads from .INI text "section", "section_title"
 * valid responses are "YES", "NO"
 * RETURNS: TRUE  if "YES"
            FALSE if "NO"                                                   */

char *ini_read_section(char *str1, char *str2, FILE *f);
/* reads in relevant text from .INI file handle "f", beginning at "str1"
   and ending at "str2"
 * see "fil_read_to_strip" to see what is stripped and what is kept
 * RETURNS: relevant section text                                           */

/* ------------------------------------------------------------------------ */
/* --------------------  KEYBOARD FUNCTION PROTOTYPES  -------------------- */

char getchr(void);
/* gets next available keypress; if no keypress available, waits for one
 * ASCII code and scan code is returned in structure "asciiscan"
 * RETURNS: ASCII code                                                      */

char getchre(byte x, byte y);
/* gets next available keypress and echoes it to "x","y"; if no keypress
   available, waits for one
 * ASCII code and scan code is returned in structure "asciiscan"
 * RETURNS: ASCII code                                                      */

char kbd_clear(void);
/* clears keyboard buffer
 * RETURNS: ASCII code of last character that was in buffer                 */

void kbd_give(void);
/* gives control back to original keyboard intterupt                        */

void kbd_rate(byte rate, byte delay);
/* set typematic "rate" and typematic "delay" for repeat-key action
                               +-----+--------+
                               |delay|millisec|
                               +-----+--------+
                               |   0 | 250    |
			       |   1 | 500    |
			       |   2 | 750    |
			       |   3 | 1000   |
			       +-----+--------+
   +----+---------+ +----+---------+ +----+---------+ +----+---------+
   |rate|chars/sec| |rate|chars/sec| |rate|chars/sec| |rate|chars/sec|
   +----+---------+ +----+---------+ +----+---------+ +----+---------+
   |  0 | 30.0	  | |  8 | 15.0    | | 16 | 7.5     | | 24 | 3.7     |
   |  1 | 26.7	  | |  9 | 13.3    | | 17 | 6.7     | | 25 | 3.3     |
   |  2 | 24.0	  | | 10 | 12.0    | | 18 | 6.0     | | 26 | 3.0     |
   |  3 | 21.8	  | | 11 | 10.9    | | 19 | 5.5     | | 27 | 2.7     |
   |  4 | 20.0	  | | 12 | 10.0    | | 20 | 5.0     | | 28 | 2.5     |
   |  5 | 18.5	  | | 13 |  9.2    | | 21 | 4.6     | | 29 | 2.3     |
   |  6 | 17.1	  | | 14 |  8.6    | | 22 | 4.3     | | 30 | 2.1     |
   |  7 | 16.0	  | | 15 |  8.0	   | | 23 | 4.0     | | 31 | 2.0     |
   +----+---------+ +----+---------+ +----+---------+ +----+---------+      */

void kbd_status_load(void);
/* restores saved keyboard status of insert, caps/num/scroll lock           */

void kbd_status_save(void);
/* saves current keyboard status of insert, caps/num/scroll lock            */

void kbd_take(void);
/* takes control of the keyboard interrupt                                  */

void kbd_all_off(void);
/* turns all three lights off (NUM LOCK, CAPS LOCK, and SCROLL LOCK)        */

void kbd_all_on(void);
/* turns all three lights on (NUM LOCK, CAPS LOCK, and SCROLL LOCK)         */

void kbd_caps_off(void);               /* turns CAPS LOCK light off         */
void kbd_caps_on(void);                /* turns CAPS LOCK light on          */

char kbd_hit(void);
/* RETURNS: ASCII value of key if a key is ready to be retrieved
              (by getchr/getchre)
            0 if no key has been pressed                                    */

void kbd_insert_off(void);             /* turns INSERT on                   */
void kbd_insert_on(void);              /* turns INSERT off                  */

boolean kbd_is_all_on(void);
/* RETURNS: TRUE if all light on, FALSE if not                              */

boolean kbd_is_alt(void);
/* RETURNS: TRUE if either alt is depressed, FALSE if not                   */

boolean kbd_is_alt_left(void);
/* RETURNS: TRUE if left alt is depressed, FALSE if not                     */

boolean kbd_is_alt_left_only(void);
/* RETURNS: TRUE if only left alt is depressed, FALSE if not                */

boolean kbd_is_alt_right(void);
/* RETURNS: TRUE if right alt is depressed, FALSE if not                    */

boolean kbd_is_alt_right_only(void);
/* RETURNS: TRUE if only right alt is depressed, FALSE if not               */

boolean kbd_is_alt_only(void);
/* RETURNS: TRUE if only an alt is depressed, FALSE if not                  */

boolean kbd_is_caps_on(void);
/* RETURNS: TRUE if CAPS LOCK light on, FALSE if not                        */

boolean kbd_is_ctrl(void);
/* RETURNS: TRUE if either ctrl is depressed, FALSE if not                  */

boolean kbd_is_ctrl_left(void);
/* RETURNS: TRUE if left ctrl is depressed, FALSE if not                    */

boolean kbd_is_ctrl_left_only(void);
/* RETURNS: TRUE if only left ctrl is depressed, FALSE if not               */

boolean kbd_is_ctrl_right(void);
/* RETURNS: TRUE if right ctrl is depressed, FALSE if not                   */

boolean kbd_is_ctrl_right_only(void);
/* RETURNS: TRUE if only right ctrl is depressed, FALSE if not              */

boolean kbd_is_ctrl_only(void);
/* RETURNS: TRUE if only a ctrl is depressed, FALSE if not                  */

boolean kbd_is_insert_on(void);
/* RETURNS: TRUE if INSERT is on, FALSE if not                              */

boolean kbd_is_num_on(void);
/* RETURNS:TRUE if NUM LOCK light on, FALSE if not                          */

boolean kbd_is_scroll_on(void);
/* RETURNS: TRUE if SCROLL LOCK light on, FALSE if not                      */

boolean kbd_is_shift(void);
/* RETURNS: TRUE if either shift is depressed, FALSE if not                 */

boolean kbd_is_shift_left(void);
/* RETURNS: TRUE if left shift is depressed, FALSE if not                   */

boolean kbd_is_shift_left_only(void);
/* RETURNS: TRUE if only left shift is depressed, FALSE if not              */

boolean kbd_is_shift_right(void);
/* RETURNS: TRUE if right shift is depressed, FALSE if not                  */

boolean kbd_is_shift_right_only(void);
/* RETURNS: TRUE if only right shift is depressed, FALSE if not             */

boolean kbd_is_shift_only(void);
/* RETURNS: TRUE if a shift is depressed, FALSE if not                      */

void kbd_num_off(void);                /* turns NUM LOCK light off          */
void kbd_num_on(void);                 /* turns NUM LOCK light on           */

void kbd_scroll_off(void);             /* turns SCROLL LOCK light off       */
void kbd_scroll_on(void);              /* turns SCROLL LOCK light on        */

/* ------------------------------------------------------------------------ */
/* -------------------  LINKED LIST FUNCTION PROTOTYPES  ------------------ */

llist *lst_find(llist *node, llist *list);
/* RETURNS: "node" of linked "list"
            NULL if "node" not present in linked "list"                     */

llist_double *lst_free_double(llist_double *list);
/* deallocate a doubly-linked "list"
 * RETURNS: NULL                                                            */

llist_single *lst_free_single(llist_single *list);
/* deallocate a singly-linked "list"
 * RETURNS: NULL                                                            */

llist *lst_tail(llist *list);
/* RETURNS: tail of linked "list"                                           */

/* THE FOLLOWING TWO FUNCTIONS DO NOT YET WORK PROPERLY */
/*llist_double *lst_unlink_double(llist_double **head, llist_double *unlink);
 * unlink "unlink" from doubly linked list who's head is pointed to by "head"
 * RETURNS: next available node
 *          NULL if linked list is empty                                    */

/*llist_single *lst_unlink_single(llist_single **head, llist_single *unlink);
 * unlink "unlink" from singly linked list who's head is pointed to by "head"
 * RETURNS: next available node
 *          NULL if linked list is empty                                    */

/* ------------------------------------------------------------------------ */
/* ------------------  MATHEMATICAL FUNCTION PROTOTYPES  ------------------ */

double mth_findroot(double left, double right,
                    double tolerance, double (*f)(), double (*df)());
/* hybrid 1d Newton-Raphson/Regula Falsi root finder
 * input function f and its derivative df, an interval
 * left, right known to contain the root, and an error tolerance
 * Based on Blinn                                                           */

int mth_gcd(int u, int v);
/* binary greatest common divisor by Silver and Terzian.  See Knuth
 * both inputs must be >= 0                                                 */

byte max_byte(word nums, byte num1, ...);
/* RETURNS: greatest byte of a list of bytes                                */

int max_int(word nums, int num1, ...);
/* RETURNS: greatest integer of a list of integers                          */

shortint max_shortint(word nums, shortint num1, ...);
/* RETURNS: greatest integer of a list of short integers                    */

word max_word(word nums, word num1, ...);
/* RETURNS: greatest word of a list of words                                */

byte min_byte(word nums, byte num1, ...);
/* RETURNS: smallest byte of a list of bytes                                */

int min_int(word nums, int num1, ...);
/* RETURNS: smallest integers of a list of integers                         */

shortint min_shortint(word nums, shortint num1, ...);
/* RETURNS: smallest short integer of a list of short integers              */

word min_word(word nums, word num1, ...);
/* RETURNS: smallest word of a list of words                                */

double mth_newtonraphson(double (*f)(), double (*df)(), double x);
/* generic 1d Newton-Raphson step. f is function, df is derivative
 * x is current best guess for root location. Returns new estimate          */

int mth_roots_quadratic(double a, double b, double c, double *roots);
/* return roots of a*x^2 + b*x + c
 * stable algebra derived from Numerical Recipes by Press et al             */

double mth_regulafalsi(double (*f)(), double left, double right);
/* generic 1d regula-falsi step.  f is function to evaluate
 * interval known to contain root is given in left, right
 * returns new estimate                                                     */

/* ------------------------------------------------------------------------ */
/* ---------------  MATHEMATICAL MATRIX FUNCTION PROTOTYPES  -------------- */

matrix3 *m3_add(matrix3 *A, matrix3 *B, matrix3 *C);
/* C = A + B
 * RETURNS: C                                                               */

matrix3 *m3_copy(matrix3 *A);
/* RETURNS: copy of A                                                       */

matrix3 *m3_mul(matrix3 *A, matrix3 *B, matrix3 *C);
/* C = A * B
 * RETURNS: C                                                               */

matrix3 *m3_new(double *a[3][3]);
/* RETURNS: new 3x3 matrix initialized to a[3][3]                           */

matrix3 *m3_sub(matrix3 *A, matrix3 *B, matrix3 *C);
/* C = A - B
 * RETURNS: C                                                               */

matrix3 *m3_transpose(matrix3 *A, matrix3 *B);
/* B = transpose(A)
 * RETURNS: B                                                               */

matrix4 *m4_add(matrix4 *A, matrix4 *B, matrix4 *C);
/* C = A + B
 * RETURNS: C                                                               */

matrix4 *m4_copy(matrix4 *A);
/* RETURNS: copy of A                                                       */

matrix4 *m4_mul(matrix4 *A, matrix4 *B, matrix4 *C);
/* C = A * B
 * RETURNS: C                                                               */

matrix4 *m4_new(double *a[4][4]);
/* RETURNS: new 4x4 matrix initialized to a[4][4]                           */

matrix4 *m4_sub(matrix4 *A, matrix4 *B, matrix4 *C);
/* C = A - B
 * RETURNS: C                                                               */

matrix4 *m4_transpose(matrix4 *A, matrix4 *B);
/* B = transpose(A)
 * RETURNS: B                                                               */

/* ------------------------------------------------------------------------ */
/* ---------------  MATHEMATICAL VECTOR FUNCTION PROTOTYPES  -------------- */

vector2 *v2_add(vector2 *u, vector2 *v, vector2 *w);
/* w = u + v
 * RETURNS: w                                                               */

vector2 *v2_combine(vector2 *u, double c1,
                    vector2 *v, double c2, vector2 *w);
/* w = c1(u) + c2(v)
 * RETURNS: w                                                               */

vector2 *v2_copy(vector2 *v);
/* RETURNS: copy of u                                                       */

double v2_dot(vector2 *u, vector2 *v);
/* w = u dot v
 * RETURNS: w                                                               */

double v2_len(vector2 *v);
/* RETURNS: magnitude of v                                                  */

double v2_len_sqr(vector2 *v);
/* RETURNS: magnitude of v squared                                          */

vector2 *v2_lerp(vector2 *lo, vector2 *hi, double alpha, vector2 *w);
/* w = linear interpolation between lo and hi by amount alpha
 * RETURNS: w                                                               */

vector2 *v2_mul(vector2 *u, vector2 *v, vector2 *w);
/* w = u * v (multiplication component-wise)
 * RETURNS: w                                                               */

point2 *v2_mul_by_proj(point2 *p, matrix3 *A);
/* RETURNS: transformed point p * projection matrix m                       */

vector2 *v2_neg(vector2 *v);
/* v is negated
 * RETURNS: v                                                               */

vector2 *v2_new(double x, double y);
/* RETURNS: new 2D vector initialized to (x,y)                              */

vector2 *v2_norm(vector2 *v);
/* v is normalized (becomes unit length)
 * RETURNS: v                                                               */

vector2 *v2_ortho(vector2 *u, vector2 *v);
/* u = some orthogonal vector to v
 * RETURNS: u                                                               */

vector2 *v2_scale(vector2 *v, double newlen);
/* v is scaled to length newlen
 * RETURNS: v                                                               */

double v2_seg_len(point2 *p, point2 *q);
/* RETURNS: length of line segment pq                                       */

vector2 *v2_sub(vector2 *u, vector2 *v, vector2 *w);
/* w = u - v
 * RETURNS: w                                                               */

vector3 *v3_add(vector3 *u, vector3 *v, vector3 *w);
/* w = u + v
 * RETURNS: w                                                               */

vector3 *v3_combine(vector3 *u, double c1,
                    vector3 *v, double c2, vector3 *w);
/* w = c1(u) + c2(v)
 * RETURNS: w                                                               */

vector3 *v3_copy(vector3 *v);
/* RETURNS: copy of u                                                       */

vector3 *v3_cross(vector3 *u, vector3 *v, vector3 *w);
/* w = u cross v
 * RETURNS: w                                                               */

double v3_dot(vector3 *u, vector3 *v);
/* w = u dot v
 * RETURNS: w                                                               */

double v3_len(vector3 *v);
/* RETURNS: magnitude of v                                                  */

double v3_len_sqr(vector3 *v);
/* RETURNS: magnitude of v squared                                          */

vector3 *v3_lerp(vector3 *lo, vector3 *hi, double alpha, vector3 *w);
/* w = linear interpolation between lo and hi by amount alpha
 * RETURNS: w                                                               */

vector3 *v3_mul(vector3 *u, vector3 *v, vector3 *w);
/* w = u * v (multiplication component-wise)
 * RETURNS: w                                                               */

point3 *v3_mul_by_matrix(point3 *p, matrix3 *A, point3 *q);
/* q = p * A
 * RETURNS: transformed point q                                             */

point3 *v3_mul_by_proj(point3 *p, matrix4 *A);
/* RETURNS: transformed point p * projection matrix A                       */

vector3 *v3_neg(vector3 *v);
/* v is negated
 * RETURNS: v                                                               */

vector3 *v3_new(double x, double y, double z);
/* RETURNS: new 3D vector initialized to (x,y,z)                            */

vector3 *v3_norm(vector3 *v);
/* v is normalized (becomes unit length)
 * RETURNS: v                                                               */

vector3 *v3_scale(vector3 *v, double newlen);
/* v is scaled to length newlen
 * RETURNS: v                                                               */

double v3_seg_len(point3 *p, point3 *q);
/* RETURNS: length of line segment pq                                       */

vector3 *v3_sub(vector3 *u, vector3 *v, vector3 *w);
/* w = u - v
 * RETURNS: w                                                               */

/* ------------------------------------------------------------------------ */
/* ------------------  MISCELLANEOUS FUNCTION PROTOTYPES  ----------------- */

void beep(void);
/* beeps speaker                                                            */

byte bestlib_init(byte mode, boolean mouse);
/* initializes THE BEST LIBRARY
 * sets "blink" = TRUE and "txt_cur_move" = TRUE
 * calls "msec" and "txt_mem(TEXTSAVE, NULL)"
 * if originally in a text mode, fills global structure "cursor"
 * sets the video mode to "mode" [see video_set for details]
 * if "mode" = FALSE, does not change video mode
 * if "mouse" = TRUE, initializes the mouse to video mode "mode"
 * if "mouse = FALSE, does not initialize mouse
 * RETURNS: previous video mode if video mode was changed (if not,
            current video mode)                                             */

void boot(word how);
/* "how" = WARM, warm boot; "how" = COLD, cold boot                         */

char *dos_shell(void);
/* shells to DOS, returning on "EXIT"
 * RETURNS: NULL if successful, or a pointer to a string saying error       */

void msec(int delaytime);
/* delays computer for "delaytime" milliseconds
 * first call initializes itself to computer                                */

void sound_off(void);
/* stops any sound from the speaker                                         */

boolean stopw(byte index, word delaytime);
/* "index" refers to a stopwatch and must be between 0-99
 * "delaytime" is number of clock ticks to set stopwatch to
 * if called with "delaytime" = 0,
 *   RETURNS: TRUE  if finished
              FALSE if not                                                  */

byte video_get(void);
/* RETURNS: current video mode                                              */

void video_restore(byte mode);
/* restores video to "mode"
 * if "mode" is a text mode, restores video memory, cursor position and shape,
   turns on cursor, and enables blinking characters                         */

void video_set(byte mode);
/* "mode" represents a video mode: [value] - manually specified video mode
                                   TEXT    - text mode if not already in one
                                   TEXT25  - 25-line text mode
                                   TEXT50  - 50-line text mode
                                   TEXT25F - forced 25-line text mode
                                   TEXT50F - forced 50-line text mode
                                   VGA16   - 640x480x16 graphics mode
                                   VGA256  - 320x200x256 graphics mode
 * NOTE  re-initialize mouse driver by "ms_init" to new video mode          */

/* ------------------------------------------------------------------------ */
/* ----------------------  MOUSE FUNCTION PROTOTYPES  --------------------- */

void ms_get(int *x, int *y);
/* stores mouse abscissa in "x" and mouse ordinate in "y"
 * if mouse is in text mode, stores byte values (can be byte *x, byte *y)
 * if "y" = NULL, "x" assumed to be "int *xy" (or byte *xy if text mode)    */

int ms_getx(void);
/* RETURNS: mouse abscissa
 * if mouse is in text mode, RETURNS: byte value                            */

int ms_gety(void);
/* RETURNS: mouse ordinate
 * if mouse is in text mode, RETURNS: byte value                            */

void ms_hide(void);
/* hides mouse cursor                                                       */

boolean ms_init(byte mode);
/* initialize mouse for video mode "mode"
                                       TEXT25 - 25-line text mode
                                       TEXT50 - 50-line text mode
                                       VGA16  - 640x480x16 graphics mode
                                       VGA256 - 320x200x256 graphics mode
 * initializes "mousepresent" to return value
 * initializes structure "msdata" with default values
 * centers mouse cursor on screen and hides it (use "ms_show" to see it)
 * sets maximum abscissa and ordinate of mouse cursor to screen size
 * RETURNS: TRUE if successful or FALSE if no mouse driver present          */

boolean ms_kill(void);
/* completely disables mouse driver;
 * RETURNS: TRUE is successful or FALSE is failed                           */

void ms_range(int minx, int miny, int maxx, int maxy);
/* new mosue movement range is bounded by "minx","miny" and "maxx","maxy"
 * if "minx" = MIN, sets minimum abscissa to screen minimum
 * if "maxx" = MAX, sets maximum abscissa to screen maximum
 * if "miny" = MIN, sets minimum ordinate to screen minimum
 * if "maxy" = MAX, sets maximum ordinate to screen maximum                 */

void ms_set(int x, int y);
/* position mouse cursor at "x","y"
 * if "x" = MEM, the "mousedata.npos[0]" is used
 * if "y" = MEM, the "mousedata.npos[1]" is used
 * if values are supplied for either "x" or "y", those are stored into
   "mousedata.npos[0]" or "mousedata.npos[1]", respectively                 */

int ms_setx(int x);
/* set mouse cursor abscissa to "x"
 * if "x" = MEM, the "mousedata.npos[0]" is used
 * if a value is supplied for "x", it is stored into "mousedata.npos[0]"
 * RETURNS: mouse ordinate                                                  */

int ms_sety(int y);
/* set mouse cursor ordinate to "y"
 * if "x" = MEM, the "mousedata.npos[1]" is used
 * if a value is supplied for "y", it is stored into "mousedata.npos[1]"
 * RETURNS: mouse abscissa                                                  */

char ms_shape_get(byte *fgclr, byte *bgclr, char *ch);
/* reads in the current text mouse "bgclr","fgclr", and "ch"
 * RETURNS: ASCII character of mouse                                        */

void ms_shape_set(byte fgclr, byte bgclr, char ch);
/* changes the text mouse cursor to ASCII character "ch"
 * "fgclr"/"bgclr" = NO if no foreground/background color modification
 * "ch" = NO if no character modification                                   */

void ms_show(void);
/* displays mouse cursor                                                    */

void ms_stat(void);
/* updates all "mousedata" information except pos[] and but[]               */

/* ------------------------------------------------------------------------ */
/* ---------------------  STRING FUNCTION PROTOTYPES  --------------------- */

boolean is_number_dec(char *str);
/* RETURNS: TRUE  if "str" is a decimal number
            FALSE if not                                                    */

boolean is_number_hex(char *str);
/* RETURNS: TRUE if "str" is a hexadecimal number, FALSE if not
            FALSE if not                                                    */

void mem_copy(void *destination, void *source, word bytes);
/* copy "bytes" bytes from "source" into "destination"                      */

word scan_byte(char *start, char compare, word count, boolean direction);
/* checks if one-byte value "compare" is present in "start"
 * checks "count" bytes (if NULL, search to end of "start")
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first character matching "compare"
      else FALSE      if no match found or "start" is not a string          */

word scan_byte_not(char *start, char compare, word count, boolean direction);
/* checks if any one-byte value other than "compare" is present in "start"
 * checks "count" bytes (if NULL, search to end of "start")
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first character not matching "compare"
      else FALSE      if only "compare" present (no other characters)       */

word scan_bytes(char *start, char compare[], word count, boolean direction);
/* checks if any one of the characters in "compare" (which must be a NULL-
   terminated string) are present in "start"
 * checks "count" bytes (if NULL, search to end of "start")
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first character matching one of "compare"
      else FALSE      if no match found or "start" is not a string          */

word scan_bytes_not(char *start, char compare[],
                    word count, boolean direction);
/* checks if any characters other than those in "compare" (which must be
   NULL-terminated) are present in "start"
 * checks "count" bytes (if NULL, search to end of "start")
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first character not matching "compare"
      else FALSE      if only "compare" present (no other characters)       */

word scan_str(char *start, char *compare, word count, boolean direction);
/* checks if "compare" is present in "start"
 * checks "count" bytes (if NULL, search to end of "start")
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first string matching "compare"
      else FALSE      if no match found or if either "compare" or
                      "start" are not strings                               */

word scan_str_not(char *start, char *compare, word count, boolean direction);
/* checks if any string other than "compare" is present in "start"
 * checks "count" bytes (if NULL, search to end of "start")
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first string not matching "compare"
      else FALSE      if no match found or if either "compare" or
                      "start" are not strings                               */

word scan_strs(char *start, char *compare[], word count, boolean direction);
/* checks if any one of the strings in "compare" ("compare" must be
   NULL-terminated) are present in "start"
 * checks "count" bytes (if NULL, search to end of "start")
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first string matching "compare"
      else FALSE      if no match found or if either "compare" or
                      "start" are not strings                               */

word scan_strs_not(char *start, char *compare[],
                   word count, boolean direction);
/* checks if any string other than those in "compare" ("compare" must be
   NULL-terminated) are present in "start"
 * checks "count" bytes (if NULL, search to end of "start")
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first string not matching "compare"
      else FALSE      if no match found or if either "compare" or
                      "start" are not strings                               */

word scan_word(word *start, word compare, word count, boolean direction);
/* checks if word "compare" is present in "start"
 * checks "count" words
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first integer matching "compare" or
           FALSE      if no match found or if "count" = 0                   */

word scan_word_not(word *start, word compare, word count, boolean direction);
/* checks if any integers other than "compare" are present in
   "start"
 * checks "count" words
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first integer not matching "compare"
      else FALSE      if only "compare" is present (no other integers)      */

word scan_words(word *start, word compare[], word count, boolean direction);
/* checks if any one of the integers in "compare" ("compare" must be
   NULL-terminated) are present in "start"
 * checks "count" words
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first integer matching "compare" or
           FALSE      if no match found or if "count" = 0                   */

word scan_words_not(word *start, word compare[],
                    word count, boolean direction);
/* checks if any integer other than those in "compare" ("compare" must
   be NULL-terminated) are present in "start"
 * checks "count" words
 * search "direction": FORWARD or BACKWARD
 * RETURNS: offset + 1 of first integer not matching "compare"
      else FALSE      if only "compare" is present (no other integers)      */

int sign(int number);
/* RETURNS: sign of "number"                                                */

void str_case_down(char *str);
/* converts all characters in "str" to lowercase                            */

void str_case_down_pr(printdata *prdata);
/* converts all characters in "prdata.string" to lowercase                  */

void str_case_flip(char *str);
/* converts all characters in "str" to opposite case                        */

void str_case_flip_pr(printdata *prdata);
/* converts all characters in "prdata.string" to opposite case              */

void str_case_up(char *str);
/* converts all characters in string "str" to uppercase                     */

void str_case_up_pr(printdata *prdata);
/* converts all characters in "prdata.string" to uppercase                  */

int str_cmp(char *str1, char *str2);
/* compares "str1" to "str2"
 * RETURNS: +1 if "str1" is alphabetically greater than "str2"
 * RETURNS:  0 if "str1" and "str2" are same
 * RETURNS: -1 if "str1" is alphabetically less than "str2"                 */

word str_copy(char *destination, char *source);
/* copies string "source" into "destination" (including NULL terminator)
 * RETURNS: length of string "source"                                       */

void str_del_byte(char *start, char del, word count);
/* deletes all occurrences of "del" from "start", searching "count" bytes
 * if "count" = NULL, search to end of "start"                              */

void str_del_bytes(char *start, word count);
/* deletes "count" bytes from "start"                                       */

void str_del_str(char *start, char *del, word count);
/* deletes all occurrences of "del" from "start", searching "count" bytes
 * if "count" = NULL, search to end of "start"                              */

void str_del_word(word *start, word del, word count);
/* deletes all occurrences of "del" from "start", searching "count" bytes   */

void str_del_words(word *start, word count);
/* deletes "count" words from "start"                                       */

void str_fill_byte(char *destination, char source, word count);
/* Fills "destination" with "count" byte-values "source"                    */

void str_fill_str(char *destination, char *source, word count);
/* Fills "destination" with "count" strings "source"                        */

void str_fill_word(word *destination, word source, word count);
/* Fills "destination" with "count" word-values "source"                    */

void str_inc(char *str);                   /* increments ASCII number "str" */

void str_ins_byte(char *start, char insert, word count);
/* inserts "count" "insert"s into string "start"                            */

void str_ins_str(char *start, char *insert, word count);
/* inserts "count" "insert"s into string "start"                            */

void str_ins_word(word *start, word insert, word count);
/* inserts "count" "insert"s into word array "start"                        */

word str_len(char *str);
/* RETURNS: length of "str"                                                 */

word str_len_pr(printdata *prdata);
/* RETURNS: length of "prdata.string"                                       */

char *str_next_str(char *str);
/* read next string from "str" (a string can consist of alphanumeric
   characters, hyphens, apostrophes, or text surrounded in quotes, like
   "It is: 04/12/94" -- nothing else)
 * RETURNS: pointer to next word
 *          NULL if no word was found (passed in a NULL string)             */

char *str_next_word(char *str);
/* read next word from "str" (a word can consist of alphabet letters,
   hyphens, or apostrophes -- nothing else)
 * RETURNS: pointer to next word
 *          NULL if no word was found (passed in a NULL string)             */

void str_rep_byte_byte(char *start, char search,
                       char replace, word count, boolean direction);
/* search "start" "count" bytes for "search" and replaces all occurrences
   of it with "replace"
 * if "count" = NULL, search to end of "start"  ONLY WITH DIRECTION: FORWARD
 * search in "direction": FORWARD or BACKWARD
 * WARNING: IF "count" = NULL AND "direction" = BACKWARD, WILL SEARCH AND
   REPLACE BEYOND BEGINNING OF STRING "start" -- DO NOT DO THIS!!           */

void str_rep_byte_str(char *start, char search,
                      char *replace, word count, boolean direction);
/* search "start" "count" bytes for "search" and replaces all occurrences
   of it with "replace"
 * if "count" = NULL, search to end of "start"  ONLY WITH DIRECTION: FORWARD
 * search in "direction": FORWARD or BACKWARD
 * WARNING: IF "count" = NULL AND "direction" = BACKWARD, WILL SEARCH AND
   REPLACE BEYOND BEGINNING OF STRING "start" -- DO NOT DO THIS!!           */

void str_rep_byte_word(char *start, char search,
                       word replace, word count, boolean direction);
/* search "start" "count" bytes for "search" and replaces all occurrences
   of it with "replace"
 * if "count" = NULL, search to end of "start"  ONLY WITH DIRECTION: FORWARD
 * search in "direction": FORWARD or BACKWARD
 * WARNING: IF "count" = NULL AND "direction" = BACKWARD, WILL SEARCH AND
   REPLACE BEYOND BEGINNING OF STRING "start" -- DO NOT DO THIS!!           */

void str_rep_str_byte(char *start, char *search,
                      char replace, word count, boolean direction);
/* search "start" "count" bytes for "search" and replaces all occurrences
   of it with "replace"
 * if "count" = NULL, search to end of "start"  ONLY WITH DIRECTION: FORWARD
 * search in "direction": FORWARD or BACKWARD
 * WARNING: IF "count" = NULL AND "direction" = BACKWARD, WILL SEARCH AND
   REPLACE BEYOND BEGINNING OF STRING "start" -- DO NOT DO THIS!!           */

void str_rep_str_str(char *start, char *search,
                     char *replace, word count, boolean direction);
/* search "start" "count" bytes for "search" and replaces all occurrences
   of it with "replace"
 * if "count" = NULL, search to end of "start"  ONLY WITH DIRECTION: FORWARD
 * search in "direction": FORWARD or BACKWARD
 * WARNING: IF "count" = NULL AND "direction" = BACKWARD, WILL SEARCH AND
   REPLACE BEYOND BEGINNING OF STRING "start" -- DO NOT DO THIS!!           */

void str_rep_word_byte(word *start, word search,
                       char replace, word count, boolean direction);
/* search "start" "count" bytes for "search" and replaces all occurrences
   of it with "replace"
 * search in "direction": FORWARD or BACKWARD                               */

void str_rep_word_word(word *start, word search,
                       word replace, word count, boolean direction);
/* search "start" "count" bytes for "search" and replaces all occurrences
   of it with "replace"
 * search in "direction": FORWARD or BACKWARD                               */

char str_right(char *str, word number);
/* RETURNS: char "number" from string "str", counting from end of string    */

char str_right_pr(printdata *prdata, word number);
/* RETURNS: char "number" from string "prdata.string", counting from end of
            string                                                          */

/* ------------------------------------------------------------------------ */
/* ----------------  STRING CHARACTER FUNCTION PROTOTYPES  ---------------- */

char case_down(char ch);
/* RETURNS: "ch" in lowercase                                               */

char case_down_ptr(char *ch);
/* RETURNS: "ch" in lowercase (also modifies "ch")                          */

char case_flip(char ch);
/* RETURNS: "ch" in opposite case                                           */

char case_flip_ptr(char *ch);
/* RETURNS: "ch" in opposite case (also modifies "ch")                      */

char case_up(char ch);
/* RETURNS: "ch" in uppercase                                               */

char case_up_ptr(char *ch);
/* RETURNS: "ch" in uppercase (also modifies "ch")                          */

boolean is_alpha(char ch);
/* RETURNS: TRUE if "ch" is an alphabet letter, FALSE if not
            FALSE if not                                                    */

boolean is_alpha_down(char ch);
/* RETURNS: TRUE if "ch" is a lowercase alphabet letter, FALSE if not
            FALSE if not                                                    */

boolean is_alpha_up(char ch);
/* RETURNS: TRUE if "ch" is an uppercase alphabet letter, FALSE if not
            FALSE if not                                                    */

boolean is_alphanum(char ch);
/* RETURNS: TRUE if "ch" is an alphanumeric character, FALSE if not
            FALSE if not                                                    */

boolean is_ascii(char ch);
/* RETURNS: TRUE if "ch" is a standard ASCII character, FALSE if not
            FALSE if not                                                    */

boolean is_case_down(char ch);
/* RETURNS: TRUE if "ch" is lowercase, FALSE if not
            FALSE if not                                                    */

boolean is_case_up(char ch);
/* RETURNS: TRUE if "ch" is uppercase, FALSE if not
            FALSE if not                                                    */

boolean is_ctrlchar(char ch);
/* RETURNS: TRUE if "ch" is a control character (0-31 or 127), FALSE if not
            FALSE if not                                                    */

boolean is_digit_dec(char ch);
/* RETURNS: TRUE if "ch" is a digit, FALSE if not
            FALSE if not                                                    */

boolean is_digit_hex(char ch);
/* RETURNS: TRUE if "ch" is a hexadecimal digit, FALSE if not
            FALSE if not                                                    */

boolean is_greek(char ch);
/* RETURNS: TRUE if "ch" is a greek letter, FALSE if not
            FALSE if not                                                    */

boolean is_letter(char ch);
/* RETURNS: TRUE  if "ch" is an alphabet letter, an apostrophe, or a hyphen
            FALSE if not                                                    */

boolean is_letternum(char ch);
/* RETURNS: TRUE  if "ch" is an alphanumeric letter, an apostrophe, or a
                  hyphen
            FALSE if not                                                    */

boolean is_print(char ch);
/* RETURNS: TRUE  if "ch" is a printable character (has ASCII symbol)
            FALSE if not                                                    */

boolean is_punc(char ch);
/* RETURNS: TRUE if "ch" is a punctuation character, FALSE if not
            FALSE if not                                                    */

/* ------------------------------------------------------------------------ */
/* ----------------  STRING CONVERSION FUNCTION PROTOTYPES  --------------- */

char *con_bool_to_str(boolean bool);
/* convert boolean FALSE or TRUE into a string
 * RETURNS: "TRUE"  if "bool" = TRUE
 *          "FALSE" if "bool" = FALSE                                       */

char *con_color_to_str(byte color);
/* convert "color" into its string color name
 * RETURNS: string representation of color
 *          NULL if "color" is not a valid color                            */

shortint con_str_to_bool(char *str);
/* convert "str" into FALSE or TRUE
 * RETURNS: TRUE  if "str" = "TRUE"
 *          FALSE if "str" = "FALSE"
 *          -1    if "str" is not a valid boolean word                      */

shortint con_str_to_color(char *str);
/* convert "str" into its color equivalent
 * RETURNS: color value
 *          -1 if "str" is not a valid color                                */


/* ------------------------------------------------------------------------ */
/* --------------------  TEXT MODE FUNCTION PROTOTYPES  ------------------- */

void txt_ascii_get(word number, byte codes[]);
/* reads "number" characters into "codes"
 * see ASCII GRAPHIC DEFINITIONS for details on structure of "codes"        */

void txt_ascii_set(word number, byte codes[]);
/* sets "number" characters using data from "codes"
 * see ASCII GRAPHIC DEFINITIONS for details on structure of "codes"        */

void txt_blink(int what);
/* if "what" = TRUE,  blinking characters
             = FALSE, 16 background colors                                  */

byte txt_char_height(void);
/* RETURNS: height of text mode characters (in pixels/scan lines)           */

byte txt_char_length(void);
/* RETURNS: length of text mode characters (in pixels)                      */

void txt_cls(void);
/* clears the screen                                                        */

void txt_erase(byte x, byte y, byte length, byte height);
/* overwrites the region with corner at "x","y", x-length "length", and
   y-height "height" with spaces                                            */

void txt_erase_col(byte col);
/* overwrites "col" with spaces                                             */

void txt_erase_row(byte row);
/* overwrites "row" with spaces                                             */

void txt_fill_area(byte x, byte y, filldata *fidata);
/* fills screen according to structure "fidata"
 * the filling begins at corner "x","y"
 * if "x" = MEM, "fidata.x" is used
 * if "y" = MEM, "fidata.y" is used                                         */

char txt_fill_col(byte col, byte fgclr, byte bgclr, char *str);
/* prints string "str" in fgcolor "fgclr" and bgcolor "bgclr" at "col",0
   down the screen
 * if "fgclr" = NO, foreground is not modified
 * if "bgclr" = NO, background is not modified
 * if "str" = NULL, no string is printed
 * RETURNS: ASCII value of first character overwritten                      */

char txt_fill_row(byte row, byte fgclr, byte bgclr, char *str);
/* prints string "str" in fgcolor "fgclr" and bgcolor "bgclr" at 0,"row"
   across the screen
 * if "fgclr" = NO, foreground is not modified
 * if "bgclr" = NO, background is not modified
 * if "str" = NULL, no string is printed
 * RETURNS: ASCII value of first character overwritten                      */

word txt_flood(byte fgclr, byte bgclr, char *str);
/* floods screen with string "str" in "fgclr","bgclr"
 * if "fgclr" = NO, foreground color is not modified
 * if "bgclr" = NO, background color is not modified
 * if "str" = NULL, no string is written
 * RETURNS: length of "str"                                                 */

word txt_get_abs(void);
/* RETURNS: offset of text page                                             */

byte txt_get_act(void);
/* RETURNS: active text page                                                */

byte txt_get_vis(void);
/* RETURNS: visual text page                                                */

byte txt_last(void);
/* RETURNS: last text page number                                           */

void txt_mem(byte what, textimagedata *timage);
/* if "what" = TEXTSHOW - restores text memory
             = TEXTSAVE - stores text memory
 * storage area "timage" is used (use "txt_chrattrs_need" to get memory
   requirements for storing an 80x25 or 80x50 screen)
 * if "timage" = NULL, one built-in storage area is used                    */

word txt_print(byte x, byte y, printdata *prdata);
/* prints according to structure "prdata"
 * the printing begins at "x","y"
 * if "x" = MEM, "prdata.x" is used
 * if "y" = MEM, "prdata.y" is used
 * RETURNS: length of "prdata.string"                                       */

byte txt_rows(void);
/* RETURNS: [number of rows]-1 in current text page                         */

void txt_scroll(int columns, int rows);
/* smoothly scrolls screen "columns" and "rows" -- negatives apply          */

void txt_scroll_fast(shortint columns, shortint rows);
/* quickly smoothly scrolls screen "columns" and "rows" -- negatives apply
 * NOTE some flicker may occur                                              */

void txt_scroll_off(shortint direction);
/* smoothly scrolls screen off in "direction"                               */

void txt_scroll_on(shortint direction);
/* smoothly scrolls screen on in "direction"                                */

void txt_scroll_over(int scanlines);
/* smoothly scrolls "scanlines" of a screen overtop another screen --
   negative "scanlines" means scroll down (off screen)                      */

void txt_scroll_rows(byte row, byte height, shortint horz_scroll);
/* smoothly scrolls screen rows "height" beginning at "row"
 * scrolls "horz_scroll" columns -- negatives apply                         */

void txt_scroll_window(byte x, byte y, byte length, byte height,
                       shortint horz_scroll, shortint vert_scroll);
/* smoothly scrolls screen region with corner at "x","y", x-length
   "length", and y-height "height" in direction "direction","horz_scroll"
   characters and "vert_scroll" rows -- negatives apply                     */

void txt_set_abs(word offset);
/* sets offset of text page                                                 */

void txt_set_act(byte page);
/* sets text page "page" as active
 * if "page" = TEXTPAGEVISUAL, active page becomes current visual page
 * if "page" = TEXTPAGELAST, last page becomes active page                  */

void txt_set_rel(int columns, int rows);
/* sets horz offset "columns" and vert offset "rows" from original offset   */

void txt_set_vis(byte page);
/* sets a text page as visual, or seen
 * if "page" = TEXTPAGEACTIVE, visual page becomes current active page
 * if "page" = TEXTPAGELAST, last page becomes visual page                  */

void txt_split(word line);          /* splits visual page at "line" (0-400) */

/* ------------------------------------------------------------------------ */
/* -----------------  TEXT ANIMATION FUNCTION PROTOTYPES  ----------------- */

/* :(NONE YET :( */

/* ------------------------------------------------------------------------ */
/* -----------------  TEXT ATTRIBUTE FUNCTION PROTOTYPES  ----------------- */

char txt_attr_save(byte x, byte y, byte *fgclr, byte *bgclr);
/* stores foreground color at "x","y" into "fgclr" and background color
   into "bgclr"
 * if "fgclr" = NULL, foreground is not stored
 * if "bgclr" = NULL, background is not stored
 * RETURNS: ASCII value of character at "x","y"                             */

char txt_attr_show(byte x, byte y, byte fgclr, byte bgclr, int count);
/* prints "count" fgcolors "fgclr" and bgcolors "bgclr" at "x","y"
 * if "fgclr" = NO, foreground is not modified
 * if "bgclr" = NO, background is not modified
 * if "x" and "y" both equal TCUR, advances the cursor position to one
   past the last attribute printed
 * RETURNS: ASCII value of character at "x","y"                             */

void txt_attrs_fill(byte x, byte y,
                    byte length, byte height, byte fgclr, byte bgclr);
/* the region with corner "x","y", x-length "length", and y-height
   "height" is filled in fgcolor "fglcr" and bgcolor "bgclr"
 * if "fgclr" = NO, foreground is not modified
 * if "bgclr" = NO, background is not modified                              */

word txt_attrs_need(byte length, byte height);
/* RETURNS: memory requirement for a "txt_attrs_save"ed image of
   x-length "length" and y-height "height"                                  */

void txt_attrs_save(byte x, byte y,
                    byte length, byte height, textimagedata *attrs);
/* stores the region of attributes from corner "x","y" with x-length
   "length" and y-height "height" into "attrs"
 * if "x" = MEM, "attrs.x" is used
 * if "y" = MEM, "attrs.y" is used
 * if "length" = MEM, "attrs.length" is used
 * if "height" = MEM, "attrs.height" is used                                */

void txt_attrs_show(byte x, byte y,
                    byte fgclr, byte bgclr, textimagedata *attrs);
/* prints the region of attributes "attrs" at top-left corner "x","y"
 * if "x" = MEM,  "attrs.x" is used
 * if "y" = MEM,  "attrs.y" is used
 * if "fgclr" = NO,  foreground color is not modified
              = YES, modifies foreground with stored colors
              = MEM, "attrs.fgclr" is used
 * if "bgclr" = NO,  background color is not modified
              = YES, modifies background with stored colors
              = MEM, "attrs.bgclr" is used                                  */

byte txt_bg_get(byte x, byte y);    /* RETURNS: background color at "x","y" */

byte txt_fg_get(byte x, byte y);    /* RETURNS: foreground color at "x","y" */

/* ------------------------------------------------------------------------ */
/* -----------------  TEXT CHARACTER FUNCTION PROTOTYPES  ----------------- */

void txt_chr_attr_save(byte x, byte y, byte *fgclr, byte *bgclr, char *ch);
/* stores foreground color at "x","y" into "fgclr", background color into
   "bgclr", and ASCII character into "ch"
 * if "fgclr" = NULL, foreground is not stored
 * if "bgclr" = NULL, background is not stored
 * if "ch" = NULL, character is not stored
 * RETURNS: ASCII value of character at "x","y"                             */

char txt_chr_attr_show(byte x, byte y,
                       byte fgclr, byte bgclr, char ch, int count);
/* prints "count" characters "ch" in fgcolor "fgclr" and bgcolor "bgclr"
   at "x","y"
 * if "fgclr" = NO, foreground is not modified
 * if "bgclr" = NO, background is not modified
 * if "x" and "y" both equal TCUR, advances the cursor position to one
   past the last attribute printed
 * RETURNS: ASCII value of first character overwritten                      */

char txt_chr_erase(byte x, byte y, int count);
/* overwrites "count" characters at "x","y" with spaces
 * RETURNS: ASCII value of first character overwritten                      */

char txt_chr_get(byte x, byte y);
/* RETURNS: ASCII value of character at "x","y"                             */

char txt_chr_show(byte x, byte y, char ch, int count);
/* prints "count" characters "ch" at "x","y"
 * RETURNS: ASCII value of first character overwritten                      */

char txt_chrattr_save(byte x, byte y, word *chrattr);
/* stores character with its attribute at "x","y" into "chrattr"
 * RETURNS: ASCII value of character that was saved                         */

char txt_chrattr_show(byte x, byte y,
                      byte fgclr, byte bgclr, word chrattr, int count);
/* prints "count" characters with attributes, from "chrattr", at "x","y"
 * if "fgclr" = NO, foreground is not modified
 * if "bgclr" = NO, background is not modified
 * RETURNS: ASCII value of first character overwritten                      */

char txt_chrattrs_fill(byte x, byte y, byte length, byte height,
                       byte fgclr, byte bgclr, char ch);
/* the region with corner "x","y", x-length "length", and y-height "height"
   is filled with "ch" in "fgclr","bgclr"
 * if "fgclr" = NO, foreground is not modified
 * if "bgclr" = NO, background is not modified
 * if "ch" = NO, no character is written
 * RETURNS: ASCII value of first character overwritten                      */

word txt_chrattrs_need(byte length, byte height);
/* RETURNS: memory requirement for a "txt_chrattrs_save"ed image            */

void txt_chrattrs_save(byte x, byte y,
                       byte length, byte height, textimagedata *chrattrs);
/* stores the region of characters and their attributes from corner
   "x","y" with x-length "length" and y-height "height" into "chrattrs"
 * if "x" = MEM, "chrattrs.x" is used
 * if "y" = MEM, "chrattrs.y" is used
 * if "length" = MEM, "chrattrs.length" is used
 * if "height" = MEM, "chrattrs.height" is used                             */

void txt_chrattrs_show(byte x, byte y,
                       byte fgclr, byte bgclr, textimagedata *chrattrs);
/* prints a region of character and their attributes "chrattrs" at
   top-left corner "x","y"
 * if "x" = MEM, "chrattrs.x" is used
 * if "y" = MEM, "chrattrs.y" is used
 * if "fgclr" = NO,  foreground color is not modified
              = YES, modifies foreground with stored colors
              = MEM, "chrattrs.fgclr" is used
 * if "bgclr" = NO,  background color is not modified
              = YES, modifies background with stored colors
              = MEM, "chrattrs.bgclr" is used                               */

void txt_chrattrs_show_char(byte x, byte y, byte x_timage, byte y_timage,
                            byte fgclr, byte bgclr, textimagedata *chrattrs);
/* prints one character and its attributes from "x_timage","y_timage" of
   "chrattrs" at screen "x","y"
 * if "x" = MEM, "chrattrs.x" is used
 * if "y" = MEM, "chrattrs.y" is used
 * if "fgclr" = NO,  foreground color is not modified
              = YES, modifies foreground with stored colors
              = MEM, "chrattrs.fgclr" is used
 * if "bgclr" = NO,  background color is not modified
              = YES, modifies background with stored colors
              = MEM, "chrattrs.bgclr" is used                               */

void txt_chrattrs_show_str(byte x, byte y, byte x_timage, byte y_timage,
               byte length,  byte fgclr, byte bgclr, textimagedata *chrattrs);
/* prints string of character and their attributes from "x_timage","y_timage"
   of "chrattrs" at screen "x","y"
 * if "x" = MEM, "chrattrs.x" is used
 * if "y" = MEM, "chrattrs.y" is used
 * if "fgclr" = NO,  foreground color is not modified
              = YES, modifies foreground with stored colors
              = MEM, "chrattrs.fgclr" is used
 * if "bgclr" = NO,  background color is not modified
              = YES, modifies background with stored colors
              = MEM, "chrattrs.bgclr" is used                               */

void txt_chrattrs_show_region(byte x, byte y, byte x_timage, byte y_timage,
   byte length, byte height, byte fgclr, byte bgclr, textimagedata *chrattrs);
/* prints region of character and their attributes from "x_timage","y_timage"
   of "chrattrs" at screen "x","y"
 * if "x" = MEM, "chrattrs.x" is used
 * if "y" = MEM, "chrattrs.y" is used
 * if "fgclr" = NO,  foreground color is not modified
              = YES, modifies foreground with stored colors
              = MEM, "chrattrs.fgclr" is used
 * if "bgclr" = NO,  background color is not modified
              = YES, modifies background with stored colors
              = MEM, "chrattrs.bgclr" is used                               */

void txt_chrs_erase(byte x, byte y, textimagedata *chrs);
/* overwrites "chrs" with corner at "x","y" with spaces
 * if "x" = MEM, "chrs.x" is used
 * if "y" = MEM, "chrs.y" is used                                           */

void txt_chrs_fill(byte x, byte y, byte length, byte height, char ch);
/* the region with corner "x","y", x-length "length", and y-height
   "height" is filled with character "ch"                                   */

word txt_chrs_need(byte length, byte height);
/* RETURNS: memory requirement for a "txt_chrs_save"ed image                */

void txt_chrs_save(byte x, byte y,
                   byte length, byte height, textimagedata *chrs);
/* stores the region of characters from corner "x","y" with x-length
   "length" and y-height "height" into "chrs"
 * if "length" = MEM, "chrs.length" is used
 * if "height" = MEM, "chrs.height" is used                                 */

void txt_chrs_show(byte x, byte y, textimagedata *chrs);
/* prints the region of character "chrs" with top-left corner "x","y"
 * if "x" = MEM, "chrs.x" is used
 * if "y" = MEM, "chrs.y" is used                                           */

/* ------------------------------------------------------------------------ */
/* ------------------  TEXT CURSOR FUNCTION PROTOTYPES  ------------------- */

void cur_get(cursordata *curdata);
/* fills structure "curdata" with all text cursor information               */

void cur_get_abs(cursordata *curdata);
/* fills structure "curdata" with all text cursor information, as reported by
   VGA card                                                                 */

void cur_get_coord(byte *x, byte *y);
/* stores cursor abscissa in "x" and cursor ordinate in "y" on active page
 * if "y" = NULL, "x" is assumed to be "byte *xy"                           */

void cur_get_coord_abs(byte *x, byte *y);
/* stores cursor abscissa in "x" and cursor ordinate in "y", as reported by
   VGA card
 * if "y" = NULL, "x" is assumed to be "byte *xy"                           */

void cur_get_shape(byte *start, byte *end);
/* gets cursor shape on active page
 * stores starting scan line into "start", ending scan line into "end"
 * if "end" = NULL, "start" is assumed to be "byte *start_end"              */

void cur_get_shape_abs(byte *start, byte *end);
/* gets cursor shape as reported by VGA card
 * stores starting scan line into "start", ending scan line into "end"
 * if "end" = NULL, "start" is assumed to be "byte *start_end"              */

byte cur_get_x(void);
/* RETURNS: cursor abscissa on active page                                  */

byte cur_get_x_abs(void);
/* RETURNS:cursor abscissa as reported by VGA card                          */

byte cur_get_y(void);
/* RETURNS: cursor ordinate on active page                                  */

byte cur_get_y_abs(void);
/* RETURNS:cursor ordinate as reported by VGA card                          */

boolean cur_is_on(void);
/* RETURNS:TRUE if text cursor is on, FALSE if not                          */

void cur_off(void);
/* turns cursor off                                                         */

void cur_on(void);
/* turns cursor on                                                          */

void cur_set(cursordata *curdata);
/* sets cursor statistics according to "curdata"                            */

void cur_set_bios(cursordata *curdata);
/* sets cursor statatics according to "curdata" via BIOS                    */

byte cur_set_coord(byte x, byte y);
/* sets cursor to "x","y"
 * if "x" = MCUR, cursor abscissa is set to mouse abscissa
 * if "y" = MCUR, cursor ordinate is set to mouse ordinate
 * RETURNS: cursor abscissa                                                 */

void cur_set_coord_bios(byte x, byte y);
/* sets cursor to "x","y" via BIOS                                          */

void cur_set_shape(byte start, byte end);
/* defines new cursor shape, starting at scan line "start", ending at
   scan line "end"
 * if "start" = NO, starting scan line of cursor is not modified
 * if "end" = NO, ending scan line of cursor is not modified
 * "start" and end" must be between 0 - 31                                  */

void cur_set_shape_bios(byte start, byte end);
/* defines new cursor shape, starting at scan line "start", ending at
   scan line "end"
 * "start" and end" must be between 0 - 31                                  */

byte cur_set_x(byte x);
/* sets cursor abscissa to "x"
 * RETURNS: cursor ordinate                                                 */

byte cur_set_x_bios(byte x);
/* sets cursor abscissa to "x" via BIOS
 * RETURNS: cursor ordinate                                                 */

byte cur_set_y(byte y);
/* sets cursor ordinate to "y"
 * RETURNS: cursor abscissa                                                 */

byte cur_set_y_bios(byte y);
/* sets cursor ordinate to "y" via bios
 * RETURNS: cursor abscissa                                                 */

/* ------------------------------------------------------------------------ */
/* -----------------  TEXT USER INPUT FUNCTION PROTOTYPES  ---------------- */

int txt_get_let(byte x, byte y, char *str, byte max, byte fillchar,
                char *msg, byte fgclr, byte bgclr, char *def);
/* accepts only alphabet character input from keyboard into "str"
 * accepts a maximum of "max" characters; if "max" = MAX, accepts a
   maximum of "str_len(str)" characters
 * prints message "msg" at "x","y" followed by default response "def"
 * fills empty response space with "fillchar", unless "fillchar" = NO
 * colors response space with "fgclr","bgclr"
 * will not allow input to exceed screen limit
 * hides text cursor and restores its position upon return
 * RETURNS: number of characters of input
            -1 if <ESC> is pressed
            -2 if an error occurred                                         */

int txt_get_num(byte x, byte y, int *input, byte max, byte fillchar,
                char *msg, byte fgclr, byte bgclr, char *def);
/* accepts only numeric digit input and '+','-' from keyboard into "input"
 * accepts a maximum of "max" characters; input is allowed to be -32768..32767
 * prints message "message" at "x","y" followed by default response "def"
 * fills empty response space with "fillchar", unless "fillchar" = NO
 * colors response space with "fgclr","bgclr"
 * will not allow input to exceed screen limit
 * hides text cursor and restores its position upon return
 * RETURNS: number of characters of input
            -1 if <ESC> is pressed
            -2 if an error occurred                                         */

int txt_get_numu(byte x, byte y, word *input, byte max, byte fillchar,
                 char *msg, byte fgclr, byte bgclr, char *def);
/* accepts only numeric digit input from keyboard into "input"
 * accepts a maximum of "max" characters; input is allowed between 0..65535
 * prints message "message" at "x","y" followed by default response "def"
 * fills empty response space with "fillchar", unless "fillchar" = NO
 * colors response space with "fgclr","bgclr"
 * will not allow input to exceed screen limit
 * hides text cursor and restores its position upon return
 * RETURNS: number of characters of input
            -1 if <ESC> is pressed
            -2 if an error occurred                                         */

int txt_get_str(byte x, byte y, char *str, byte max, byte fillchar,
                char *msg, byte fgclr, byte bgclr, char *def);
/* accepts all ASCII character input from keyboard into "str"
 * accepts a maximum of "max" characters; if "max" = MAX, accepts a maximum
   of "str_len(str)" characters
 * prints message "message" at "x","y" followed by default response
   "def"
 * fills empty response space with "fillchar", unless "fillchar" = NO
 * colors response space with "fgclr","bgclr"
 * will not allow input to exceed screen limit
 * hides text cursor and restores its position upon return
 * RETURNS: number of characters of input
            -1 if <ESC> is pressed
            -2 if an error occurred                                         */

/* ------------------------------------------------------------------------ */
/* -------------------  TEXT STRING FUNCTION PROTOTYPES  ------------------ */

void txt_str_attr_show(byte x, byte y,
                       byte fgclr, byte bgclr, char *str, byte command);
/* prints string "str" in fgcolor "fgclr" and bgcolor "bgclr" at "x","y"
 * if "fgclr" = NO,  foreground color is not modified
 * if "bgclr" = NO,  background color is not modified
 * if "command" = ALIGN_NONE   no command
                = ALIGN_HORZ   horizontal center; shifts odd lengths left
                = ALIGN_VERT   vertical center; shifts odd lengths up
                = ALIGN_CENTER horizontal and vertical center
                = ALIGN_RIGHT  right justify; flush to right margin         */

word txt_str_erase(byte x, byte y, char *str, byte command);
/* overwrites "str" at "x","y" with blanks (ASCII 32)
 * if "command" = ALIGN_NONE   no command
                = ALIGN_HORZ   horizontal center; shifts odd lengths left
                = ALIGN_VERT   vertical center; shifts odd lengths up
                = ALIGN_CENTER horizontal and vertical center
                = ALIGN_RIGHT  right justify; flush to right margin
 * RETURNS: length of "str"                                                 */

word txt_str_erase_pr(byte x, byte y, printdata *prdata);
/* overwrites "printdata.text" at "x","y" with blanks (ASCII 32)
 * if "x" = MEM, "prdata.x" is used
 * if "y" = MEM, "prdata.y" is used
 * RETURNS: length of "prdata.string"                                       */

word txt_str_save(byte x, byte y, byte length, char *str, byte command);
/* reads "length" characters from "x","y" into "str"
 * if "length" = NULL, uses length of "str" as number of characters to read
 * The NULL character is appended as last character in "str"
 * if "command" = ALIGN_NONE   no command
                = ALIGN_HORZ   horizontal center; shifts odd lengths left
                = ALIGN_VERT   vertical center; shifts odd lengths up
                = ALIGN_CENTER horizontal and vertical center
                = ALIGN_RIGHT  right justify; flush to right margin
 * RETURNS: length of "str"                                                 */

word txt_str_show(byte x, byte y, char *str, byte command);
/* prints string "str" at "x","y"
 * if "command" = ALIGN_NONE   no command
                = ALIGN_HORZ   horizontal center; shifts odd lengths left
                = ALIGN_VERT   vertical center; shifts odd lengths up
                = ALIGN_CENTER horizontal and vertical center
                = ALIGN_RIGHT  right justify; flush to right margin
 * RETURNS: length of "str"                                                 */

word txt_strattr_need(byte length);
/* RETURNS: memory requirement for "txt_strattr_save"ed image of
   x-length "length"                                                        */

word txt_strattr_save(byte x, byte y, shortint length,textimagedata *strattr);
/* reads "length" characters and their attributes from "x","y" to "strattr"
 * if "length" = MEM, "strattr.length" is used
 * RETURNS: character count of "strattr" (which is length / 2)              */

word txt_strattr_show(byte x, byte y, byte fgclr, byte bgclr,
                      textimagedata *strattr, byte command);
/* prints string with attributes "strattr" at "x","y"
 * if "fgclr" = NO,  foreground color is not modified
              = YES, modifies foreground with stored colors
              = MEM, "strattr.fgclr" is used
 * if "bgclr" = NO,  background color is not modified
              = YES, modifies background with stored colors
              = MEM, "strattr.bgclr" is used
 * if "command" = ALIGN_NONE   no command
                = ALIGN_HORZ   horizontal center; shifts odd lengths left
                = ALIGN_VERT   vertical center; shifts odd lengths up
                = ALIGN_CENTER horizontal and vertical center
                = ALIGN_RIGHT  right justify; flush to right margin
 * RETURNS: character count of "strattr" (which is length / 2)              */

/* ------------------------------------------------------------------------ */
/* -------------------  TEXT WINDOW FUNCTION PROTOTYPES  ------------------ */

word win_define(void);
/* defines a new window                                                     */

void win_move(void);
/* moves a window to absolute coordinates                                   */

void win_move_rel(void);
/* moves a window relative to its current position                          */

void win_scroll(int horz, int vert, windowdata *win);
/* scrolls window "win" "horz" chars horizontally and "vert" chars
   vertically -- negatives apply                                            */

/* ------------------------------------------------------------------------ */
/* -----------------------  VGA FUNCTION PROTOTYPES  ---------------------- */

void fade_in(void);                         /* fade into a screen           */

void fade_out(void);                        /* fade a screen to black       */

boolean isit_color(void);   /* RETURNS: TRUE if color capable, FALSE if not */

boolean isit_ega(void);     /* RETURNS: TRUE if   EGA capable, FALSE if not */

boolean isit_vga(void);     /* RETURNS: TRUE if   VGA capable, FALSE if not */

boolean isit_svga(void);    /* RETURNS: TRUE if  SVGA capable, FALSE if not */

/* ------------------------------------------------------------------------ */
/* -----------------  VGA 640x480x16 FUNCTION PROTOTYPES  ----------------- */

void _16_boxfill(int x, int y, int length, int height, int color, int how);
/* creates a solid box of color "color" with one corner at "x","y" and
   x-length "length" and y-height "height" (which can be negative)
 * RETURNS: 0 if successful or -1 if box dimensions are off-screen
 * "how" determines how image is drawn: COPY_IMAGE - draws image
                                        AND_IMAGE  - ANDs image
                                        OR_IMAGE   - ORs image
                                        XOR_IMAGE  - XORs image
         COPY_IMAGE_SET - draws image and sets to current scroll
         AND_IMAGE_SET  - ANDs  image and sets to current scroll
         OR_IMAGE_SET   - ORs   image and sets to current scroll
         XOR_IMAGE_SET  - XORs  image and sets to current scroll            */

void _16_boxoutline(int x, int y, int length, int height, int color,int how);
/* creates an outline of a box color "color" with one corner at "x","y"
   and x-length "length" and y-height "height" (which can be negative)
 * "length" and "height" must be at least 2
 * RETURNS: 0 if successful or -1 if box dimensions are off-screen
 * "how" determines how image is drawn: COPY_IMAGE - draws image
                                        AND_IMAGE  - ANDs image
                                        OR_IMAGE   - ORs image
                                        XOR_IMAGE  - XORs image
         COPY_IMAGE_SET - draws image and sets to current scroll
         AND_IMAGE_SET  - ANDs  image and sets to current scroll
         OR_IMAGE_SET   - ORs   image and sets to current scroll
         XOR_IMAGE_SET  - XORs  image and sets to current scroll            */

void _16_floodall(int color, int scroll);
/* floods a screen-size with color "color
 * "scroll" determines relative to what flood will occur:
                                              TRUE  - relative to screen
                                              FALSE - relative to A000:0000 */

void _16_floodallall(int color);
/* floods a 640x816 region of video RAM with color "color"                  */

void _16_linebiglen(int x, int y, int length,
                    int height, int color, int how, int dimensions);
/* draws line with one end at "x","y", x-length "length", and y-height
   "height" in color "color"
 * "how" determines how image is drawn: COPY_IMAGE - draws image
                                        AND_IMAGE  - ANDs image
                                        OR_IMAGE   - ORs image
                                        XOR_IMAGE  - XORs image
         COPY_IMAGE_SET - draws image and sets to current scroll
         AND_IMAGE_SET  - ANDs  image and sets to current scroll
         OR_IMAGE_SET   - ORs   image and sets to current scroll
         XOR_IMAGE_SET  - XORs  image and sets to current scroll
 * line is drawn using user-specified block size "dimensions"               */

void _16_linebigxy(int x1, int y1, int x2, int y2,
                   int color, int how, int dimensions);
/* draws a line from "x1","y1" to "x2","y2" in color "color"
 * line is drawn using user-specified block size "dimensions"
 * "how" determines how image is drawn: COPY_IMAGE - draws image
                                        AND_IMAGE  - ANDs image
                                        OR_IMAGE   - ORs image
                                        XOR_IMAGE  - XORs image
         COPY_IMAGE_SET - draws image and sets to current scroll
         AND_IMAGE_SET  - ANDs  image and sets to current scroll
         OR_IMAGE_SET   - ORs   image and sets to current scroll
         XOR_IMAGE_SET  - XORs  image and sets to current scroll            */

void _16_linelen(int x, int y, int length, int height, int color, int how);
/* draws line with one end at "x","y", x-length "length", and y-height
   "height" in color "color"
 * same as "linexy" but draws line using relative distances
 * RETURNS: 0 if successful or -1 if line dimensions are off-screen
 * "how" determines how image is drawn: COPY_IMAGE - draws image
                                        AND_IMAGE  - ANDs image
                                        OR_IMAGE   - ORs image
                                        XOR_IMAGE  - XORs image
         COPY_IMAGE_SET - draws image and sets to current scroll
         AND_IMAGE_SET  - ANDs  image and sets to current scroll
         OR_IMAGE_SET   - ORs   image and sets to current scroll
         XOR_IMAGE_SET  - XORs  image and sets to current scroll            */

void _16_linexy(int x1, int y1, int x2, int y2, int color, int how);
/* draws a line from "x1","y1" to "x2","y2" in color "color"
 * same as "linecool" but draws line properly
 * "how" determines how image is drawn: COPY_IMAGE - draws image
                                        AND_IMAGE  - ANDs image
                                        OR_IMAGE   - ORs image
                                        XOR_IMAGE  - XORs image
         COPY_IMAGE_SET - draws image and sets to current scroll
         AND_IMAGE_SET  - ANDs  image and sets to current scroll
         OR_IMAGE_SET   - ORs   image and sets to current scroll
         XOR_IMAGE_SET  - XORs  image and sets to current scroll
 * RETURNS: 0 if successful or -1 if line dimensions are off-screen         */

void _16_pixel(int x, int y, int color, int scroll);
/* changes pixel at "x","y" to "color"
 * "scroll" determines relative to what pixel will be set:
                                              TRUE  - relative to screen
                                              FALSE - relative to A000:0000 */

int _16_pixel_avg(int x, int y, int scroll);
/* "scroll" determines relative to what pixel will be read:
                                              TRUE  - relative to screen
                                              FALSE - relative to A000:0000
 * RETURNS: average color of nine pixels surrounding "x","y"                */

int _16_pixel_color(int x, int y, int scroll);
/* "scroll" determines relative to what pixel will be read:
                                              TRUE  - relative to screen
                                              FALSE - relative to A000:0000
 * RETURNS: pixel color at "x","y"                                          */

boolean _16_pixel_is(int x, int y, int color, int scroll);
/* "scroll" determines relative to what pixel will be checked:
                                              TRUE  - relative to screen
                                              FALSE - relative to A000:0000
 * RETURNS: TRUE  if pixel at "x","y" is "color"
            FALSE if not                                                    */

int _16_popupcolumn(int x, int y, int choice, int maxopts,
                    char *ptr[], int mousepresent);
/* a column will pop up at "x","y" with maximum choices "maxopts"
 * "choice" will be first highlighted menu
 * "ptr" points to main menu options
 * "mousepresent" is TRUE if a mouse is present and has been initialized
   with "ms_init()"                                                         */

int _16_popupmenu(int x, int y, int choice, int maxmenus,
                  char *ptr[], int data[][3], char *text[], int mousepresent);
/* a menu will pop up at "x","y" with maximum choices "maxmenus"
 * "choice" will be first highlighted menu
 * "ptr" points to main menu options
 * "data" holds necessary data
   [number of submenus], [index into *text], [1 = active, 0 = inactive]
 * "text" points to all of submenus
 * "mousepresent" is TRUE if a mouse is present and has been initialized
   with "ms_init()"                                                         */

int _16_scrollevel(void);     /* RETURNS: number of rows currently scrolled */

void _16_scrollrow(int rows);
/* scrolls screen "rows" rows (+ve scrolls down, -ve scrolls up)
 * if "rows" = 0, restores video pointer to A000:0000                       */

void _16_thermal(int x, int y, int length, int height);
/* scans through each pixel, taking average color of surrounding pixels
 * "scroll" determines relative to what pixel will be read:
                                              TRUE  - relative to screen
                                              FALSE - relative to A000:0000 */

/* ------------------------------------------------------------------------ */
/* --------------  VGA 640x480x16 IMAGE FUNCTION PROTOTYPES  -------------- */

void _16_copy(imagedata *destination, imagedata *source);
/* copies "source" into "destination"
 * both must be "_16_c_save"ed, "_16_i_save"ed, or "_16_p_save"ed images
 * make sure "destination" has been been allocated sufficient memory        */

void _16_move(int oldx, int oldy, int newx, int newy,
              int id, imagedata *oldgraph, imagedata *graph[]);
/* "oldgraph", at "oldx","oldy", is moved
 * the new image "image" becomes located at "newx","newy"
 * if "oldx" = MCUR, mouse cursor abscissa is used
             = MEM,  "oldgraph.x" is used
 * if "oldy" = MCUR, mouse cursor ordinate is used
             = MEM,  "oldgraph.y" is used
 * if "newx" = MCUR, mouse cursor abscissa is used
             = MEM,  "graph.x" is used
 * if "newy" = MCUR, mouse cursor ordinate is used
             = MEM,  "graph.y" is used
 * "segment" determines memory location of background image
 * "id" is a unique number indexing
 * "memoryidentity" that identifies graphic (it is a constant)
 * "segment" determines memory location of background image
 * two global arrays required: "memoryidentity" and "memoryaddress"
     unsigned int memoryidentity[MAXGRAPHICS];
     void *memoryaddress[MAXGRAPHICS];
   DO NOT MODIFY THESE VARIABLES -- THEY ARE USED BY THE ASSEMBLER ROUTINES
   "memoryidentity" is a unique graphic number for each separate image
   "memoryadddress" is an array of video memory offsets for each image
 * this procedure will animate "_16_c_save"ed images                        */

/* ------------------------------------------------------------------------ */
/* ----------  VGA 640x480x16 COMPRESS IMAGE FUNCTION PROTOTYPES  --------- */

/* use all of these routines only with images saved by "_16_c_save"         */

void _16_c_move(int oldx, int oldy, int newx, int newy,
                imagedata *oldgraph, imagedata *graph, imagedata *segment[]);
/* "oldgraph", at "oldx","oldy", is moved
 * the new image "image" becomes located at "newx","newy"
 * if "oldx" = MCUR, mouse cursor abscissa is used
             = MEM,  "oldgraph.x" is used
 * if "oldy" = MCUR, mouse cursor ordinate is used
             = MEM,  "oldgraph.y" is used
 * if "newx" = MCUR, mouse cursor abscissa is used
             = MEM,  "graph.x" is used
 * if "newy" = MCUR, mouse cursor ordinate is used
             = MEM,  "graph.y" is used
 * "segment" determines memory location of background image                 */

unsigned int _16_c_need_scrn(int left, int top, int length, int height);
/* RETURNS: memory requirement of image with top-left corner at
   "left","top" and x-length "length" and y-height "height"                 */

unsigned int _16_c_need_wrst(int length, int height);
/* RETURNS: worst-case memory requirement of theoretical image with
   x-length "length" and y-height "height"
 * use only with "_16_c_save"                                               */

int _16_c_percent(imagedata *image);
/* RETURNS: how much percent smaller (or larger) a "_16_c_save"ed image is,
   compared to an uncompressed "_16_p_save"ed image (relative to 100)
 * a return value of 40 means 60% smaller whereas 125 means 25% larger      */

int _16_c_read_off(imagedata *image, int offset);
/* RETURNS: color of pixel "offset" (starts at 0) of image "image"          */

int _16_c_read_xy(imagedata *image, int x, int y);
/* RETURNS: color of pixel at "x","y" of image "image"                      */

void _16_c_save(int left, int top, int length, int height,
	int transparency_color, imagedata *image, unsigned int size, int how);
/* stores screen location with top-left corner at "left","top",
   x-length "length", y-height "height", and transparency color
   "transparency_color" into image "image"
 * if byte size "size" is 0, it will be calculated automatically
 * "how" determines if image will be saved relative to current
   scroll or not:  TRUE  - image is saved relative to current scroll
                   FALSE - image is saved relative to A000:0000             */

void _16_c_show(int x, int y, imagedata *image, byte how);
/* writes image "image" at "x","y"
 * if "x" = -1, "imagedata.x" is used for abscissa and "imagedata.y"
   is used for ordinate
 * bit "imagedata.how" determines if image is shown relative to
   screen (TRUE) or relative to A000:0000 (FALSE)
 * "how" determines how image is drawn: COPY_IMAGE - draws image
                                        AND_IMAGE  - ANDs image
                                        OR_IMAGE   - ORs image
                                        XOR_IMAGE  - XORs image             */

void _16_i_to_c(imagedata *destination_c, imagedata *source_i);
/* converts "_16_i_save"ed image "source_i"
   into "_16_c_save"ed image "destination_c"                                */

void _16_p_to_c(imagedata *destination_c, imagedata *source_p);
/* converts "_16_p_save"ed image "source_p"
   into "_16_c_save"ed image "destination_c"                                */

/* ------------------------------------------------------------------------ */
/* -----------  VGA 640x480x16 PIXEL IMAGE FUNCTION PROTOTYPES  ----------- */

/* use all of these routines only with images saved by "_16_p_save"         */

void _16_c_to_p(imagedata *destination_p, imagedata *source_c);
/* converts "_16_c_save"ed image "source_c"
   into "_16_p_save"ed image "destination_p"                                */

void _16_i_to_p(imagedata *destination_p, imagedata *source_i);
/* converts "_16_i_save"ed image "source_i"
   into "_16_p_save"ed image "destination_p"                                */

void _16_p_move(int oldx, int oldy, int newx, int newy,
                imagedata *oldgraph, imagedata *graph, imagedata *segment[]);
/* "oldgraph", at "oldx","oldy", is moved
 * the new image "image" becomes located at "newx","newy"
 * if "oldx" = MCUR, mouse cursor abscissa is used
             = MEM,  "oldgraph.x" is used
 * if "oldy" = MCUR, mouse cursor ordinate is used
             = MEM,  "oldgraph.y" is used
 * if "newx" = MCUR, mouse cursor abscissa is used
             = MEM,  "graph.x" is used
 * if "newy" = MCUR, mouse cursor ordinate is used
             = MEM,  "graph.y" is used
 * "segment" determines memory location of background image                 */

unsigned int _16_p_need(int length, int height);
/* RETURNS: memory requirement of a
   "_16_p_save"ed image of x-length "length and y-height "height"           */

int _16_p_read_off(imagedata *image, int offset);
/* RETURNS: color of pixel "offset" (starts at 0) of image "image"          */

int _16_p_read_xy(imagedata *image, int x, int y);
/* RETURNS: color of pixel at "x","y" of image "image"                      */

void _16_p_save(int left, int top, int length, int height,
	 int transparencycolor, imagedata *image, unsigned int size, int how);
/* stores screen location with top-left corner at "left","top",
   x-length "length", y-height "height", and transparency color
   "transparency_color" into image "image"
 * if byte size "size" is 0, it will be calculated automatically
 * "how" determines if image will be saved relative to current
   scroll or not:  TRUE  - image is saved relative to current scroll
                   FALSE - image is saved relative to A000:0000             */

void _16_p_show(int x, int y, imagedata *image, byte how);
/* writes image "image" at "x","y"
 * if "x" = -1, "imagedata.x" is used for abscissa and "imagedata.y"
   is used for ordinate
 * bit "imagedata.how" determines if image is shown relative to
   screen (TRUE) or relative to A000:0000 (FALSE)
 * "how" determines how image is drawn: COPY_IMAGE - draws image
                                        AND_IMAGE  - ANDs image
                                        OR_IMAGE   - ORs image
                                        XOR_IMAGE  - XORs image             */

/* ------------------------------------------------------------------------ */
/* -----------  VGA 640x480x16 PLANE IMAGE FUNCTION PROTOTYPES  ----------- */

/* use all of these routines only with images saved by "_16_i_save"         */

void _16_c_to_i(imagedata *destination_i, imagedata *source_c);
/* converts "_16_c_save"ed image "source_c"
   into "_16_i_save"ed image "destination_i"                                */

void _16_i_move(int oldx, int oldy, int newx, int newy,
             imagedata *oldgraph[], imagedata *graph[], imagedata *segment[]);
void _16_i_move_rect(int oldx, int oldy, int newx, int newy,
             imagedata *oldgraph[], imagedata *graph[], imagedata *segment[]);
/* use "_16_i_move_rect" to move rectangular graphics only
 * "oldgraph", at "oldx","oldy", is moved
 * "oldgraph[0]" is the full-color graphic and "oldgraph[1]" is the full-
   black version of the graphic
 * the new image "image" becomes located at "newx","newy"
 * "graph[0]" is the full-color graphic and "graph[1]" is the
   full-black version of the graphic
 * if "oldx" = MCUR, mouse cursor abscissa is used
             = MEM,  "oldgraph.x" is used
 * if "oldy" = MCUR, mouse cursor ordinate is used
             = MEM,  "oldgraph.y" is used
 * if "newx" = MCUR, mouse cursor abscissa is used
             = MEM,  "graph.x" is used
 * if "newy" = MCUR, mouse cursor ordinate is used
             = MEM,  "graph.y" is used
 * "segment" determines memory location of background image                 */

unsigned int _16_i_need(int length, int height);
/* RETURNS: memory requirement of a
   "_16_i_save"ed image of x-length "length and y-height "height"           */

int _16_i_read_off(imagedata *image, int offset);
/* RETURNS: color of pixel "offset" (starts at 0) of image "image"          */

int _16_i_read_xy(imagedata *image, int x, int y);
/* RETURNS: color of pixel at "x","y" of image "image"                      */

void _16_i_save(int left, int top, int length, int height,
                imagedata *image, unsigned int size, int how);
/* stores screen location with top-left corner at "left","top",
   x-length "length", and y-height "height" into image "image"
 * if byte size "size" is 0, it will be calculated automatically
 * "how" determines if image will be saved relative to current
   scroll or not:  TRUE  - image is saved relative to current scroll
                   FALSE - image is saved relative to A000:0000             */

void _16_i_show(int x, int y, imagedata *image, byte how);
/* writes image "image" at "x","y"
 * if "x" = -1, "imagedata.x" is used for abscissa and "imagedata.y"
   is used for ordinate
 * "how" determines how image is drawn: COPY_IMAGE - draws image
                                        AND_IMAGE  - ANDs image
                                        OR_IMAGE   - ORs image
                                        XOR_IMAGE  - XORs image
 * bit "imagedata.how" determines if image is shown relative to
   screen (TRUE) or relative to A000:0000 (FALSE)                           */

void _16_p_to_i(imagedata *destination_i, imagedata *source_p);
/* converts "_16_p_save"ed image "source_p"
   into "_16_i_save"ed image "destination_i"                                */

void _16_restore_bg(int left, int top,
                    int length, int height, imagedata *segment[]);
/* restores region of background with top-left
   corner at "left","top", x-length "length" and y-height "height"
 * background is stored in segment "segment"
 * bit "imagedata.how" determines if image is shown relative to
   screen (TRUE) or relative to A000:0000 (FALSE)                           */

/* ------------------------------------------------------------------------ */
/* -----------------  VGA 320x200x256 FUNCTION PROTOTYPES  ---------------- */

void _256_floodall(int color, int scroll);
/* floods a screen-size with color "color
 * "scroll" determines relative to what flood will occur:
                                              TRUE  - relative to screen
                                              FALSE - relative to A000:0000 */

void _256_pixel(int x, int y, int color, int scroll);
/* changes pixel at "x","y" to "color"
 * "scroll" determines relative to what pixel will be set:
                                              TRUE  - relative to screen
                                              FALSE - relative to A000:0000 */

/* ------------------------------------------------------------------------ */

#endif

/*==========================================================================*/

// REALiTY
