#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>
#include "colors.h"
#include "!bestlib.h"

   /*** NOTE  the names and structure of the routines used in these examples
              have changed in The Best Library 2.00; the updated examples will
              be released soon                                            ***/

#define FILE 1
#define SORT 2
#define PRINT 3
#define SCREEN 4
#define DOS 5

#define NEW 1
#define LOAD 2
#define SAVE 3
#define FONTSIZE 1
#define BLOCK 1
#define ENTIREDOCUMENT 2
#define EXTERNALFILE 3
#define EXITTO 1
#define SHELLTO 2

#define BGCOLOR DARKGRAY               /* background color                  */
#define TEXTCOLOR WHITE                /* color of text messages            */
#define ABORTCOLOR RED                 /* color of abort messages           */
#define ERASECOMMANDTEXT boxfill(0, txty, MAXX, txtht, BGCOLOR, COPY_IMAGE);

   /*** NOTE  even though this program only uses the "keyp" structure, the
              other three are necessary for the assembler routines in the
              !BESTLIB.LIB library to function properly.  C would also
              produce a "linker warning" if you have enabled that warning ***/
filldata fidata;                       /* create a "filldata" structure     */
printdata prdata;                      /* create a "printdata" structure    */
mousedata msdata;                      /* create a "mousedata" structure    */
asciiscan keyp;                        /* create an "asciiscan" structure   */

char *menu1ptr[] = { "FILE", "SORT", "PRINT", "SCREEN", "DOS" };   /* menus */
char *menu1text[] = {                                           /* submenus */
   (char *)0x001D,
   "NEW", "LOAD", "SAVE",
   "BLOCK", "ENTIRE DOCUMENT", "EXTERNAL FILE",
   "FONT SIZE",
   "EXIT TO", "SHELL TO"
};
int menu1data[][3] = { { 3, 1, 0x0007 },
                       { 0, 0, 0x0000 },
                       { 3, 4, 0x0004 },
                       { 1, 7, 0x0001 },
                       { 2, 8, 0x0003 }
};

void main(void)
{
   int gr_err, gdrv = VGA, gmod = VGAHI, fontsize = 5,
       oldmode, mouse = FALSE, command = FALSE, submenu,
       txtht = 15, txty = 465, menu, menux = MAXX / 3, menuy = 220;
   char *errmsg;

   oldmode = readvideomode();          /* save the current video mode       */
   if (oldmode == 3 || oldmode == 7 || oldmode == 21) {
                                       /* if the old mode was a text mode.. */
      textmem(3);                      /* store text video memory           */
      cursor(3, 1);                    /* hide and store cursor position    */
   }
   mouse = initms_gr();             /* initialize mouse driver if installed */
   initgraph(&gdrv, &gmod, "");        /* initialize graphics mode          */
   if ((gr_err = graphresult()) != grOk) {
      /* if an error occurred in changing to graphics mode, print the error */
      printf("Graphics error: %s\n", grapherrormsg(gr_err));
      exit(1);                        /* exit to DOS returning errorlevel 1 */
   }
   settextjustify(LEFT_TEXT, TOP_TEXT);
   settextstyle(SMALL_FONT, HORIZ_DIR, fontsize);  /* setup font size/style */
   floodall(BGCOLOR);                  /* create the screen background      */
   do {
      command = popupmenu(menux, menuy, 1, 5,
                          menu1ptr, menu1data, menu1text, mouse);
      if (command == -1) break;       /* if unable to allocate memory, exit */
      submenu = command & 0x000F, menu = command >> 4;
      setcolor(TEXTCOLOR);             /* set the appropriate text color    */
      switch(menu) {
      case FILE:                       /* a selection from the file menu    */
         switch(submenu) {
         case NEW:                     /* the new submenu was selected      */
            menu1text[0] = (char *)0x001D;  /* restore menu restrictions    */
            menu1data[2][2] = 0x0004;       /* disable submenu restrictions */
            ERASECOMMANDTEXT;               /* erase any previous messages  */
            outtextxy(0, txty, "The NEW submenu was selected -- some options \
disabled");
            break;
         case LOAD:                    /* the load submenu was selected     */
            menu1text[0] = (char *)0x001F;  /* enable menu restrictions     */
            menu1data[2][2] = 0x0007;       /* enable submenu restrictions  */
            ERASECOMMANDTEXT;               /* erase any previous messages  */
            outtextxy(0, txty, "The LOAD submenu was selected -- some options\
 enabled");
            break;
         case SAVE: ;                  /* the save submenu was selected     */
            ERASECOMMANDTEXT;          /* erase any previous messages       */
            outtextxy(0, txty, "The SAVE submenu was selected");
            break;
         }
         break;                        /* exit from switch statement        */
      case SORT:                       /* the sort menu was selected        */
         ERASECOMMANDTEXT;             /* erase any previous messages       */
         outtextxy(0, txty, "The SORT menu was selected");
         break;                        /* exit from switch statement        */
      case PRINT:                      /* a selection from the print menu   */
         switch(submenu) {
         case BLOCK:                   /* the block submenu was selected    */
            ERASECOMMANDTEXT;          /* erase any previous messages       */
            outtextxy(0, txty, "The BLOCK submenu was selected");
            break;
         case ENTIREDOCUMENT:          /* the entiredocument was selected   */
            ERASECOMMANDTEXT;          /* erase any previous messages       */
            outtextxy(0, txty, "The ENTIRE DOCUMENT submenu was selected");
            break;
         case EXTERNALFILE: ;          /* the externalfile was selected     */
            ERASECOMMANDTEXT;          /* erase any previous messages       */
            outtextxy(0, txty, "The EXTERNAL FILE submenu was selected");
            break;
         }
         break;                        /* exit from switch statement        */
      case SCREEN:                     /* a selection from the fonts menu   */
         switch(submenu) {
         case FONTSIZE:         /* the select new font submenu was selected */
            textm(0);                  /* make sure we are in text mode     */
            clear(LIGHTGRAY, BLACK);   /* clear the screen and set colors   */
            printsatxy("What font size would you like to use (1-7)?", 10, 12);
            readnumber(7, 1, 54, 12, &fontsize);  /* ask user for font size */
            initgraph(&gdrv, &gmod, "");     /* re-initialize graphics mode */
            settextstyle(SMALL_FONT, HORIZ_DIR, fontsize);     /* font size */
            txtht = textheight("A") + 3;     /* initialize text height      */
            txty = MAXY - txtht;             /* initialize text y-coord     */
            menux = MAXX - (textwidth(menu1ptr[3])+17 +
                    textwidth(menu1text[4])+33 + textwidth(menu1text[5])+33 +
                    textwidth(menu1text[6])+33);  /* calculate text x-coord */
            if (menux > MAXX / 3) menux = MAXX / 3;
            floodall(BGCOLOR);         /* create the screen background      */
         }
         break;                        /* exit from switch statement        */
      case DOS:                        /* a selection from the DOS menu     */
         switch(submenu) {
         case EXITTO: break;           /* the exit to submenu was selected  */
         case SHELLTO:                 /* the shell to submenu was selected */
            if ((errmsg = dosshell()) != NULL) {
               ERASECOMMANDTEXT;       /* erase any previous messages       */
               while (textwidth(errmsg) > MAXX)  /* entire message must fit */
                  settextstyle(SMALL_FONT, HORIZ_DIR, --fontsize);
               outtextxy(0, txty, errmsg);  /* print the returned error msg */
            }
            else {                     /* else if no error occurred..       */
               highstandardvga();      /* get back into 640x480x16 mode VGA */
               settextjustify(LEFT_TEXT, TOP_TEXT);
               settextstyle(SMALL_FONT, HORIZ_DIR, fontsize);
               floodall(BGCOLOR);      /* restore the screen background     */
               outtextxy(0, txty, "Welcome back!");
            }
            break;
         }
         break;
      case FALSE:                      /* no selection was registered       */
         setcolor(ABORTCOLOR);         /* set the appropriate abort color   */
         ERASECOMMANDTEXT;             /* erase any previous messages       */
         outtextxy(0, txty, "Operation aborted");
         setcolor(TEXTCOLOR);          /* restore text message color        */
         break;                        /* exit from switch statement        */
      }
   } while (menu != DOS || submenu != EXITTO);  /* loop until exit selected */

   changevideomode(oldmode);           /* restore the original video mode   */
   if (oldmode == 3 || oldmode == 7 || oldmode == 21) {
                                       /* if the old mode was a text mode.. */
      textmem(1);                      /* restore text video memory         */
      cursor(1, 1);                    /* show and restore cursor position  */
   }
}
