'
'  TERM.BAS Example Program
'

'$INCLUDE: 'PCL4VB.BI'
'$INCLUDE: 'MODEM_IO.BI'
'$INCLUDE: 'TERM_IO.BI'
'$INCLUDE: 'DEFINES.BI'
'$INCLUDE: 'CRC.BI'
'$INCLUDE: 'XYPACKET.BI'
'$INCLUDE: 'PROCESS.BI'
'$INCLUDE: 'TIMING.BI'

 DECLARE SUB MyExit(BYVAL Port,Message$)
 DECLARE SUB SayYesNo(BYVAL Flag)                                                  

 Buf2048$ = STRING$(2048+16,0)
 'Above must be first string allocation statement. Buf2048$ should NOT be
 'referenced other than in computing BufSeg below.
 BufSeg = (1+SSEG(Buf2048$)) + (SADD(Buf2048$) \ 16)

 CONST FALSE = 0, TRUE = NOT FALSE
 CONST CTLZ = 26
 DIM RATES$(12)

 CLS
 COLOR 7
 rc = InitCRC()

 RATES$(1) = "300"
 RATES$(2) = "600"
 RATES$(3) = "1200"
 RATES$(4) = "2400"
 RATES$(5) = "4800"
 RATES$(6) = "9600"
 RATES$(7) = "19200"
 RATES$(8) = "38400"
 RATES$(9) = "57600"
 RATES$(10) = "115200"

 VIEW PRINT 1 TO 24
 PARMS$ = RTRIM$(COMMAND$)
 I = INSTR(PARMS$, " ")
 IF I < 1 THEN
   PRINT "  Usage: TERM <Port> <BaudRate>"
   PRINT "Example: TERM 1 9600"
   END
 END IF
 L = LEN(PARMS$)
 ARG1$ = LEFT$(PARMS$, I - 1)
 ARG2$ = LTRIM$(RIGHT$(PARMS$, L - I))
 BaudCode = -1
 'Get COM port
 Port = VAL(ARG1$) - 1
 'Get baud code
 FOR I = 1 TO 10
   IF RATES$(I) = ARG2$ THEN
      BaudCode = I - 1
      EXIT FOR
   END IF
 NEXT I
 'Verify good baud rate
 IF BaudCode = -1 THEN
   PRINT "Cannot recognize baud rate "; ARG2$
   END
 END IF
 'Reset port
 CALL InitProcess(Port,ARG2$)
 Code = SioRxBuf(Port, BufSeg, Size2K)
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioRxBuf()"
   Code = SioError(Code)
   END
 END IF
 Code = SioReset(Port, BaudCode)
 CLS
 IF Code < 0 THEN
   PRINT "Error "; Code; " returned from SioReset()"
   Code = SioError(Code)
   END
 END IF

 PRINT "-- TERM 5/5/95 --"
 PRINT " "
 LIBVER = SioInfo(ASC("V"))
 LV$ = LTRIM$(STR$(LIBVER\16)) + "." + LTRIM$(STR$(LIBVER MOD 16))
 PRINT "      Library: ";LV$
 PRINT "TX Interrupts: ";
 CALL SayYesNo(SioInfo(ASC("I")))
 PRINT " Flow Control: ";
 CALL SayYesNo(RTS_CTS_CONTROL)
 IF RTS_CTS_CONTROL THEN
   RC = SioFlow(Port,18)
 END IF
 PRINT "   16550 UART: ";
 CALL SayYesNo(SioFIFO(Port,LEVEL_8))
 PRINT "Seg(RxBuffer): ";HEX$(BufSeg)
 PRINT
 'always set DTR and RTS
 Code = SioDTR(Port, SET_LINE)
 Code = SioRTS(Port, SET_LINE)
 'wait for Modem to say its ready
 '(AT_COMMAND_SET, etc. defined in DEFINES.BI)
 IF AT_COMMAND_SET THEN
   PRINT "  <<Waiting for Modem DSR>>"
   DO
     IF SioDSR(Port) THEN
       EXIT DO
     ELSE
       AnyKey$ = INKEY$
       IF (AnyKey$ <> "") OR SioBrkKey() THEN
         CALL MyExit(Port,"Aborted by user")
       END IF
       PRINT ".";
       RC = SioDelay(18)
     END IF
   LOOP
   PRINT "  <<DSR on>>"
 END IF
 'waiting for modem CTS ?
 IF RTS_CTS_CONTROL THEN
   PRINT "  <<Waiting for Modem CTS>>"
   DO
     IF SioCTS(Port) THEN
       EXIT DO
     ELSE
       AnyKey$ = INKEY$
       IF (AnyKey$ <> "") OR SioBrkKey() THEN
         CALL MyExit(Port,"Aborted by user")
       END IF
       PRINT ".";
       RC = SioDelay(18)
     END IF
   LOOP
   PRINT "  <<CTS on>>"
 END IF
 'initialize (Hayes compatible) modem ?
 IF AT_COMMAND_SET THEN
   PRINT "  <<Initializing modem>>
   RC = ModemSendTo(Port,4,"AT!")
   RC = ModemEcho(Port,10)
   RC = ModemSendTo(Port,4,"AT E1 S7=60 S11=60 V1 X1 Q0!")
   IF ModemWaitFor(Port,5*ONE_SECOND,TRUE,"OK") THEN
     'modem is ready
      PRINT
      PRINT "  <<MODEM READY>>"
   ELSE
      PRINT
      PRINT "  <<WARNING: Expected OK not received>>"
   END IF
 END IF


 PRINT "Entering TERMINAL loop (^Z for MENU)..."
 CALL ShowStatus

 DO
   'Look at incoming serial
   Code = SioGetc(Port, 1)
   IF Code > -1 THEN
     Code = SioCrtWrite(Code)
   END IF
   'Anything to send
   AnyKey$ = INKEY$
   IF AnyKey$ <> "" THEN
     IF AnyKey$ = CHR$(CTLZ) THEN
       IF Process() THEN
         EXIT DO
       END IF
     ELSE
       Code = SioPutc(Port, ASC(AnyKey$))
     END IF
   END IF
 LOOP
 PRINT "User typed ^Z"
 Code = SioDone(Port)
 END

 SUB MyExit(BYVAL Port,Message$)
 rc = SioDone(Port)
 PRINT Message$
 STOP
 END SUB

 SUB SayYesNo(BYVAL Flag)                                                  
 IF Flag THEN
   PRINT "YES"
 ELSE
   PRINT "NO"
 END IF
 END SUB
