;
;
;    (CEVS) Cross-Eyed Viking Solutions 
;
;   PCX Unit 1.0 / 286 for real mode.
;   Lorne Kirkland Chartier (1996) - public domain.
;
;

H_PCX           equ 1                           ; skip extrn funcs in header

                .286p
                .model medium, pascal
                jumps

include         pcx.inc
include         support.inc

bsize           equ 4096                        ; size of i/o buffer
eof             equ 0ffffh                      ; end of file code

; this macro gets the next byte from a file
@fgetc          macro
                local fgiserr, fgetc1, fgetc2, fgetcx

                cmp cs:[bndx],0         ; are there bytes to read?
                jne fgetc2              ; if so, just go get one

                push ds
                push bx cx dx
                mov ax,cs
                mov ds,ax
                mov ax,3f00h
                mov cx,bsize
                mov dx,o buffer
                int 21h                 ; fill the buffer
                pop dx cx bx
                pop ds
                cmp ax,0                ; any bytes read
                je fgiserr
                jnc fgetc1              ; if no error, go on
fgiserr:
                mov ax,eof              ; otherwise, return eof
                jmp fgetcx
fgetc1:
                mov cs:[bndx],ax        ; how many bytes were read
                mov cs:[bpnt],o buffer
fgetc2:
                push si                 ; now, get the next byte
                mov si,cs:[bpnt]        ; from the buffer
                mov al,byte ptr cs:[si]
                pop si
                inc cs:[bpnt]           ; point to subsequent byte
                dec cs:[bndx]           ; decrement bytes left in buffer
                and ax,0ffh             ; null the high order byte
fgetcx:
                endm

; this macro writes a byte to a file
@fputc          macro
                local fpiserr, fputc1, fputc2, fputcx

                cmp cs:[bndx],bsize             ; is buffer less than full?
                jl fputc2                       ; if so, just go write byte

                push ds
                push ax bx cx dx
                mov ax,cs
                mov ds,ax
                mov ax,4000h
                mov cx,cs:[bndx]
                mov dx,o buffer
                int 21h                         ; write the buffer
                pop dx cx bx
                cmp ax,0                        ; any bytes read
                pop ax ds
                je fpiserr
                jnc fputc1                      ; if no error, go on
fpiserr:
                mov ax,eof                      ; otherwise, return eof
                jmp fputcx
fputc1:
                mov cs:[bndx],0                 ; no bytes in buffer anymore
                mov cs:[bpnt],o buffer
fputc2:
                push si
                mov si,cs:[bpnt]
                mov byte ptr cs:[si],al         ; write byte to buffer
                pop si
                inc cs:[bpnt]                   ; advance buffer pointer
                inc cs:[bndx]                   ; advance bytes in buffer
fputcx:
                endm

@fpflush        macro
                local fpflushd
                push ds
                mov ax,cs
                mov ds,ax                       ; ds = buffer segment
                mov ax,4000h
                mov cx,cs:[bndx]
                jcxz fpflushd
                mov dx,o buffer
                int 21h                         ; flush the buffer
fpflushd:
                pop ds
                endm


                .code

;
;   pcxreadhdr() - read & validate an 8-bit pcx header
;   pass:       pcxh - pcx header structure buffer
;               fhdl - file handle
;   returns:    carry flag set on error, carry clear if ok
;

                public pcxreadhdr

pcxreadhdr      proc pascal pcxh:far ptr byte, fhdl:word
                uses ds, si
                cld

                lds si,pcxh

                mov ah,3fh
                mov bx,fhdl
                mov cx,size PCX_Hdr
                mov dx,si
                int 21h                         ; read the pcx header
                jc pcxheaderd

                cmp [si].pcxhmanufact,0ah       ; manufacturer id valid?
                jne pcxheadere                  ; no, quit with error

                cmp [si].pcxhversion,5          ; version supports 256c+?
                jl pcxheadere                   ; no, quit with error

                cmp [si].pcxhbitsppix,8         ; 8-bit/24-bit bitmap?
                jne pcxheadere                  ; no, quit with error
                cmp [si].pcxhcplanes,1          ; 8-bit bitmap?
                jne pcxheadere                  ; no, quit with error

                clc
                jmp pcxheaderd

pcxheadere:
                stc
pcxheaderd:
                ret
pcxreadhdr      endp


;
;   pcxdecode() - decode an 8-bit pcx picture
;   pass:       pcxh - pre-read pcx header structure buffer
;               fhdl - file handle
;               dest - destination buffer
;               pal  - palette buffer (or 0 for don't load palette)
;   returns:    carry flag set on error, carry clear if ok
;

                public pcxdecode

pcxdecode       proc pascal pcxh:far ptr byte, fhdl:word, dest:far ptr byte, \
                            pal:far ptr byte
                uses ds, es, di
                cld

                lds di,pcxh
                mov cx,[di].pcxhymax
                sub cx,[di].pcxhymin
                inc cx                          ; cx = depth (line counter)
                mov dx,[di].pcxhxmax
                sub dx,[di].pcxhxmin
                inc dx                          ; dx = width

                mov bx,fhdl                     ; bx = file handle
                les di,dest                     ; es:di = pcx buffer

                mov cs:[bpnt],o buffer          ; init buffered i/o vars
                mov cs:[bndx],0


                ; -----------------------------------------
                ;   decode the pcx plane
                ; -----------------------------------------

align 2
pcxdloop:
                push cx dx                      ; save line counter, width

align 2
readpcxl_l1:
                @fgetc                          ; grab a byte

                mov cx,ax
                and cx,0c0h
                cmp cx,0c0h                     ; is it a run of bytes?
                jne readpcxone                  ; no, go do one

                mov ch,0
                mov cl,al
                and cx,3fh                      ; mask count
                cmp cx,dx
                jle readpcxmany
                mov cx,dx
readpcxmany:
                sub dx,cx

                @fgetc                          ; get repeat byte

           rep  stosb
                cmp dx,0
                jg readpcxl_l1
                jmp readfini

align 2
readpcxone:
                stosb
                dec dx
                jnz readpcxl_l1                 ; no, loop

readfini:
                pop dx cx                       ; restore line counter
                dec cx
                jz pcxdpal                      ; quit if done

                test di,4000h                   ; passed 16k boundary yet?
                jz pcxdloop                     ; no, keep decoding

                @normalize es, di               ; else normalize far pointer
                jmp pcxdloop                    ; keep decoding

pcxdpal:
                @fgetc
                cmp al,0ch                      ; palette found?
                jne pcxdecoded

                mov cx,768
                les di,pal
                mov ax,es
                or ax,ax
                jz pcxdecoded
pcxdpal2:
                @fgetc                          ; grab palette byte
                shr al,2                        ; 8-bit -> 6-bit
                mov byte ptr [di],al
                inc di
                dec cx
                jnz pcxdpal2                    ; continue until done

pcxdecoded:
                ret
pcxdecode       endp


;
;   pcxwritehdr() - write an 8-bit pcx header
;   pass:       pcxh - pcx header structure buffer
;               fhdl - file handle
;               bufw - width of pcx
;               bufd - depth of pcx
;   returns:    carry flag set on error, carry clear if ok
;

                public pcxwritehdr

pcxwritehdr     proc pascal pcxh:far ptr byte, fhdl:word, bufw:word, bufd:word
                uses ds, si
                cld

                lds si,pcxh

                push si
                mov cx,size PCX_Hdr
                mov al,0
pcxwcloop:
                mov byte ptr [si],0             ; clear the header
                inc si
                dec cx
                jnz pcxwcloop
                pop si

                mov [si].pcxhmanufact,0ah       ; manufacturer id
                mov [si].pcxhversion,5          ; version supports 256c+
                mov [si].pcxhencoding,1         ; encoding scheme, must be 1
                mov [si].pcxhbitsppix,8         ; 8-bit bitmap
                mov ax,bufw
                mov [si].pcxhbspline,ax         ; bytes per line
                dec ax
                mov [si].pcxhxmax,ax            ; maximum x
                mov ax,bufd
                dec ax
                mov [si].pcxhymax,ax            ; maximum y
                mov [si].pcxhcplanes,1          ; color planes, 1 for 8-bit
                mov [si].pcxhpaltype,1          ; palette type (not true color)

                mov ah,40h
                mov bx,fhdl
                mov cx,size PCX_Hdr
                mov dx,si
                int 21h                         ; read the pcx header

                ret
pcxwritehdr     endp


;
;   pcxencode() - decode an 8-bit pcx picture
;   pass:       pcxh - pre-read pcx header structure buffer
;               fhdl - file handle
;               src  - source buffer
;               pal  - palette buffer
;   returns:    carry flag set on error, carry clear if ok
;

                public pcxencode

pcxencode       proc pascal pcxh:far ptr byte, fhdl:word, src:far ptr byte, \
                            pal:far ptr byte
                uses ds, si, di
                cld

                mov cs:[bpnt],o buffer          ; init buffered i/o vars
                mov cs:[bndx],0

                lds si,pcxh
                mov cx,[si].pcxhymax
                sub cx,[si].pcxhymin
                inc cx                          ; cx = depth (line counter)
                mov di,[si].pcxhxmax
                sub di,[si].pcxhxmin
                inc di                          ; dx = width

                mov bx,fhdl                     ; bx = file handle
                lds si,src                      ; ds:si = pcx buffer


                ; -----------------------------------------
                ;   encode the pcx plane
                ; -----------------------------------------

align 2
pcxeloop:
                push di si                      ; save line counter

                add di,si
                mov al,byte ptr [si]            ; al = prev
                inc si
                mov dh,1                        ; dh : count = 1
align 2
pcxeloop2a:
                cmp si,di                       ; end of line?
                jge eloopd                      ; yes, quit

                mov ah,byte ptr [si]            ; ah = current byte
                inc si
                cmp ah,al
                jne eloop1a
                cmp dh,63
                jge eloop1a
                inc dh                          ; count++
                jmp pcxeloop2a                  ; and loop

eloop1a:
                cmp dh,1
                jg eloop1b
                mov dl,al
                and dl,0c0h
                cmp dl,0c0h
                jne eloop1c
eloop1b:
                or dh,0c0h                      ; count |= 0xc0
                push ax
                mov al,dh
                @fputc                          ; write count
                pop ax

eloop1c:
                @fputc                          ; write previous

                mov al,ah                       ; previous = current
                mov dh,1                        ; count = 1
                jmp pcxeloop2a                  ; and loop

align 2
eloopd:
                cmp dh,1
                jg eloop1e
                mov dl,al
                and dl,0c0h
                cmp dl,0c0h
                jne eloop1f
eloop1e:
                or dh,0c0h
                push ax
                mov al,dh
                @fputc                          ; write count
                pop ax

eloop1f:
                @fputc                          ; write previous

                pop si di                       ; restore line counter
                add si,di
                dec cx
                jz pcxepal                      ; quit if done

                test si,4000h                   ; passed 16k boundary yet?
                jz pcxeloop                     ; no, keep decoding

                @normalize ds, si               ; else normalize far pointer
                jmp pcxeloop                    ; keep encoding

pcxepal:
                mov al,0ch
                @fputc                          ; indicate palette

                mov cx,768
                lds si,pal
pcxepal2:
                mov al,byte ptr [si]
                inc si
                shl al,2                        ; 6-bit -> 8-bit
                @fputc                          ; write palette byte
                dec cx
                jnz pcxepal2                    ; continue until done

                @fpflush                        ; flush partial buffer (if any)

pcxencoded:
                ret
pcxencode       endp


;
;
;   DATA (STORED IN CODE SEGMENT)
;
;

bpnt            dw 0
bndx            dw 0
buffer          db bsize dup (0)

                end

