; load.asm -- program to read font file and throw into Planes 2 and 3 of the Vga
; This'll work for EGA as well.
; This is for font bigger than 8 pixels wide
;the data
;the program
vga_segment         equ       0a000h    ;display memory segment
sc_index            equ       3c4h      ;sequence controller
map_mask            equ       2         ;map mask (sc)
; data segment starts here
data       segment                       ; define data segment
nambuff    db        '(font name goes here)',0       ; maximum bytes
databuff   db        16386 dup (?)        ; data buffer
data       ends
; -----------------------------
code     segment
main      proc      far
         assume cs:code,ds:data,es:data ;all segments set to code segment
start:
; set up stack for return
           push      ds
           sub       ax,ax
           push      ax
; set ds to data segment
          mov       ax,data
          mov       ds,ax
;point es to display memory for the rest of the program
;
          mov       ax,vga_segment
          mov       es,ax
          sub       di,di               ; di = address 0 in display memory
; Stuff font bit patterns into planes 2 and 3
;                port   reg     val
; modec   dw      3c4h,   2,      1100b   ; map mask  (enable maps 2 and 3)
;         dw      3c4h,   4,      7       ; memory mode  (bitmap or serial)
;         dw      3ceh,   5,      0       ; mode register  (bitmap or serial)
;         dw      3ceh,   6,      4       ; miscellaneous  (seg = A000h)
          mov       dx,3c4h             ; map mask
          mov       al,2
          out       dx,al
          inc       dx
          mov       al,1100b            ; enable maps 2 and 3
          out       dx,al
          dec       dx
          mov       al,4                ; memory mode
          out       dx,al
          inc       dx
          mov       al,7                ; bitmap mode
          out       dx,al
          mov       dx,3ceh
          mov       al,5                ; graphics mode
          out       dx,al
          inc       dx
          mov       al,0
          out       dx,al
          dec       dx
          mov       al,6                ; graphics miscellaneous
          out       dx,al
          inc       dx
          mov       al,4
          out       dx,al
          dec       dx
; the funny thing about this program is that you can load the font bit patterns
; into the B000 segment instead of the A000 segment and it seems to work.  This
; might be useful along with some dos extender program that wanted to use the
; A000 segment for extra DOS memory.  But if you load the bit patterns into 
; the B800 segment, it doesn't work.  Does anybody know why?
; open file
          mov       dx,offset nambuff   ; address of name
          mov       al,0                ; file open for reading
          mov       ah,3dh              ; function to open file
          int       21h                 ; call dos
          mov       bx,ax               ; file handle in bx
;   (error routine deleted)
; read file
newbuff:
          mov       cx,16386             ; number of bytes to read
          mov       dx,offset databuff  ; address of buffer
          mov       ah,3fh              ; function to read file
          int       21h                 ; call dos
;        mov       si,bx               ; save handle
;           mov       cx,ax               ; number of bytes read in cx
; the loading routine
; Sends first byte in data buffer to plane 2, address 0 in video buffer
; Sends second byte in data buffer to plane 3, address 0 in video buffer
; Sends third byte in data buffer to plane 2, address 1 in video buffer
; Sends fourth byte in data buffer to plane 3, address 1 in video buffer
; tra la la la la,  etc.
; set count
         mov       cx,8194              ; number of bytes to read/2
;point routine at data buffer
          mov       bx,offset databuff  ; address of buffer
;select the plane that this object will be drawn in.
loopit:
          mov       dx,sc_index         ; point to sequencer index register
          mov       ah,4                ; select plane 2 (0100b)  
          mov       al,map_mask         ; map mask address register
          out       dx,ax               ; send it
; get the byte in ah, send to plane 2
          mov       ah,[bx]             ; get character
          mov       es:[di],ah          ; move into memory location 
; flip to the next plane
          mov       dx,sc_index         ; point to sequencer index register
          mov       ah,8                ; select plane 3 (1000b)
          mov       al,map_mask         ; map mask address register
          out       dx,ax               ; send it
; get the byte in ah, send to plane 3
          inc       bx                  ; point to next byte in data buffer
          mov       ah,[bx]
          mov       es:[di],ah     ;move into memory location
; loop until done
          inc       bx                  ; point to next byte in data buffer
          inc       di                  ; point to next address in video buffer
          loop      loopit
;        close file
        mov     ah,3eh
        int     21h

;        reset VGA to text mode.  Forget about BIOS, that resets everything
;   You're basically changing it to odd-even mode and changing the video segment.
; Read Ferraro's book on the EGA/VGA if you don't understand.
; mode3   dw      3c4h,   2,      3       ; map mask  (enable map 0/1)
;         dw      3c4h,   4,      3       ; memory mode  (odd/even)
;         dw      3ceh,   5,      10h     ; mode register  (odd/even)
;         dw      3ceh,   6,      0eh     ; miscellaneous  (seg = B800)
          mov       dx,3c4h             ; map mask
          mov       al,2
          out       dx,al
          inc       dx
          mov       al,3            ; enable maps 2 and 3
          out       dx,al
          dec       dx
          mov       al,4                ; memory mode
          out       dx,al
          inc       dx
          mov       al,3                ; odd-even
          out       dx,al
          mov       dx,3ceh
          mov       al,5                ; graphics mode
          out       dx,al
          inc       dx
          mov       al,10h              ; odd/even
          out       dx,al
          dec       dx
          mov       al,6                ; graphics miscellaneous
          out       dx,al
          inc       dx
          mov       al,0eh
          out       dx,al
          dec       dx
; set block specifier to 0, you could set it to something else too,
; but I haven't been using multiple fonts
          mov       ax,1103h
          mov       bl,0
          int       10h                 
; clear screen
        push    es
        push    di
        push    cx

        mov     ax,720h         ;   clear screen to spaces
        mov     cx,39 * 100     ; this routine isn't really necessary
        rep     stosw

        pop     cx
        pop     di
        pop     es
        mov     ax,1h                   ; I forget why I did this
          ret                           ; return to Dos
main      endp                          ; end of main program
code     ends
         end       start

