	page	66,132
;******************************** TIME1.ASM  *********************************

LIBSEG           segment byte public "LIB"
		assume cs:LIBSEG , ds:nothing

;----------------------------------------------------------------------------
.xlist
	include  mac.inc
	include  common.inc
.list
;----------------------------------------------------------------------------

$day_in_month	db	31		;days in March
		db	30		;days in April
		db	31		;days in May
		db	30		;days in June
		db	31		;days in July
		db	31		;days in August
		db	30		;days in September
		db	31		;days in October
		db	30		;days in November
		db	31		;days in December
		db	31		;days in January
		db	-1		;the rest are in February

comment 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -(  TIME  )
DAYS_TO_DATE - build date for the number of days since Jan 1, 1980.
;
; input:  AX = 	days elapsed since January 1, 1980 ("numdays")
;
; output: DX		year (1980-2099)
;	  AH		month (1-12)
;	  AL		day (1-31)
;
;* * * * * * * * * * * * * *

	public		days_to_date
days_to_date	proc	far
		apush	bx,si
		add	ax,1401		;adjust year to 03-01-1976
		xor	dx,dx		;DX = 0
		mov	bx,1461
		div	bx		;AX = leap years, DX = remaining days
		mov	si,ax		;SI = leap years
		xchg	ax,dx		;AX = remaining days from last ly
		xor	dx,dx		;DX = 0
		mov	bx,365
		div	bx		;AX = years since ly, DX = rem days
		cmp	ax,4		;is this the leap day?
		 jne	dys_dte_050	;  n: skip day/year adjust
		dec	ax		;  y: actual year = year - 1
		mov	dx,bx		;     day of year = 365
dys_dte_050:	shl	si,1		;mul leap year by 4...
		shl	si,1
		add	ax,si		;AX = years since 03-01-1976
		xchg	dx,ax		;DX = years since 03-01-1976, AX =days
		xchg	bx,ax		;BX = remaining days in adjusted year
		mov	si,offset $day_in_month
dys_dte_100:	lods	byte ptr cs:[si] ;get days/month starting with March
		cbw
		sub	bx,ax		;all days accounted for?
		 jnc	dys_dte_100	;  n: get next month's days, else...
		add	ax,bx		;AX = day of month - 1
		inc	ax		;AX = day of month
		sub	si,offset $day_in_month ;SI = month (1=March)
		mov	bx,si		;BX = month (1=March)
		inc	bx
		inc	bx		;BX = month (3=March, 14=Feb)
		mov	ah,bl		;AL = day of month, AH = month (14=Feb)
		add	dx,1976		;DX = year
		cmp	ah,12		;is month greater than 12?
		 jbe	days_date_050	;  n: skip month/year adjust
		inc	dx		;  y: adjust year and
		sub	ah,12		;	month, (Jan = 1, Dec = 12)
days_date_050:	apop	bx,si
		retf
days_to_date	endp

LIBSEG	ENDS
	end
