	page	66,132

; This an example TSR to do several house keeping functions as follows:
;  1. Put a large cursor on screen and hold it.
;  2. Hot key into debug or DOS if system hangs.
;  3. Turn off the infernal bell char.
;  4. Set Num Lock off  
;
;    Created By:  Jeff Owens  11-23-88  
;
kb_flag	equ	417h
video_state equ	449h


	assume	cs:code,ds:code
code    segment para public 'CODE'

;
; the psp is used to hold variables as follows
;
orig_int_tbl	equ	7ch		; room for copy of int tbl

	org	100h
start:	jmp	begin

;
;			       data section
;
initial_mode	db	?		; initial video mode
int_mask	db	?		; original interrupts enabled

debug:
	db	0eah
debug_offset 	dw	?
debug_segment	dw	?
;
;			       main code section
;

;---------------------------
int21:
	cmp	ah,4bh
	jne	onward
	push	ax
	push	cx
	MOV	CX,010BH	; Block cursor
	MOV	AH,01H		; Set cursor function
	INT	10H		; Set it
	pop	cx
	pop	ax
onward:
	db	0eah
int21_off	dw	0
int21_seg	dw	0

int10:
	cmp	ah,02
	je	position_cursor
	cmp	ah,09
	je	write_attr
	cmp	ah,06
	je	normal_color
	cmp	ah,0eh				;check for tty write
	jne	int10_exit
	cmp	al,07h				;check if bell char
	jne	int10_exit
	iret					;ignore bell
;
; scroll down
;
normal_color:
	mov	byte ptr cs:[7fh],0		;disable color force
	jmp	int10_exit

position_cursor:
	cmp	dl,0
	jne	int10_exit
	jmp	normal_color

write_attr:
	cmp	byte ptr cs:[7fh],1fh
	je	force_color
	cmp	al,';'
	jne	int10_exit			;jmp if not ';'
	mov	byte ptr cs:[7fh],bl
force_color:
	mov	bl,17h
int10_exit:
	db	0eah
int10_off	dw	0
int10_seg	dw	0	

trigger_mask	db	08h		; enable key


int_09:	push	es
	push	ax
	sub	ax,ax
	mov	es,ax
	
        IN      AL,60H          ;CHECK SCAN CODE
        CMP     AL,01           ;IS IT esc KEY?
        JNZ     int09_exit      ;NO, ON TO KEYBOARD ROUTINE
        MOV     AL,BYTE PTR es:KB_FLAG ;GET KEYBOARD FLAG BYTE FROM ROM DATA
        TEST    AL,08h		;check for alt key
	jnz	trigger_found
int09_exit:
	pop	ax
	pop	es
	db	0eah
int09_off dw	0
int09_seg dw	0
        
;
; eat this key and re-enable the keyboard
;
trigger_found:
        IN      AL,61H          ;OTHERWISE, WE TAKE IT FROM HERE
        MOV     AH,AL           ;RESET
        OR      AL,80H          ;THE
        OUT     61H,AL          ;KEYBOARD
        MOV     AL,AH           ;CONTROL
        OUT     61H,AL          ;PORT
        CLI                     ;TURN OFF INTERRUPTS
        MOV     AL,20H          ;RESET INTERRUPT CONTROLLER (8259)
        OUT     20H,AL
        STI                     ;LET PENDING INTERRUPTS EXECUTE
;
; check if debug is active
;
	cmp	word ptr es:[0eh],70h	;check for debug
	je	no_debug		;jmp if no debug
;
; go to debug without desturbing the stack
;
	mov	ax,word ptr es:[0ch]
	mov	cs:debug_offset,ax
	mov	ax,word ptr es:[0eh]
	mov	cs:debug_segment,ax
        POP     ax
        POP     es
;
; adjust the return address seen by debug
;
	push	bp
	mov	bp,sp
	inc	word ptr [bp+2]		;adjust the return address
	pop	bp
	       
        jmp	debug

no_debug:
	in	al,61H			; turn off sound
	jmp	short $+2
	and	al,0FCH
	out	61H,al

	mov	al,36H			; reset system timer
	out	43H,al
	xor	al,al
	jmp	short $+2
	out	40H,al
	jmp	short $+2
	out	40H,al

	mov	cx,40H			; restore int tbl
	push	cs
	pop	ds

	xor	ax,ax
	mov	es,ax
	mov	di,ax
	mov	si,orig_int_tbl
	cli
	cld
	rep	movsw

	mov	al,cs:int_mask		; restore enabled ints
	out	21H,al
	sti

	mov	al,cs:initial_mode		; set video back to original
	cmp	byte ptr es:[video_state],al
	je	vid_ok
	xor	ah,ah
	int	10H
vid_ok:
	pop	ax
	pop	es
	mov	ax,4C01h		; can we really do this?!!?
	int	21H			; YOW!

resident_end	label	word

;-------------------------------------------------------------------------

begin:
 	cld

	mov	ax,40h
	mov	es,ax			;point at keyboard data

	mov	word ptr es:[17h],0	;clear all keyboard status flags

	call	keyboard_ready_check
	mov	al,0edh			;tell keyboard a status
	out	60h,al			;  byte is coming

	mov	cx,3000h
	loop	$
	
	call	keyboard_ready_check
	mov	al,00			;send status (led code)
	out	60h,al			;  to keyboard (turn off all leds)
	call	keyboard_ready_check
		
	mov	ah,9
	mov	dx,offset status_message
	int	21h
	
	mov	ax,cs
	mov	ds,ax
;
; add int21 trap to hold block cursor
;
	mov	ax,3521h
	int	21h
	mov	int21_off,bx
	mov	int21_seg,es
	mov	ax,2521h
	mov	dx,offset int21
	int	21h			;set new int21 vector
;
; add int10 trap to change asm comment color
;
	mov	ax,3510h
	int	21h
	mov	int10_off,bx
	mov	int10_seg,es
	mov	ax,2510h
	mov	dx,offset int10
	int	21h			;set new int10 vector
;
; add int09 trap to restore dos/debug
;
	mov	ax,3509h
	int	21h
	mov	int09_off,bx
	mov	int09_seg,es
	mov	ax,2509h
	mov	dx,offset int_09
	int	21h			;set new int10 vector
;
; save interrupt vector state
;
	mov	ax,cs
	mov	es,ax
	
	xor	ax,ax
	mov	ds,ax
	
	mov	si,ax
	mov	di,orig_int_tbl
	mov	cx,40H			; save int tbl
	cld
	rep	movsw

	in	al,21H			; save enabled ints
	mov	cs:int_mask,al

	mov	al,byte ptr ds:[video_state]	; save video mode
	mov	cs:initial_mode,al

	mov	ax,cs
	mov	ds,ax
	mov	es,ax
	
numlock_exit:
	mov	dx,offset resident_end
	int	27h
  
;
;			      subroutines
;

keyboard_ready_check:
	mov	cx,7fffh
kloop:	in	al,64h
	test	al,02h
	loopnz	kloop			;wait for good status
	ret
	
status_message	db	'NumLock disabled, and Keyboard LED turned off'
		db	0dh,0ah,'$'

code	ends
	end	start
