/* ZIPUP 1.1  --- the working program    (c) 1989 Bob Jaques */
/* 10/16/89   1515                                Jim Barth  */

/* ******************************************************************** */
/* Please note that this program has a routine written by Mike Smedley  */
/* in his excellent Version 5.0 of CXL, which is downloadable from most */
/* good bulletin boards.  ZIPUP was compiled in Turbo C Version 2.0     */
/* using the following command line:  tcc zipup.c cxltcs.lib            */
/* ******************************************************************** */


#include <stdio.h>
#include <bios.h>
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <dir.h>
#include "cxlstr.h"

#define DEFAULT "ZIPUP.TXT"
void clrscr(void);
int print_usage(void);
int fcloseall(void);
int ch,output,rem,quot,wanted[4];
long int offset,find,count,i,length,c,endbyte,firstbyte;
FILE *fp,*comm_file;
char *itoa(int value1,char *str,int radix);
char path1,path2,pathname[120],string[80];
char line[10] = ".ZIP";
char *strupr(char *s),*p;
char *strcpy (char *dest,const char *src);
char *strchr(const char *line,int NUMBER_LEFT);
char *strcat (char *dest,const char *src);
char dots[60] = ".................................................";
char zipfile[100],tempname[100],zipcomment[100],t1[100];
char *strncpy(char *destination, const char *source,size_t num_bytes);
int file_exists(char *filename,int amode);
int fseek(FILE *fp,long offset,int origin);
int fgetc(FILE *fp);
int fputc(int character,FILE *fp);
long ftell(FILE *fp);
int byte1 = 0,byte2 = 0,done = 0,finished = 0,character;


/*
   ============================
   = T H E  M A I N  L O O P  =
   ============================
*/

main(argc, argv)        /* As far as aruguments go, I am only looking for */
int argc;               /* a maximum of two command-line arguments.       */
char *argv[];           /* ZIPUP expects to see:          */
                        /*    ZIPUP ZIPFILE[.ZIP] COMMENT.TXT             */
                        /* The program will use a default of ZIPUP.TXT    */
                        /* in the currect directory if no comment file is */
                        /* specified.                                     */


{
strcat (zipfile,argv[1]);
strcat (zipcomment,argv[2]);
printf ("\n\n\nZIPUP Version 1.1 \t\t\t   (c) 1989 Bob Jaques & Jim Barth\n\n");
  if (strlen(zipfile) >= 1)
    {
      if ((strlen(zipfile) > 3) &&  (strstr(strupr(zipfile),"*.ZIP") != NULL))
        {
          p = strleft(zipfile,strlen(zipfile) - 5); /* This little bit of */
          find_if_comment(zipcomment);              /* code is to handle  */
          strcpy (t1,zipfile);                      /* the wildcard of    */
          printf("\n");                             /* "ZIPUP *.ZIP"      */
          process_wildcards (zipcomment, t1,p);
          exit (0);
        }
  if (strchr (zipfile,'.') == NULL)
    {                                   /*  This is to handle the    */
       strcpy (t1,"");                  /*  case where the user just */
       strcpy (t1,zipfile);             /*  entered ZIPUP ZIPFILE    */
       strcat (t1,".ZIP");              /*  without a. ZIP extention.*/
       strcpy (pathname,"");
       strcat (pathname,t1);
       if (!file_exists (pathname,0))
        {
          printf("%s is not in this directory!",t1);
          print_usage();
          exit (1);
        }
   }
   else {
     strcat (t1,zipfile);
     strcat (pathname,t1);
       if (!file_exists (t1,0))
         {
            printf("Unable to open %s.\n",t1);
            print_usage();
            exit(1);
         }
    }
  }
  else
  if (strlen(zipfile) < 1)
    {
      printf("You must supply a \"ZIP\" file(s) to process!");
      print_usage();
      exit(1);
    }

     find_if_comment(zipcomment);     /* Make sure the specified comment */
                                      /* file does indeed exist.         */
     add_the_comments(zipcomment,t1); /* Now that the comment files DOES */
                                      /* exist, we can add the comments  */
                                      /* the .ZIP file(s).               */


     exit (0);                        /* Set the ERRORLEVEL to "0" since */
                                      /* we got this far with no errors. */
}      /* =====================
          =END OF MAIN ROUTINE=
          =====================*/





/*
   ========================================================================
   = This is the function that will search for the place to insert the    =
   = comment file into the ".ZIP" file.  It also computes the length of   =
   = of the desired comment file to be added.                             =
   = Some of the coding may be unorthodox, but, hey, it works!            =
   ========================================================================
*/

add_the_comments()
{
   wanted[0] = 80;    /*  These are the values that are looked for as a */
   wanted[1] = 75;    /*  "key".  If you add 16 to the memory address   */
   wanted[2] = 5;     /*  wanted[3], this will make the beginning of    */
   wanted[3] = 6;     /*  the place in the "ZIP" file that marks the    */
                      /*  length of the comment file.                   */


   comm_file = fopen(zipcomment,"rb");  /* Open the comment file for */
   count = 0;                           /* our reading only          */
   while ((ch = fgetc (comm_file)) !=EOF)
        {                   /* Very simply, this is counting the length */
         count++;           /* of the comment file.  Count = length     */
        }

 {
 div_t n;                    /* Divides the length of the comment file */
 n = div (count,256);        /* into two bytes for placement in the    */
 byte1 = n.rem;              /* structure of the ".ZIP" file.          */
 byte2 = n.quot;             /*                                        */
 }


 fp = fopen(t1, "rb+");
 fseek(fp,0,SEEK_END);
 count = 0;
 firstbyte = 1;
 endbyte = ftell(fp);
 strcpy (string,"");
 strcpy (string,strupr(t1));
 strcat (string,strleft(dots,50 - strlen (t1)));
 strcat (string, " ");
 gotoxy (4,wherey());
 printf("%s",string);
 count = endbyte - 4;
 find = 0;
 LOOP1:
   for (i = 0; i < 3;i++)
    {
     if (count == firstbyte)
       {
           printf ("Corrupted ZIP file"); /* Well, it there must be     */
           fclose(fp);                    /* SOMETHING wrong if we got  */
           fclose(comm_file);             /* to the beginning of the    */
                                          /* file without finding what  */
                                          /* we were looking for.       */

           exit(1);                       /* Something went wrong so    */
                                          /* exit with ERRORLEVEL @ 1   */
       }
    fseek (fp,count + i,SEEK_SET);
    find = fgetc(fp);
      if (find != wanted[i])
        {
           --count;
           goto LOOP1;
        }
     }

           gotoxy (53,wherey());
           printf("Stripping old comment");
           count = count + 20;
           fseek(fp,count,SEEK_SET);
           character = byte1;
           fputc(character,fp);
           character = byte2;
           fputc(character,fp);

           gotoxy (53,wherey());
           printf("Adding new comment   ");
           rewind(comm_file);
           while (( ch = fgetc (comm_file)) != EOF)
           fputc (ch,fp);
           fclose(comm_file);

           fseek(fp,0,SEEK_END);
           fclose(fp);
           gotoxy (73,wherey());
           printf("Done!\n");
           return(0);



/* This simple function simply checks for the presence of a file that */
/* is stored in the variable PATHNAME.                                */
}
file_exists()
{
return (access(pathname, 0) == 0);
}


/* This little function prints the expected usage of ZIPUP.  This     */
/* function is referred to in the case of all errors and unrecognized */
/* inputs from the command line.                                      */
print_usage()
{
   printf("\n\n");
   printf("USAGE: ZIPUP File Comment\n");
   printf("where      File = Path and Filename of file(s) to process.\n");
   printf("        Comment = Path and Filename of comment file to add.\n\n");
   printf("If no comment file given, default is ZIPUP.TXT\n");
}


/* The following routine, PROCESS_WILDCARDS, was the easiest way I found */
/* to handle the case where the user entered "ZIPUP *.ZIP" on the        */
/* command line.  Some of it probably doesn't seem logical, but, again,  */
/* it works!                                                             */
process_wildcards()
{
   struct ffblk ffblk;
   int done,number = 1;
   done = findfirst(t1,&ffblk,0);
   while (!done)
   {
     strcpy (t1,p);
     strcat (t1,ffblk.ff_name);
     /*printf("In process_wildcards: t1 = %s\n",t1); */
     printf("%d.  ",number);
     number++;
     add_the_comments(t1,zipcomment);
     strcpy (t1,"");
     done = findnext(&ffblk);
   }
}

/*  This last function, find_if_comment, simply looks for the requested    */
/*  comment file from the command line.  If one was not specified, ZIPUP   */
/*  will default to ZIPUP.TXT, which is expected to be in the same         */
/*  directory that ZIPUP is run from.  This function also checks for the   */
/*  presence of ZIPUP.TXT if no other comment file was requested to be     */
/*  processed.                                                             */
find_if_comment()
{
  if (*zipcomment != NULL)
   {
      strcpy (pathname,"");
      strcpy (pathname, zipcomment);
      if (!file_exists (pathname,0))
        {
          printf("Unable to open comment file %s.\n",strupr(zipcomment));
          print_usage ();
          exit (1);
        }
  }
  else  {
    printf("No comment file specified -- using default of ZIPUP.TXT.\n");
    strcpy (zipcomment,"");
    strcat (zipcomment,DEFAULT);
    strcpy (pathname,zipcomment);
    if (!file_exists (pathname,0))
      {
       printf("\nThere is no default comment file in this directory.\n");
       print_usage ();
       exit (1);
      }
  }
 return(pathname);
}

/* ************************************************************************ */
/* Well, that's all there is to it.  If anyone knows of any "better" way to */
/* to do what some of this code does, please share it with us.  We are      */
/* eager to learn a different approach.                                     */
/*                                                                          */
/* The authors can be reached at:                                           */
/*    Bob Jaques                           Jim Barth                        */
/*    6814 Helena DR NE                    11544 Kevin Lane NE              */
/*    Bremerton, WA  98310                 Poulsbo, WA  98370               */
/*    FIDO (1:350/20 12-14.4K HST)         FIDO (1:350/21 12-2400 MNP)      */
/* ************************************************************************ */

