Comment |
Name    VERSION2.PRC
Type    Procedure
Author  BF Gavin, Online Reference BBS.  All rights reserved.

Intent  Check for DOS v2.00 or higher
Origin  26FEB89
Update  15APR89 - Changed procedure from "Version" to "Version2".
        04JUN89 - Mov CS to DS for .COM or .EXE capability.
        05OCT89 - Add in major, minor variables in CODE SEGMENT
        04NOV89 - Return AH,AL as set by DOS
        11JAN90 - Change local variables from '_xxx' to '@xxx'
        19JAN90 - Fix bug that didn't display error message

Needs   Nothing
Entry   Nothing

Flags        (destroyed)
Regs    AX - (destroyed)  Work reg

Exit    Returns major/minor version in AH/AL
Remark  Terminates program if DOS is not 2.0 or higher, ERRORLEVEL=1
        |


@doserr$        Db    Cr,Lf,'Sorry, requires DOS 2.0 or higher',Cr,Lf,Lf,'$'
@osmajor        Db    0                         ; DOS major version level
@osminor        Db    0                         ; DOS minor version level

DOS_Version     Proc   Near
        Mov     AH,30h                          ; Version function call
        Int     21h                             ; Call DOS
        Cmp     AL,02h                          ; Version 2 or higher?
        Jnb     _dosversionexit                 ; OK - continue
        Push    CS                              ; Get code segment
        Pop     DS                              ; Insure DS is set
        Lea     DX,@doserr$                     ; Wrong DOS version message
        Mov     AH,09h                          ; Display dollar string
        Int     21h                             ; Call DOS
        Mov     AX,4C01h                        ; Set ERRORLEVEL = 1..
        Int     21h                             ;   and exit

  _dosversionexit:
        Mov     @osmajor,AL                     ; Save major version level
        Mov     @osminor,AH                     ; Save minor version level
        Ret                                     ; To caller with version in AX
DOS_Version     Endp





Comment |
Name    LBLANKS1.PRC
Type    Procedure
Author  BF Gavin, Online Reference BBS.  All rights reserved.

Intent  Return next non blank character in AL, either case
Origin  18MAY1988
Update  18JAN1990 - Set CF=1 if 13 (CR) is 1st non-blank character

Needs   Nothing
Entry   DS:SI points at string

Regs    AX - (destroyed) Charcter returned to caller in AL
        SI - (destroyed) Points to next character
Flags        (destroyed)

Exit    AL holds non-blank character
Remark  Skips tab and space characters
        |

Leading_Blanks  Proc    Near
  _lblanks_loop:
        Lodsb                                   ; Read the next byte at [SI]
        Cmp     AL,20h                          ; Is AL a blank space?
        Jz      _lblanks_loop                   ; Yes - get the next byte
        Cmp     AL,09h                          ; Is AL a tab character?
        Jz      _lblanks_loop                   ; Yes - get the next byte
        Cmp     AL,0Dh                          ; Carriage return?
        Jne     _lblanks_exit                   ; No  - leave CF=0
        Stc                                     ; Yes - set CF=1
        Ret                                     ; With char in AL, CF=set

  _lblanks_exit:
        Clc
        Ret                                     ; With char in AL, CF=clear
Leading_Blanks  Endp





Comment |
Name    DISP-DOS.PRC
Type    Procedure
Author  BF Gavin, Online Reference BBS.  All rights reserved.

Intent  Display message [DS:DX] at current cursor location with DOS
Origin  19JUN87
Update  15SEP89 - Assign unique label names
        15OCT90 - Preserve DX register

Needs   Nothing
Entry   DX points at ASCIIZ message

Regs    AX - (DESTROYED) DOS function, Char in AL
        DX - (preserved) Message pointer at entry
        SI - (preserved) Message pointer source reg

Exit
Remark  Used for Hercules, etc, video drivers.
        DISP-MSG.PRC does not support odd-ball drivers.
        |


Display_Message Proc      Near
        Push    DX                              ; Save all registers used
        Push    SI                              ; Entry value
        Mov     SI,DX                           ; Message pointer

  _display_msg_loop:
        Lodsb                                   ; Get message bytes
        Cmp     AL,0                            ; All done?
        Jz      _display_msg_exit               ; Yes
        Mov     DL,AL                           ; Setup to display
        Mov     AH,02                           ; Display character function
        Int     21h                             ; Call DOS
        Jmp     Short _display_msg_loop         ; Loop through message

  _display_msg_exit:
        Pop     SI                              ; Restore saved registers
        Pop     DX
        Ret                                     ; To caller
Display_Message Endp





Comment |
Name    Upper_Case
Type    Procedure
Author  BF Gavin, Online Reference BBS.  All rights reserved.

Intent  Convert letter in AL to upper case
Origin  15OCT90 -
Update  ddmmmyy -

Needs   Other procedures.
Caller  Procedure names.
Size    xxx bytes.

Entry   Describe registers at entry.
        FL - (DESTROYED) ?
        AL - (DESTROYED) Letter to convert.


Exit    AL is upper case.
Remark

        |

Upper_Case      Proc    Near
        Cmp     AL,97                           ; Lower case 'A'?
        Jb      _ucexit                         ; No  - not a lower case char
        Cmp     AL,122                          ; Lower case 'Z'?
        Ja      _ucexit                         ; No  - not a lower case char
        And     AL,0DFh                         ; Yes - convert to upper case

  _ucexit:
        Ret                                     ; To caller with upper case AL
Upper_Case      Endp





Comment |
Name    AXDX2HEX
Type    Procedure
Author  BF Gavin

Intent  Convert DX:AX to ASCII hex characters
Origin  16JAN89
Update  14SEP89 - Assign unique label names
        13OCT90 - Carry Flag 0/1 = leading zeros/blanks.

Needs   Nothing
Entry   DX:AX set to HI:LO hex values.
        ES:DI points to 8 byte buffer area
        NC    use leading zeros
        CF    use leading blanks

Flags      - (preserved)
Regs    AX - (preserved)
        BX - (preserved)
        CX - (preserved)
        DX - (preserved)
        SI - (preserved)
        DI - (preserved)
        DS - (preserved)

Exit    Buffer contains ASCII hex characters.
Remark  Leading zeros or leading blanks set by Carry Flag state.
        |
                EVEN
@HexBfrPtr      Dw      0                       ; Save area for DI buffer ptr
@AXDX_Tbl       Db      '0123456789abcdef'      ; Xlat table, lower case
@AXDX2Hex_Sw    Db      1                       ; 0/1 = leading zeros/blanks

AXDX2Hex        Proc    Near
        PushF                                   ; Save direction flag
        Push    AX                              ; Save all registers used
        Push    BX
        Push    CX
        Push    DX
        Push    SI
        Push    DS
        Mov     @HexBfrPtr,DI                   ; Save it

        Mov     @AXDX2Hex_Sw,1                  ; Assume leading blanks wanted
        Jc      _axdx_bfrset                    ; User wants leading blanks
        Mov     @AXDX2Hex_Sw,0                  ; NC - wants leading zeros

  _axdx_bfrset:
        Add     DI,7                            ; End of buffer
        Std                                     ; Descending direction
        Mov     BX,CS                           ; Xlat table is here
        Mov     DS,BX                           ; Address it
        Mov     BX,Offset @AXDX_Tbl             ; Xlat table
        Push    DX                              ; Save for later
        Mov     DX,AX                           ; Work on AX via DX
        Mov     CX,4                            ; 4 nybbles worth

  _loop_32_lo:
        Mov     AL,DL                           ; Lo nybble to AL
        And     AL,0Fh                          ; Isolate lo nybble
        Xlat                                    ; Convert nybble to hex
        Stosb                                   ; Store in display area
        Shr     DX,1                            ; Get next nybble
        Shr     DX,1
        Shr     DX,1
        Shr     DX,1
        Loop    _loop_32_lo

        Pop     DX                              ; Restore DX to DX
        Mov     CX,4                            ; 4 nybbles worth

  _loop_32_hi:
        Mov     AL,DL                           ; Lo nybble to AL
        And     AL,0Fh                          ; Isolate lo nybble
        Xlat                                    ; Convert nybble to hex
        Stosb                                   ; Store in display area
        Shr     DX,1                            ; Get next nybble
        Shr     DX,1
        Shr     DX,1
        Shr     DX,1
        Loop    _loop_32_hi

        Cmp     @AXDX2Hex_Sw,1                  ; Want leading blanks?
        Jnz     _h32b                           ; No - skip this part
        Mov     DI,@HexBfrPtr                   ; Start of buffer
        Mov     SI,DI                           ; Set both
        Cld                                     ; Ascending direction
        Mov     CX,7                            ; Check first 7 digits
  _h32a:
        Lodsb                                   ; Check for ASCII zero
        Cmp     AL,30h                          ; Zero
        Jnz     _h32b                           ; Done
        Mov     AL,20h                          ; Set to blank
        Stosb                                   ; Store it
        Loop    _h32a                           ; Keep going

  _h32b:
        Mov     DI,@HexBfrPtr                   ; Restore all registers used
        Pop     DS
        Pop     SI
        Pop     DX
        Pop     CX
        Pop     BX
        Pop     AX
        PopF                                    ; Restore flags
        Ret                                     ; To caller
AXDX2Hex        Endp





Comment |
Name    DIVIDE10.PRC
Type    Function
Author  BF Gavin, Online Reference BBS.  All rights reserved.

Intent  Divide DX:AX by 10.  Prevents Int03 overflow interrupt when returned
        quotient > 16 bit value.

Origin  26FEB1989
Update

Needs   Nothing
Entry   DX:AX set to Hi:Lo values
        SI    set to Divisor

Regs    AX - (destroyed) - Entry Lo dividend, Exit quotient Lo
        BX - (destroyed) - Remainder
        CX - (preserved) - Divide bit width 16/32
        DX - (destroyed) - Entry Hi dividend, Exit quotient Hi
        SI - (preserved) - Working divisor
Flags        (destroyed)

Exit    DX:AX quotient,  BX remainder
Remark
        |
Divide10        Proc    Near
        Push    CX                              ; Entry value
        Mov     SI,10                           ; Divisor value to SI
        Xor     BX,BX                           ; Zero partial dividend
        Or      DX,DX                           ; Test for 32 bit divide
        Jz      _div16_setup                    ; No  - do 16 bit instead
        Mov     CX,32                           ; 32 bits max for divide

  _div32_loop:
        Shl     AX,1                            ; Hi bit to carry
        Rcl     DX,1                            ; Set carry in Hi reg
        Rcl     BX,1                            ; Carry to partial divdnd
        Cmp     BX,SI                           ; Partial divdnd < divisor
        Jb      _div1032_nxt                    ; Yes - skip subtraction
        Sub     BX,SI                           ; Partial divdnd - divsor
        Inc     AX                              ; Set quotient bit

  _div1032_nxt:
        Loop    _div32_loop                     ; Loop thru CX bits
        Jmp     Short _divide10_exit            ; All done

  _div16_setup:
        Mov     CX,16                           ; 16 bits max for divide

   _div16_loop:
        Shl     AX,1                            ; Hi bit to carry
        Rcl     BX,1                            ; Carry to partial divdnd
        Cmp     BX,SI                           ; Partial divdnd < divisor
        Jb      _div1016_nxt                    ; Yes - skip subtraction
        Sub     BX,SI                           ; Partial divdnd - divsor
        Inc     AX                              ; Set quotient bit

  _div1016_nxt:
        Loop    _div16_loop                     ; Loop thru CX bits

  _divide10_exit:
        Pop     CX                              ; Entry value
        Ret
Divide10        Endp





Comment |
Name    AXDX2DEC
Type    Procedure
Author  BF Gavin

Intent  Convert DX:AX to ASCII decimal value in user buffer.
Origin  15MAY1988
Update  04JUN89 - Removed DIVIDE10.PRC from this procedure.
        14SEP89 - Assign unique label names.
        13OCT90 - Control leading blanks with Carry Flag.

Needs   Divide10.  This procedure prevents overflow errors (Int03) when
        Quotient > 16 bits.

Entry   DX:AX set to HI:LO hex values.
        ES:DI points to start of 10 byte display buffer at entry
        NC use leading zeros.
        CF use leading blanks.

        FL - (preserved)
        AX - (preserved)
        BX - (preserved)
        CX - (preserved)
        DX - (preserved)
        DI - (preserved)
        DS - (preserved)


Exit    Display buffer contains ASCII decimal characters.
Remark  Leading zeros or leading blanks set by switch.
        |


@AXDX2Dec_Sw    Db      1                       ; 0/1 = leading zeros/blanks
@DecBfrPtr      Dw      0                       ; Save area for DI buffer ptr
AXDX2Dec        Proc    Near
        PushF                                   ; Save all registers used
        Push    AX
        Push    BX
        Push    CX
        Push    DX
        Push    DS
        Mov     @DecBfrPtr,DI                   ; Save DI pointer to buffer
        Mov     @AXDX2Dec_Sw,1                  ; Assume leading blanks wanted

        Jc      _axdx2dec                       ; CF = leading blanks
        Mov     @AXDX2Dec_Sw,0                  ; NC = leading zeros

  _axdx2dec:
        Cld                                     ; Ascending direction
        Mov     CX,5                            ; Zero the 10 byte display
        Mov     BX,AX                           ; Save AX in BX
        Mov     AX,3030h                        ; Store ASCII zeros
        Rep     Stosw                           ; Do it
        Mov     AX,BX                           ; Restore AX from BX
        Mov     DI,@DecBfrPtr                   ; Restore buffer pointer
        Add     DI,9                            ; End of buffer
        Std                                     ; Descending direction

  _axdx2dec_loop:
        Call    Divide10                        ; AX = Quotient, BX = remainder
        Add     BL,30h                          ; Remainder to ASCII
        Mov     [DI],BL                         ; Store in display
        Dec     DI                              ; Instead of Stosb
        Or      AX,AX                           ; Test for Lo dividend
        Jnz     _axdx2dec_loop                  ; More left to do
        Or      DX,DX                           ; Test for Hi dividend
        Jnz     _axdx2dec_loop                  ; AX zero, but Hi is valid

  ;Substitute blanks for leading zeros
        Cmp     @AXDX2Dec_Sw,0                  ; Leading zeros?
        Jz      _d32b                           ; Yes - don't substitute blanks
        Mov     DI,@DecBfrPtr                   ; Pointer to start of buffer
        Cld                                     ; Ascending direction
        Mov     CX,9                            ; Check first 9 digits
        Mov     DI,@DecBfrPtr                   ; Start of buffer

  _d32a:
        Cmp     Byte Ptr ES:[DI],30h            ; Check for ASCII zero
        Jnz     _d32b                           ; Done
        Mov     Byte Ptr ES:[DI],20h            ; Store a blank
        Inc     DI                              ; Next position
        Loop    _d32a                           ; Keep going

  _d32b:
        Mov     DI,@DecBfrPtr                   ; Restore DI pointer
        Pop     DS                              ; Restore all registers used
        Pop     DX
        Pop     CX
        Pop     BX
        Pop     AX
        PopF                                    ; Entry flags
        Ret                                     ; To caller
AXDX2Dec      Endp
