Echo off
Echo  This is a sample batch file which illustrates how you can create
Echo  a detailed batch file for use with PALRUN.  This is only an
Echo  example and may not work with your system unless you change
Echo  applicable subdirectories, file names and extensions, etc.
Echo  
Echo  This batch file assumes that your Palhouse is "PALHOUSE.ZIP" and
Echo  that you have the appropriate extraction program available.
Echo  
Echo  By issuing the command of "PALRUN PALWP filename", PALRUN will
Echo  look for PALHOUSE.ZIP in your path and extract PALWP.BAT from that
Echo  ZIP archive.  Obviously, you first have to create PALHOUSE.ZIP
Echo  and store a copy of PALWP.BAT there.  In this particular example,
Echo  all WordPerfect support files are housed in E:\WP\WPSPRT.ZIP, and
Echo  they are extracted with one of the commands within PALWP.BAT.
Echo  Similarly, all files for editing are housed within E:\WP\WPEDIT.ZIP,
Echo  and the file that you request to edit (the %1 parameter) will be
Echo  extracted from that ZIP archive.
Echo  
pause
Echo  
Echo  Once PALWP.BAT is extracted (you must have PKUNZIP on your
Echo  path), PALRUN will invoke "PALWP filename".  This batch file first
Echo  changes to your editing directory, then extracts all WordPerfect
Echo  files from WPSPRT.ZIP, then invokes WordPerfect to edit the name
Echo  of the file that you passed on the command line.
Echo  
Echo  When you finish your editing session with WordPerfect and exit the
Echo  program, control is returned to this batch file.  The last several
Echo  commands in this batch file delete all of the files which were
Echo  earlier extracted from WPSPRT.ZIP.
Echo  
Echo  At the completion of the batch file, PALRUN deletes the batch file
Echo  that it extracted from PALHOUSE.ZIP.
Echo  
pause
Echo  
Echo  *******  Batch execution begins here  *******
Echo  Change to the drive and subdirectory in which the WordPerfect
Echo  editing is to be done.
Echo  
e:
cd \wp
Echo  
Echo  Extract required files into editing subdirectory, overwriting
Echo  any pre-existing versions of those files.  In this case, all the
Echo  support files are contained in E:\WP\WPSPRT.ZIP.
Echo  
pkunzip -o wpsprt *.*
Echo  
Echo  Now extract the file for editing if one has been specified on
Echo  your command line and does not already exist.
Echo  
Echo  First, skip extraction if no file was specified.
Echo  
if  "%1"=="" goto skipextr
Echo  
Echo  Second, if the file already exists, don't extract over it.
Echo  
if exist %1 goto already
Echo  
Echo  Do the extraction.
Echo  
pkunzip -o wpedit %1
goto skipextr
:already
Echo  %1 ALREADY EXISTS!!  SKIPPING EXTRACTION!!
:skipextr
Echo  
Echo  Call up WordPerfect.
Echo  
wp %1
Echo  
Echo  Now that we're through, use PKZIP to "f"reshen any of the support
Echo  files that may have been changed through setup or whatever,
Echo  deleting them from the disk at the same time.  With PKZIP's
Echo  "-mf" switch, it is not necessary to specify the particular files
Echo  that you want to freshen if you want to freshen any and all files
Echo  that are already in WPSPRT.
Echo  
Pkzip -mf wpsprt
Echo  
Echo  And now to take care of the edited file.  We want to move it into
Echo  WPEDIT.ZIP.  Since we may have created a brand new file, we want
Echo  to "U"pdate rather than "F"reshen.  In this batch file we provide
Echo  a skip over this command if no file was specified on the command
Echo  line.  You should understand that with this batch structure, if
Echo  you have summoned WordPerfect without specifying the file to
Echo  edit on the command line, and if you then create or make a change
Echo  to a file that's not in WPEDIT.ZIP, then it will not be
Echo  automatically added to WPEDIT.ZIP when all is said and done.
Echo  
if  "%1"=="" goto skiptidy
pkzip -mu wpedit %1
:skiptidy
Echo  
Echo  Remember.  This batch file only places into WPEDIT.ZIP the file
Echo  which was explicitly called when you first invoked PALRUN.  If
Echo  you have edited any other file, you will have to manually add
Echo  that to WPEDIT.ZIP.
Echo  
Echo  Control is now returned to PALRUN, which deletes this batch file.
