// Function to handle an owner-drawn list box
#include <windows.h>
#include "odlbox.h"

BOOL FAR PASCAL ODListBox(HWND hDlg, unsigned message, WORD wParam,
LONG lParam) {

// define some colors for the selected text and background
#define GREEN  RGB(0,255,0)
#define BLUE   RGB(0,0,255)

HWND hLst;                    // handle to the list box
HDC  hDC;                     // device context handle
LPDRAWITEMSTRUCT lpDIS;       // long pointer to DRAWITEMSTRUCT
LPMEASUREITEMSTRUCT lpMIS;    // long pointer to MEASUREITEMSTRUCT
TEXTMETRIC tm;                // text info structure

HBRUSH hBrush;                // draws text background
DWORD OldTextColor;           // saves old text color
DWORD OldBkColor;             // saves old background color

int NumItems;                 // number of items in list box
int i;                        // temporary variable

char textStr[80];             // list box item string buffer
char *textItems[] =
{                             // strings going into the list box
  "One",
  "Two",
  "Three",
  "Four",
  "Five",
  "Six",
  "Seven",
  "Eight",
  "Nine",
  "Ten"
};

NumItems= 10;

switch (message) {

     case WM_INITDIALOG:
          hLst= GetDlgItem(hDlg, IDB_LISTBOX);
          for(i = 0; i < NumItems; ++i)
               SendMessage(hLst, LB_ADDSTRING, 0, (LONG)
                    (LPSTR) textItems[i]);
          SetFocus(GetDlgItem(hDlg, IDB_OK));
          break;


     case WM_COMMAND:

          if(wParam == IDB_OK) {
               EndDialog(hDlg, NULL);
               return TRUE;
          }
          break;


     case WM_DRAWITEM:

          // copy the DRAWITEMSTRUCT pointer from lParam
          lpDIS= (LPDRAWITEMSTRUCT)lParam;

          // if no items in the list box yet, set focus
          if(lpDIS->itemID == -1) {
            DrawFocusRect(lpDIS->hDC, (LPRECT)&lpDIS->rcItem);
            return TRUE;
          }

          // draw items in list box and check for selection
          if((lpDIS->itemAction & ODA_DRAWENTIRE) ||
               (lpDIS->itemAction & ODA_SELECT)) {

               // Get the text string and save in textStr
               SendMessage(hLst, LB_GETTEXT, (WORD)lpDIS->itemID,
                    (LONG) (LPSTR) textStr);

               // Handle the selection state
               if (lpDIS->itemState & ODS_SELECTED) {

                    // text was selected, so make it red on blue
                    // first, draw and fill background
                    hBrush= CreateSolidBrush(BLUE);
                    FillRect(lpDIS->hDC, (LPRECT)&lpDIS->rcItem,
                         hBrush);
                    DeleteObject(hBrush);

                    // set colors and output the text
                    OldTextColor= SetTextColor(lpDIS->hDC, GREEN);
                    OldBkColor= SetBkColor(lpDIS->hDC, BLUE);
                    TextOut(lpDIS->hDC, (int)(lpDIS->rcItem.left),
                         (int)(lpDIS->rcItem.top), (LPSTR)textStr,
                         lstrlen(textStr));

                    // restore old colors
                    SetTextColor(lpDIS->hDC, OldTextColor);
                    SetBkColor(lpDIS->hDC, OldBkColor);

               }
               else {

                    // item not selected, so make it black on white
                    // first, draw and fill background
                    hBrush= GetStockObject(WHITE_BRUSH);
                    FillRect(lpDIS->hDC, (LPRECT)&lpDIS->rcItem,
                         hBrush);

                    // next, draw the text
                    TextOut(lpDIS->hDC, (int)(lpDIS->rcItem.left),
                         (int)(lpDIS->rcItem.top), (LPSTR)textStr,
                         lstrlen(textStr));

               }

               // Check for focus state
               if(lpDIS->itemState & ODS_FOCUS)
                 DrawFocusRect(lpDIS->hDC, (LPRECT)&lpDIS->rcItem);

               return TRUE;

          }

          if(lpDIS->itemAction & ODA_FOCUS) {

               DrawFocusRect(lpDIS->hDC, (LPRECT)&lpDIS->rcItem);
               return TRUE;

          }
          break;


     case WM_MEASUREITEM:

          /* get and use height of current font */
          lpMIS= (LPMEASUREITEMSTRUCT)lParam;    // copy info pointer
          hDC= GetDC(hDlg);                  // create a DC
          GetTextMetrics(hDC, &tm);          // get text info
          lpMIS->itemHeight= tm.tmHeight;    // get text height
          ReleaseDC(hDlg, hDC);              // free the DC
          return TRUE;

} /* switch(message) - end */
return FALSE;

} /* ODListBox() - end */
