/*      Hello.C
	By Pete Davis and Mike Wallace
	Windows Programmer's Journal
	Volume 1 Number 2
	
*/

#include <windows.h>
#include "hello.h"

BOOL InitInstance (HANDLE);

/* The main procedure. This is called by Windows when your program is run. */
/* hCurrInst is the handle for the current instance of the program         */
/* hPrevInst is teh handle for the last instance of the program to run     */
/* CmdLine is a pointer to a string of whatever command line params came in*/
/* nCmd is the specifies the applications appearance.                      */

int FAR PASCAL WinMain(HANDLE hCurrInst, HANDLE hPrevInst, LPSTR CmdLine, int nCmd) {

MSG             msg;                    /* Message                       */
HWND    hWnd;                   /* Our Window Handle */

	if (!hPrevInst) {                       /* If no instance already exists, */
		if (!InitInstance(hCurrInst))   /* try initializing instance      */
		return FALSE;                           /* No dice, it failed             */
	}
	
	hWnd=CreateWindow(      "Hello",                                /* Window Class                 */
						"Hello World Program",  /* Window caption               */
						WS_OVERLAPPEDWINDOW,    /* Overlapped style             */
						CW_USEDEFAULT,                  /* Use defaults for the */
						CW_USEDEFAULT,                  /* X & Y Positions and  */
						CW_USEDEFAULT,                  /* X & Y sizes                  */
						CW_USEDEFAULT,          
						NULL,                                   /* Parent Window                */
						NULL,
						hCurrInst,                              /* Instance                             */
						NULL);                                  /* Creation Params              */

	ShowWindow(hWnd, nCmd);
	UpdateWindow(hWnd);
	
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	
	return (msg.wParam);
}


BOOL InitInstance(HANDLE hInstance) {

WNDCLASS        wc;                             /* Window class structure */

	wc.lpszMenuName = "amenu";                /* Our Menu       */
	wc.lpszClassName= "Hello";                      /* Used above in CreateWindow */
	wc.hbrBackground= GetStockObject(WHITE_BRUSH);  /* White bkgrnd   */
	wc.hInstance    = hInstance;
	wc.style        = CS_VREDRAW | CS_HREDRAW;
	wc.lpfnWndProc  = MainWndProc;          /* Name of proc to handle window */
	wc.hCursor      = LoadCursor(NULL, IDC_ARROW);          /* Arrow Cursor */
	wc.hIcon        = LoadIcon(NULL, IDI_APPLICATION);  /* Generic Icon */
	wc.cbClsExtra   = 0;            /* no extras */
	wc.cbWndExtra   = 0;            /* No Extras */
	
	return (RegisterClass(&wc)); /* Let's register that class */
}

/* This is our main windows procedure. It receives messages in message, then,
depending on what the message is, we react accordingly
*/

long FAR PASCAL MainWndProc(HWND hWnd, unsigned message, WORD wParam, LONG lParam) {

	switch(message) {
	
		/* WM_COMMAND may mean one of our menu items was selected */
		case WM_COMMAND:
		
			/* Check for a menu item */
			switch(wParam) {
			
				/* Did the user select Hello? */
				case IDM_HELLO:
					/* Say Hello World */
					MessageBox(hWnd, "Hello World!", "Hello", MB_OK);
					
					/* Ok, that's all there is. */
					break;
				
				/* Oh, they wanna leave. Too bad. */    
				case IDM_QUIT:
					PostQuitMessage(0);
					break;
					
				/* We don't want it, so give it back to Windows */
				default: 
					return (DefWindowProc(hWnd, message, wParam, lParam));
					break;
				
			}

			break;
					
				
				
		/* Quit out of program when we receive a WM_DESTROY */
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
			
		/* Default case; We don't need it, so give it back to Windows */                
		default:
			return (DefWindowProc(hWnd, message, wParam, lParam));
			break;
	}
					
}

