program rusnews;  {read news}

{

Russell Schulz - russell@alpha3.ersys.edmonton.ab.ca (930323)

}

{

KNOWN SHORTCOMINGS (but don't let them scare you away - they're pessimistic)

(see also rusnews.fut for future considerations)

does not 'f'ollow up to postings or post new ones (for all users)
  as of v0.96 followups implemented - ready for testing - trusted users only
to post a new article, must follow up to another one and change headers
  ( References:, Subject:, possibly Newsgroups: )
does not use the b-tree index for Waffle 1.65's password file for higher speed
not tested with Waffle 1.65 directory structure at author's site
  (possibly only seqf changes to sequence)
  (it's working fine with Waffle 1.65, though - I've seen the evidence)
also not tested with memory requirements of 1.65's rnews.exe - but it works
will use the first rnews.exe found in the current directory+path - be careful
  with the directory you run this from - for sure not the user's home dir!
assumes all mail goes out to smarthost
  (cannot mail to local users (without it leaving the site first!))
  (does not use paths file information)
  (cannot use it to post by mail on a local site)
  (basically just doesn't use rmail.exe)
cannot 'G'oto an already-read-some-or-all group and reread only part
  - it's either only-new-articles or all-articles-on-disk now
cannot 'G'oto a group not already in your join file
at most 400 articles/group selectable (but you can usually go back for more)
  online version: 60 articles/group
crossposts detected/filtered using at most 200 groups in join file
  online version: 120 groups used in detection
very limited kill/antikill files
  no regular expression searches
  restricted to Subject: and From: only (substring or not,
    case sensitive or not - selectable)
  at most 150 killed/antikilled items/group
    online version: 50 killed/antikilled items/group
doesn't create directories as needed - must already exist
threading doesn't use References: data as much as it could
  it hashes them for much smaller space requirements now, so it should
  be fine except in the case of hash collisions - perfect detection of
  references sacrificed for space savings
doesn't log outgoing mail in ~waffle/admin/mail
doesn't guess when daylight savings hits
  (you have to change the clock on your pc anyway, and the policy about
  when to switch is different around the world)
has no simple built-in editor
does not use waffle's editor information from STATUS command or _editors file
has no good way to send time limit information to editor program
only understands %A, %W, %n, and %u waffle parameters
  (for static netmail:/netnews:/replyto: entries)
to get around waffle's rnews.exe continuation line noncompliance it doesn't
  keep lines to 80 columns (in the References: line)
any outgoing line more than 255 chars will be truncated somewhere still
'U'njoin not there

KNOWN WEIRDNESS

'W'rite not implemented in selection screen
'r'eply and 'f'ollow make you be careful with sig
  (but it works)
    (except in online version with very long posts if you have a lousy editor)
  (this helps prevent double sig enclosure, for sure!)
'P'revious group needs work (same issue as 'G'oto)
8-bit non-clean - assumes all input >126 is line noise (easily fixed)
leaves files laying around in temporary directory - could be handy, since
  sometimes rnews fails without an errorlevel, but could also get in your
  way - you may want to delete them periodically

ENVIRONMENT VARIABLES

(required) WAFFLE - same as waffle requires it - full pathname of static file
NET_NAME - users' waffle name
  also -u/--user
EDITOR - full path+extension of editor (default: c:\usr\bin\vi.exe)
  also -e/--editor - see also -o/--editor-options
  as of v0.96 full path should no longer be required - just extension
TZ - time zone; default: `MST' (if not found in static file)
FULLNAME - full real-world name of user
  also -f/--fullname (underscores changed to spaces)
  should not be necessary for Waffle 1.64 and 1.65
WAFFLEVERSION - version of waffle; default: `1.64'
  also static entry: version; also -v/--waffle-version

CREDITS

Kim Storm, for the `nn' newsreader (a much more powerful newsreader
  for Unix, some of whose keystrokes were used here (not Unix, nn))

Bill Fenner, author of PWPL165.ZIP from simtel20, who allowed me
  to know what was where in the password file with no guessing

Rhys Weatherley, who suggested hashing the Message-ID: and References:
  lines for better threading accuracy without taking much space

}

{rnews.exe in 1.64 and 1.65 seems to ignore leading-space continuation in}
{headers, despite rfc 1036, so need to define this}

{$define rnewscontbroken}

{$define nontiny} {do not delete this line - change to tiny to make rusnews0}

{use tiny for a default-to-fossil-port-0 version, with smaller limits}
{this is usually called rusnews0.exe.  use with any __small__}
{fossil-compatible editor, such as trived.exe from same author}

{trived is a trivial editor implementing a small subset of vi on the console}
{_or_ out a fossil - no ANSI.SYS required on console; about 50k required}

{$undef debug}
{$undef testsort}
{$undef testhash}
{$define ignoreoldoptions}
{$define oldmaildelivery}
{$define mouse}

{$ifdef tiny}
{$M 24576,0,27000}
{$undef mouse}
{$else}
{$M 32768,0,170000}
{$endif}

uses dos,crt,rusngenf

{$ifdef mouse}

,mouse   {my mouse unit is from Turbo Technix}

{$endif}

;

const

  newsreadername='rusnews';
  newsreaderversion='v1.01';

{$ifdef tiny}
  maxarts=60;
  maxkills=50;
  maxlpp=25;
  maxcols=80;
  maxjoined=120;
{$else}
  maxarts=400;
  maxkills=150;
  maxlpp=50;
  maxcols=132;
  maxjoined=200;
{$endif}

  minlpp=8;
  mincols=32;

  selheaderlines=1;
  headerbufsize=2048;
  headertlsize=30;

{$ifndef mouse}
  hasmouse=false;
{$endif}

type
  subjstringt=string[70];
  fnstringt=string[14];
  datestringt=string[8];
  fromstringt=string[20];
  groupstringt=string[40];
  killstringt=string[75];
  fnarray=array[1..maxarts] of fnstringt;
  fromarray=array[1..maxarts] of fromstringt;
  datearray=array[1..maxarts] of datestringt;
  headerbuft=array[1..headerbufsize] of char;
  headerlinet=record
      first: char;
      offset: integer;
    end;
  headertrackedlinest=array[1..headertlsize] of headerlinet;
  killsarr=array[1..maxkills] of killstringt;
  hashedt=array[1..2] of word;
  hashedarr=array[1..maxarts] of hashedt;

{$ifdef mouse}
  mevent=record
           event, btnstatus, horiz, vert: word;
         end;
{$endif}

var
  oldfilemode: byte;
  basedir: string;
  userid: string;
  shadow: integer;
  numarts: integer;
  numjoined: integer;

{high nybble of indents used for auto-selected articles etc.}

  indents: array[1..maxarts] of byte;
  sizeink: array[1..maxarts] of byte;
  basesubjs: array[1..maxarts] of subjstringt;
  joinedgroups: array[1..maxjoined] of groupstringt;
  filenamesp: ^fnarray;
  fromsp: ^fromarray;
  datesp: ^datearray;
  hmessageidsp: ^hashedarr;
  hreferencesp: array[1..4] of ^hashedarr;
  selected: array[1..maxarts] of boolean;
  highestart: word;
  highestread: word;
  wafenv: string;
  spooldir,temporarydir,userdir,waffledir,outboxdir: string;
  uucpname,node,smarthost,organ,timezone: string;
  netmail: string;
  netnews: string;
  replyto: string;
  home: string;
  joinfn,killfn,antikillfn: string;
  joinf,killf,antikillf: text;
  optfn: string;
  alreadyread: word;
  currgroup: string;
  headerinmem: string;
  headerbuf: headerbuft;
  headertrackedlines: headertrackedlinest;
  headerbytesinmem: integer;
  currart: integer;
  donegroup: boolean;
  browsedir: integer;
  browseonlysel: boolean;
  alreadyingroup: boolean;
  readallarts: boolean;
  nextwhilereading: boolean;
  editor: string;
  editoroptions: string;
  vspeller: string;
  vspelleroptions: string;
  killsubjsp,killfromsp: ^killsarr;
  killtextp: ^killsarr;
  antikillsubjsp,antikillfromsp: ^killsarr;
  antikilltextp: ^killsarr;
  haskillfile: boolean;
  hasantikillfile: boolean;
  killfileinmem: boolean;
  antikillfileinmem: boolean;
  numkills: integer;
  numantikills: integer;
  numsubjks,numfromks: integer;
  numsubjaks,numfromaks: integer;
  nonglobalkills: boolean;
  nonglobalantikills: boolean;
  fullname: string;
  waffleversion: string;
  console: boolean;
  port: integer;
  trusted: boolean;
  minutes: integer;
  forumsetl: string;
  minstart: integer;
  mailfrom: string;
  newsfrom: string;
  lpp: integer;
  sellpp: integer;
  cols: integer;
  lowcolor: byte;
  highcolor: byte;
  oldtextattr: byte;

{$ifdef mouse}
  hasmouse: boolean;
  mousevent: mevent;
  themouse: resetrec;
{$endif}

  subjectscaseinsensitive: boolean;
  subjectlength: byte;
  makespacelikex: boolean;
  makereturnlikeasterisk: boolean;
  hideheaders: string;
  showheaders: string;
  highlightheaders: string;
  wanderingnumbers: boolean;
  antikillreferences: boolean;
  showsubjectkills: boolean;
  showfromkills: boolean;
  showsubjectantikills: boolean;
  showfromantikills: boolean;
  autoantikill: boolean;
  warnautoantikill: boolean;
  editaftervspell: boolean;
  caseinsensitivekill: boolean;
  caseinsensitiveantikill: boolean;
  substringsubjectkill: boolean;
  substringfromkill: boolean;
  substringsubjectantikill: boolean;
  substringfromantikill: boolean;
  quiet: boolean;
  ignoreenvironment: boolean;
  confirmnext: boolean;
  confirmquit: boolean;
  missingsubjectisok: boolean;
  tildehome: boolean;
  antikillthisnewsreader: boolean;  {not of great use to many, I'm sure}
  clearscreenbetweengroups: boolean;
  detectvideo: boolean;
  antikillevenkilled: boolean;
  mailprefix: string;

function mitoday: integer; {minutes into today}

var
  h,m,s,s00: word;

begin
  gettime(h,m,s,s00);
  mitoday := 60*h+m;
end;

{$I rusn-io.pas}

procedure usage;

begin
  xwritelnsss('usage: ',newsreadername,' [options]');
  xwritelns('  -u --user %A');
  xwritelns('  -n --newsgroup c.b.w (jumps directly to that newsgroup)');
  xwritelns('  -p --port 0 (uses that fossil port - 0=COM1, 1=COM2)');
  xwritelns('  -f --fullname Full_Name (underscores will become spaces)');
  xwritelns('  -e --editor d:/path/editor.exe (uses this editor)');
  xwritelns('  -o --editor-options !_w:\user\%A (editor non-filename options)');
  xwritelns('  -s --forum-set-list local_usenet (uses these forum sets only)');
  xwritelns('  -t --trusted (allows dialin users to edit articles)');
  xwritelns('  -v --waffle-version %V (specifies waffle version)');
  xwritelns('  -m --minutes %O (specifies minutes online time)');
  xwritelns('  -d --shadow 1 (shadows all COMx output to console)');
  xwritelns('  -r --rcfile w:/waffle/lib/rusnews.opt (reads in options)');
  xwriteln;
  xwritelns('see documentation for other configuration options');
  xwriteln;
  xwritelns('russell@alpha3.ersys.edmonton.ab.ca (930323)');
  halt(1);
end;

{$I rusn-fun.pas}

{$ifdef mouse}

procedure handler     { Mouse event handler called by device driver }
   (flags, cs, ip, ax, bx, cx, dx, si, di, ds, es, bp: word);

interrupt;

begin
  mousevent.event     := ax;
  mousevent.btnstatus := bx;
  mousevent.horiz     := cx;
  mousevent.vert      := dx;
  inline (        { Exit processing for far return to device driver }
       $8B/$E5/            { MOV  SP, BP }
       $5D/                { POP  BP }
       $07/                { POP  ES }
       $1F/                { POP  DS }
       $5F/                { POP  DI }
       $5E/                { POP  SI }
       $5A/                { POP  DX }
       $59/                { POP  CX }
       $5B/                { POP  BX }
       $58/                { POP  AX }
       $CB );              { RETF    }
end;

{$endif}

procedure warn(warning: string);

var
  wastec: char;

begin
  xclreolxy(1,lpp);
  xwritess(warning,' - press any key ');
  wastec := xreadkey;
  xclreolxy(1,lpp);
end;

procedure warnerr(prg: string; doserr: integer);

var
  errstr: string;

begin
  errstr := itoa(doserr); 
  if doserr=2 then errstr := '2 (file not found)'
  else if doserr=3 then errstr := '3 (path not found)'
  else if doserr=5 then errstr := '5 (access denied)'
  else if doserr=6 then errstr := '6 (invalid handle)'
  else if doserr=8 then errstr := '8 (not enough memory)'
  else if doserr=10 then errstr := '10 (invalid environment)'
  else if doserr=11 then errstr := '11 (invalid format)'
  else if doserr=18 then errstr := '18 (no more files)';

  warn('warning: '+prg+' failed (error '+errstr+')');
end;

procedure defaultlppcols;

begin
  if console then
    if detectvideo then
      lpp := mem[$40:$84]+1
    else
      lpp := 25
  else
    lpp := 24;

  cols := mem[$40:$4a];
end;

procedure fixuplppcols;

begin
  lpp := max(minlpp,min(lpp,maxlpp));
  cols := max(mincols,min(cols,maxcols));

{}{} {will be 36 when selection code handles letters and numbers for toggles}

  sellpp := min(lpp-selheaderlines-4,26);
end;

procedure execp(cmd,cmdline: string);

var
  path: string;
  success: boolean;
  el: string;
  at: integer;

begin
  if (pos(':',cmd)<>0) or (pos('\',cmd)<>0) then
    exec(cmd,cmdline)
  else if indir(cmd,'.') then
    exec(cmd,cmdline)
  else
    begin
      path := getenv('PATH');
      success := false;
      while not success and (path<>'') do
        begin
          if copy(path,length(path),255)<>';' then
            path := path+';';
          at := pos(';',path);
          el := copy(path,1,at-1);
          path := copy(path,at+1,255);
          if indir(cmd,el) then
            begin
              success := true;
              exec(el+'\'+cmd,cmdline);
            end;
        end;
    end;
end;

procedure sethash(var h: hashedt; s: string);

var
  i: integer;
  atat: integer;
{$ifdef oldhash}
  ls,rs: integer;
{$endif}
  leng: integer;
  l: integer;
  startaft: integer;

begin
{$ifdef oldhash}
  for i := 1 to 6 do
    h[i] := 0;
  atat := pos('@',s);
  if atat=0 then
    begin
{leave malformed ones alone}
    end
  else
    begin
{assume all message-ids are at least 6 chars long - a@b.cd is}
      ls := atat-6;
      rs := atat+1;
{handle these specially - the last bunch of stuff is always the same!}
      if pos(newsreadername,s)>0 then
        ls := 10;
      if ls<1 then
        ls := 1;
      if atat>length(s)-5 then
        rs := length(s)-5;
      for i := 1 to 3 do
        h[i] := 16*( (ord(s[ls+i*2-1])) and 15)+( (ord(s[ls+i*2])) and 15);
      for i := 1 to 3 do
        h[i+3] := 16*( (ord(s[rs+i*2-1])) and 15)+( (ord(s[rs+i*2])) and 15);
    end;
{$endif}

  h[1] := 0;
  h[2] := 0;
  atat := pos('@',s);
  if atat=0 then
    begin
{leave malformed ones alone}
    end
  else
    begin
      leng := length(s);
      l := min(16,leng);
      for i := 1 to l do
        if odd(ord(s[i])) then
          h[1] := (h[1] shl 1)+1
        else
          h[1] := h[1] shl 1;
      l := min(16,leng);
      startaft := leng-l;
      if startaft>atat then
        startaft := atat;
      for i := 1 to l do
        if odd(ord(s[startaft+i])) then
          h[2] := (h[2] shl 1)+1
        else
          h[2] := h[2] shl 1;
    end;

{$ifdef testhash}

{
writeln('hashed "',s,'" to ',h[1]:5,' ',h[2]:5);
}

{$endif}

end;

procedure updatejoin(highestnum: word);

var
  s: string;
  tempf: text;

begin
  if highestnum>alreadyread then
    begin
      xwritelns('Updating join file...');
      assign(tempf,temporarydir+'\'+userid);
      reset(joinf);
      rewrite(tempf);
      while not eof(joinf) do
        begin
          readln(joinf,s);
          if getfirstw(s)=currgroup then
            writeln(tempf,currgroup,' ',highestnum)
          else
            writeln(tempf,s);
        end;
      close(joinf);
      close(tempf);

      reset(tempf);
      rewrite(joinf);
      while not eof(tempf) do
        begin
          readln(tempf,s);
          writeln(joinf,s);
        end;
      close(tempf);
      close(joinf);

      erase(tempf);

      reset(joinf);
    end;
end;

{$I rusn-kil.pas}

procedure backupjoin;

var
  s: string;
  tempf: text;
  createjoined: boolean;

begin
  xwritelns('Backing up join file...');
  createjoined := (numjoined=0);
  assign(tempf,home+'\join.bak');
  reset(joinf);
  rewrite(tempf);
  while not eof(joinf) do
    begin
      readln(joinf,s);
      writeln(tempf,s);
      if createjoined and (numjoined<maxjoined) then
        begin
          inc(numjoined);
          joinedgroups[numjoined] := getfirstw(s);
        end;
    end;
  close(tempf);
  reset(joinf);
end;

procedure swapi(var i,j: integer);

var
  t: integer;

begin
  t := i;
  i := j;
  j := t;
end;

procedure swapart(a,b: integer);

var
  tempsubj: subjstringt;
  tempfilename: fnstringt;
  tempdate: datestringt;
  tempindents: byte;
  tempsizeink: byte;
  tempfrom: fromstringt;

{don't need to worry about hashing stuff - by this time, not needed}

begin
  tempsubj := basesubjs[a];
  tempfilename := filenamesp^[a];
  tempdate := datesp^[a];
  tempindents := indents[a];
  tempsizeink := sizeink[a];
  tempfrom := fromsp^[a];

  basesubjs[a] := basesubjs[b];
  filenamesp^[a] := filenamesp^[b];
  datesp^[a] := datesp^[b];
  indents[a] := indents[b];
  sizeink[a] := sizeink[b];
  fromsp^[a] := fromsp^[b];

  basesubjs[b] := tempsubj;
  filenamesp^[b] := tempfilename;
  datesp^[b] := tempdate;
  indents[b] := tempindents;
  sizeink[b] := tempsizeink;
  fromsp^[b] := tempfrom;
end;

procedure sortitall;

var
  i,j: integer;
  dateptrs,subjptrs,finalptrs,revfinalptrs: array[1..maxarts] of integer;
  dateptrsdone: integer;
  finalptrsdone: integer;
  finalstart: integer;
  currsubjptr: integer;
  foundnewsubj: boolean;
  currsubj: string;

begin

{first sort by date, then for each oldest article, take the rest of the}
{articles in that thread together, sorting within the thread only}

  for i := 1 to numarts do
    dateptrs[i] := i;

{the dates equal but subjects not test is for comp.sources.* etc. v29i033}
{hopefully will help part 1/6 posts too (eg alt.sources)}

  for i := 1 to numarts-1 do
    for j := i+1 to numarts do
      if (datesp^[dateptrs[i]]>datesp^[dateptrs[j]]) then
        swapi(dateptrs[i],dateptrs[j])
      else if ( (datesp^[dateptrs[i]]=datesp^[dateptrs[j]]) and
       firstsubjg(basesubjs[dateptrs[i]],basesubjs[dateptrs[j]]) ) then
        swapi(dateptrs[i],dateptrs[j]);

  for i := 1 to numarts do
    subjptrs[i] := i;

  for i := 1 to numarts-1 do
    for j := i+1 to numarts do
      if firstsubjg(basesubjs[subjptrs[i]],basesubjs[subjptrs[j]]) then
        swapi(subjptrs[i],subjptrs[j]);

{sort via finalptrs indirection to prevent extra swapping}

  dateptrsdone := 0;
  finalptrsdone := 0;
  while finalptrsdone<numarts do
    begin
      inc(dateptrsdone);

      if dateptrs[dateptrsdone]>0 then
        begin

          currsubj := basesubjs[dateptrs[dateptrsdone]];

          currsubjptr := 1;
          while firstsubjg(currsubj,basesubjs[subjptrs[currsubjptr]]) do
            inc(currsubjptr);

          finalstart := finalptrsdone+1;
          foundnewsubj := false;
          while (finalptrsdone<numarts) and not foundnewsubj do
            begin
              if subjseq(currsubj,basesubjs[subjptrs[currsubjptr]]) then
                begin
                  inc(finalptrsdone);
                  finalptrs[finalptrsdone] := subjptrs[currsubjptr];
                  inc(currsubjptr);
                end
              else
                foundnewsubj := true;
            end;

{$ifdef testsort}
write('now have: ');
for i := finalstart to finalptrsdone do
  write(finalptrs[i],' ');
writeln;
xwrites('pausing...');
xwritelns(xreadkey);
{$endif}

          for i := finalstart to finalptrsdone-1 do
            for j := i+1 to finalptrsdone do
              if not firstartfirst(finalptrs[i],finalptrs[j]) then
                swapi(finalptrs[i],finalptrs[j]);

          for i := 1 to numarts do
            if subjseq(basesubjs[dateptrs[i]],currsubj) then
              dateptrs[i] := -dateptrs[i];

        end;
    end;

  for i := 1 to numarts do
    revfinalptrs[finalptrs[i]] := i;

  for i := 1 to numarts-1 do
    if finalptrs[i]<>i then
      begin
        swapart(i,finalptrs[i]);
        finalptrs[revfinalptrs[i]] := finalptrs[i];
        revfinalptrs[finalptrs[i]] := revfinalptrs[i];
        finalptrs[i] := i;
        revfinalptrs[i] := i;
      end;

end;

procedure shellout;

var
  comspec: string;
  doserr: integer;
  wastec: char;

begin
  if console and trusted then
    begin
      xgotoxy(1,lpp);
      xwriteln;
      xwriteln;
      xwriteln;
      xwritelns('use `EXIT'' to return to rusnews');
      xwritelns('be careful - you probably don''t have a lot of memory left');
      xwriteln;
      comspec := getenv('COMSPEC');
      if comspec='' then
        if indir('c:\.','command.com') then
          comspec := 'c:\command.com';
      if comspec='' then
        begin
          warn('could not find what shell to run - no COMSPEC variable');
        end
      else
        begin
          execp(comspec,'');
          doserr := doserror;
          xgotoxy(1,lpp);
          xwriteln;
          xwriteln;
          xwriteln;
          if doserr<>0 then
            xwrites('(error) press any key to return to rusnews ')
          else
            xwrites('press any key to return to rusnews ');
          wastec := xreadkey;
          xwrites(^M);
          xclreol;
          if doserr<>0 then
            warnerr('shell',doserr);
        end
    end;
end;

{$I rusn-bro.pas}

procedure readinarts;

var
  lowfilenum: word;
  fileinfo: searchrec;
  subject: string;
  from: string;
  newsgroups: string;
  messageid: string;
  references: string;
  filename: string;
  filenum: word;
  datestr: string;
  ch: char;
  i: integer;
  workwithit: boolean;
  readnomore: boolean;
  highestfile: word;
  mangledsubject: string;
  mailgroup: boolean;
  waskilled: boolean;

begin
  if readallarts then
    lowfilenum := 0
  else
    lowfilenum := alreadyread;
  readallarts := false;
  nextwhilereading := false;
  readnomore := false;
  highestart := 0;
  highestfile := 0;
  findfirst(basedir+'*.*',archive,fileinfo);
  while (doserror=0) and (numarts<maxarts) and not nextwhilereading and
   not readnomore do
    begin
      if xkeypressed then
        begin
          ch := xreadkey;
          if ch='N' then
            nextwhilereading := true
          else if ch='O' then
            readnomore := true
          else if ch='Q' then
            begin
              nextwhilereading := true;
              alreadyingroup := true;
              currgroup := '';
            end;
        end;

      filenum := atow(fileinfo.name);
      if not nextwhilereading and not readnomore and
       (filenum>lowfilenum) and
       (fileinfo.name[1]>='0') and (fileinfo.name[1]<='9') then
        begin

{some people put tabs in the Subject: line!  ick!}

          filename := basedir+fileinfo.name;
          subject := expand(getheaderline(filename,'subject:'));

          from := getheaderline(filename,'from:');
          newsgroups := getheaderline(filename,'newsgroups:');

          xwrites(fileinfo.name);

          mailgroup := (currgroup=mailprefix+'.'+userid);

          if mailgroup and (subject='') then
            subject := '(No subject)';

          if (subject='') and missingsubjectisok then
            subject := '(No subject - please provide one)';

          waskilled := false;
          workwithit := true;

          if not mailgroup then
            begin
              if subject='' then
                begin
                  workwithit := false;
                  xwrites('e');
                end
              else if alreadyseen(newsgroups) then
                begin
                  workwithit := false;
                  xwrites('s');
                end
              else
                begin
                  workwithit := not subjkilled(subject);
                  if workwithit then
                    workwithit := not fromkilled(from);
                  waskilled := not workwithit;
                  if waskilled then
                    xwrites('k');
                  if antikillevenkilled then
                    workwithit := true;
                end;
            end;

          if workwithit then
            begin
              inc(numarts);
              filenamesp^[numarts] := fileinfo.name;

{ use mangledsubject instead of basesubjs[numarts] to prevent accidental }
{ thread separation when Re: makes it go beyond subjstringt length }

{ changed 'Re: ' to 'Re:' - a LOT of broken systems out there! }

              mangledsubject := subject;
              indents[numarts] := 0;
              while upper(copy(mangledsubject,1,3))='RE:' do
                begin
                  inc(indents[numarts]);
                  mangledsubject := ltrim(copy(mangledsubject,4,255));
                end;
              basesubjs[numarts] := mangledsubject;

              fromsp^[numarts] := getfromname(from);
              if fromsp^[numarts]='' then
                fromsp^[numarts] := getfromaddr(from);

              if fileinfo.size>255*1024 then
                sizeink[numarts] := 255
              else
                sizeink[numarts] :=
                 longint(fileinfo.size+1023) div longint(1024);

              datestr := getheaderline(filename,'date:');
              datesp^[numarts] := stringtodatestring(datestr);

              messageid := getheaderline(filename,'message-id:');
              sethash(hmessageidsp^[numarts],messageid);

              references := getheaderline(filename,'references:');

{ Andrew system non-compliance, looks like }
              if references='' then
                references := getheaderline(filename,'in-reply-to:');

{ don't wipe out data with a 0 just because there's nothing in the header }
              if numoccur('<',references)>0 then
                indents[numarts] := numoccur('<',references);

              if not mailgroup then
                begin

{for use with auto-select key - start of antikill}
                  if antikillreferences then
                    if pos(node,references)<>0 then
                      indents[numarts] := indents[numarts] or 128;

{for author's use to make sure everything's working}
                  if antikillthisnewsreader then
                    if pos(newsreadername,messageid)<>0 then
                      indents[numarts] := indents[numarts] or 128;

                  if indents[numarts]<128 then
                    if subjantikilled(subject) then
                      indents[numarts] := indents[numarts] or 128
                    else if fromantikilled(from) then
                      indents[numarts] := indents[numarts] or 128;

                  if (indents[numarts] and 128)<>0 then
                    xwrites('a');

                end;

              if (indents[numarts]<128) and waskilled then
                begin
{if was killed, only antikilling can bring it back}
                  dec(numarts);
                end
              else
                begin
                  while numoccur('>',references)>4 do
                    messageid := chopfirstw(references);

                  sethash(hreferencesp[1]^[numarts],chopfirstw(references));
                  sethash(hreferencesp[2]^[numarts],chopfirstw(references));
                  sethash(hreferencesp[3]^[numarts],chopfirstw(references));
                  sethash(hreferencesp[4]^[numarts],chopfirstw(references));

                  if filenum>highestart then
                    highestart := filenum;
                end

            end;

          if wanderingnumbers then
            xwrites(' ')
          else
            xwritess('     ',^M);

          if not readnomore then
            if filenum>highestfile then
              highestfile := filenum;
        end;
      findnext(fileinfo);
    end;

  if numarts=0 then
    xwritelns('no new articles')
  else if wanderingnumbers then
    xwriteln;

{if all were read but filtered, show them as read to avoid scanning next time}

  if (numarts=0) and not nextwhilereading and not readnomore then
    updatejoin(highestfile);
end;

procedure viewarts(lowest,highest: integer; updatehighestread: boolean);

var
  numleft: integer;
  i: integer;
  willupdatej: boolean;

begin

  willupdatej := updatehighestread;

  currart := lowest;
  donegroup := false;
  browsedir := 1;
  browseonlysel := true;
  while not donegroup do
    begin

      if browseonlysel then
        while (currart>=lowest) and (currart<=highest) and
         not selected[currart] do
          inc(currart,browsedir)
      else
        browseonlysel := true;

      if currart>highest then
        donegroup := true;
      if currart<lowest then
        browsedir := 1;
      if (currart>=lowest) and (currart<=highest) then
        begin
          browsedir := 1;

{using k/b/a can mess this up any nice and simple way, so do it this way}
{will still show LAST when you're past the last selected one - so what}

          numleft := 0;
          for i := currart+1 to highest do
            if selected[i] then
              inc(numleft);

          browseart(currart,numleft,willupdatej);
          if (atow(filenamesp^[currart])>highestread) and willupdatej then
            highestread := atow(filenamesp^[currart]);
        end;

{ handle case of going to non-selected-also articles on extremes (first/last) }

{ allow `n' etc. to indicate finished reading, but not `a',`p',`b' }

      if ((browsedir>0) or (currart>lowest)) and
       (browseonlysel or (browsedir<0) or (currart<highest)) then
        inc(currart,browsedir);

    end;

{willupdatej can change to false part way through}

  if not willupdatej then
    highestread := 0;
end;

procedure pickagroup(var possgroup: string);

var
  howto: char;

begin
  xclreolxy(1,lpp);
  if possgroup='' then
    begin
      xwrites('Goto group (or initials): ');
      xreadlns(possgroup,cols-30);
    end;
  if (possgroup='') then
    xclreolxy(1,lpp)
  else
    if joinedtogroup(possgroup) then
      begin
        howto := 
         onekey('<j>ump normally, <a>ll articles (default=j) ','ja '+#13);
        if (howto=' ') or (howto=#13) then
          howto := 'j';
        if howto='a' then
          readallarts := true;
        xclreolxy(1,lpp);
      end
    else
      begin
        warn('could not find a group to match');
        possgroup := '';
      end;
end;

{$I rusn-sel.pas}

procedure groupinit;

procedure groupinitkills;

var
  s: string;
  killgroup: string;
  inglobals: boolean;
  killline: integer;
  sizewarned: boolean;

function killeof: boolean;

begin
  if killfileinmem then
    killeof := (killline>=numkills)
  else
    killeof := eof(killf);
end;

function nextkillline: killstringt;

var
  s: string;

begin
  if killfileinmem then
    begin
      inc(killline);
      nextkillline := killtextp^[killline];
    end
  else
    begin
      readln(killf,s);
      nextkillline := s;
    end;
end;

begin

{read in kill file for this group}

  numsubjks := 0;
  numfromks := 0;
  nonglobalkills := false;

  killline := 0;
  inglobals := true;

  sizewarned := false;

  if haskillfile then
    begin
      if not killfileinmem then
        begin
          if not quiet then
            xwritelns('reading in kill file...');
          reset(killf);
        end;

{allow defaults to come before the first Newsgroups line}

      killgroup := currgroup;
      while not killeof do
        begin
          s := nextkillline;

{if it's a new Newsgroups: selection, then check it - otherwise, process}

          if parseheadername(s)='Newsgroups' then
            begin
              killgroup := parseheadervalue(s);
              inglobals := false;
            end
          else if killgroup=currgroup then
            begin

              if showsubjectkills and showfromkills then
                xwritelnss('kill: ',s)
              else
                begin
                  if showsubjectkills then
                    if parseheadername(s)='Subject' then
                      xwritelnss('kill: ',s);
                  if showfromkills then
                    if parseheadername(s)='From' then
                      xwritelnss('kill: ',s);
                end;

              if parseheadername(s)='Subject' then
                begin
                  if numsubjks<maxkills then
                    begin
                      inc(numsubjks);
                      killsubjsp^[numsubjks] := parseheadervalue(s);
                      if not inglobals then
                        nonglobalkills := true;
                    end
                  else
                    begin
{}{} {too many subject kills - ignore}
{}{} {should discard the oldest one}
                      if not sizewarned then
                        warn('kill file is larger than memory allows');
                      sizewarned := true;
                    end;
                end
              else if parseheadername(s)='From' then
                begin
                  if numfromks<maxkills then
                    begin
                      inc(numfromks);
                      killfromsp^[numfromks] := parseheadervalue(s);
                      if not inglobals then
                        nonglobalkills := true;
                    end
                  else
                    begin
{}{} {too many from kills - ignore}
{}{} {should discard the oldest one}
                      if not sizewarned then
                        warn('kill file is larger than memory allows');
                      sizewarned := true;
                    end;
                end
              else
                begin
{}{} {invalid entry in kill file}
                  warn('unrecognizable entry in kill file');
                  warn(copy(s,1,40));
                end;
            end;
        end;
    end;
end;

procedure groupinitantikills;

var
  s: string;
  antikillgroup: string;
  inglobals: boolean;
  antikillline: integer;
  sizewarned: boolean;

function antikilleof: boolean;

begin
  if antikillfileinmem then
    antikilleof := (antikillline>=numantikills)
  else
    antikilleof := eof(antikillf);
end;

function nextantikillline: killstringt;

var
  s: string;

begin
  if antikillfileinmem then
    begin
      inc(antikillline);
      nextantikillline := antikilltextp^[antikillline];
    end
  else
    begin
      readln(antikillf,s);
      nextantikillline := s;
    end;
end;

begin

{read in antikill file for this group}

  numsubjaks := 0;
  numfromaks := 0;
  nonglobalantikills := false;

  antikillline := 0;
  inglobals := true;

  sizewarned := false;

  if hasantikillfile then
    begin
      if not antikillfileinmem then
        begin
          if not quiet then
            xwritelns('reading in antikill file...');
          reset(antikillf);
        end;

{allow defaults to come before the first Newsgroups line}

      antikillgroup := currgroup;
      while not antikilleof do
        begin
          s := nextantikillline;

{if it's a new Newsgroups: selection, then check it - otherwise, process}

          if parseheadername(s)='Newsgroups' then
            begin
              antikillgroup := parseheadervalue(s);
              inglobals := false;
            end
          else if antikillgroup=currgroup then
            begin

              if showsubjectantikills and showfromantikills then
                xwritelnss('antikill: ',s)
              else
                begin
                  if showsubjectantikills then
                    if parseheadername(s)='Subject' then
                      xwritelnss('antikill: ',s);
                  if showfromantikills then
                    if parseheadername(s)='From' then
                      xwritelnss('antikill: ',s);
                end;

              if parseheadername(s)='Subject' then
                begin
                  if numsubjaks<maxkills then
                    begin
                      inc(numsubjaks);
                      antikillsubjsp^[numsubjaks] := parseheadervalue(s);
                      if not inglobals then
                        nonglobalantikills := true;
                    end
                  else
                    begin
{}{} {too many subject antikills - ignore}
{}{} {should discard the oldest one}
                      if not sizewarned then
                        warn('antikill file is larger than memory allows');
                      sizewarned := true;
                    end;
                end
              else if parseheadername(s)='From' then
                begin
                  if numfromaks<maxkills then
                    begin
                      inc(numfromaks);
                      antikillfromsp^[numfromaks] := parseheadervalue(s);
                      if not inglobals then
                        nonglobalantikills := true;
                    end
                  else
                    begin
{}{} {too many from antikills - ignore}
{}{} {should discard the oldest one}
                      if not sizewarned then
                        warn('antikill file is larger than memory allows');
                      sizewarned := true;
                    end;
                end
              else
                begin
{}{} {invalid entry in antikill file}
                  warn('unrecognizable entry in antikill file');
                  warn(copy(s,1,40));
                end;
            end;
        end;
    end;
end;

begin
  numarts := 0;
  headerinmem := '';
  highestread := 0;

  basedir := getbasedir(currgroup);
  if basedir='' then
    begin
      xwritelns('could not find /dir= entry for this group - location of');
      xwritelns('  news unknown.  make sure you are using the new DEFAULT');
      xwritelns('  lines instead of the old (v1.63 and lower) FORUM lines');
      halt(1);
    end;

  if not quiet then
    xwritelnss('news directory=',basedir);

  groupinitkills;
  groupinitantikills;
end;

procedure findhighest;

var
  s: string;

begin
  reset(joinf);
  alreadyread := 65535;
  while (alreadyread=65535) and not eof(joinf) do
    begin
      readln(joinf,s);
      if getfirstw(s)=currgroup then
        alreadyread := getalreadyread(s);
    end;

{ only needed for initial single-group stuff }

  if alreadyread=65535 then
    begin
      xwritelnss('not joined to ',currgroup);
      halt(1);
    end;

{ end of only needed part }

end;

procedure initialize;

var
  currparmi: integer;
  currparm: string;
  nextparm: string;
  colors: string;
  optf: text;
  opttag: string;
  optval: string;
  gotogroup: boolean;

function handleoption(tag, value: string): boolean;

var
  usedarg: boolean;

begin
  usedarg := false;
  if (tag='-u') or (tag='--user') then
    begin
      userid := value;
      usedarg := true;
    end
  else if (tag='-n') or (tag='--newsgroup') then
    begin
      currgroup := value;
      if currgroup<>'' then
        alreadyingroup := true;
      usedarg := true;
    end
  else if (tag='-g') or (tag='--goto') then
    begin
      gotogroup := true;
      if copy(value,1,1)<>'-' then
        begin
          currgroup := value;
          usedarg := true;
        end;
    end
  else if (tag='-p') or (tag='--port') then
    begin
      console := false;
      port := atoi(value);
      trusted := false;
      usedarg := true;
    end
  else if tag='--console' then
    begin
      console := true;
      port := -1;
      trusted := true;
      minutes := maxint;
    end
  else if (tag='-l') or (tag='--lines') then
    begin
      lpp := atoi(value);
    end
  else if (tag='-c') or (tag='--columns') then
    begin
      cols := atoi(value);
    end
  else if (tag='-f') or (tag='--fullname') then
    begin
      fullname := ununderscore(value);
      usedarg := true;
    end
  else if (tag='-e') or (tag='--editor') then
    begin
      editor := value;
      usedarg := true;
    end
  else if (tag='-o') or (tag='--editor-options') then
    begin
      editoroptions := ununderscore(value);
      usedarg := true;
    end
  else if (tag='-s') or (tag='--forum-set-list') then
    begin
      forumsetl := ununderscore(value);
      usedarg := true;
    end
  else if (tag='-t') or (tag='--trusted') then
    begin
      trusted := true;
    end
  else if (tag='-v') or (tag='--waffle-version') then
    begin
      waffleversion := value;
      usedarg := true;
    end
  else if (tag='-m') or (tag='--minutes') then
    begin
      minutes := atoi(value);
      usedarg := true;
    end
  else if (tag='-d') or (tag='--shadow') then
    begin
      shadow := atoi(value);
      usedarg := true;
    end
  else if (tag='-r') or (tag='--rcfile') then
    begin
      optfn := unslash(value);
      usedarg := true;
    end
  else if tag='--vspeller' then
    begin
      vspeller := unslash(value);
      usedarg := true;
    end
  else if tag='--vspeller-options' then
    begin
      vspelleroptions := ununderscore(value);
      usedarg := true;
    end
  else if tag='--subjects-case-insensitive' then
    begin
      subjectscaseinsensitive := true;
    end
  else if tag='--subject-length' then
    begin
      if atoi(value)>0 then
        subjectlength := atoi(value);
      usedarg := true;
    end
  else if tag='--make-space-like-x' then
    begin
      makespacelikex := true;
    end
  else if tag='--make-return-like-asterisk' then
    begin
      makereturnlikeasterisk := true;
    end
  else if tag='--hide-these-headers' then
    begin
      hideheaders := upper(value);
      usedarg := true;
    end
  else if tag='--show-only-these-headers' then
    begin
      showheaders := upper(value);
      usedarg := true;
    end
  else if tag='--highlight-these-headers' then
    begin
      highlightheaders := upper(value);
      usedarg := true;
    end
  else if tag='--wandering-numbers' then
    begin
      wanderingnumbers := true;
    end
  else if tag='--antikill-references' then
    begin
      antikillreferences := true;
    end
  else if tag='--show-subject-kills' then
    begin
      showsubjectkills := true;
    end
  else if tag='--show-from-kills' then
    begin
      showfromkills := true;
    end
  else if tag='--show-subject-antikills' then
    begin
      showsubjectantikills := true;
    end
  else if tag='--show-from-antikills' then
    begin
      showfromantikills := true;
    end
  else if tag='--auto-antikill' then
    begin
      autoantikill := true;
    end
  else if tag='--warn-auto-antikill' then
    begin
      warnautoantikill := true;
    end
  else if tag='--edit-after-vspell' then
    begin
      editaftervspell := true;
    end
  else if tag='--case-insensitive-kill' then
    begin
      caseinsensitivekill := true;
    end
  else if tag='--case-insensitive-antikill' then
    begin
      caseinsensitiveantikill := true;
    end
  else if tag='--substring-subject-kill' then
    begin
      substringsubjectkill := true;
    end
  else if tag='--substring-from-kill' then
    begin
      substringfromkill := true;
    end
  else if tag='--substring-subject-antikill' then
    begin
      substringsubjectantikill := true;
    end
  else if tag='--substring-from-antikill' then
    begin
      substringfromantikill := true;
    end
  else if tag='--quiet' then
    begin
      quiet := true;
    end
  else if tag='--ignore-environment' then
    begin
      ignoreenvironment := true;
    end
  else if tag='--confirm-next' then
    begin
      confirmnext := true;
    end
  else if tag='--confirm-quit' then
    begin
      confirmquit := true;
    end
  else if tag='--missing-subject-is-ok' then
    begin
      missingsubjectisok := true;
    end
  else if tag='--tilde-home' then
    begin
      tildehome := true;
    end
  else if tag='--antikill-this-newsreader' then
    begin
      antikillthisnewsreader := true;
    end
  else if tag='--clear-screen-between-groups' then
    begin
      clearscreenbetweengroups := true;
    end
  else if tag='--detect-video' then
    begin
      detectvideo := true;
      defaultlppcols;
    end
  else if tag='--antikill-even-killed' then
    begin
      antikillevenkilled := true;
      defaultlppcols;
    end
  else if tag='--mail-prefix' then
    begin
      mailprefix := value;
      usedarg := true;
    end
  else
    begin


{$ifdef ignoreoldoptions}

{ compatability switch with earlier releases - now obsolete }

{try to make sure any error messages are going to be visible!}

      console := true;
      xwritelnsss(newsreadername,' unknown option: ',tag);
      halt(1);

{$else}

      userid := tag;
      xwritelns('warning: obsolete usage of userid on the command line');
      xwritelns('use -u/--user instead');

{$endif}

    end;

  handleoption := usedarg;

end;

begin
  randomize;
  new(filenamesp);
  new(fromsp);
  new(datesp);
  new(killsubjsp);
  new(killfromsp);
  new(killtextp);
  new(antikillsubjsp);
  new(antikillfromsp);
  new(antikilltextp);
  new(hmessageidsp);
  new(hreferencesp[1]);
  new(hreferencesp[2]);
  new(hreferencesp[3]);
  new(hreferencesp[4]);
  userid := '';
  currgroup := '';
  forumsetl := '';
  waffleversion := '';

{$ifdef tiny}
  console := false;
  port := 0;
  trusted := false;
  minutes := 60;
{$else}
  console := true;
  port := -1;
  trusted := true;
  minutes := maxint;
{$endif}

  fullname := '';
  editor := '';
  editoroptions := '';
  vspeller := '';
  vspelleroptions := '';
  shadow := 0;
  optfn := '';

  subjectscaseinsensitive := false;
  subjectlength := 50;
  makespacelikex := false;
  makereturnlikeasterisk := false;
  hideheaders := '';
  showheaders := '';
  highlightheaders := upper(':Subject:From:');
  wanderingnumbers := false;
  antikillreferences := false;
  showsubjectkills := false;
  showfromkills := false;
  showsubjectantikills := false;
  showfromantikills := false;
  autoantikill := false;
  warnautoantikill := false;
  editaftervspell := false;
  caseinsensitivekill := false;
  caseinsensitiveantikill := false;
  substringsubjectkill := false;
  substringfromkill := false;
  substringsubjectantikill := false;
  substringfromantikill := false;
  quiet := false;
  ignoreenvironment := false;
  confirmnext := false;
  confirmquit := false;
  missingsubjectisok := false;
  tildehome := false;
  antikillthisnewsreader := false;
  clearscreenbetweengroups := false;
  detectvideo := false;
  antikillevenkilled := false;
  mailprefix := '';

  alreadyingroup := false;
  readallarts := false;

  gotogroup := false;

  defaultlppcols;

  currparmi := 1;
  while currparmi<=paramcount do
    begin
      currparm := paramstr(currparmi);
      if currparmi<paramcount then
        nextparm := paramstr(currparmi+1)
      else
        nextparm := '';

      if handleoption(currparm,nextparm) then
        inc(currparmi);

      inc(currparmi);

    end;

  if optfn<>'' then
    begin
      assign(optf,optfn);
      {$I-}
      reset(optf);
      {$I+}
      if ioresult<>0 then
        begin
          console := true;
          xwritelnss('could not open option file ',optfn);
          halt(1);
        end;
      optfn := '';
      while not eof(optf) do
        begin
          readln(optf,optval);
          opttag := chopfirstw(optval);
          if length(opttag)>0 then
            if opttag[1]<>'#' then
              begin
                if opttag[1]<>'-' then
                  opttag := '--'+opttag;
                if handleoption(opttag,optval) then
                  ;
              end;
        end;
      close(optf);
      if optfn<>'' then
        xwritelns('cannot use -r/--rcfile inside an rcfile, sorry');
    end;

{try to make sure any error messages are going to be visible!}

  if not console and (port<>0) and (port<>1) then
    begin
      console := true;
      xwritelns('error: -p/--port specified without valid port number');
      xwritelns('  valid numbers are 0 (COM1) and 1 (COM2)');
      halt(1);
    end;

{$ifdef debug}
  xwritelns('parameters:');
  for currparmi := 1 to paramcount do
    xwritelns(paramstr(currparmi));
{$endif}

  xwritelnsss(newsreadername,' ',newsreaderversion);

  if (userid='') and not ignoreenvironment then
    userid := lower(getenv('NET_NAME'));

  if userid='' then
    usage;

  xwritelnss('user: ',userid);

  wafenv := unslash(getenv('WAFFLE'));
  if wafenv='' then
    begin
      xwritelns('must set WAFFLE environment variable');
      halt(1);
    end;

  if (waffleversion='') and not ignoreenvironment then
    waffleversion := getenv('WAFFLEVERSION');
  if waffleversion='' then
    waffleversion := getstaticvalue('version');
  if waffleversion='' then
    waffleversion := '1.64';
  if (length(waffleversion)<>4) or (copy(waffleversion,2,1)<>'.') or
   (numoccur('.',waffleversion)<>1) then
    begin
      xwritelns('WAFFLEVERSION environment variable, or static file version:');
      xwritelns('setting, or -v/--waffle-version argument in wrong format');
      xwritelns('should be similar to `1.64'' (without the quotes)');
      xwritelnsss('it is currently set to: `',waffleversion,'''');
      halt(1);
    end;

  if not quiet then
    xwritelnss('waffle version: ',waffleversion);

  spooldir := unslash(getstaticvalue('spool'));
  temporarydir := unslash(getstaticvalue('temporary'));
  userdir := unslash(getstaticvalue('user'));
  waffledir := unslash(getstaticvalue('waffle'));
  outboxdir := unslash(getstaticvalue('outbox'));
  if outboxdir='' then
    outboxdir := spooldir+'\outbox';

  if fullname='' then
    begin
      if waffleversion='1.64' then
        fullname := getpwinfo164(5)
      else if waffleversion='1.65' then
        fullname := getpwinfo165(3)
      else
        xwritelns('only Waffle 1.64 and 1.65 password file formats known');
    end;
  if (fullname='') and not ignoreenvironment then
    fullname := ununderscore(getenv('FULLNAME'));
  if fullname='' then
    begin
      xwritelnsss('user ',userid,' has no name in the password file');
      xwritelns('  that can be found, and environment variable FULLNAME');
      xwritelns('  not set, and option -f/--fullname not used');
      halt(1);
    end;

  if not quiet then
    xwritelnss('full name: ',fullname);

{}{} {needs to get editor entry from password and extern/_editors files}

  if (editor='') and not ignoreenvironment then
    editor := getenv('VISUAL');
  if (editor='') and not ignoreenvironment then
    editor := getenv('EDITOR');
  if editor='' then
    editor := 'vi.exe';

  if not quiet then
    xwritelnss('editor: ',editor);

  if (vspeller='') and not ignoreenvironment then
    vspeller := getenv('VSPELL');
  if (vspeller='') and not ignoreenvironment then
    vspeller := getenv('SPELL');
  if vspeller='' then
    vspeller := 'vspell.exe';

  if not quiet then
    xwritelnss('vspeller: ',vspeller);

  if not quiet then
    xwritelnsi('minutes left: ',minutes);

  uucpname := getstaticvalue('uucpname');
  node := getstaticvalue('node');
  smarthost := getstaticvalue('smarthost');
  organ := getstaticvalue('organ');
  netmail := getstaticvalue('netmail');
  netnews := getstaticvalue('netnews');
  replyto := getstaticvalue('replyto');

  if mailprefix='' then
    mailprefix := uucpname+'.mail';

  if not quiet then
    xwritelnssss('mail group=',mailprefix,'.',userid);

  if netmail='' then
    netmail := '%A@%n (%W)';
  if netnews='' then
    netnews := netmail;

  mailfrom := wafexpand(netmail);
  newsfrom := wafexpand(netnews);
  if replyto<>'' then
    replyto := wafexpand(replyto);

  if (numoccur('.',node)=0) or (numoccur('@',newsfrom)<>1) or
   (numoccur('@',mailfrom)>1) or (numoccur('@',replyto)>1) or
   ( (numoccur('@',mailfrom)=0) and (numoccur('!',mailfrom)=0) ) then
    begin
      xwritelns('invalid node: or netmail:/netnews:/replyto: static entry');
      xwritelns('  the node entry needs at least one "."');
      xwritelns('  the netmail entry needs one "@" and/or at least one "!"');
      xwritelns('  the netnews entry needs one "@"');
      xwritelns('  the replyto entry (if any) can have at most one "@"');
      xwriteln;
      xwritelns('current settings:');
      xwritelnss('  node:     ',node);
      xwritelnss('  newsfrom: ',newsfrom);
      xwritelnss('  mailfrom: ',mailfrom);
      xwritelnss('  replyto:  ',replyto);
      halt(1);
    end;

  if not quiet then
    xwritelnss('mail from: ',mailfrom);
  if mailfrom<>newsfrom then
    if not quiet then
      xwritelnss('news from: ',newsfrom);
  if replyto<>'' then
    if not quiet then
      if replyto=mailfrom then
        xwritelnss('reply-to: ','(same as mail)')
      else if replyto=newsfrom then
        xwritelnss('reply-to: ','(same as news)')
      else
        xwritelnss('reply-to: ',replyto);

  if forumsetl='' then
    forumsetl := getstaticvalue('forums');

  forumsetl := ltrim(trim(forumsetl));

  if forumsetl='' then
    begin
      xwritelns('empty forum set list');
      halt(1);
    end;

  if not quiet then
    xwritelnss('forum set list: ',forumsetl);

  if not ignoreenvironment then
    timezone := getenv('TZ');

  if timezone='' then
    timezone := getstaticvalue('timezone');
  if timezone='' then
    timezone := 'MST';
  if pos(' ',timezone)>1 then
    timezone := copy(timezone,1,pos(' ',timezone)-1)
  else if length(timezone)>5 then
    timezone := copy(timezone,1,3);
{ handles TZ=GMT0BST and TZ=+1100 cases }

  if not quiet then
    xwritelnss('timezone: ',timezone);

  home := userdir+'\'+userid;
  joinfn := home+'\join';
  assign(joinf,joinfn);
  {$I-}
  reset(joinf);
  {$I+}
  if ioresult<>0 then
    begin
      xwritelnsss('join file ',joinfn,' not found.');
      halt(1);
    end;

  numjoined := 0;
  backupjoin;

  haskillfile := false;
  hasantikillfile := false;
  killfileinmem := false;
  antikillfileinmem := false;

  readinkill(true);
  readinantikill(true);

  if currgroup<>'' then
    if not joinedtogroup(currgroup) then
      begin
        xwritelnsss('not joined to ',currgroup,
         ' - starting at top of join file');
        currgroup := '';
        alreadyingroup := false;
      end;

  minstart := mitoday;

  fixuplppcols;

  if not quiet then
    begin
      xwritelnsi('lines per page: ',lpp);
      xwritelnsi('sel lines per page: ',sellpp);
      xwritelnsi('columns: ',cols);
    end;

{$ifdef mouse}

  hasmouse := false;

{$endif}

  if console then
    begin
      oldtextattr := textattr;
      lowcolor := 7;
      highcolor := 15;
      colors := getstaticvalue('colors');
      if colors='' then
        colors := getstaticvalue('colours');
      if colors<>'' then
        begin
          lowcolor := atoi(chopfirstw(colors));
          highcolor := atoi(getfirstw(colors));
        end;
      if lowcolor=0 then
        lowcolor := 7;
      if highcolor=0 then
        highcolor := 15;
      if lowcolor=highcolor then
        if lowcolor=7 then
          highcolor := 15
        else
          lowcolor := 7;
      xlowvideo;

{$ifdef mouse}

      mreset(themouse);
      hasmouse := themouse.exists;

      if hasmouse then
        begin
          minsttask($14,seg(handler),ofs(handler));
          mousevent.event := 0;
        end;

{$endif}

    end;

  if gotogroup then
    begin

{ make sure last line had no valuable information }
      xgotoxy(1,lpp);
      xwriteln;

      pickagroup(currgroup);
      if currgroup<>'' then
        alreadyingroup := true;
    end;
end;

procedure shutdown;

begin
  close(joinf);
  if haskillfile then
    close(killf);
  if hasantikillfile then
    close(antikillf);

{$ifdef mouse}

  if hasmouse then
    begin
      mhide;
      mreset(themouse);
    end;

{$endif}

  xgotoxy(1,lpp);
  xwriteln;
  if console then
    begin
      textattr := oldtextattr;
      xwriteln;
    end;
end;

begin

  initialize;

{$ifdef debug}
  execp('c:\usr\bin\freem.exe','');
  xwrites('rusnews: freem: doserror=');
  xwritei(doserror);
  xwriteln;
{$endif}

  repeat
    if alreadyingroup then
      alreadyingroup := false
    else
      currgroup := getnextgroup;
    if currgroup<>'' then
      begin

        if clearscreenbetweengroups then
          xclrscr;

        xwritelnss('group found=',currgroup);

        groupinit;
        findhighest;
        xwritelns('Reading...');
        readinarts;
        if not nextwhilereading then
          begin

{all these routines handle numarts=0 just fine - but it cuts down on output}
            if numarts>0 then
              begin
                xwritelns('Sorting...');
                sortitall;

{$ifdef testsort}
                xwrites('pausing...');
                xwritelns(xreadkey);
{$endif}

          {
            for i := 1 to numarts do
              xwritelnsssssss(filenamesp^[i]:14,' ',datesp^[i],' ',
               indents[i]:1,' ',copy(basesubjs[i],1,55));
          }

                selectarts;
                viewarts(1,numarts,true);
                updatejoin(highestread);
              end;
          end;
      end;
  until currgroup='';
  shutdown;
end.