unit rusngenf;  {generic functions unit - not rusnews-specific at all}

{ formerly from the file: }

{

rusn-fun.pas - rusnews functions

}

interface

uses dos;

function max(a,b: integer): integer;
function min(a,b: integer): integer;
function integertozstring(i, width: integer): string;
function time: string;
function timedigits: string;
function cdow: string;
function dayofmonth: integer;
function month: integer;
function monthname: string;
function year: integer;
function getenv(s: string): string;
function numoccur(c: char; s: string): integer;
function unquote(s: string): string;
function unslash(s: string): string;
function ununderscore(s: string): string;
function unspace(s: string): string;
function atow(s: string): word;
function atoi(s: string): integer;
function itoa(i: integer): string;
function upper(s: string): string;
function lower(s: string): string;
function ltrim(s: string): string;
function trim(s: string): string;
function getfirstw(s: string): string;
function chopfirstw(var s: string): string;
function randomletter: char;
function randomdigit: char;
function getfromaddr(from: string): string;
function getfromname(from: string): string;
function chop(s: string; i: integer): string;
function nore(s: string): string;
function monthstringtointeger(monthstr: string): integer;
function isdigit(c: char): boolean;
function islower(c: char): boolean;
function snatchint(var s: string): integer;
function getuniqfile(basedir: string): string;
function getuniqfext(basename: string): string;
function expand(str: string): string;
function isdev(s: string): boolean;
function rot13(s: string): string;
function indir(filespec,dir: string): boolean;

implementation

function max;

begin
  if a>b then max := a else max := b;
end;

function min;

begin
  min := -max(-a,-b);
end;

function integertozstring;

var
  result: string;

begin
  str(i,result);
  while length(result)<width do
    result := '0'+result;
  integertozstring := result;
end;

function time;

var
  h,m,s,s00: word;

begin
  gettime(h,m,s,s00);
  time := integertozstring(h,2)+':'+integertozstring(m,2)+':'+
   integertozstring(s,2);
end;

function timedigits;

var
  h,m,s,s00: word;

begin
  gettime(h,m,s,s00);
  timedigits :=
   integertozstring(h,2)+integertozstring(m,2)+integertozstring(s,2);
end;

function cdow;

var
  y,m,d,dow: word;
  result: string;

begin
  getdate(y,m,d,dow);
  result := 'Sunday';
  if dow=1 then result := 'Monday';
  if dow=2 then result := 'Tuesday';
  if dow=3 then result := 'Wednesday';
  if dow=4 then result := 'Thursday';
  if dow=5 then result := 'Friday';
  if dow=6 then result := 'Saturday';
  cdow := result;
end;

function dayofmonth;

var
  y,m,d,dow: word;

begin
  getdate(y,m,d,dow);
  dayofmonth := d;
end;

function month;

var
  y,m,d,dow: word;

begin
  getdate(y,m,d,dow);
  month := m;
end;

function monthname;

var
  themonth: integer;
  result: string;

begin
  themonth := month;
  result := 'January';
  if themonth=2  then result := 'February';
  if themonth=3  then result := 'March';
  if themonth=4  then result := 'April';
  if themonth=5  then result := 'May';
  if themonth=6  then result := 'June';
  if themonth=7  then result := 'July';
  if themonth=8  then result := 'August';
  if themonth=9  then result := 'September';
  if themonth=10 then result := 'October';
  if themonth=11 then result := 'November';
  if themonth=12 then result := 'December';
  monthname := result;
end;

function year;

var
  y,m,d,dow: word;

begin
  getdate(y,m,d,dow);
  year := y;
end;

function getenv;

var
  i: integer;
  envseg: word;
  envread: integer;
  firstb: byte;
  thisb: byte;
  varname: string;
  vardata: string;
  done: boolean;
  result: string;

begin
  result := '';
  envseg := memw[prefixseg:$2c];
  envread := 0;
  repeat
    firstb := mem[envseg:envread];
    if firstb>0 then
      begin
        varname := '';
        repeat
          thisb := mem[envseg:envread];
          inc(envread);
          if thisb<>ord('=') then
            varname := varname+chr(thisb);
        until thisb=ord('=');
        vardata := '';
        repeat
          thisb := mem[envseg:envread];
          inc(envread);
          if thisb>0 then
            vardata := vardata+chr(thisb);
        until thisb=0;
        done := (varname=s);
        if done then
          result := vardata;
    end;
  until (firstb=0) or done;
  getenv := result;
end;

function numoccur;

var
  result: integer;
  i: integer;

begin
  result := 0;
  for i := 1 to length(s) do
    if s[i]=c then
      inc(result);
  numoccur := result;
end;

function unquote;

begin
  if (s[1]='"') and (s[length(s)]='"') then
    unquote := copy(s,2,length(s)-2)
  else
    unquote := s;
end;

function unslash;

var
  i: integer;
  result: string;

begin
  result := s;
  for i := 1 to length(result) do
    if result[i]='/' then
      result[i] := '\';
  unslash := result;
end;

function ununderscore;

var
  i: integer;
  result: string;

begin
  result := s;
  for i := 1 to length(result) do
    if result[i]='_' then
      result[i] := ' ';
  ununderscore := result;
end;

function unspace;

var
  i: integer;
  result: string;

begin
  if (numoccur(' ',s)=0) and (numoccur(^I,s)=0) then
    result := s
  else
    begin
      result := '';
      for i := 1 to length(s) do
        if (s[i]<>' ') and (s[i]<>^I) then
          result := result+s[i];
    end;
  unspace := result;
end;

function atow;

var
  result: word;
  code: word;

begin
  val(s,result,code);
  atow := result;
end;

function atoi;

var
  result: integer;
  code: word;

begin
  val(s,result,code);
  atoi := result;
end;

function itoa;

begin
  itoa := integertozstring(i,0);
end;

function upper;

var
  result: string;
  i: integer;

begin
  result := s;
  for i := 1 to length(s) do
    result[i] := upcase(result[i]);
  upper := result;
end;

function lower;

var
  result: string;
  i: integer;

begin
  result := s;
  for i := 1 to length(s) do
    if (result[i]>='A') and (result[i]<='Z') then
      result[i] := chr(ord(result[i])-ord('A')+ord('a'));
  lower := result;
end;

function ltrim;

var
  result: string;

begin
  result := s;
  while ((result[1]=' ') or (result[1]=^I)) and (length(result)>0) do
    result := copy(result,2,255);
  ltrim := result;
end;

function trim;

var
  result: string;

begin
  result := s;
  while ((result[length(result)]=' ') or (result[length(result)]=^I)) and
   (length(result)>0) do
    result := copy(result,1,length(result)-1);
  trim := result;
end;

function getfirstw;

var
  result: string;
  spaceat: integer;
  tabat: integer;

begin
  result := trim(ltrim(s));
  spaceat := pos(' ',result);
  tabat := pos(^I,result);
  if tabat>0 then
    if (spaceat>0) and (tabat>spaceat) then
      result := copy(result,1,spaceat-1)
    else
      result := copy(result,1,tabat-1)
  else
    if spaceat>0 then
      result := copy(result,1,spaceat-1);
  getfirstw := result;
end;

function chopfirstw;

var
  result: string;
  spaceat: integer;
  tabat: integer;

begin
  s := trim(ltrim(s));
  result := getfirstw(s);
  s := trim(ltrim(copy(s,length(result)+1,255)));
  chopfirstw := result;
end;

function randomletter;

begin
  if random(2)=0 then
    randomletter := chr(ord('a')+random(26))
  else
    randomletter := chr(ord('A')+random(26));
end;

function randomdigit;

begin
  randomdigit := chr(ord('0')+random(10));
end;

function getfromaddr;

var
  result: string;
  at: integer;

begin
  at := pos('<',from);
  if at>0 then
    result := copy(from,at+1,length(from)-at-1)
  else
    begin
      at := pos(' ',from);
      if at>0 then
        result := copy(from,1,at-1)
      else
        result := from;
    end;
  getfromaddr := result;
end;

{be careful with address like

  "Some (Happy) User" <some@happy.com>

- need to grab the right parts right}

function getfromname;

var
  result: string;
  at: integer;

begin
  result := '';
  if copy(from,length(from),1)='>' then
    begin
      at := pos('<',from);
      if at>1 then
        result := copy(from,1,at-2);
    end;
  if result='' then
    begin
      at := pos('(',from);
      if at>0 then
        result := copy(from,at+1,length(from)-at-1)
      else
        begin
          at := pos('<',from);
          if at>1 then
            result := copy(from,1,at-2);
        end;
    end;
  getfromname := unquote(result);
end;

function chop;

var
  result: string;

begin
  chop := copy(s,i+1,255);
end;

function nore;

begin
  if upper(copy(s,1,4))='RE: ' then
    nore := chop(s,4)
  else
    nore := s;
end;

function monthstringtointeger;

var
  result: integer;
  lowermonthstr: string;

begin
  result := 12;
  lowermonthstr := lower(monthstr);
  if lowermonthstr='jan' then result := 1
  else if lowermonthstr='feb' then result := 2
  else if lowermonthstr='mar' then result := 3
  else if lowermonthstr='apr' then result := 4
  else if lowermonthstr='may' then result := 5
  else if lowermonthstr='jun' then result := 6
  else if lowermonthstr='jul' then result := 7
  else if lowermonthstr='aug' then result := 8
  else if lowermonthstr='sep' then result := 9
  else if lowermonthstr='oct' then result := 10
  else if lowermonthstr='nov' then result := 11;
  monthstringtointeger := result;
end;

function isdigit;

begin
  isdigit := (c>='0') and (c<='9');
end;

function islower;

begin
  islower := (c>='a') and (c<='z');
end;

function snatchint;

var
  intsofar: integer;

begin
  intsofar := 0;
  while (length(s)>0) and not isdigit(s[1]) do
    s := chop(s,1);
  while (length(s)>0) and isdigit(s[1]) do
    begin
      intsofar := 10*intsofar+ord(s[1])-ord('0');
      s := chop(s,1);
    end;
  snatchint := intsofar;
end;

function getuniqfile;

{basedir has to end in \}

var
  result: integer;
  fileinfo: searchrec;

begin
  result := 0;
  findfirst(basedir+'*',archive,fileinfo);
  while doserror=0 do
    begin
      result := max(result,atoi(fileinfo.name));
      findnext(fileinfo);
    end;
  getuniqfile := basedir+itoa(result+1);
end;

function getuniqfext;

var
  result: integer;
  fileinfo: searchrec;
  filefound: string;

begin
  result := 0;
  findfirst(basename+'.*',archive,fileinfo);
  while doserror=0 do
    begin
      filefound := fileinfo.name;
      while pos('.',filefound)>0 do
        filefound := copy(filefound,pos('.',filefound)+1,255);
      result := max(result,atoi(filefound));
      findnext(fileinfo);
    end;
  getuniqfext := basename+'.'+itoa(result+1);
end;

function expand;

var
  work: string;
  i,j: integer;

begin
  if pos(^I,str)=0 then
    expand := str
  else
    begin
      work := '';
      for i := 1 to length(str) do
        if length(work)<240 then
          if str[i]=^I then
            for j := 1 to 8-(length(work) and 7) do
              work := work+' '
          else
            work := work+str[i];
      expand := work;
    end;
end;

function isdev;

var
  offs: word;
  segm: word;
  oldsegm: word;
  foundnul: boolean;
  result: boolean;
  basename: string;
  i: integer;

begin
  result := false;
  segm := 0;
  offs := $400;

  basename := upper(unslash(s));

{handle LPT1: case}
  if copy(basename,length(basename),1)=':' then
    basename := copy(basename,1,length(basename)-1);

{strip disk and path designators}
  while pos(':',basename)<>0 do
    basename := copy(basename,pos(':',basename)+1,255);
  while pos('\',basename)<>0 do
    basename := copy(basename,pos('\',basename)+1,255);

{strip anything after the first period}
  if pos('.',basename)<>0 then
    basename := copy(basename,1,pos('.',basename)-1);

{NUL is supposed to be guaranteed the first in the chain}
  foundnul := false;
  while (not foundnul) and (offs>0) do
    begin
      if (mem[segm:offs]=ord('N')) and (mem[segm:offs+1]=ord('U')) and
       (mem[segm:offs+2]=ord('L')) and (mem[segm:offs+3]=ord(' ')) and
       (mem[segm:offs+4]=ord(' ')) and (mem[segm:offs+5]=ord(' ')) and
       (mem[segm:offs+6]=ord(' ')) and (mem[segm:offs+7]=ord(' ')) then
        begin

{$ifdef devverbose}
          writeln('found NUL at ',offs);
          writeln('attrib=',memw[segm:offs-6]);
{$endif}

          if memw[segm:offs-6]=$8004 then
            begin

{$ifdef devverbose}
              writeln('looks like the real NUL to me!');
{$endif}

              foundnul := true;
            end;
        end;

      if not foundnul then
        inc(offs);
    end;

  if foundnul then
    begin

      while length(basename)<8 do
        basename := basename+' ';

      while not result and (meml[segm:offs-10]<>$ffffffff) do
        begin

          result := true;
          for i := 0 to 7 do
            result := result and (chr(mem[segm:offs+i])=basename[1+i]);

{$ifdef devverbose}
          writeln('name of device=',
           chr(mem[segm:offs]),
           chr(mem[segm:offs+1]),
           chr(mem[segm:offs+2]),
           chr(mem[segm:offs+3]),
           chr(mem[segm:offs+4]),
           chr(mem[segm:offs+5]),
           chr(mem[segm:offs+6]),
           chr(mem[segm:offs+7]),
           '.');

          writeln('new position: ',memw[segm:offs-10],':',memw[segm:offs-8]);
{$endif}

          oldsegm := segm;
          segm := memw[oldsegm:offs-8];
          offs := memw[oldsegm:offs-10]+10;

        end;

    end;
  isdev := result;
end;

function rot13;

var
  result: string;
  upc: char;
  i: integer;

begin
  result := s;
  for i := 1 to length(result) do
    begin
      upc := upcase(result[i]);
      if (upc>='A') and (upc<='M') then
        result[i] := chr(ord(result[i])+13)
      else if (upc>='N') and (upc<='Z') then
        result[i] := chr(ord(result[i])-13);
    end;
  rot13 := result;
end;

function indir;

var
  fileinfo: searchrec;

begin
  findfirst(dir+'\'+filespec,archive,fileinfo);
  indir := (doserror=0);
end;

end.
