{

rusn-bro.pas - rusnews browseart and friends

}

procedure browseart(artnum: integer; numleft: integer;
 var willupdatej: boolean);

var
  rot13ing: boolean;
  showallheaders: boolean;
  artfn: string;
  artf: text;
  nonactedleft: boolean;
  lastlineshown: integer;
  newart: boolean;
  artfrom: string;
  artsubject: string;
  ff: boolean;
  arteof: boolean;
  artopen: boolean;
  artlinebuf: string;
  artwaslongline: boolean;
  numlefts: string[30];
  totlines: integer;
  firstblankline: integer;
  artlineno: integer;
  artuheader: string;
  startofline: boolean;

function isheaderline: boolean;  {valid only once getartl has returned it}

begin
  isheaderline := artlineno<firstblankline;
end;

procedure getartl(var s: string; maxlen: integer; toscreen: boolean);

var
  gotaline: boolean;

begin
  inc(artlineno);
  startofline := false;
  if artlinebuf<>'' then
    begin
      s := copy(artlinebuf,1,maxlen);
      if maxlen=255 then
        artlinebuf := ''
      else
        artlinebuf := copy(artlinebuf,maxlen+1,255);

{ looks redundant with case below just like this, but isn't.  really.}

      if artlinebuf='' then
        arteof := eof(artf);

    end
  else if eof(artf) then
    begin
      arteof := true;
      s := '(internal error)'
    end
  else
    begin
      gotaline := false;
      while not gotaline and not arteof do
        begin

          startofline := not artwaslongline;
          artwaslongline := false;

          read(artf,s);

          if eoln(artf) then
            readln(artf)
          else
            artwaslongline := true;

          if s='' then
            if firstblankline>artlineno then
              firstblankline := artlineno;

          gotaline := true;

{ don't use isheaderline here.  if last header is hidden, first pass }
{ will set firstblankline to a small number, which will then cause }
{ artlineno=firstblankline before the first blank line is actually seen }

          if (artlineno<=firstblankline) then
            if startofline then
              if (s<>'') then
                if (s[1]<>' ') and (s[1]<>^I) then
                  artuheader := upper(getfirstw(s));

          if (artlineno<=firstblankline) and not showallheaders and
           toscreen and (s<>'') then
            if hideheaders<>'' then
              begin
                if pos(':'+artuheader,hideheaders)<>0 then
                  gotaline := false;
              end
            else if showheaders<>'' then
              if pos(':'+artuheader,showheaders)=0 then
                gotaline := false;

{will trim() break _anything_?  like, while reading in headers?  mail? etc.}

{using trim() is _not_ evil on headers - is it ever a problem?  what about}
{expanding tabs?  except for Makefiles and map entries...}

{trim() screws up signatures, which are added after getartl is used}

{trim() screws up old-style uuencoded postings!  taken out!}

{taken out trim() and expand() when not showing on screen (ie saving to disk) }

{}{}{} {unfortunately, this doesn't work when replying to something that}
{}{}{} {begins with a tab - the line overflows in the editor.  needs work}

          if gotaline then
            begin
              if toscreen then
                s := trim(expand(s));

{time-saver, probably, to skip over the copy/copy when possible}
              if length(s)>maxlen then
                begin
                  artlinebuf := copy(s,maxlen+1,255);
                  s := copy(s,1,maxlen);
                end;
            end;

{ in case of malformed articles - prevent infinite loop }

          if artlinebuf='' then
            arteof := eof(artf);

        end;

      if not gotaline then
        s := '(malformed article)';

    end;
end;

procedure artresetattempt;

{ don't bother with filemode here - tpascal doesn't use it on text files }

begin
  {$I-}
  reset(artf);
  {$I+}
  if ioresult=0 then
    begin
      arteof := eof(artf);
      artlinebuf := '';
      artwaslongline := false;
      artlineno := 0;
      artuheader := '';
      artopen := true;
    end;
end;

procedure artreset;

var
  givenup: boolean;
  yn: char;

begin
  givenup := false;
  artopen := false;
  while not artopen and not givenup do
    begin
      artresetattempt;
      if not artopen then
        begin
          yn := onekey('unable to open file.  try again?  y/n ','yn ');
          if yn=' ' then
            yn := 'y';
          if yn='n' then
            givenup := true;
        end;
    end;
  if not artopen then
    begin
      newart := true;
      arteof := true;
    end;
end;

procedure showartl(s: string);

begin
  if isheaderline then
    begin
      if pos(':'+artuheader,highlightheaders)<>0 then
        begin
          if startofline then
            xwritess(chopfirstw(s),' ');
          xhighvideo;
          xwritelns(screenline(s));
          xlowvideo;
        end
      else
        xwritelns(screenline(s));
    end
  else if rot13ing then
    xwritelns(rot13(screenline(s)))
  else
    xwritelns(screenline(s));
end;

procedure newbrowsescreen;

begin
  xclrscr;
end;

procedure morelines(linestoshow: integer);

var
  s: string;
  ff: boolean;
  brandnewlinesshown: integer;

begin
  if arteof then
    newart := true
  else
    begin
      nonactedleft := true;
      ff := false;
      brandnewlinesshown := 0;
      while not arteof and (brandnewlinesshown<linestoshow) and not ff do
        begin
          getartl(s,cols-1,true);
          ff := (pos(^L,s)<>0);
          showartl(s);
          inc(brandnewlinesshown);
          inc(lastlineshown);
        end;
    end;
end;

procedure rewindtopline(newtopline: integer);

var
  s: string;
  skippedlines: integer;
{
  ff: boolean;
  brandnewlinesshown: integer;
}

begin
  newbrowsescreen;
  nonactedleft := true;
  artreset;
  lastlineshown := 0;
  skippedlines := min(0,newtopline);
  while skippedlines<newtopline do
    begin
      getartl(s,cols-1,true);
      inc(skippedlines);
      inc(lastlineshown);
    end;

  morelines(lpp-1);

{
  ff := false;
  brandnewlinesshown := 0;
  while (brandnewlinesshown<lpp) and not arteof and not ff do
    begin
      getartl(s,79,true);
      ff := (pos(^L,s)<>0);
      showartl(s);
      inc(brandnewlinesshown);
      inc(lastlineshown);
    end;
}

end;

procedure refresh;

begin
  rewindtopline(lastlineshown-lpp+1);
end;

procedure showlastline;

var
  wastes: string;

begin
  if totlines<0 then
    begin
      xwrites('searching for bottom line...');
      totlines := 0;
      artreset;
      while not arteof do
        begin
          inc(totlines);
          getartl(wastes,cols-1,true);
        end;
    end;
  rewindtopline(totlines-lpp+1);
end;

procedure browsehelppage;

var
  ch: char;

begin
  xclrscr;
  writexy(1,1,newsreadername+' '+newsreaderversion+
   ' - newsreader-under-development');
  writexy(1,2,'russell@alpha3.ersys.edmonton.ab.ca (930323)');
  writexy(1,4,'space,d,CR - forward 1 page, 1/2 page, 1 line');
  writexy(1,5,'u - back 1 page');
  writexy(1,6,'^ - top line        $ - bottom line');
  writexy(1,7,'n,p - next, previous selected article');
  writexy(1,8,'b,a - back,ahead through (possibly unselected) articles');
  writexy(1,9,'r - reply to author (in mail)');
  writexy(1,10,'f - followup (in netnews) (possibly not yet)');
  writexy(1,11,'k - kill by subject or author (will not display again)');
  writexy(1,12,'K - antikill by subject or author (for auto-selection)');
  writexy(1,13,'^R - reread kill and antikill files from disk');
  if trusted then
    writexy(1,14,'e - edit article on disk');
  writexy(1,15,'D - rot13-decode article       w - write article to disk');
  writexy(1,16,'h - toggle showing all headers   ^L - refresh screen');
  writexy(1,17,'! - shell escape        N - next group (no update)');
  writexy(1,19,'? - help                Q - quit (no update)');
  writexy(1,21,'file:');
  writexy(7,21,artfn);
  writexy(1,23,'press any key to return ');
  ch := xreadkey;
  refresh;
end;

procedure browseback;

begin
  newart := true;
  browsedir := -1;
  browseonlysel := false;
end;

procedure browseahead;

begin
  newart := true;
  browseonlysel := false;
end;

procedure writeart;

var
  outfilen: string;
  outfile: text;
  illegal: boolean;
  doit: boolean;
  appending: boolean;
  s: string;

{for non-trusted users, make sure no : or \ in unslash(filename)}
{and try to make sure it's not a device driver (con, aux, lpt1, etc.)}
{then force it in the user's home directory}

begin
  xclreolxy(1,lpp);
  xwrites('file name (blank to abort): ');
  xreadlns(outfilen,cols-30);

  outfilen := ltrim(trim(outfilen));

  if tildehome then
    if copy(outfilen,1,2)='~/' then
      outfilen := home+copy(outfilen,2,255);

  outfilen := unslash(outfilen);

  illegal := false;
  doit := (outfilen<>'');

  if numoccur(':',outfilen)>1 then
    illegal := true;

  if doit and not trusted then
    begin
      if numoccur(':',outfilen)>0 then
        illegal := true;
      if numoccur('\',outfilen)>0 then
        illegal := true;
      if numoccur('.',outfilen)>1 then
        illegal := true;
      outfilen := upper(outfilen);

{known devices just in case isdev doesn't catch them}

      if (outfilen='CON') or (outfilen='PRN') or
       (outfilen='AUX') or (outfilen='NUL') or
       (outfilen='LPT1') or (outfilen='LPT2') or (outfilen='LPT3') or
       (outfilen='COM1') or (outfilen='COM2') or
       (outfilen='COM3') or (outfilen='COM4') or
       (outfilen='CLOCK$') then
        illegal := true;

{isdev works here, but may not be perfect - don't run it if you don't have to}

      if not illegal then
        if isdev(outfilen) then
          illegal := true;

    end;

  if doit and illegal then
    begin
      warn('unable to use that filename');
    end;

  if doit and not illegal then
    begin
      if not trusted then
        outfilen := home+'\'+outfilen;
      assign(outfile,outfilen);
      {$I-}
      append(outfile);
      {$I-}
      appending := true;
      if ioresult<>0 then
        begin
          {$I-}
          rewrite(outfile);
          {$I+}
          appending := false;
        end;
      if ioresult=0 then
        begin
          xclreolxy(1,lpp);
          if appending then
            xwritesss('appending to ',outfilen,' ...')
          else
            xwritesss('writing to ',outfilen,' ...');
          artreset;
          while not arteof do
            begin
              getartl(s,255,false);
              writeln(outfile,s);
            end;
          close(outfile);
          xclreolxy(1,lpp);
          xwrites('done.');
        end
      else
        begin
          warn('unable to write file!');
        end;
    end;
  refresh;
end;

procedure editart;

var
  doserr: integer;

begin
  if trusted then
    begin
      close(artf);
      execp(editor,editoroptions+' '+artfn);
      doserr := doserror;
      if doserr<>0 then
        warnerr('edit',doserr);
      artreset;
      refresh;
    end;
end;

procedure replytoart;

var
  subject: string;
  messageid: string;
  replyaddr: string;
  artreplyto: string;
  newreplyaddr: string;
  replyname: string;
  defaultreply: boolean;
  author: string;
  ccaddr: string;
  mailfn: string;
  mailf: text;
  maillffn: string;
  maillff: text;
  rereadblankfound: boolean;
  fromfound: boolean;
  sigfn: string;
  sigf: text;
  foundblank: boolean;
  s: string;
  sendeditvspellquit: char;
  seqstr: string;
  outmailfn: string;
  outmailf: text;
  outmailnum: integer;
  gotafile: boolean;
  basesite: string;
  lineno: integer;
  doserr: integer;

begin
  close(artf);
  subject := artsubject;
  if copy(subject,1,4)<>'Re: ' then
    subject := 'Re: '+subject;
  messageid := getheaderline(artfn,'message-id:');

  artreplyto := getheaderline(artfn,'reply-to:');
  
  replyaddr := artreplyto;
  if replyaddr='' then
    replyaddr := artfrom;
  if replyaddr='' then
    replyaddr := mailfrom;

  author := getfromaddr(replyaddr);

{handle case where Reply-To: is same as From:, but without name - keep it}
  if getfromname(replyaddr)='' then
    if author=getfromaddr(artfrom) then
      replyaddr := artfrom;

  xclreolxy(1,lpp);
  xwrites('Reply To: ');
  xreadlns(newreplyaddr,cols-15);
  defaultreply := (newreplyaddr='');
  if defaultreply then
    begin
      replyname := getfromname(replyaddr);
      replyaddr := getfromaddr(replyaddr);
    end
  else
    begin
      replyaddr := newreplyaddr;
      replyname := '';
    end;

{get the address (if possible) from aliases and user/*/forward files}

  replyaddr := expandmail(replyaddr);

  xclreolxy(1,lpp);

{
  xwrites('CC: ');
  xreadlns(ccaddr,cols-10);
  xclreolxy(1,lpp);
}

  mailfn := temporarydir+'\'+userid+'.mai';
  assign(mailf,mailfn);
  rewrite(mailf);
  writeln(mailf,'From ',userid,'  ',copy(cdow,1,3),', ',dayofmonth,' ',
   copy(monthname,1,3),' ',year,' ',time,' ',timezone,' ',
   'remote from ',uucpname);
  writeln(mailf,'Received: by ',node,' ('+newsreadername+')');
  writeln(mailf,'       via UUCP; ',copy(cdow,1,3),', ',dayofmonth,' ',
   copy(monthname,1,3),' ',year,' ',time,' ',timezone);
  writeln(mailf,'       for ',replyaddr);
  write(mailf,'To: ',replyaddr);
  if replyname='' then
    writeln(mailf)
  else
    writeln(mailf,' (',replyname,')');
  if replyaddr<>getfromaddr(artfrom) then
    writeln(mailf,'X-Original-Article-From: ',artfrom);
  writeln(mailf,'Subject: ',subject);
  writeln(mailf,'From: ',mailfrom);
  if replyto<>'' then
    writeln(mailf,'Reply-To: ',replyto);
  writeln(mailf,'Message-ID: ',newmessageid);
  writeln(mailf,'Date: ',copy(cdow,1,3),', ',dayofmonth,' ',
   copy(monthname,1,3),' ',year,' ',time,' ',timezone);
  writeln(mailf,'In-Reply-To: ',messageid);
  writeln(mailf,'Organization: ',organ);
  writeln(mailf,'X-Newsreader: ',newsreadername,' ',newsreaderversion);
  writeln(mailf);
  if defaultreply then
    writeln(mailf,'In ',currgroup,' you write:')
  else
    writeln(mailf,'In ',currgroup,', ',author,' writes:');
  writeln(mailf);
  artreset;
  foundblank := false;
  while not arteof and not foundblank do
    begin
      getartl(s,255,false);
      if s='' then
        foundblank := true;
    end;
  while not arteof do
    begin
      getartl(s,77,false);
      if copy(s,1,1)='>' then
        writeln(mailf,'>',expand(s))
      else
        writeln(mailf,'> ',expand(s))
    end;
  close(artf);
  sigfn := home+'\mailsig';
  assign(sigf,sigfn);
  {$I-}
  reset(sigf);
  {$I+}
  if ioresult=0 then
    begin
      readln(sigf,s);
      if s<>'-- ' then
        writeln(mailf,'-- ');
      reset(sigf);
      while not eof(sigf) do
        begin
          readln(sigf,s);
          writeln(mailf,expand(s));
        end;
      close(sigf);
    end;
  close(mailf);

  sendeditvspellquit := 'e';
  while (sendeditvspellquit<>'s') and (sendeditvspellquit<>'q') do
    begin
      if sendeditvspellquit='v' then
        begin
          execp(vspeller,vspelleroptions+' '+mailfn);
          doserr := doserror;
          if doserr<>0 then
            warnerr('vspell',doserr);
          if editaftervspell then
            sendeditvspellquit := 'e';
        end;
      if sendeditvspellquit='e' then
        begin
          execp(editor,editoroptions+' '+mailfn);
          doserr := doserror;
          if doserr<>0 then
            warnerr('edit',doserr);
        end;

      xclreolxy(1,lpp-1);
      sendeditvspellquit :=
       onekey('Reply: <s>end <e>dit <v>spell <q>uit','sevq');

      if sendeditvspellquit='s' then
        xwrites('send')
      else if sendeditvspellquit='e' then
        xwrites('edit')
      else if sendeditvspellquit='v' then
        xwrites('vspell')
      else if sendeditvspellquit='q' then
        xwrites('quit');

    end;

  if sendeditvspellquit='s' then
    begin

{$ifdef oldmaildelivery}

      seqstr := integertozstring(newseqnumber,4);

      { here copy mailf to maillff - strip carriage returns }

      maillffn := spooldir+'\'+smarthost+'\'+seqstr+'.dat';
      assign(maillff,maillffn);
      rewrite(maillff);

      assign(mailf,mailfn);
      reset(mailf);

{check for changed From: lines on non-trusted users and replace}

{must make sure a From: line is actually found!}

      rereadblankfound := false;
      fromfound := false;
      while not eof(mailf) do
        begin
          readln(mailf,s);
          if not trusted then
            begin
              if s='' then
                begin
                  rereadblankfound := true;
                  if not fromfound then
                    begin
                      fromfound := true;
                      write(maillff,'From: ',mailfrom,#10);
                    end;
                end
              else if not rereadblankfound then
                begin
                  if getfirstw(s)='From:' then
                    fromfound := true;
                  if makesame(s,'From: ',mailfrom) then
                    begin
                      xclreolxy(1,1);
                      xclreolxy(1,2);
                      xclreolxy(1,3);
                      xclreolxy(1,4);
                      xclreolxy(1,5);
                      xclreolxy(1,6);
                      xclreolxy(1,7);
                      writexy(1,1,'From: line was changed from');
                      writexy(1,2,s+' to');
                      writexy(1,3,mailfrom);
                      writexy(1,4,'and has been changed back.  if you need');
                      writexy(1,5,'to change From:, run as a trusted user.');
                      writexy(1,6,'adding a Reply-To: is probably better');
                    end;
                end;
            end;
          write(maillff,s,#10);
        end;
      close(mailf);
      close(maillff);

      maillffn := spooldir+'\'+smarthost+'\'+seqstr+'.xqt';
      assign(maillff,maillffn);
      rewrite(maillff);
      write(maillff,'U ',userid,' ',uucpname,#10);
      write(maillff,'Z',#10);
      write(maillff,'F D.',uucpname,seqstr,#10);
      write(maillff,'I D.',uucpname,seqstr,#10);
      write(maillff,'C rmail ',replyaddr,#10);
      close(maillff);

      mailfn := spooldir+'\'+smarthost+'\'+seqstr+'.cmd';
      assign(mailf,mailfn);
      rewrite(mailf);
      writeln(mailf,'S ',seqstr,'.DAT D.',uucpname,seqstr,' ',
       userid,' - ',seqstr,'.DAT 0666');
      writeln(mailf,'S ',seqstr,'.XQT X.',uucpname,seqstr,' ',
       userid,' - ',seqstr,'.XQT 0666');
      close(mailf);

      basesite := copy(basesitename(replyaddr),1,8);
      outmailfn := outboxdir+'\'+basesite;

{$ifdef oldandsillymethod}
      gotafile := false;
      outmailnum := 1;
      while not gotafile do
        begin
          assign(outmailf,outmailfn+'.'+itoa(outmailnum));
          {$I-}
          reset(outmailf);
          {$I+}
          if ioresult<>0 then
            gotafile := true
          else
            begin
              inc(outmailnum);
              close(outmailf);
            end;
        end;
      outmailfn := outmailfn+'.'+itoa(outmailnum);
{$endif}

      outmailfn := getuniqfext(outboxdir+'\'+basesite);

      assign(outmailf,outmailfn);
      rewrite(outmailf);

      mailfn := temporarydir+'\'+userid+'.mai';
      assign(mailf,mailfn);
      reset(mailf);

      rereadblankfound := false;
      lineno := 1;
      while not eof(mailf) do
        begin
          readln(mailf,s);
          if lineno=1 then
            writeln(outmailf,
             copy(s,1,length(s)-length(' remote from '+uucpname)))
          else if lineno>4 then
            begin
              if not trusted then
                begin
                  if s='' then
                    rereadblankfound := true
                  else if not rereadblankfound then
                    if makesame(s,'From: ',mailfrom) then
                      ;
                end;
              writeln(outmailf,s);
            end;
          inc(lineno);
        end;
      close(mailf);
      close(outmailf);

{$else} {not oldmaildelivery}

{$endif}

    end;

  artreset;

{leave refresh to caller}

end;

procedure mailart;

begin
  warn('using `r''eply instead');
  replytoart;
  refresh;
end;

procedure followtoart;

var
  followupto: string;
  newsgroups: string;
  originalnewsgroups: string;
  shouldmail: boolean;
  shouldfollow: boolean;
  replyfollow: char;
  subject: string;
  messageid: string;
  references: string;
  author: string;
  newartfn: string;
  newartf: text;
  refline: string;
  wref: string;
  nextref: string;
  ref1,ref2: string;
  newartlffn: string;
  newartlff: text;
  sigfn: string;
  sigf: text;
  foundblank: boolean;
  s: string;
  sendeditvspellquit: char;
  monitor: string;
  monitordir: string;
  monitorfn: string;
  monitorf: text;
  fromfound: boolean;
  doserr: integer;

begin
  xclreolxy(1,lpp);
  xwrites('Follow...');

  close(artf);
  followupto := getheaderline(artfn,'followup-to:');
  newsgroups := getheaderline(artfn,'newsgroups:');
  originalnewsgroups := newsgroups;

  shouldfollow := true;
  shouldmail := (followupto='poster') or (followupto='sender') or 
   (pos('@',followupto)<>0) or (pos('!',followupto)<>0) or
   (pos('%',followupto)<>0);

{followups redirected to /dev/null - but there are local groups with no .}

  if pos('.',followupto)=0 then
    begin
      ;
    end;

  if shouldmail then
    begin
      followupto := newsgroups;
      xclreolxy(1,lpp-2);
      xclreolxy(1,lpp-1);
      xwritelns('author seemed to want replies by mail only.');
      replyfollow := 
       onekey('<r>eply by mail, <f>ollowup anyway, <q>uit ','rfq');
      shouldmail := (replyfollow='r');
      shouldfollow := (replyfollow='f');
    end;

{}{} {don't let untrusted users post yet}
  if not trusted then
    shouldmail := true;

  if shouldmail then
    begin
      artreset; {replytoart closes it immediately}
      replytoart;
    end
  else if shouldfollow then
    begin

{ don't propogate errors in the Newsgroups: line if you can help it }

      newsgroups := unspace(newsgroups);
      followupto := unspace(followupto);

      if followupto='' then
        followupto := newsgroups;

{currgroup isn't necessarily even in the followupto list, so don't warn}
{about moderation when people post followups to, say,}
{news.announce.newgroups where followups are always redirected to news.groups}

{}{} {should check if _any_ group in the list is moderated, and give warning}
      if pos(','+currgroup+',',','+followupto+',')<>0 then
        if groupbattr(currgroup,'/mod') then
          warn('this group is moderated');

{ give the user a warning, to prevent Followup-To: misc.test,talk.bizarre }
      if followupto<>newsgroups then
        warn('followups have been changed');

{}{} {should check if _any_ of the groups is marked as /solo => strip it out}
      if groupbattr(currgroup,'/solo') and (pos(',',newsgroups)<>0) then
        begin
          warn('warning: /solo group - crosspost removed');
          followupto := currgroup;
        end;

{ warn on 4 or more groups }
      if numoccur(',',followupto)>3 then
        warn('this is a massive crossposting.  consider using Followup-To:');

      subject := artsubject;
      if copy(subject,1,4)<>'Re: ' then
        subject := 'Re: '+subject;
      messageid := getheaderline(artfn,'message-id:');
      references := getheaderline(artfn,'references:');

{Andrew system non-compliance, looks like}
      if references='' then
        references := getheaderline(artfn,'in-reply-to:');

      author := getheaderline(artfn,'reply-to:');
      if author='' then
        author := getheaderline(artfn,'from:');

{handle case where Reply-To: is same as From:, but without name - keep the}
{name if you can}

      if getfromname(author)='' then
        if getfromaddr(author)=getfromaddr(artfrom) then
          if getfromname(artfrom)<>'' then
            author := getfromaddr(author)+' ('+getfromname(artfrom)+')';

      newartfn := temporarydir+'\'+userid+'.fol';
      assign(newartf,newartfn);
      rewrite(newartf);

{}{} {put a Path: entry here that ends in user id?  rnews.exe ends in !news}

      writeln(newartf,'Newsgroups: ',followupto);
      if followupto<>originalnewsgroups then
        writeln(newartf,'X-Original-Newsgroups: ',originalnewsgroups);
      writeln(newartf,'From: ',newsfrom);
      if replyto<>'' then
        writeln(newartf,'Reply-To: ',replyto);
      writeln(newartf,'Subject: ',subject);
      writeln(newartf,'Message-ID: ',newmessageid);
      writeln(newartf,'Date: ',copy(cdow,1,3),', ',dayofmonth,' ',
       copy(monthname,1,3),' ',year,' ',time,' ',timezone);

{ special-casing in getheaderline() makes sure we get the last few }
{ references always.  well, except on >255 char References: lines }

{ wref is the space-terminated string of references that are yet to be }
{ written out - it starts with two spaces if need be (other than line one) }

      ref1 := '';
      ref2 := '';

      refline := references;
      ref1 := chopfirstw(refline);
      if refline<>'' then
        begin
          ref2 := chopfirstw(refline);
        end;
      while numoccur('>',refline)>0 do
        begin
          ref1 := ref2;
          ref2 := chopfirstw(refline);
        end;

      refline := '';
      if ref1<>'' then
        refline := refline+ref1+' ';
      if ref2<>'' then
        refline := refline+ref2+' ';

      refline := refline+messageid;

{$ifdef rnewscontbroken}
      writeln(newartf,'References: ',refline);
{$else}
      wref := 'References: ';
      while refline<>'' do
        begin
          refline := ltrim(refline);
          nextref := chopfirstw(refline);
          if length(wref+nextref)>70 then
            begin
              writeln(newartf,wref);
              wref := '  '+nextref+' ';
            end
          else
            wref := wref+nextref+' ';
        end;
      if wref<>'' then
        writeln(newartf,trim(wref));
{$endif}

      writeln(newartf,'Organization: ',organ);
      writeln(newartf,'X-Newsreader: ',newsreadername,' ',newsreaderversion);
      writeln(newartf);
      writeln(newartf,author,' writes:');
      writeln(newartf);
      artreset;
      foundblank := false;
      while not arteof and not foundblank do
        begin
          getartl(s,255,false);
          if s='' then
            foundblank := true;
        end;
      while not arteof do
        begin
          getartl(s,77,false);
          if copy(s,1,1)='>' then
            writeln(newartf,'>',expand(s))
          else
            writeln(newartf,'> ',expand(s))
        end;
      close(artf);
      sigfn := home+'\sig';
      assign(sigf,sigfn);
      {$I-}
      reset(sigf);
      {$I+}
      if ioresult=0 then
        begin
          readln(sigf,s);
          if s<>'-- ' then
            writeln(newartf,'-- ');
          reset(sigf);
          while not eof(sigf) do
            begin
              readln(sigf,s);
              writeln(newartf,s);
            end;
          close(sigf);
        end;
      close(newartf);

      sendeditvspellquit := 'e';
      while (sendeditvspellquit<>'s') and (sendeditvspellquit<>'q') do
        begin
          if sendeditvspellquit='v' then
            begin
              execp(vspeller,vspelleroptions+' '+newartfn);
              doserr := doserror;
              if doserr<>0 then
                warnerr('vspell',doserr);
              if editaftervspell then
                sendeditvspellquit := 'e';
            end;
          if sendeditvspellquit='e' then
            begin
              execp(editor,editoroptions+' '+newartfn);
              doserr := doserror;
              if doserr<>0 then
                warnerr('edit',doserr);
            end;

          xclreolxy(1,lpp-1);
          sendeditvspellquit :=
           onekey('Follow: <s>end <e>dit <v>spell <q>uit','sevq');

          if sendeditvspellquit='s' then
            xwrites('send')
          else if sendeditvspellquit='e' then
            xwrites('edit')
          else if sendeditvspellquit='v' then
            xwrites('vspell')
          else if sendeditvspellquit='q' then
            xwrites('quit');

        end;

      if sendeditvspellquit='s' then
        begin

{}{} {check headers}
     {invalid format of Newsgroups: line (spaces, etc.)}
     {warn if any groups in Newsgroups: not in forum set}
     {delete any duplicates from Newsgroups: line}
     {check From:}
     {a Lines: header might be polite.  maybe not}

{copy to monitor directory if asked}
     
          monitorfn := '';
          monitor := groupsattr(currgroup,'/spy=');

          if monitor='' then
            begin
              if not quiet then
                warn('there is no monitor for this group');
            end
          else
            begin
              monitordir := getbasedir(monitor);
              if monitordir='' then
                begin
                  warn('no dir found for monitor group '+monitor+' !');
                end
              else
                begin
                  monitorfn := getuniqfile(monitordir);
                end;
            end;

{}{} {would be nice to check for content-free messages sent by mistake}

          newartlffn := temporarydir+'\'+userid+'.nl';
          assign(newartlff,newartlffn);
          rewrite(newartlff);
          if monitorfn<>'' then
            begin
              assign(monitorf,monitorfn);
              rewrite(monitorf);
            end;

          foundblank := false;
          reset(newartf);
          while not eof(newartf) do
            begin
              readln(newartf,s);

              if not foundblank then
                if copy(s,1,6)='From: ' then
                  fromfound := true;

              if s='' then
                begin
                  if not foundblank then
                    begin
                      if not fromfound then
                        begin
                          write(newartlff,'From: ',newsfrom,#10);
                          if monitorfn<>'' then
                            writeln(monitorf,'From: ',newsfrom);
                          fromfound := true;
                        end;
                    end;
                  foundblank := true;
                end;

              write(newartlff,s,#10);
              if monitorfn<>'' then
                writeln(monitorf,s);
            end;
          close(newartf);
          close(newartlff);
          if monitorfn<>'' then
            close(monitorf);

{}{} {should use rnews in bin directory only?}

          execp('rnews.exe',newartlffn);

{}{} {rnews sometimes displays random error message on low memory}
          delay(1000);

          doserr := doserror;
          if doserr<>0 then
            warnerr('rnews',doserr);
        end;
    end;
  artreset;
  refresh;
end;

procedure killart;

var
  subjectfromoops: char;
  i: integer;

begin
  subjectfromoops := onekey(
   'kill: this group: <s>ubject <f>rom; always <S>ubject <F>rom; <o>ops',
   'sfSFo');

  if subjectfromoops<>'o' then
    begin
      if (subjectfromoops='s') or (subjectfromoops='S') then
        begin
          xwrites(#13);
          xclreol;
          addtokill('Subject',basesubjs[artnum],(subjectfromoops='S'));

{too much checking here - won't hurt anything but the clock}
          for i := 1 to numarts do
            if subjkilled(basesubjs[i]) then
              selected[i] := false;
        end
      else
        begin
          xwrites(#13);
          xclreol;
          addtokill('From',getfromaddr(artfrom),(subjectfromoops='F'));

{too much checking here - won't hurt anything but the clock}
          for i := 1 to numarts do
            if fromkilled(fromsp^[i]) then
              selected[i] := false;
        end;
      newart := true;
    end;
end;

procedure antikillart;

var
  subjectfromoops: char;
  i: integer;

begin
  subjectfromoops := onekey(
   'antikill: this group: <s>ubject <f>rom; always <S>ubject <F>rom; <o>ops',
   'sfSFo');

  if subjectfromoops<>'o' then
    begin
      if (subjectfromoops='s') or (subjectfromoops='S') then
        begin
          xwrites(#13);
          xclreol;
          addtoantikill('Subject',basesubjs[artnum],(subjectfromoops='S'));

{too much checking here - won't hurt anything but the clock}

          for i := 1 to numarts do
            if subjantikilled(basesubjs[i]) then
              begin
                selected[i] := true;
                indents[i] := indents[i] or 128;
              end;
        end
      else
        begin
          xwrites(#13);
          xclreol;
          addtoantikill('From',getfromaddr(artfrom),(subjectfromoops='F'));

{too much checking here - won't hurt anything but the clock}

          for i := 1 to numarts do
            if fromantikilled(fromsp^[i]) then
              begin
                selected[i] := true;
                indents[i] := indents[i] or 128;
              end;
        end;
    end;
end;

procedure toggleheaders;

begin
  showallheaders := not showallheaders;
  firstblankline := maxint;
  rewindtopline(0);
end;

procedure rereadkillfiles;

begin
  readinkill(false);
  readinantikill(false);
  refresh;
end;

procedure quitbrowsenoupdate;

var
  doit: boolean;

begin
  doit := true;
  if confirmquit then
    doit := (onekey('are you SURE you want to quit?  y/n ','yn')='y');
  if doit then
    begin
      xwriteln;
      if willupdatej then
        xwritelnss('quitting without updating join file for ',currgroup);
      xwriteln;
      newart := true;
      donegroup := true;
      if willupdatej then
        begin
          currgroup := '';
          alreadyingroup := true;
          willupdatej := false;
        end;
    end
  else
    refresh;
end;

procedure nextgroupnoupdate;

var
  doit: boolean;

begin
  doit := true;
  if confirmnext then
    doit := (onekey(
     'are you SURE you want to jump directly to the next group?  y/n ',
     'yn')='y');
  if doit then
    begin
      if willupdatej then
        begin
          xwriteln;
          xwritelns('join file not updated');
          xwriteln;
          willupdatej := false;
        end;
      newart := true;
      donegroup := true;
    end
  else
    refresh;
end;

procedure geteopkey;

var
  ch: char;
  needakey: boolean;
  dataline: string[80];

begin
  repeat
    needakey := false;
    dataline := '--'+time+'--?=help--'+numlefts+'--';
    if arteof then
      dataline := dataline+'(Bottom)--';
    if length(dataline)+length(currgroup)>74 then
      dataline := '--'+
       copy(currgroup,length(currgroup)-(74-length(dataline)),255)+
       dataline
    else
      dataline := '--'+currgroup+dataline;
    xwritess(dataline,' ');
    ch := xreadkey;
    xwrites(^M);
    xclreol;
    if ch='?' then browsehelppage
    else if ch='n' then newart := true
    else if ch='p' then begin newart := true; browsedir := -1; end
    else if ch='b' then browseback
    else if ch='a' then browseahead
    else if ch='u' then rewindtopline(lastlineshown-lpp-(lpp div 2))
    else if ch='<' then rewindtopline(lastlineshown-lpp-(lpp div 2))
    else if ch='^' then rewindtopline(0)
    else if ch='$' then showlastline
    else if ch=#13 then morelines(1)
    else if ch=' ' then morelines(lpp-3)
    else if ch='>' then morelines(lpp-3)
    else if ch='d' then morelines(lpp div 2)
    else if ch='w' then begin writeart; needakey := true; end
    else if ch='r' then begin replytoart; needakey := true; refresh; end
    else if ch='m' then begin mailart; needakey := true; end
    else if ch='f' then begin followtoart; needakey := true; end
    else if ch='k' then begin killart; needakey := true; refresh; end
    else if ch='K' then begin antikillart; needakey := true; refresh; end
    else if ch='e' then begin editart; needakey := true; end
    else if ch='D' then begin rot13ing := not rot13ing; refresh; end
    else if ch='h' then toggleheaders
    else if ch=^L  then refresh
    else if ch=^R  then begin rereadkillfiles; needakey := true; end
    else if ch='Q' then quitbrowsenoupdate
    else if ch='N' then nextgroupnoupdate
    else if ch='!' then begin shellout; refresh; end
    else needakey := true;
  until not needakey;
end;

begin

  rot13ing := false;
  showallheaders := false;

  numlefts := itoa(numleft)+' more';
  if numleft=0 then
    numlefts := 'LAST';

  if not willupdatej then
    numlefts := numlefts+' (no update)';

  newbrowsescreen;
  nonactedleft := false;
  lastlineshown := 0;

  totlines := -1;
  firstblankline := maxint;

  artfn := basedir+filenamesp^[artnum];

{don't get from fromsp^[] - need full name _and_ address for kill file}
  artfrom := getheaderline(artfn,'from:');

  artsubject := getheaderline(artfn,'subject:');

  newart := false;  {artreset could change this}

  assign(artf,artfn);

  refresh;  {does an artreset itself}

  while not newart do
    begin

{if we've already read off the end of the article, it's time for a new one}
      if arteof and not nonactedleft then
        newart := true
      else
        begin

{otherwise indicate all has been seen and get a key}

          nonactedleft := false;
          geteopkey;
        end;
    end;
  if artopen then
    close(artf);
end;
