/*
**	Routines to parse /waffle/system/dirs type files
**
**	Otto Makela, Jyvaskyla, Finland, 1992
**	Distributed under the GNU General Public Licence:
**	see file COPYING for details
*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	"dirs.h"

	/* Collection arrays for dirs file tokens and @files filenames */
int dirs_tokens=0;
char *dirs_token[MAXTOKENS],*dirs_value[MAXTOKENS];

/*
**	Parse one line from dirs file into separate tokens and their values
*/
int parse_line(char *line)	{
	char c;
	int quoted=0;

	for(dirs_tokens=0; c=*line; line++)
		if(quoted)	{
			if(c==quoted)	{
				*line='\0';
				quoted=0;
			}
		} else if(c=='/')	{
			dirs_value[dirs_tokens]=NULL;
			dirs_token[dirs_tokens++]=line+1;
		} else if((c=='=' || c==':') && dirs_tokens)	{
			*line='\0';
			dirs_value[dirs_tokens-1]=line+1;
		} else if(c=='"' || c=='\'')	{
			quoted=c;
			if(dirs_value[dirs_tokens-1]==line)
				dirs_value[dirs_tokens-1]++;
		} else if(c==';' || c=='#')	{
			*line='\0';
			break;
		} else if(isupper(c))
			*line=tolower(c);
		else if(isspace(c))
			*line='\0';
	return dirs_tokens;
}


/*
**	Return position of requested token in the dirs_token[] array,
**	or -1 if none
*/
int token_set(char *searched)	{
	register int i;

	for(i=0; i<dirs_tokens; i++)
		if(!strcmp(searched,dirs_token[i]))
			return i;
	return -1;
}


/*
**	Return value of requested token, or defvalue if it has no value
*/
char *token_value(char *searched,char *defvalue)	{
	register int i;

	if((i=token_set(searched))!=-1 && dirs_value[i])
		return dirs_value[i];
	return defvalue;
}


#ifdef	MAIN

/*
**	A test main program
*/

main(int argc,char *argv[])	{
	int line=0,loop;
	char buffer[BUFSIZ];
	FILE *f;

	if(argc<2) argv[1]="/waffle/system/dirs";

	if(!(f=fopen(argv[1],"r")))	{
		perror(argv[1]);
		exit(1);
	}

	while(fgets(buffer,sizeof(buffer),f))	{
		printf("%u: %s",++line,buffer);
		if(!parse_line(buffer)) continue;
		printf("(%u)",dirs_tokens);
		for(loop=0; loop<dirs_tokens; loop++)
			printf(dirs_value[loop]?"\t%s=\"%s\"\n":"\t%s\n",
				dirs_token[loop],dirs_value[loop]);
	}

	printf("%s: %u lines\n",argv[1],line);
	fclose(f);
	exit(0);
}
#endif
