/*
dosmcb.c
Stealth Bomber Version 2.2

Kevin Dean
Fairview Mall P.O. Box 55074
1800 Sheppard Avenue East
Willowdale, Ontario
CANADA    M2J 5B9
CompuServe ID: 76336,3114

February 10, 1992

	This module handles the DOS memory control block interface.

	This code is public domain.
*/


#if (defined(M_I86SM) || defined(M_I86MM) || defined(M_I86CM) || defined(M_I86LM) || defined(M_I86HM)) && !defined(_MSC_VER) && !defined(_QC)
#define _MSC_VER
#endif

#if !defined(__BORLANDC__) && !defined(__TURBOC__) && !defined(_MSC_VER) && !defined(_QC)
#error Unknown compiler.
#endif


#include <dos.h>
#include <stddef.h>

#include "dosmcb.h"


#if defined(_MSC_VER) || defined(_QC)

#if !defined(MK_FP)
#define MK_FP(seg, off)  ((void far *)(((unsigned long)(seg) << 16) | (off)))
#endif

#if !defined(peek)
#define peek(seg, off)  (*(int far *)MK_FP(seg, off))
#endif

#endif


/***/
/* Get the first DOS memory control block. */
MCB far *getmcb(void)
{
union REGS regs;
struct SREGS sregs;

/* DOS function 0x52 gets the DOS list of lists. */
regs.h.ah = 0x52;
segread(&sregs);
intdosx(&regs, &regs, &sregs);

/* The first MCB segment pointer is two bytes behind the list of lists. */
return (MK_FP(peek(sregs.es, regs.x.bx - 2), 0));
}


/***/
/* Get the next DOS memory control block. */
MCB far *nextmcb(MCB far *thismcb)
{
/* Next MCB is size + 1 paragraphs away. */
return (thismcb->id == 0x5A ? NULL : MK_FP(FP_SEG(thismcb) + thismcb->size + 1, 0));
}


/***/
/* Determine the owner of a particular pointer. */
MCB far *mcb_owner(const void far *ptr)
{
/* Determine true segment. */
unsigned pseg = FP_SEG(ptr) + (FP_OFF(ptr) >> 4);

MCB far *mcb = getmcb();

/* Pointer is invalid if below DOS memory or has wrapped around high memory. */
if (pseg < FP_SEG(mcb) || pseg < FP_SEG(ptr))
  mcb = NULL;

/* Find pointer's MCB if it exists. */
while (mcb && pseg > FP_SEG(mcb) + mcb->size)
  mcb = nextmcb(mcb);

/* Pointer cannot point within MCB itself. */
if (pseg == FP_SEG(mcb))
  mcb = NULL;

return (mcb);
}
