/*
 * This routine implements postnews, the rn function that actually posts an
 * article.  It is called by Pnews.
 *
 * We expect a command like like:
 *
 * postnews art_file
 *
 *
 *  art_file       is the name of the file which contains the article
 *
 */

#include <stdio.h>
#include <io.h>
#include <conio.h>
#include <stdlib.h>
#include <process.h>
#include <string.h>

#ifdef __TURBOC__
#include <dir.h>
#else
#define MAXDIR FILENAME_MAX
#endif

#include <time.h>

/*
 *  The article in art_file is ready to go except for some "minor"
 *  additions.
 *
 */


#define FALSE 0
#define TRUE 1

#define SFILENAME "seqf"

#define FROMLINE   "From: "
#define DATELINE   "Date: "
#define PATHLINE   "Path: "
#define MESSAGEID  "Message-ID: "
#define REPLYTO    "Reply-To: "

#define NEWSGROUPS "Newsgroups: "
#define SUBJECT    "Subject: "

#define MAIL_IDENT "\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01\01"

extern char *tempdir;
extern char *domain;
extern char *mailbox;
extern char *E_signature;
extern char *E_homedir;
extern char *nodename;
extern char *confdir;
extern char *replyto;
extern char *newserver;
extern char *mailserv;
extern char *name;


int DeliverNews(char *input, char *path);


int
  main(argc, argv)
   int argc;
   char **argv;
{

   char temp_file[MAXDIR];   /* File name of temp
                              * file to send  */
   char author_copy[MAXDIR];

   char *ac_env;

   int i;
   int j;

   int saw_subject;
   int saw_newsgroups;
   int abandon_ship;
   int full_line;

   char t;
   char *s;

   FILE *seqfile_fp;
   long seq;

   FILE *f_edit;
   FILE *f_reply;
   char buff[BUFSIZ];

   struct tm *now;
   long tnow;
   char *months[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};


   hostinit(FALSE);

/* Get the next sequence number for use in the Messge-ID: */

   strcpy(temp_file, confdir);
   strcat(temp_file, "/");
   strcat(temp_file, SFILENAME);

   if ((seqfile_fp = fopen(temp_file, "rt")) != NULL)
   {
      fscanf(seqfile_fp, "%ld", &seq);
      fclose(seqfile_fp);
   }
   else
   {
      printf("getseq: can't find %s, faking it (with 1)\n", temp_file);
      seq = 1;
   };


   strcpy(temp_file, tempdir);
   strcat(temp_file, "/postnews.tmp");
   unlink(temp_file);        /* Might as well get rid
                              * of one (if it exists) */


/* OK.  Time to ship it.  Massage the headers.
   First, emit the ones we must add.
*/


   f_reply = fopen(temp_file, "wb");

   strcpy(buff, PATHLINE);
   strcat(buff, nodename);
   strcat(buff, "!");
   strcat(buff, mailbox);
   fprintf(f_reply, "%s\n", buff);

   strcpy(buff, FROMLINE);
   strcat(buff, mailbox);
   strcat(buff, "@");
   strcat(buff, domain);
   strcat(buff, " (");
   strcat(buff, name);
   strcat(buff, ")");
   fprintf(f_reply, "%s\n", buff);

   tnow = time(NULL);
   now = gmtime(&tnow);
   fprintf(f_reply, "%s%d %s %d %2.2d:%2.2d:%2.2d GMT\n", DATELINE, now->tm_mday,
           months[now->tm_mon], now->tm_year,
           now->tm_hour, now->tm_min,
           now->tm_sec);



   strcpy(buff, MESSAGEID);
   sprintf(&(buff[strlen(buff)]), "<%ld@%s>", seq, nodename);
   fprintf(f_reply, "%s\n", buff);

   if (replyto != NULL)
   {
      strcpy(buff, REPLYTO);
      strcat(buff, replyto);
      fprintf(f_reply, "%s\n", buff);
   }

/* Now open the file the user edited and copy the headers (except
   for the empty ones.  Also, insure that there is a subject and that
   the Newsgroups: header is there.  I should also check that the
   Newsgroups are valid but ...
*/

   f_edit = fopen(argv[1], "rb");

   saw_subject = FALSE;
   saw_newsgroups = FALSE;
   abandon_ship = FALSE;

   while (fgets(buff, sizeof (buff), f_edit))
   {
      i = strlen(buff);
      if (((i == 2) && (buff[0] == '\r') && (buff[1] == '\n')) ||
            ((i == 1) && (buff[0] == '\n')) ||
            (i == 0))
      {
         /* Finished with the headers */
         break;
      }
      full_line = FALSE;
      if ((buff[i - 2] == '\r') && (buff[i - 1] == '\n'))
      {
         /* Repair line if it uses DOS rules */
         buff[i - 2] = '\n';
         buff[i - 1] = '\0';
         i--;
      }

      if (buff[i - 1] == '\n')
      {
         full_line = TRUE;
         buff[--i] = '\0';
      }
      else
      {
         printf("Encountered a header line longer than %d characters\n", BUFSIZ);
         printf("That capability is not implemented\n");
         printf("Things are going to break real soon now\n");
      }

      if (strnicmp(buff, SUBJECT, strlen(SUBJECT)) == 0)
      {
         saw_subject = TRUE;
      }
      else if (strnicmp(buff, NEWSGROUPS, strlen(NEWSGROUPS)) == 0)
      {
         saw_newsgroups = TRUE;
      }
      else
      {
         /* It's a header that we don't care about the format. Just make sure
          * that it is not empty */
         s = strchr(buff, ':');
         if (s == NULL)
         {
            printf("Badly formed header - %.40s%s\n", buff, (strlen(buff) > 40) ? "..." : " ");
            abandon_ship = TRUE;
            break;
         }
         s++;                /* Skip the colon */
         while (*s != '\0')
         {
            if (*s == ' ')
               s++;
            else
               break;
         }
         if (*s == '\0')
         {
            /* Empty header, throw it away */
            continue;
         }
      }

      fprintf(f_reply, "%s\n", buff);
   }

/* Finished with the headers.  Just copy the rest of the beast */

   if (abandon_ship)
   {
      printf("Posting abandoned.  Press any key to continue.");
      getch();
      return 1;
   }

   if (!saw_subject || !saw_newsgroups)
   {
      printf("Ill formed article.  You must have a Subject: and a Newsgroups: line.\n");
      printf("Posting abandoned.  Press any key to continue.");
      getch();
      return 1;
   }

   fprintf(f_reply, "\n");

   while (fgets(buff, sizeof (buff), f_edit))
   {
      i = strlen(buff);
      if ((buff[i - 2] == '\r') && (buff[i - 1] == '\n'))
      {
         /* Repair line if it uses DOS rules */
         buff[i - 2] = '\n';
         buff[i - 1] = '\0';
         i--;
      }

      if (buff[i - 1] == '\n')
      {
         full_line = TRUE;
         buff[--i] = '\0';
      }
      fprintf(f_reply, "%s\n", buff);
   }



   fclose(f_edit);

/* And finally, worry about the .signature file */
   if (E_signature != NULL)
   {
      f_edit = fopen(E_signature, "rt");
      if (f_edit != NULL)
      {
         fprintf(f_reply, "--\n");
         while ((i = fread(buff, sizeof (char), sizeof (buff), f_edit)) != 0)
         {
            j = fwrite(buff, sizeof (char), i, f_reply);
            if (i != j)
            {
               printf("Postnews:  Error copying %s\n", E_signature);
            }
         }
      }
   }
   fclose(f_edit);
   fclose(f_reply);


/* OK.  Let's ship it.
 *
 */

   DeliverNews(temp_file, (newserver ? newserver : mailserv));

/*
 *  OK.  Save a copy if the author so wishes.
 *
 */
   ac_env = getenv("AUTHORCOPY");
   if (ac_env != NULL)
   {
      /* build the file name (in author_copy) */
      author_copy[0] = '\0';
      if ((strlen(ac_env) > 2) && (ac_env[1] == ':'))
      {
         strncpy(author_copy, ac_env, 2);
         author_copy[2] = '\0';
         ac_env += 2;
      }
      if (ac_env[0] == '~')
      {
         ac_env += 1;
         if ((strlen(author_copy) != 0) && (E_homedir[1] == ':'))
         {
            printf("Pnews: Error in AUTHORCOPY -- two directories\n");
            author_copy[0] = '\0';
         }
         strcat(author_copy, E_homedir);
      }
      strcat(author_copy, ac_env);
      f_reply = fopen(author_copy, "at");
      if (f_reply == NULL)
      {
         printf("Unable to open %s\n", author_copy);
      }
      else
      {
         f_edit = fopen(temp_file, "rt");
         if (f_edit == NULL)
         {
            printf("Unable to open %s", temp_file);
         }
         else
         {
            fprintf(f_reply, "%s\n", MAIL_IDENT);
            while ((i = fread(buff, sizeof (char), sizeof (buff), f_edit)) != 0)
            {
               j = fwrite(buff, sizeof (char), i, f_reply);
               if (i != j)
               {
                  printf("Postnews:  Error copying %s\n", temp_file);
               }
            }

         }
      }
      fclose(f_edit);
      fclose(f_reply);
   }



   unlink(temp_file);

   return 0;
}
