/*
 * This routine implements Pnews, the rn function that posts an article
 * or a followup to an article.
 *
 * We expect a command like like:
 *
 * Pnews -h %h
 *
 *
 *  %h      is the name of the header file (which might contain the article)
 *
 *
 * CAVEAT:  This program has the same name as the "real" Pnews.  The
 *                      expected argument list is [almost] the same as one of the
 *                      possible lists for the "real" Pnews.  It attempts to honor
 *                      the same enviroment variables as the "real" Pnews.
 *
 *                      IT IS NOT THE REAL PNEWS.
 */

#include <stdio.h>
#include <io.h>
#include <conio.h>
#include <stdlib.h>
#include <process.h>
#include <errno.h>
#include <string.h>

#ifdef __TURBOC__
#include <dir.h>
#else
#define MAXDIR FILENAME_MAX
#endif

#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "config.h"
#include "timestmp.h"
/*
 *
 *  The basic logic is:
 *
 *              1.  Edit
 *              2.  Ask "Abort, Edit, List, Send?"
 *              3.  If Edit, goto 1
 *              4.  If Abort, copy to $HOME/article.dead, announce same, exit(1)
 *              5.  If List, ???, goto 2
 *              6.      If Send, exec postnews which will massage the file (add Date: ...)
 *                                       and then send the file on its way (equivalent to uux??)
 *              7.  Goto 2
 *
 */


#define FALSE 0
#define TRUE 1
#define FROMLINE "From: "
#define DATELINE "Date: "

char *fail_reasons[] = {
   "Arg list too long",
   "Invalid modeflag",
   "Program not found",
   "File not a program",
   "Not enough memory",
   "Unknown reason"
};

extern char *E_tmpdir;
extern char *domain;
extern char *E_mailbox;
extern char *E_editor;
extern char *E_homedir;

extern char *getval(char *nam, char *def);

void usage()
{

   printf("Pnews -h headerfile\n");

}

int spawn_fail(int code)
{

   switch (code)
   {
      case E2BIG:return 0;
    case EINVAL:
      return 1;
    case ENOENT:
      return 2;
    case ENOEXEC:
      return 3;
    case ENOMEM:
      return 4;
    default:
      return 5;
   }
}



int
  main(argc, argv)
   int argc;
   char **argv;
{

   char ed[MAXDIR];          /* Editor to use (vi is
                              * default) */

   /* also used for file names after editor is not needed */
   char *editor;

   char *default_editor;

   int j;

   char t;

   FILE *f_scratch;
   FILE *f_posting;

   hostinit(FALSE);

   banner(argv);
   printf("Pnews for rn %s \n", RN_VERSION);


   if ((argc != 3) || (strcmp(argv[1], "-h") != 0))
   {
      printf("\nPnews: invalid arg list\n");
      usage();
      return 1;
   }


   t = 'E';
   while (TRUE)
   {
      if (t == 'E')
      {
         if (E_editor != NULL)
            default_editor = E_editor;
         else
            default_editor = "vi";

         strcpy(ed, getval("VISUAL", getval("EDITOR", default_editor)));
         editor = strchr(ed, ' ');
         if (editor != NULL)
         {
            /* _I_ don't want that wretched %s */
            editor[0] = '\0';
         }
         editor = ed;

         j = spawnlp(P_WAIT, editor, editor, argv[2], NULL);
         if (j == -1)
         {
            printf("Unable to spawn %s (%s)\n", editor,
                   fail_reasons[spawn_fail(errno)]);
            return 1;
         }
      }
      else if (t == 'L')
      {
         printf("Feature unimplemented\n");
      }
      else if (t == 'A')
      {
         exit(1);
      }
      else if (t == 'S')
      {
         j = spawnlp(P_WAIT, "postnews", "postnews", argv[2], NULL);
         if (j == -1)
         {
            printf("Unable to spawn %s (%s)\n", "postnews",
                   fail_reasons[spawn_fail(errno)]);
            return 1;
         }
         else if (j != 0)
         {
            /* Postnews had a problem with it.  It has already told the user
             * and given them a chance to respond. */
            t = 'E';
            continue;
         }
         /* Successfully shipped */
         break;
      }

      printf("\nAbort, Send, List, Edit? ");
      t = toupper(getche());
      printf("\n");
   }

   return 0;

}




char *
  getval(nam, def)
   char *nam, *def;
{
   char *val;

   if ((val = getenv(nam)) == NULL || !*val)
      val = def;
   return val;
}
