/************************************************************************
 *
 *  This program will set up %./NEWSRC to be subscribed to ALL of
 *  the newsgroups mentioned in the active file and to have read
 *  all the articles that have expired.
 *
 *  %.      is the directory containing all of the "dot" files
 *                      it defaults to the HOME directory unless DOTDIR is
 *                      defined
 *
 *  NEWSRC  defaults to "newsrc" unless NEWSRC is defined
 *
 ************************************************************************/


#include <stdio.h>
#include <stdlib.h>

#ifdef __TURBOC__
#include <dir.h>
#else
#define MAXDIR FILENAME_MAX
#endif

#include "lib.h"

#include "active.h"
#include "config.h"
#include "timestmp.h"

char *getval(char *nam, char *def);

char newsrc_name[MAXDIR];

main(argc, argv)
   int argc;
   char **argv;
{
   struct grp *cur_grp;
   FILE *f;

   hostinit(FALSE);

   strcpy(newsrc_name, getval("DOTDIR", E_homedir));
   strcat(newsrc_name, "/");
   strcat(newsrc_name, getval("NEWSRC", "newsrc"));
   f = fopen(newsrc_name, "w");
   if (f == NULL)
   {
      printf("Unable to create %s\n", newsrc_name);
      exit(1);
   }
   get_active();

   cur_grp = group_list;
   while (cur_grp != NULL)
   {
      fprintf(f, "%s:", cur_grp->grp_name);
      if (cur_grp->grp_low > 2)
      {
         fprintf(f, "1-%d", cur_grp->grp_low - 1);
      }
      fprintf(f, "\n");
      cur_grp = cur_grp->grp_next;
   }
   fclose(f);
   return (0);

}




char *
  getval(nam, def)
   char *nam, *def;
{
   char *val;

   if ((val = getenv(nam)) == NULL || !*val)
      val = def;
   return val;
}
