/*
	SNEWS 1.91

	DEFS.H - General public decls


    Copyright (C) 1991  John McCombs, Christchurch, NEW ZEALAND
                        john@ahuriri.gen.nz
                        PO Box 2708, Christchurch, NEW ZEALAND

	Modifications copyright (C) 1993  Daniel Fandrich
						<dan@fch.wimsey.bc.ca> or CompuServe 72365,306

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 1, as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    See the file COPYING, which contains a copy of the GNU General
    Public License.


	Source is formatted with a tab size of 4.

 */

#include <alloc.h>
#include <time.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <share.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <dir.h>
#include <signal.h>

#ifdef __OS2__
#define INCL_DOSNLS
#define INCL_DOSPROCESS
#include <os2.h>
#endif


#if __TURBOC__ && (__TURBOC__ < 0x300)
#define flockopen fopen		/* old Turbo C compilers didn't support _fsopen */
#elif __TURBOC__ >= 0x300
#define flockopen(a,b) _fsopen(a,b,SH_DENYWR)
#endif
/* MSC supports flockopen(), & hopefully the same way as I'm defining it!
   This isn't a very good way of doing things -- change the flockopen calls to
   use _fsopen directly */


#define VERSION      "Simple NEWS 1.91"

#define HIST_MEM_LIMIT  75000l  /* leave this much RAM free after loading history */

#define ACTIVE_NUM_LEN   8      /* length of the numbers in the active file */

#define TRUE     1
#define FALSE    0

#define IOBUFSIZE	8192

/* this is the data we get from the UUPC .rc files */

typedef struct {
    char temp_name[80];           /* unbatch temp file             */
	char temp_str[80];			  /* Temporary dir display str     */
    char news_dir[80];            /* news base directory           */
    char incoming_dir[80];        /* incoming news spool directory */
    char user[80];                /* current user id               */
    char my_name[80];             /* my full name                  */
    char my_domain[80];           /* our domain                    */
    char my_site[80];             /* site name                     */
    char my_organisation[80];     /* organisation                  */
    char replyuser[80];           /* Reply-To User address         */
    char replydomain[80];         /* Reply-To User domain          */
    char mail_server[80];         /* where posts are routed to     */
    char editor[80];              /* system editor                 */
    char home[80];                /* home mail directory           */
    char signature[80];           /* signature file                */
    char alias_file[80];          /* alias file                    */
	char extract_file[80];        /* article extract file          */
    char uncompress[80];          /* batch uncompress program      */
	char hotpipe[80];             /* hotkey (F4) pipe program      */
} INFO;


/* NOTE - if hi_num and lo_num are the same there are no articles */

typedef struct active {
    char   group[60];           /* group name                               */
    char   gp_file[9];          /* name of the file that the data is in     */
	char   post;				/* y=allowed to post, n=not, m=moderated    */
	char   local;               /* 1=local news group                       */
    long   lo_num;              /* lowest number less one                   */
    long   hi_num;              /* highest number                           */
    long   num_pos;             /* file offset of the numbers               */
    struct active *next;        /* next entry                               */
    struct active *last;        /* last entry                               */
    int    index;               /* which number in the list, from 0         */
    char   *read_list;          /* array hi_num-lo_num long. TRUE=read it   */
} ACTIVE;


/*
 *  READ LIST:
 *      The list of articles which has been seen by a user is kept in an
 *      ascii file, which has a newsgroup name followed by the list
 *      of article numbers which have been seen.
 *
 *      The file is read by 'load_read_list', which allocates and array of
 *      flags, one per article, and plugs these into the ACTIVE structure.
 *      The flags are set to TRUE when a user has seen an article.
 *
 *      On shutdown a new 'snews.nrc' file is written
 */

/*
 *  This structure is an index to the history file.  'mid' is a 32bit hash
 *  of the message id.  'offset' is the offset into the history file, and
 *  'next' makes the linked list
 */

typedef struct hist_list {
    long mid;
    long offset;
    struct hist_list *next;
} HIST_LIST;


/*
 *  This linked list is returned by 'look_up_history'.  It is a list
 *  of the groups to which an article has been crossposted.  It does
 *  not include self
 */

typedef struct cross_posts {
    char   group[60];            /* group name                               */
    long   art_num;              /* article number in this group             */
    struct cross_posts *next;    /* next entry                               */
} CROSS_POSTS;

extern char *char_set_names[];
extern INFO my_stuff;
extern int active_code_page;
extern enum char_sets current_char_set;
extern volatile int break_hit;

#ifndef ACTIVE_C

extern int textb, textf, headb, headf, helpf, helpb, msgf, msgb;

#endif


ACTIVE *load_active_file(void);
void close_active_file(void);
void close_active(void);
ACTIVE *find_news_group(char *group);
void update_active_entry(ACTIVE *a);
char *make_news_group_name(char *ng);

void save_read_list(void);
void load_read_list(void);

int load_stuff(void);

void cdecl sig_break();

char *expand_filename(char *filename);

FILE *open_out_file(char *ng);
FILE *open_index_file(char *ng);

int post_sequence(void);

void *xmalloc(size_t size);

int check_valid_post_group(char *ng);
int is_local_group(char *ng);

FILE *open_hist_file(void);
void close_hist_file(void);
void add_hist_record(char *msg_id, char *ng);

HIST_LIST *load_history_list(void);
void free_hist_list(void);
HIST_LIST *find_msg_id(char *msg_id);
CROSS_POSTS *look_up_history(char *msg_id, char *ng);
void free_cross_post_list(CROSS_POSTS *cx);
