/*
 * --------------------------------------------------------------------
 * snu_fpm.c - SNUUPM _ Filter PMail
 * Adds a uucp-format "From" line to the header, preparing the the
 * message file for rmail.exe from uupc11z.
 * Author: Mike Lawrie, Rhodes University. <ccml@hippo.ru.ac.za>
 * Based on the program "filter.c"
 * --------------------------------------------------------------------
 */

#define VERSION 1

/*
 * --------------------------------------------------------------------
 * filter.c
 * a program to take the output produced by Pegasus Mail/PC in standalone
 * mode, and place it appropriately. with associated
 * support .cmd and .xqt files for mail processing using the Waffle BBS uucico
 * and uuxqt programs.
 *
 * Pegasus Mail/PC (C) Copyright 1990, 1991, David Harris, Dunedin, New Zealand
 * WAFFLE  (C) Copyright 1991 by Darkside International of Mountain View CA.
 *
 * Author: Brendan Murray, Dunedin, New Zealand
 * Permission is granted to do whatever you like with this code. Just about
 * anyone ought to be able to improve on it. No warranty whatsoever is granted
 * or implied.
 *
 * V1.1
 * --------------------------------------------------------------------
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <time.h>

void main (int argc, char * argv[] )
    {

    char *timeptr;
    time_t timer;

    FILE *infile;

    char *FqDn;		/* fully qualified domain name from UUPC.RC */
    char *NodeName;	/* this host from UUPC.RC */
    char *TimeZone;     /* from the environment variable TZ */
    char *PMuser;	/* from the environment variable PMUSER */

    char *uupcdir;
    char *tmpstring;

    int cntr;
    int cntr2;
    char ch;

    if (argc != 2)
      {
      /* even though Pmail probably won't display this */
      fprintf( stderr,"Usage: %s MessageFile\n", argv[0] );
      exit(1);
      }


/*
 * --------------------------------------------------------------------
 *	UUPC uses an environment variable (UUPCSYSRC) to point at the
 *	static parameters file
 * --------------------------------------------------------------------
 */
    uupcdir = (char *) malloc(MAXPATH);
    if (( uupcdir = (char *) getenv ("UUPCSYSRC")) == NULL)
      {
      fprintf (stderr, "ERROR: UUPCSYSRC has not been defined\n");
      exit(1);
      }

   if (( infile = fopen(uupcdir,"r")) == NULL)
      {
      fprintf(stderr,"Unable to open %s",uupcdir);
      exit(1);
      }

/*
 * --------------------------------------------------------------------
 * Read the uupc.rc file, and extract the following:-
 *
 *	FqDn=nodename
 * --------------------------------------------------------------------
 */

   tmpstring = (char *) malloc (132);
   while ((fgets(tmpstring, 132, infile)) != NULL)
      {
      if ((strnicmp(tmpstring, "DOMAIN", strlen("DOMAIN"))) == 0)
	 {
	 cntr = strlen("DOMAIN"); /* might as well start here */

/* Start of domain name must be alpha */

	 while ((!isalpha(tmpstring[cntr])) && (tmpstring[cntr] != '\0'))
	    cntr++;
	 if (tmpstring[cntr] == '\0')
	    {
	    fprintf(stderr,"No DOMAIN specified in %s\n",uupcdir);
	    exit(1);
	    }
	 FqDn = (char *) malloc (132); /* it can't be bigger than this? */
	 cntr2 = 0;
	 while ((tmpstring[cntr] != '\0'))
	    FqDn[cntr2++] = tmpstring[cntr++];
	 FqDn[--cntr2] = '\0';
	 }
      else
      if ((strnicmp(tmpstring, "NODENAME", strlen("NODENAME"))) == 0)
	{
	 cntr = strlen("NODENAME"); /* might as well start here */
	 /* find an alpha character, the start of the uucpname */
	 while ((!isalpha(tmpstring[cntr])) && (tmpstring[cntr] != '\0'))
	    cntr++;
	 if (tmpstring[cntr] == '\0')
	    {
	    fprintf(stderr,"No NODENAME specified in %s\n",uupcdir);
	    exit(1);
	    }
	 NodeName = (char *) malloc (132); /* it can't be bigger than this? */
	 cntr2 = 0;
	 while ((tmpstring[cntr] != '\0'))
	    NodeName[cntr2++] = tmpstring[cntr++];
	 NodeName[--cntr2] = '\0';
	 }
      }
      fclose(infile);
	    
/*
 * --------------------------------------------------------------------
 * Get the TZ env variable
 * --------------------------------------------------------------------
 */
    TimeZone = (char *) malloc (132); /* a number! */
    if( (tmpstring=(char *)getenv("TZ")) == NULL )
	{
	fprintf( stderr, "ERROR: TZ env variable has not been defined\n" );
	exit( 1 );
	}

    cntr2 = 0;
    while ((*tmpstring != '\0') && (*tmpstring != '\n'))
	TimeZone[cntr2++] = *tmpstring++;
    TimeZone[cntr2] = '\0';
    
/*
 * --------------------------------------------------------------------
 * Get the PMUSER env variable
 * --------------------------------------------------------------------
 */

    PMuser = (char *) malloc (132); /* a number! */
    if( (tmpstring=(char *)getenv("PMUSER")) == NULL )
	{
	fprintf( stderr, "ERROR: PMUSER env variable has not been defined\n" );
	exit( 1 );
	}

    cntr2 = 0;
    while ((*tmpstring != '\0') && (*tmpstring != '\n'))
	PMuser[cntr2++] = *tmpstring++;
    PMuser[cntr2] = '\0';

/*
 * --------------------------------------------------------------------
 * Get the time, insert a comma, overwrite the \n, chop off the year
 * --------------------------------------------------------------------
 */

    time( &timer );
    timeptr = ctime( &timer );
    for( cntr=18; cntr >= 3; cntr-- )
	timeptr[cntr+1] = timeptr[cntr];
    timeptr[3]  = ',';
    timeptr[20] = '\0';

/*
 * --------------------------------------------------------------------
 * Output to stdout - this allows piping into rmail.exe
 * Prefix the header lines in front of what PMAIL creates
 * --------------------------------------------------------------------
 */

    printf("From %s!%s %s %s remote from %s\n",
	   FqDn, PMuser, timeptr, TimeZone, NodeName);


/*
 * --------------------------------------------------------------------
 * Copy the PMAIL file
 * --------------------------------------------------------------------
 */

    if( (infile = fopen(argv[1],"r")) == NULL )
	{
	fprintf( stderr, "Error in opening PMAIL file %s\n", argv[1] );
	exit( 1 );
	}

    while (( ch = fgetc(infile)) != 0xff )
       putchar(ch);

    fclose(infile);

    if( (unlink(argv[1])) != 0 )
	{
	fprintf( stderr, "ERROR: Failed to delete PMAIL file %s\n", argv[1] );
	exit( 1 );
	}

    }
/*
 * --------------------------------------------------------------------
 * End of file
 * --------------------------------------------------------------------
 */