;MPQSHD3.ASM 3.2
;	MACHINE LANGUAGE SUBROUTINE
;	FOR MULTIPLE POLYNOMIAL QUADRATIC SIEVE
;	Hard Disk verison
;	1989/90 by YUJI KIDA
;
.386P

code	segment	use16
	assume	cs:code,ds:code

	INCLUDE	UBP.MAC
	include	mpqshd.h

org	100h

start:
	jmp	start0

org	104h
	mov	eax,cr0		;reset PE bit
	and	eax,07ffffffeh
	mov	cr0,eax

	db	0eah		;jmp far ptr flushrl
	dw	offset flushrl
csegmem	dw	?

	; return to REAL mode
flushrl:
	sti
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


; COMMAND ̐U蕪

start0:
	MOV_AX	AR0		;ARRAY[0] ŃR}hn
	MOV	BX,OFFSET CMD_TBL
	SHL	AX,1
	ADD	BX,AX
	JMP	CS:[BX]

CMD_TBL:
	dw	INITIALIZE,GETPRIME,STORE_DATA,CLOSEFILE

	even
pmodecsseg	dw	?

P_OFF	DW	?
P_SEG	dw	?
primeadrnow	dd	?

W_OFF	DW	?
W_SEG	DW	?

primes		dw	?

handle1		dw	?
size1		dw	?
handle2		dw	?
size2		dw	?
handle3		dw	?
size3		dw	?
handle4		dw	?

rowpointer	dw	?

rownow		dw	?

offnow		dw	?
ansnow		dw	?
masknow		dw	?

allbytes	dw	?
allwords	dw	?
halfbytes	dw	?
halfwords	dw	?


;
; get and set primes
;
;command#=1

getprime:
	lds	si,dword ptr cs:[P_OFF]
	mov	edi,dword ptr cs:[primeadrnow]
	lodsw
	cmp	ax,2
	je	getprime4B
	xor	eax,eax
	mov	ax,[si]
getprime10:
	mov	fs:[edi],eax
	add	cs:[primeadrnow],primeunitbytes
	mov	ax,ss
	mov	ds,ax
	retf
getprime4B:
	mov	eax,[si]
	jmp	getprime10


;
;  s̐ݒ
;      W=X^2 Ȃ W 𓾂Ĉs̃f[^ݒ肷

;COMMAND#=2

STORE_DATA:
	PUSH	BP

	LDS	SI,DWORD PTR CS:[W_OFF]
	MOV	BX,SI		;MEMO 鐔

	MOV	AX,[SI]
	AND	AX,8000H		;get sign
	ROL	AX,1			;sign in 0-th bit
	AND	WORD PTR [SI],1FFFH	;cut sign
	MOV	cs:[ANSNOW],AX		;16 BIT ̌
	MOV	cs:[MASKNOW],2
	MOV	cs:[OFFNOW],offset BUFFER

	mov	edi,primeadr+primeunitbytes	;offset of 2

	STD

	MOV	AX,[bx]		;transfer to 32bit format
	test	al,1
	jz	div3200		;if even words
	MOV	SI,BX
	mov	dx,ax
	SHL	dX,1
	ADD	SI,dX		;highest adr
	mov	word ptr [si+2],0
	inc	ax
div3200:
	shr	ax,1
	mov	[bx],ax


	MOV	CX,CS:[primes]
div32LP:
	PUSH	CX

	MOV	eBP,fs:[eDI]	;ebp=鐔
div3210:
	MOV	SI,BX
	MOV	AX,[SI]
	MOV	CX,AX		;dword length
	SHL	AX,2
	sub	ax,2
	ADD	SI,AX		;dword highest adr
	XOR	eDX,eDX	
div3220:
	LODSd
	DIV	eBP
	LOOP	div3220

	OR	eDX,eDX
	JZ	div32100	;divide exactly if it can

	ROL	cs:[MASKNOW],1
	JNC	DIV3230

	PUSH	BX		;set results for each 16 primes
	MOV	BX,cs:[OFFNOW]
	MOV	AX,cs:[ANSNOW]
	MOV	cs:[BX],AX
	MOV	cs:[ANSNOW],0
	ADD	BX,2
	MOV	cs:[OFFNOW],BX
	POP	BX
DIV3230:	
	add	edi,primeunitbytes
	POP	CX
	LOOP	div32LP

	mov	si,bx		;transfer to 16bit format
	mov	ax,[si]
	shl	ax,1
	mov	cx,ax		;word length?
	shl	ax,1
	add	si,ax
	cmp	word ptr [si],0	;check highest word
	jne	div3255
	dec	cx
div3255:
	mov	[bx],cx		

	jmp	div200


div32100:
	MOV	AX,cs:[MASKNOW]
	XOR	cs:[ANSNOW],AX

	MOV	SI,BX
	MOV	AX,[SI]
	MOV	CX,AX		;dword length
	SHL	AX,2
	sub	ax,2
	ADD	SI,AX		;ŏ
	XOR	eDX,eDX	

	LODSd
	DIV	eBP
	PUSH	eAX		;push highst dword
	JMPS	div32120
div32110:
	LODSd
	DIV	eBP
div32120:
	MOV	[SI+4],eAX
	LOOP	div32110

	POP	eAX		;check highest dword
	OR	eAX,eAX
	JNZ	div32130
	DEC	WORD PTR [bx]	;ŏʂ 0 Ȃ LEN  DEC
div32130:
	JMP	div3210


	;set 2nd matrix part
div200:
	cld
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	mov	di,offset BUFFER
	add	di,[halfbytes]
	mov	cx,[halfwords]
	xor	ax,ax
	rep	stosw

	mov	ax,[rownow]
	inc	ax
	mov	[rownow],ax
	dec	ax
	mov	cx,ax		;memo
	shr	ax,3
	add	ax,offset BUFFER
	add	ax,[halfbytes]
	mov	bx,ax
	and	cl,7
	mov	al,1
	shl	al,cl
	mov	[bx],al

	;write result

	mov	ax,[rowpointer]
	inc	ax
	mov	[rowpointer],ax

	mov	bx,[handle1]
	cmp	ax,[size1]
	jbe	div220
	mov	bx,[handle2]
	cmp	ax,[size2]
	jbe	div220
	mov	bx,[handle3]
	cmp	ax,[size3]
	jbe	div220
	mov	bx,[handle4]
div220:
	mov	ah,40h		;write handle
	mov	cx,[allbytes]
	mov	dx,offset BUFFER
	int	21h
	jc	writeerror
	cmp	ax,cx
	jne	writeerror
	
	POP	BP
	MOV	AX,SS
	MOV	DS,AX
	MOV	ES,AX
	RETF

writeerror:
	POP	BP
	mov	bx,AR0
	mov	word ptr cs:[bx],0	;error mark

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	jmp	closefile


;
; Initialize
;COMMAND#=0

;	V1=P
;	V2=W#
;	AR[1]	TOTAL SIZE \ 2
;	AR[2]	DRIVE NUMBER 1
;	AR[3]	SIZE1 \ 2
;	AR[4]	DRIVE NUMBER 2
;	AR[5]	SIZE2 \ 2
;	AR[6]	DRIVE NUMBER 3
;	AR[7]	SIZE3 \ 2
;	AR[8]	DRIVE NUMBER 4
;	AR[9]	SIZE4 \ 2

INITIALIZE:
	mov	ax,cs
	mov	ds,ax
	mov	es,ax

	MOV	BX,V1		;P  ADDRESS ̐ݒ
	MOV	AX,[BX]
	MOV	[P_OFF],AX
	MOV	AX,[BX+2]
	MOV	[P_SEG],AX

	MOV	BX,V2		;W#  ADDRESS ̐ݒ
	MOV	AX,[BX]
	MOV	[W_OFF],AX
	MOV	AX,[BX+2]
	MOV	[W_SEG],AX

	MOV	BX,V3		;set PMODE segment
	MOV	AX,[BX]
	shr	ax,4
	add	ax,[BX+2]
	sub	ax,ARRAYHEADSEG
	mov	[pmodecsseg],ax

	MOV_AX	AR1
	shl	ax,1
	dec	ax
	mov	[primes],ax
	inc	ax
	shl	ax,1		;*2
	shr	ax,3		;bits -> bytes
	mov	[allbytes],ax
	shr	ax,1
	mov	[halfbytes],ax
	mov	[allwords],ax	
	shr	ax,1
	mov	[halfwords],ax

	mov	[rownow],0
	mov	[primeadrnow],primeadr

	; open file

	mov	bx,offset MATRIXNAME1
	MOV_AX	AR2
	or	ax,ax
	jz	INIT10
	sub	bx,2
	add	al,'@'
	mov	[bx],al
INIT10:
	mov	dx,bx
	mov	ah,3ch		;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[handle1],ax
	MOV_AX	AR3
	shl	ax,1
	MOV	[size1],ax

	mov	bx,offset MATRIXNAME2
	MOV_AX	AR4
	or	ax,ax
	jz	INIT20
	sub	bx,2
	add	al,'@'
	mov	[bx],al
INIT20:
	mov	dx,bx
	mov	ah,3ch		;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[handle2],ax
	MOV_AX	AR5
	shl	ax,1
	add	ax,[size1]
	MOV	[size2],ax

	mov	bx,offset MATRIXNAME3
	MOV_AX	AR6
	or	ax,ax
	jz	INIT30
	sub	bx,2
	add	al,'@'
	mov	[bx],al
INIT30:
	mov	dx,bx
	mov	ah,3ch		;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[handle3],ax
	MOV_AX	AR7
	shl	ax,1
	add	ax,[size2]
	MOV	[size3],ax

	mov	bx,offset MATRIXNAME4
	MOV_AX	AR8
	or	ax,ax
	jz	INIT40
	sub	bx,2
	add	al,'@'
	mov	[bx],al
INIT40:
	mov	dx,bx
	mov	ah,3ch		;create handle
	mov	cx,0
	int	21h
	jc	diskerror
	mov	[handle4],ax

	mov	[rowpointer],0

	; make GDT

	mov	ax,cs
	mov	[csegmem],ax

	mov	ax,[pmodecsseg]
	and	eax,0ffffh
	shl	eax,4
	mov	ebx,eax
	shr	eax,16
	mov	gdt_code32.base_0_15,bx
	mov	gdt_code32.base_16_23,al

	mov	ax,cs
	and	eax,0ffffh
	shl	eax,4
	mov	ebx,eax
	shr	eax,16
	mov	gdt_code16.base_0_15,bx
	mov	gdt_code16.base_16_23,al

	mov	ax,cs
	mov	ds,ax
	mov	si,offset gdttbl
	mov	ax,_gdttblseg
	mov	es,ax
	mov	di,0
	mov	cx,10h
	rep	movsw
	
	mov	eax,_gdttbladr
	mov	dword ptr gdtaddr+2,eax
	lgdt	gdtaddr

	cli

	mov	eax,cr0		;set PE bit
	or	eax,1
	mov	cr0,eax

	db	0eah		;goto protect mode
	dw	100h
	dw	offset gdt_code32-gdttbl	;selector


diskerror:
	mov	bx,AR0
	mov	word ptr [bx],8001h
	MOV	AX,SS
	MOV	DS,AX
	MOV	ES,AX
	RETF


descriptor	struc
	limit_0_15	dw	0
	base_0_15	dw	0
	base_16_23	db	0
	access		db	0
	gran		db	0
	base_24_31	db	0
descriptor	ends

code_seg_access	equ	09ah
data_seg_access	equ	092h

	; GDT table

	align	4
gdtaddr	label	qword
	dw	4*8		;size of GDT table
	dd	?
	dw	0

gdttbl		label	dword
gdt_null	descriptor <,,,,,>
gdt_code32	descriptor <0ffffh,,,code_seg_access,0cfh,0>
gdt_data32	descriptor <0ffffh,0,0,data_seg_access,0cfh,0>
gdt_code16	descriptor <0ffffh,,,code_seg_access,80h,0>


;
; close file
;COMMAND#=2

CLOSEFILE:
	mov	ah,3eh
	mov	bx,cs:[handle1]
	int	21h

	mov	ah,3eh
	mov	bx,cs:[handle2]
	int	21h

	mov	ah,3eh
	mov	bx,cs:[handle3]
	int	21h

	mov	ah,3eh
	mov	bx,cs:[handle4]
	int	21h
	retf


		db	' :'
MATRIXNAME1	db	'MPQSMAT1.UBD',0
		db	' :'
MATRIXNAME2	db	'MPQSMAT2.UBD',0
		db	' :'
MATRIXNAME3	db	'MPQSMAT3.UBD',0
		db	' :'
MATRIXNAME4	db	'MPQSMAT4.UBD',0

ALIGN 4
BUFFER		db	maxbuffersize dup(0)

CODE	ENDS
END	START
