;MPQSHD2.ASM 3.2
;	MACHINE LANGUAGE SUBROUTINE
;	FOR MULTIPLE POLYNOMIAL QUADRATIC SIEVE
;	Hard Disk version
;	1989/90 by YUJI KIDA
;
.386P

code	segment	use16
	assume cs:code,ds:code


	INCLUDE	UBP.MAC
	include	mpqshd.h

	org	100h
start:
	JMP	START0

	org	104h
sieveout:
	mov	eax,cr0		;reset PE bit
	and	eax,07ffffffeh
	mov	cr0,eax

	db	0eah		;jmp far ptr flushrl
	dw	offset flushrl
csegmem	dw	?

	; AE[hɕA
flushrl:
	sti
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


	align	4
primeadrnow	dd	?
lastprime	dd	?

lpvindexadr	dd	?
lpvdataadr	dd	?

pmodecsseg	dw	?

primes		dw	?

P_OFF	DW	?
P_SEG	DW	?
Y_OFF	DW	?
Y_SEG	DW	?

L_OFF	DW	?
L_SEG	DW	?

X_OFF	DW	?
X_SEG	DW	?

A2_OFF	DW	?
A2_SEG	DW	?
B_OFF	DW	?
B_SEG	DW	?
M_OFF	DW	?
M_SEG	DW	?
W_OFF	DW	?
W_SEG	DW	?

Ew_OFF	DW	?
Ew_SEG	DW	?

X1_OFF	DW	?
X1_SEG	DW	?

IniLog	DW	?
CutLog	DW	?

lpvnow		dw	0
lpvcount	dw	0


; COMMAND ̐U蕪


START0:
	MOV_AX	AR0		;ARRAY[0] ŃR}hn
	MOV	BX,offset CMD_TBL
	SHL	AX,1
	ADD	BX,AX
	JMP	CS:[BX]

CMD_TBL:
	DW	INITMPQS,SETR1R2,SIEVE,SIEVE_ANS,SETDATA
	DW	DECOMPOSE,lpvinit,setlpvdata,qsort,isort
	dw	getpair,initmpqs2


;
; get matching pair
; command#=10

getpair:
	xor	ebx,ebx
	mov	bx,cs:[lpvnow]
	cmp	bx,cs:[lpvcount]
	jae	short nomorepair
	shl	ebx,1
	add	ebx,cs:[lpvindexadr]
	xor	eax,eax
	mov	ax,fs:[ebx]
	add	ebx,2
	mov	edx,t_byte
	mul	edx
	add	eax,cs:[lpvdataadr]
	mov	esi,eax
getpair10:
	xor	eax,eax
	mov	ax,fs:[ebx]
	mov	edx,t_byte
	mul	edx
	add	eax,cs:[lpvdataadr]
	mov	edi,eax
	mov	eax,fs:[esi]	;prev w#
	cmp	eax,fs:[edi]	;current w#
	je	short getpairmatch
	mov	esi,edi	
	add	ebx,2
	mov	ax,cs:[lpvnow]
	inc	ax
	mov	cs:[lpvnow],ax
	cmp	ax,cs:[lpvcount]
	jb	short getpair10

nomorepair:
	les	di,dword ptr cs:[ew_off]
	mov	word ptr es:[di],0

getpairret:
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

getpairmatch:
	inc	cs:[lpvnow]

	;set ew

;	push	esi
	push	edi

	les	di,dword ptr cs:[ew_off]
	mov	cx,1
	mov	ax,fs:[esi]
	add	esi,2
	mov	es:[di+2],ax
	mov	ax,fs:[esi]
	add	esi,2
	mov	es:[di+4],ax
	or	ax,ax
	jz	short getpair50
	inc	cx
getpair50:
	mov	es:[di],cx

	;set X

	les	di,dword ptr cs:[x_off]
	mov	cx,xword
getpair70:
	mov	ax,fs:[esi]
	add	esi,2
	stosw
	loop	getpair70

	pop	esi
;	push	esi
	add	esi,wbyte

	;set X1

	les	di,dword ptr cs:[x1_off]
	mov	cx,xword
getpair90:
	mov	ax,fs:[esi]
	add	esi,2
	stosw
	loop	getpair90

	jmp	getpairret


;
; quick sort
; command#=8

qsort:
	mov	cs:[lpvnow],0
	mov	cx,cs:[lpvcount]
	dec	cx
	mov	cs:[lpvcount],cx

	cli

	mov	eax,cr0		;set PE bit
	or	eax,1
	mov	cr0,eax

	db	0eah		;goto protect mode
	dw	900h
	dw	offset gdt_code32-gdttbl	;selector

;
; insertion sort
; command#=9

isort:
	mov	cx,cs:[lpvcount]
	dec	cx

	cli

	mov	eax,cr0		;set PE bit
	or	eax,1
	mov	cr0,eax

	db	0eah		;goto protect mode
	dw	0a00h
	dw	offset gdt_code32-gdttbl	;selector

;
; set lpv data
; command#=7

setlpvdata:
	xor	eax,eax
	mov	ax,cs:[lpvcount]
	mov	ebx,eax
	shl	ebx,1
	add	ebx,cs:[lpvindexadr]
	mov	fs:[ebx],ax

	mov	edx,t_byte
	mul	edx
	add	eax,cs:[lpvdataadr]
	mov	edi,eax

	;set W#

	lds	si,dword ptr cs:[w_off]
	xor	eax,eax
	lodsw
	and	ax,01ffh
	mov	cx,ax
	lodsd
	cmp	cx,1
	jne	short setlpvdata10
	and	eax,0000ffffh
setlpvdata10:
	mov	fs:[edi],eax
	add	edi,wbyte

	;set X

	lds	si,dword ptr cs:[x_off]
	mov	cx,xword
setlpvdata30:
	lodsw
	mov	fs:[edi],ax
	add	edi,2
	loop	setlpvdata30

	inc	cs:[lpvcount]

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


;
; lpv initialize
; command#=6

lpvinit:
	; check extended memories

	xor	eax,eax
	mov	ax,cs:[primes]
	xor	edx,edx
	mov	dx,primeunitbytes
	mul	edx
	add	eax,primeadr
	mov	cs:[lpvindexadr],eax
	mov	fs:[_lpvindexadr],eax

	mov	esi,pmodeworkadr-4
	mov	eax,19510701h
	mov	edx,00100000h		;1Mbytes
lpvinit100:
	add	esi,edx
	mov	fs:[esi],eax
	cmp	fs:[esi],eax
	je	lpvinit100
	mov	eax,esi
	add	eax,4
	sub	eax,edx
	sub	eax,cs:[lpvindexadr]

	xor	edx,edx
	mov	ecx,t_byte+2
	div	ecx

	mov	ebx,_lpvmaxnumber
	mov	fs:[ebx],eax

	shl	eax,1
	add	eax,cs:[lpvindexadr]

	mov	cs:[lpvdataadr],eax
	mov	fs:[_lpvdataadr],eax

	;

	MOV	BX,V1		;set Ew ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[Ew_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[Ew_SEG],AX

	MOV	BX,V2		;set X ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[X_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[X_SEG],AX

	MOV	BX,V3		;set X1 ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[X1_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[X1_SEG],AX

	mov	ebx,cs:[lpvindexadr]
	mov	word ptr fs:[ebx],0
	mov	ebx,cs:[lpvdataadr]
	mov	dword ptr fs:[ebx],0
	mov	cs:[lpvcount],1

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

;
; W  PR() Ŋ邩eXg
;
;COMMAND#=5

decompose:
	mov	ax,_memoseg
	mov	es,ax

	mov	ax,cs:[w_off]
	mov	es:[_absQR],ax
	mov	ax,cs:[w_seg]
	mov	es:[_absQR+2],ax

	cli

	mov	eax,cr0		;set PE bit
	or	eax,1
	mov	cr0,eax

	db	0eah		;goto protect mode
	dw	700h
	dw	offset gdt_code32-gdttbl	;selector


;
; [NEGȀ
;COMMAND#=0

;	V1=work(0,0)
;	V2=P
;	V3=Y
;	V4=L
;	V5=X
;	V6=A2
;	V7=B
;	V8=OF
;	V9=W#
;	V10=MP2%(0)

;	AR[1]	NUMBER OF PRIMES \ 2
;	AR[2]	INITIAL LOG
;	AR[3]	LIMIT LOG
;
;	s̏ꍇ AR[1]=0 ɂ

MEMORY_LACK:
	MOV	BX,AR1
	MOV	WORD PTR CS:[BX],0
	JMP	initout

INITMPQS:
	MOV	BX,V1		;check work(0,0) segment
	MOV	AX,CS:[BX]
	shr	ax,4
	add	ax,CS:[BX+2]
	cmp	ax,_memoseg
	ja	short memory_lack

	MOV	BX,V2		;set P ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[P_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[P_SEG],AX

	MOV	BX,V3		;set Y ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[Y_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[Y_SEG],AX

	MOV	BX,V4		;set L ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[L_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[L_SEG],AX

	MOV	BX,V5		;set X ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[X_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[X_SEG],AX

	MOV	BX,V6		;set A2 ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[A2_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[A2_SEG],AX

	MOV	BX,V7		;set B ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[B_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[B_SEG],AX

	MOV	BX,V8		;set Off ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[M_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[M_SEG],AX

	MOV	BX,V9		;set W# ADDRESS
	MOV	AX,CS:[BX]
	MOV	CS:[W_OFF],AX
	MOV	AX,CS:[BX+2]
	MOV	CS:[W_SEG],AX

	MOV	BX,V10		;set PMODE segment
	MOV	AX,CS:[BX]
	shr	ax,4
	add	ax,CS:[BX+2]
	sub	ax,ARRAYHEADSEG
	mov	cs:[pmodecsseg],ax

	MOV_AX	AR1
	shl	ax,1
	mov	cs:[primes],ax

	MOV_AX	AR2
	MOV	CS:[IniLog],AX

	MOV_AX	AR3
	MOV	CS:[CutLog],AX

init100:
	mov	ax,cs
	mov	ds,ax
	mov	[csegmem],ax

	mov	eax,primeadr+primeunitbytes
	mov	[primeadrnow],eax
	mov	[lastprime],0

descriptor	struc
	limit_0_15	dw	0
	base_0_15	dw	0
	base_16_23	db	0
	access		db	0
	gran		db	0
	base_24_31	db	0
descriptor	ends

code_seg_access	equ	09ah
data_seg_access	equ	092h

	; fcs̍쐻
	; 32bit code segment in protect mode

	mov	ax,[pmodecsseg]
	and	eax,0ffffh
	shl	eax,4
	mov	ebx,eax
	shr	eax,16
	mov	gdt_code32.base_0_15,bx
	mov	gdt_code32.base_16_23,al

	; fcs̍쐻
	; 16 bit code segment in real mode for return

	mov	ax,cs
	and	eax,0ffffh
	shl	eax,4
	mov	ebx,eax
	shr	eax,16
	mov	gdt_code16.base_0_15,bx
	mov	gdt_code16.base_16_23,al

	; fcs̍쐻
	; 32 bit data segment : start from 00000

	; store "number of primes" and "inilog" and "cutlog" and "M"

	mov	ax,_memoseg
	mov	es,ax

	xor	di,di
	mov	cx,80h
	xor	ax,ax
	rep	stosw

	xor	eax,eax
	mov	ax,cs:[primes]
	mov	es:[_primesR],ax
	cmp	ax,7000h
	jae	short initmpqs200
	mov	ax,7000h
initmpqs200:
	and	ax,0f000h	;let be a multiple of 1000h
	xor	ecx,ecx
	mov	cx,primeunitbytes
	mul	ecx
	add	eax,pmodeworkadr

	mov	es:[_sievetopR],eax

	mov	ax,cs:[inilog]
	mov	ah,al
	mov	es:[_inilogR],ax
	mov	es:[_inilogR+2],ax

	mov	ax,cs:[cutlog]
	mov	es:[_cutlogR],ax

	lds	si,dword ptr cs:[M_off]
	mov	di,_sievewidthR
	lodsw
	and	ax,7fffh	;make positive
	movsw
	cmp	ax,1
	je	short init150
	movsw
init150:
	; fcsqɂfcsԒnZbg

	mov	ax,cs
	mov	ds,ax
	mov	si,offset gdttbl
	mov	ax,_gdttblseg
	mov	es,ax
	mov	di,0
	mov	cx,10h
	rep	movsw
	
	mov	eax,_gdttbladr
	mov	dword ptr gdtaddr+2,eax
	lgdt	gdtaddr
initout:
	cli

	mov	eax,cr0		;set PE bit
	or	eax,1
	mov	cr0,eax

	db	0eah		;goto protect mode
	dw	0b00h
	dw	offset gdt_code32-gdttbl	;selector

;
; set data for each prime
;command#=4
setdata:
	mov	edi,cs:[primeadrnow]

	lds	si,dword ptr cs:[p_off]
	lodsw
	cmp	ax,1
	ja	short setdata20
	xor	eax,eax
	lodsw
	jmp	short setdata30
setdata20:	
	lodsd
setdata30:
	cmp	eax,fs:[_sieveBsize]
	jb	short setdata32
	inc	word ptr fs:[_primes2]
	jmp	short setdata33
setdata32:
	cmp	eax,fs:[_sieveXsize]
	jb	short setdata33
	inc	word ptr fs:[_primes1]
setdata33:
	mov	edx,eax
	sub	eax,cs:[lastprime]
	mov	fs:[edi],ax
	mov	cs:[lastprime],edx

	lds	si,dword ptr cs:[y_off]
	xor	eax,eax
	lodsw
	cmp	ax,1
	ja	short setdata40
	jb	short setdata50
setdata45:
	lodsw
	jmp	short setdata50
setdata40:	
	lodsd
setdata50:
	mov	fs:[edi+4],eax

	lds	si,dword ptr cs:[l_off]
	mov	ax,[si+2]
	mov	fs:[edi+2],ax

	add	edi,primeunitbytes
	mov	cs:[primeadrnow],edi

	mov	ax,ss
	mov	ds,ax
	retf

;
; * sieving main
;   386 protect mode
; command#=2

SIEVE:
	cli

	mov	eax,cr0		;set PE bit
	or	eax,1
	mov	cr0,eax

	db	0eah		;goto protect mode
	dw	280h
	dw	offset gdt_code32-gdttbl	;selector

;
; get a sieved result
;
; command#=3
;                    !! not used now !!
SIEVE_ANS:
	retf

;
; set sieve start adr R1,R2 for each prime
;
; command#=1

SETR1R2:
	;set parameter

	mov	ax,_memoseg
	mov	es,ax

	;store A2 by 32bit form

	lds	si,dword ptr cs:[A2_OFF]
	mov	di,_A2R
	lodsw
	and	ax,7fffh
	mov	cx,ax
	inc	ax
	shr	ax,1
	stosw
	xor	ax,ax
	stosw
	rep	movsw
	stosw

	;store B by 32bit form

	lds	si,dword ptr cs:[B_OFF]
	mov	di,_BR
	lodsw
	and	ax,7fffh
	mov	cx,ax
	inc	ax
	shr	ax,1
	stosw
	xor	ax,ax
	stosw
	rep	movsw
	stosw

	cli

	mov	eax,cr0		;set PE bit
	or	eax,1
	mov	cr0,eax

	db	0eah		;goto protect mode
	dw	100h
	dw	offset gdt_code32-gdttbl


gdtaddr	label	qword
	dw	4*8		;size of GDT table
	dd	?
	dw	0


	; fcse[u

gdttbl	label	dword
gdt_null	descriptor <,,,,,>
gdt_code32	descriptor <0ffffh,,,code_seg_access,0cfh,0>
gdt_data32	descriptor <0ffffh,0,0,data_seg_access,0cfh,0>
gdt_code16	descriptor <0ffffh,,,code_seg_access,80h,0>


	;
	; * Initialize again
	; command#=11

initmpqs2:

	; check memory size

	mov	eax,19510721h
	mov	ebx,0ffffch
initmpqs210:
	add	ebx,100000h
	mov	fs:[ebx],eax
	cmp	fs:[ebx],eax
	je	initmpqs210
	sub	ebx,0ffffch
	sub	ebx,fs:[_sievetop]
	mov	eax,fs:[_sievewidth]
	shl	eax,2
initmpqs220:
	shr	eax,1
	cmp	eax,ebx
	ja	initmpqs220

	mov	fs:[_sieveBsize],eax
	add	eax,fs:[_sievetop]
	mov	fs:[_sieveover],eax

	mov	eax,fs:[_sieveBsize]
	sub	eax,fs:[_sievetop]
	mov	fs:[_sieveConst],eax

	mov	eax,fs:[_sieveBsize]
	shr	eax,sieveRepLog
	mov	fs:[_sieveXsize],eax

	xor	edx,edx
	mov	eax,fs:[_sievewidth]
	shl	eax,1
	div	fs:[_sieveBsize]
	mov	bx,AR0
	mov	cs:[bx],ax		;loop time

	retf


code	ends
end	start
