/*
 * Routines dealing with getting input from the keyboard (i.e. from the user).
 */

#include "less.h"

extern int kill_char;

#ifndef TURBOC

#if __MSDOS__
#include <io.h>
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#endif

static int tty;

/*
 * Open keyboard for input.
 */
	public void
open_getchr()
{
#if __MDDOS__
	/*
	 * Open a new handle to CON: in binary mode 
	 * for unbuffered keyboard read.
	 */
	tty = open("CON", O_RDONLY|O_BINARY);
#else
	/*
	 * Try /dev/tty.
	 * If that doesn't work, use file descriptor 2,
	 * which in Unix is usually attached to the screen,
	 * but also usually lets you read from the keyboard.
	 */
	tty = open("/dev/tty", 0);
	if (tty < 0)
		tty = 2;
#endif
}

/*
 * Get a character from the keyboard.
 */
	public int
getchr()
{
	char c;
	int result;

	do
	{
		result = iread(tty, &c, sizeof(char));
		if (result == READ_INTR)
			return (READ_INTR);
		if (result < 0)
		{
			/*
			 * Don't call error() here,
			 * because error calls getchr!
			 */
			quit(1);
		}
#if __MSDOS__
		/*
		 * In raw read, we don't see ^C so look here for it.
		 */
		if (c == kill_char)
			raise(SIGINT);
#endif
		/*
		 * Various parts of the program cannot handle
		 * an input character of '\0'.
		 * If a '\0' was actually typed, convert it to '\200' here.
		 */
		if (c == '\0')
			c = '\200';
	} while (result != 1);

	return (c);
}
#else /* TURBOC */

#include <dos.h>
#include <signal.h>

/*
 * Open keyboard for input.
 */
	public void
open_getchr()
{
}

/*
 * Get a character directly from the PC BIOS.
 */
	public int
getchr()
{
	int c;
 	static int extrac = 0;
 
 	if (extrac) {
 		c = extrac;
 		extrac = 0;
 		return c;
 	}
 	flush ();
 	do {
 		asm {
 			mov	ah,0	/* call:  BIOS read char into ax */
 			int	16h
 		}
		c = _AX;
		if (c == 0) {
			raise (SIGINT);
			c = kill_char;
		} else {
			extrac = c >> 8;
			if (c &= 0xff)
				extrac = 0;
			else
				c = '\200';
		}
 	} while (c == 0);
	return c;
}
#endif	/* TURBOC */
