NAME
        diff3 -- line-by-line three-way file comparison.

SYNOPSIS
        diff3 [options] mine older yours

DESCRIPTION
        The files to compare are mine, older, and yours.  This
        command is useful for comparing two peoples' changes to
        the same base file.  At most one of these three file names
        may be -, which tells diff3 to read the standard input for
        that file.

        With no options, the output indicates where the files differ
        by using the flags
		====  All files differ,
		====1 File one (mine) differs,
		====2 File two (older) differs,
		====3 File three (yours) differs,
        and line-editor style indications of where to change and
        append lines.

        An exit status of 0 means the files are the same, 1 means
        some conflicts were found, and 2 means trouble (missing or
        inaccessible file, or system error).

OPTIONS
        Most options are concerned with creating ed(1) scripts that
        incorporate changes from among the files.  Especially note
        the -m option, which bypasses ed.  Variations such as -e vs
        -E have to do with giving precedence to one file (usually the
        third) in case of conflicting changes, as opposed to indicating
        the conflict in brackets.  Multiple single letter options
        (unless they take an argument) can be combined into a single
        command line argument.

    -A
        Incorporate all changes from older to yours into mine,
        surrounding all conflicts with bracket lines.

    -e, --ed
        Generate an ed script that incorporates all the changes
        from older to yours into mine.  Thus your changes have
        precedence over mine where there are conflicts.

    -E
        Like -e, except bracket lines from conflicting changes in
        the first and third files.  With -E, conflicting changes
        look like this:
                        <<<<<<< mine
                        lines from mine
                        =======
                        lines from yours
                        >>>>>>> yours

    -i
        Generate w and q commands at the end of the ed script
        for System V compatibility.  This option must be combined
        with one of the -AeExX3 options, and may not be combined
        with -m.

    -m, --merge
        Apply the edit script to the first file and send the result
        to standard output.  Unlike piping the output from diff3 to
        ed, this works even for binary files and incomplete lines.
        -A is assumed if no edit script option is specified.

    --show-all
        Incorporate all unmerged changes from older to yours into
        mine, surrounding all overlapping changes with bracket
        lines.

    --show-overlap
        Like -e, except bracket lines from overlapping changes'
        first and third files.

    -x, --overlap-only
        Like -e, except output only the overlapping changes.
        (Those where all three files differ.)

    -X
        Like -E, except output only the overlapping changes.
        In other words, like -x, except bracket changes as in -E.

    -3, --easy-only
        Like -e, except output only the nonoverlapping changes.
        (Changes you made that don't conflict with mine.)


OTHER OPTIONS

    -a, --text
        Treat all files as text and compare them line-by-line,
        even if they do not appear to be text.

    -L label, --label=label
        Use the label label for the brackets output by the -A,
        -E and -X options.  This option may be given up to three
        times, one for each input file.  The default labels are
        the names of the input files.  Thus diff3 -L X -L Y -L Z
        -m A B C acts like diff3 -m A B C, except that the output
        looks like it came from files named X, Y and Z rather than
        from files named A, B and C.

    -v, --version
        Output the version number of diff3.


SEE ALSO
        cmp(1), diff(1), ed(1).

NOTES
     1. Given the number of options that favor changes in "yours"
        over "mine", you might want to think of them the other way
        around when you give yourself precedence.
     2. For more information see ``Comparing and Merging Files''
        by D MacKenzie, P Eggart, and R Stallman.  This manual page
        is derived from section 13 (Invoking diff3) of edition 1.1 for
        diff 2.1 and associated programs (January 1983).
