-------------------------- TVBUGS.CPP --------------------------

             Borland Turbo Vision (C++) Bug/Enhancement List


Last Updated: 25 may 93

Maintained by: Marc Stern
               stern@mble.philips.be



*** This list is C++ TurboVision (TV) specific.
For a Pascal specific buglist, see the file
\turbo-vision\pascal\tvbugs.pas maintained by
Brad Williams (bwilliams@marvin.ag.uidaho.edu)
on this ftp site.
All bugs and fixes presented have been discussed 
on the listserv TurbVis.           

This list contains bug fixes and enhancements to the TV sources.
These enhancements are obviously subjective and rely most of the time
on personal feelings of the posters about the look and feel of their
applications.


*** This is an unofficial list and is not a substitute for
*** Borland Technical or Customer Support which can be reached at
*** 800-331-0877 for registered Borland product owners.  Borland
*** customer on-line service can be reached at
***
***           customer-support@borland.com
***
*** Online technical support is not available.  Borland's internet
*** address for reporting bugs is
*** 
***               bugs@borland.com

All submissions determined to be "true" bugs will be forwarded
to Borland.  The maintainer of this list, the authors of bug
fixes, the TurbVis listserv and the ftp site are not responsible
for the reliability of any information presented in this document or
consequences that may result from their use.

*** Always make a backup of the source code file under a new name
*** prior making any changes to the original file.

Send all comments about bugs you have discovered and any
patches to the maintainer of this list or to the TurbVis
listserv for discussion.  Please include a description of the
problem you are having, a small section of source code which
will duplicate the problem when compiled/run, and all
suggestions for improvement of current patches are appreciated.


How to Use This List
--------------------
At the beginning of this list is an index of new problems/questions 
or changes to old problems/enhancements/questions in reverse
chronological order.
This facilitates quick review for changes from previous additions.
Following is the list of problems/enhancements/questions about bugs in TV.
They are discussed and source code patches referenced where available.  
All source code patches in this file are placed at the end in alphabetic
order according to the reference name.
Reference name is usually a function name or a object::function name,
but it can be a general topic name such as Help, System Error Messages,...

Example: Help
         MessageBox
         System Error Messages
         TInputLine::handleEvent
         TParamText::setData
         TWindow::handleEvent

If extensive files are required, the individual file will be
referenced under the appropriate problem/question.

There are two possible methods for searching this document, by
topic under the PROBLEMS/ENHANCEMENTS/QUESTIONS section or by function
(or object::method) name under the PATCHES section.
All PROBLEMS/ENHANCEMENTS/QUESTIONS and PATCHES are cross-referenced.
If you do not find the topic/patch in one list, check the other.
If you still cannot find a solution look at the FAQ (TVCPP.FAQ) 
posted at this site. If you still cannot determine a solution to
your problem, post a message to the listserv TurbVis.

---------------------------------------------------------------
       CHRONOLOGICAL INDEX OF CHANGES TO THIS DOCUMENT
---------------------------------------------------------------
25 may 1993

   Selection - 2
   System Error Messages - 1, 2, 3
   TDirCollection - 1
   TFileDialog - 1
   TListViewer - 1, 2
   TResourceFile - 1
   TView - 1
   TWindow - 2


5 may 93 - First edition of this list

   Help - 1, 2
   MessageBox - 1, 2, 3
   System Error Messages - 1, 2
   TEditor - 1
   TGroup - 1
   TInputLine - 1
   TParamText - 1
   TWindow - 1

---------------------------------------------------------------
                   PROBLEMS / ENHANCEMENTS / QUESTIONS
---------------------------------------------------------------

Help
----

1. Problem - Compilation error when using streams with help.
   Version  : 1.03
   Patch: See Help-1

2. Problem - Highlighted items no more displayed in highlight
             when scrolling in a help window longer than one screen.
   Version  : 1.03
   Patch: Not known


MessageBox
----------

1. Problem - Strange effects, memory garbage
   Version  : 1.03
   Patch: see MessageBox-1

2. Enhancement - Automatically adapt box size to message length
   Version  : 1.03
   Patch: see MessageBox-2

3. Enhancement - Automatically center 'OK/Cancel' buttons
   Version  : 1.03
   Patch: see MessageBox-3


min/max
-------

1. Problem - error when using min/max with different type variables
             than int.
   Version  : 1.03
   Patch: see min/max-1


Selection
---------

1. Problem (feature?) - When a control is unselectable, it can be selected
                        by selection its associated label.
   Version  : 1.03
   Patch: see Selection-1      


System Error Messages
---------------------

1. Problem - Wrong system error messages
   Version  : 1.03
   Patch: See System-1

2. Enhancement - Drive letter in uppercase
   Version  : 1.03
   Patch: See System-2

3. Problem - Does not handle error codes greater than 14
             (usually network error codes,...)
   Version  : 1.03
   Patch: See System-3


TDirCollection
--------------

1. Problem - If current drive is invalid (no floppy, network disconnected,...)
             when trying to change directory (TChDirDialog), after hitting
             Escape twice, the directory field on screen contains garbage.
   Version  : 1.03
   Patch: See TDirCollection-1


TEditor
-------

1. Problem - Fails sometimes to find next word
   Version  : 1.03
   Patch: see TEditor-1


TFileDialog
-----------

1. Problem - error in validation :
             cmValid is not checked in base class TDialog
   Version  : 1.03
   Patch: See TFileDialog-1


TGroup
-------

1. Enhancement - Check if focus has actually been released
                 (if disabled in a derived class for example).
   Version  : 1.03
   Patch: See TGroup-1


TInputLine
----------

1. Problem - In overwrite mode:
             Selection is not deleted when typing a new character
             At the end of the line, strange characters may be added.
   Version  : 1.03
   Patch: see TinputLine-1


TListViewer
-----------

1. If a TListViewer has no scrollbar, the view is never redrawed.
   Version  : 1.03
   Patch: See TListViewer-1


2. Double-click in a TListViewer does not select the item.
   Version  : 1.03
   Patch: See TListViewer-2


TParamText
----------

1. Problem - Displays garbage with format where sizeof() != 4
   Version  : 1.03
   Patch: see TParamText-1

         
TResourceFile
-------------

1. Problem - 32 bytes memory loss every time a TResourceFile
             is instantiated and destroyed.
   Version  : 1.03
   Patch: see TResourceFile-1


TView
-----

1. Problem - If changing the sfVisible state of ANY view inside a TDialogBox,
             the focused view is reset.
   Version  : 1.03
   Patch: see TView-1


TWindow
-------

1. Enhancement - Allow use of arrows like Tab/shift-Tab
                 (if no other meaning - like in TRadioButton,...)
   Version  : 1.03
   Patch: See TWindow-1


2. Problem - If valid(cmClose) returns False, the frame is lost.
   Version  : 1.03
   Patch: See TWindow-2
          

---------------------------------------------------------------
                          PATCHES
---------------------------------------------------------------
File     : HELP.H
Version  : 1.03
Reference: Help-1
Type     : Bug
Patch    :

  - add   '#define Uses_fpstream'   before   'include <tv.h>'

---------------------------------------------------------------
Function : inputBox, inputBoxRect
File     : MSGBOX.CPP
Version  : 1.03
Reference: MessageBox-2
Type     : Enhancement
Patch    :

 in inputBox(): 
  - change   TRect r(0, 0, 60, 8);
    into     ushort len;
             len = max( strlen(aLabel) + 9 + limit, strlen(Title) + 11 );
             len = min( len, 60 );
             len = max( len , 24 );
             TRect r(0, 0, len, 8);

 in inputBoxRect(): 
  - change   TRect( 4 + strlen(aLabel), 2, dialog->size.x - 3, 3 );
    into     uchar x = 4 + strlen( aLabel );
             r = TRect( x, 2, min(x + limit + 2, dialog->size.x - 3), 3 );


---------------------------------------------------------------
Function : inputBoxRect
File     : MSGBOX.CPP
Version  : 1.03
Reference: MessageBox-3
Type     : Enhancement
Patch    :

 in inputBoxRect():
  - change   r = TRect( dialog->size.x - 24, dialog->size.y - 4,
                        dialog->size.x - 14 , dialog->size.y - 2);
    into     r = TRect( dialog->size.x / 2 - 11, dialog->size.y - 4,
                        dialog->size.x / 2 - 1 , dialog->size.y - 2);

---------------------------------------------------------------
Function : messageBoxRect, messageBox
File     : MSGBOX.CPP
Version  : 1.03
Reference: MessageBox-1
Type     : Bug
Patch    :

 in messageBoxRect() and messageBox():
  - add   'va_end( argptr );'   before   'return'

  - change   va_start( argptr, aOptions );
    into     va_start( argptr, fmt );

---------------------------------------------------------------
Function : min/max
File     : UTIL.H
Version  : 1.03
Reference: min/max-1
Type     : Bug
Poster   : Vincent Van Den Berghe - Windows/DOS developer's journal April 93
Patch    :

  - change   inline int min/max( int a, int b )
    into     template <class T> inline T min/max( const T &a, const T &b )

---------------------------------------------------------------
Function : TLabel::handleEvent
File     : TLABEL.CPP
Version  : 1.03
Reference: Selection-1
Type     : Bug
Patch    :

  - change   if ( link != 0 )
    into     if ( link && (link->options & ofSelectable) && !(link->state & sfDisabled) )

  Warning: Change this in two lines (84, 96)

---------------------------------------------------------------
Function : TSystemError::sysErr
File     : TVTEXT2.CPP
Version  : 1.03
Reference: System-1
Type     : Bug
Patch    :

 in TVTEXT2.CPP:
  - change   const char * const near TSystemError::errorString[] =
             {
             ...
             }

    into     const char * const near TSystemError::errorString[] =
             {
              "Disk is write-protected in drive %c",
              "Critical disk error on drive %c",     // unknown unit
              "Disk is not ready in drive %c",
              "Critical disk error on drive %c",     // unknown command
              "Data integrity error on drive %c",    // bad CRC
              "Critical disk error on drive %c",     // bad request
              "Seek error on drive %c",
              "Unknown media type in drive %c",
              "Sector not found on drive %c",
              "Printer out of paper",
              "Write fault on drive %c",
              "Read fault on drive %c",
              "General failure on drive %c",
              "Bad memory image of FAT detected",
             }


---------------------------------------------------------------
Function : TSystemError::sysErr
File     : SYSERR.CPP
Version  : 1.03
Reference: System-2
Type     : Enhancement
Patch    :

 - in TSystemError::sysErr():

   change    sprintf( s, errorString[errorCode], drive + 'a' );
   into      sprintf( s, errorString[errorCode], drive + 'A' );

---------------------------------------------------------------
Function : TSystemError::sysErr
File     : SYSERR.CPP
Version  : 1.03
Reference: System-3
Type     : Bug
Patch    :

   change    sprintf( s, errorString[errorCode], drive + 'A' );

   into      if ( errorCode < sizeof(errorString) / sizeof(*errorString) )
                sprintf( s, errorString[errorCode], drive + 'A' );
             else
                sprintf( s, "Critical error %d on drive %d", errorCode, drive + 'A' );

---------------------------------------------------------------
Function : TDirCollection::getCurDir
File     : TDIRCOLL.CPP
Version  : 1.03
Reference: TDirCollection-1
Type     : Bug
Patch    :
        
   after    dir[0] = ...
            dir[1] = ':';
            dir[2] = '\\';

   add      dir[3] = '\0';

---------------------------------------------------------------
Function : TEditor::nextWord
File     : TEDITOR2.CPP
Version  : 1.03
Reference: TEditor-1
Type     : Bug
Patch    :

 ushort TEditor::nextWord( ushort p )
 {
  if ( isWordChar(bufChar(p)) )
     while ( p < bufLen && isWordChar(bufChar(p)) ) p = nextChar(p);
  else p = nextChar(p);

  while( p < bufLen && ! isWordChar(bufChar(p)) ) p = nextChar(p);

  return p;
 }

---------------------------------------------------------------
Function : TFileDialog::valid
File     : TFILDLG.CPP
Version  : 1.03
Reference: TFileDialog-1
Type     : Bug
Poster   : Vincent Van Den Berghe - Windows/DOS developer's journal April 93
Patch    :

 - change   if( command == 0 )
                return True;

            if( TDialog::valid( command ) )
                {
                ...
                }

   into     if ( ! TDialog::valid( command ) ) return False;
            if ( command == cmValid ) return True;

            {
            ...
            }

 - or, to better structure the code:

Boolean TFileDialog::valid(ushort command)
{
 if ( ! TDialog::valid( command ) ) return False;
 if ( command == cmValid || command == cmCancel || command == cmFileClear ) 
    return True;

 char fName[MAXPATH], drive[MAXDRIVE], dir[MAXDIR], name[MAXFILE], ext[MAXEXT];

 getFileName( fName );

 if ( isWild(fName) )
    {
     fnsplit( fName, drive, dir, name, ext );
     char path[MAXPATH];
     strcpy( path, drive );
     strcat( path, dir );
     if ( checkDirectory(path) )
        {
         delete (char *)directory;
         directory = newStr( path );
         strcpy( wildCard, name );
         strcat( wildCard, ext );
         if ( command != cmFileInit ) fileList->select();
         fileList->readDirectory( directory, wildCard );
        }  
     return False;
    }             

 if ( isDir(fName) )
    {
     if ( checkDirectory(fName) )
        {
         delete (char *)directory;
         strcat( fName, "\\" );
         directory = newStr( fName );
         if ( command != cmFileInit ) fileList->select();
         fileList->readDirectory( directory, wildCard );
        }
     return False;
    }

 if ( validFileName(fName) ) return True;

 messageBox( invalidFileText, mfError | mfOKButton );
 return False;
}

---------------------------------------------------------------
Function : TGroup::setCurrent
File     : TGROUP.CPP
Version  : 1.03
Reference: TGroup-1
Type     : Enhancement
Patch    :

  - after    focusView( current, False );
    add      // Test if focus lost was allowed and focus has really been loose
             if ( current && (current->state & sfFocused) )
                {
                 unlock();
                 return;
                }

 for coherency:
  - replace   if( (state & sfFocused) != 0 && p != 0 )
                p->setState( sfFocused, True );

    by        focusView( p, True);


---------------------------------------------------------------
Function : TInputLine::handleEvent
File     : TINPUTLI.CPP
Version  : 1.03
Reference: TInputLine-1
Type     : Bug
Patch    :

 line 244:
  - change   if( (state & sfCursorIns) != 0 )
               strcpy( data + curPos, data + curPos + 1 );
             else
               deleteSelect();

    into     deleteSelect();
             if ( (state & sfCursorIns) && (curPos < strlen(data)) )
                strcpy( data + curPos, data + curPos + 1 );


---------------------------------------------------------------
Function : TListViewer::focusItem, TListViewer::setRange
File     : TLSTVIEW.CPP
Version  : 1.03
Reference: TListViewer-1
Type     : Bug
Poster   : Vincent Van Den Berghe - Windows/DOS developer's journal April 93
Patch    :
                   
  - in focusItem:
    change   if( vScrollBar != 0 )
                 {
                 if( focused > aRange )
                     focused = 0;
                 vScrollBar->setParams( ... );
                 }

    into     if( focused > aRange ) focused = 0;
             if( vScrollBar != 0 )
                 vScrollBar->setParams( ... );
             else drawView();

  - in setRange:
    change   if( vScrollBar != 0 )
                 vScrollBar->setValue( item );

    into     if( vScrollBar != 0 )
                 vScrollBar->setValue( item );
             else drawView();

---------------------------------------------------------------
Function : TListViewer::handleEvent
File     : TLSTVIEW.CPP
Version  : 1.03
Reference: TListViewer-3
Type     : Bug
Poster   : Vincent Van Den Berghe - Windows/DOS developer's journal April 93
Patch    :

  - after the do-while loop, suppress
          if( event.mouse.doubleClick && range > focused )
              selectItem( focused );

  - before 'mouse = makeLocal( event.mouse.where );', add:
          if( event.mouse.doubleClick && range > focused )
              {
               selectItem( focused );
               break;
              }

---------------------------------------------------------------
Function : TParamText::setData
File     : TPARAMTE.CPP
Version  : 1.03
Reference: TInputLine-1
Type     : Bug
Patch    :

  - change   paramList = &rec;
    into     paramList = rec;

---------------------------------------------------------------
Function : TResourceFile::TResourceFile
File     : TRESFILE.CPP
Version  : 1.03
Reference: TResourceFile-1
Type     : Bug
Patch    :

  - add at the last line of the function (before returning):
    delete( header );

---------------------------------------------------------------
Function : TSystemError::sysErr
File     : SYSERR.CPP
Version  : 1.03
Reference: System-2
Type     : Enhancement
Patch    :

  - change   drive + 'a'
    into     drive + 'A'

---------------------------------------------------------------
Function : TView::setState
File     : TVIEW.CPP
Version  : 1.03
Reference: TView-2
Type     : Bug
Poster   : Vincent Van Den Berghe - Windows/DOS developer's journal April 93
Patch    :

 - change  if( (options & ofSelectable) != 0 )
   into    if( (options & ofSelectable) && !enable && owner->current == this )

---------------------------------------------------------------
Function : TWindow::handleEvent
File     : TWINDOW.CPP
Version  : 1.03
Reference: TWindow-1
Type     : Enhancement
Patch    :

  -  after    case  kbTab:
     add      case  kbDown:
              case  kbRight:

     after    case  kbShiftTab:
     add      case  kbUp:
              case  kbLeft:

---------------------------------------------------------------
Function : TWindow::close
File     : TWINDOW.CPP
Version  : 1.03
Reference: TWindow-2
Type     : Bug
Poster   : Vincent Van Den Berghe - Windows/DOS developer's journal April 93
Patch    :

void TWindow::close()
{
    if ( valid( cmClose ) )
       {
        frame = 0;  // so we don't try to use the frame after it's been deleted
        destroy( this );
       }
}


--------------------------------------------------------------------
Marc Stern                         Computer Engineer
Av. de la Basilique 386 - 19       Phone:    (322) 525.63.32
1080 Bruxelles                     FAX:      (322) 525.66.00
BELGIUM                            Internet: stern@mble.philips.be

 ################################################################
 #                                                              #
 # Announce:   TVTOOLS  -  general-purpose Turbo-Vision Tools   #
 #                         (library, sources and documentation) #
 #                                                              #
 # All this stuff is free.    Available as TVTOOL14.ZIP         #
 ################################################################
