/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#if defined( Uses_TComboBox ) && !defined( __TComboBox )
#define __TComboBox


class TComboBox : public TView
{
protected:
           char *icon;
           TInputLine  *link;
           TGenCollection *list;

public:
           TComboBox( const TRect&, TInputLine *, TGenCollection * );
           TComboBox( TInputLine *, TGenCollection * );

           virtual void initBox( TInputLine *, TGenCollection * );

           virtual void draw();
           TPalette& getPalette() const;
           virtual void handleEvent( TEvent& event );
           void shutDown();
};


class TComboViewer : public TListViewer
{
protected:
           TGenCollection *list;

public:
           TComboViewer( const TRect&, TGenCollection*, TScrollBar* );

           TPalette& getPalette() const;
           virtual void getData( void * );
           virtual void getData( char *, short, short );
           virtual void getText( char *, short, short );
           virtual void handleEvent( TEvent& );
           virtual void newList( TGenCollection * );
           virtual void setData( void * );
           void shutDown();
};


class TComboWindow : public TWindow
{
protected:
           TComboViewer *viewer;

public:
           TComboWindow( const TRect&, TGenCollection* );

           TPalette& getPalette() const;
           void getSelection( char * );
           virtual void handleEvent( TEvent& );
};

#endif
