/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TStaticText
#define Uses_TStaticTextf
#define Uses_opstream
#define Uses_ipstream
#include "tvtools.h"

#include <stdio.h>
           
const char * const near TStaticTextf::name = "TStaticText";


void TStaticTextf::init( const char *fmt, va_list arglist )
{ char buffer[256];
  vsprintf( buffer, fmt, arglist );
  delete (char *)text;
  (char *)text = strdup( buffer );
}

TStaticTextf::TStaticTextf( const TRect& bounds, const char *fmt, ... ) :
              TStaticText( bounds, "" )
{
  init( fmt, ... );
}

TStaticTextf::TStaticTextf( const ushort x, const ushort y, const char *fmt, ... ) :
              TStaticText( TRect(0,0,0,0), "" )
{
  init( fmt, ... );
  changeBounds( TRect((x),(y),(x)+strlen(text)+1,(y)+1) );
}

void TStaticTextf::write( opstream& os )
{
    TView::write( os );
    os.writeString( text );
}

void *TStaticTextf::read( ipstream& is )
{
    TView::read( is );
    text = is.readString();
    return this;
}

TStreamable *TStaticTextf::build()
{
    return new TStaticTextf( streamableInit );
}

TStaticTextf::TStaticTextf( StreamableInit ) : TStaticText( streamableInit )
{
}


