/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TWindow
#define Uses_TDeskTop
#define Uses_TProgram
#include "tvtools.h"


/***
 *
 *  Function   :    execDialog
 *
 *  Topics     :    Execute a dialog box and returns entered values.
 *
 *  Decisions  :    Fields are pre-loaded with data values.
 *                  If data is NULL, nothing is pre-loaded nor returned.
 *                  If the dialog is cancelled, data is not modified.
 *                  Dialog is destroyed before exiting.
 *
 *  Parameters :    in          TWindow *d      dialog object
 *                  in/out      void    *data   data
 *
 *  Return     :    command (cmCancel, cmYes,...)
 *
 ***/

ushort execDialog( TWindow *d, void *data )
{
  if ( ! TProgram::application->validView(d) ) return cmCancel;

  if ( data ) d->setData( data );
  ushort result = TProgram::application->deskTop->execView( d );
  if( result != cmCancel && data ) d->getData( data );
  TObject::destroy( d );
  return result;
}




