(* This is a test program for the TSUNTI.TPU unit 6-Aug-90,
   23-Jan-93

IMPORTANT ADVICE: Study these tests and the information in TSUNTI.INT
carefully before writing your own applications. The routines in the
TSUNTI.TPU unit are much more complicated than any of the others.

*)

uses Dos,
     TSUNTI
     {$IFDEF VER40}
     ,TSUNT45
     {$ENDIF}
     ;

procedure LOGO;
begin
  writeln;
  writeln ('TSUNTI unit test by Prof. Timo Salmi, 23-Jan-93');
  writeln ('University of Vaasa, Finland, ts@chyde.uwasa.fi');
{$IFDEF VER40}
  writeln ('TP version 4.0');
{$ENDIF}
{$IFDEF VER50}
  writeln ('TP version 5.0');
{$ENDIF}
{$IFDEF VER55}
  writeln ('TP version 5.5');
{$ENDIF}
{$IFDEF VER60}
  writeln ('TP version 6.0');
{$ENDIF}
{$IFDEF VER70}
  writeln ('TP version 7.0');
{$ENDIF}
  writeln;
end;  (* logo *)

(* Get the number of times this program has been run since last
   compiled. Run this test a few times, and see the count increase *)
procedure TEST1;
var status : string;
    count  : longint;
begin
  USECOUNT (count, status);
  if status = '' then
    writeln ('This program has been run ', count, ' times since compilation')
  else
    writeln ('Status of usecount ', status);
end;  (* test1 *)

(* Get the number of times this program has been run since last compiled.
   Run this test a few times, and see the counter increase. Then recompile,
   and see the counter being initialized. Nifty, isn't it. *)
procedure TEST2;
const counter : longint = 0;
var status : word;
begin
  counter := counter + 1;
  BRANDEXE (counter, SizeOf(counter), status);
  if status <> 0 then
    begin writeln ('Error status = ', status); exit; end;
  writeln ('Counter = ', counter);
end;  (* test2 *)

(* Here is a more complicted test of BRANDEXE usage. Study it carefully,
   and try out your own variations *)
procedure TEST3;
type MyInfoType = record
                    counter   : longint;
                    hour      : word;
                    minute    : word;
                    second    : word;
                    sec100    : word;
                  end;
const MyInfo
      : MyInfoType
      = (counter : 0;  { These initial values are changed by BRANDEXE. }
         hour    : 0;  { The next time you run this program, the branded }
         minute  : 0;  { values will have replaced these zeros in the .exe }
         second  : 0;
         sec100  : 0);
var status : word;
    hh, mm, ss, s100 : word;
begin
  {... This shows how the counter is used now, but let's comment it away
       this time and concentrate on the run-last-time test ...}
  {
  myinfo.counter := myinfo.counter + 1;
  BRANDEXE (MyInfo, SizeOf(MyInfo), status);
  if status <> 0 then
    begin writeln ('Error status = ', status); exit; end;
  writeln ('Counter = ', myinfo.counter);
  }
  {}
  {... This information is taken from within the .exe ...}
  write ('Last run at ', myinfo.hour, ':');
  if myinfo.minute < 10 then write ('0');
  write (myinfo.minute, ':');
  if myinfo.second < 10 then write ('0');
  writeln (myinfo.second);
  {}
  {... Get the current time ...}
  GetTime (hh, mm, ss, s100);
  write ('The time now ', hh, ':');
  if mm < 10 then write ('0');
  write (mm, ':');
  if ss < 10 then write ('0');
  writeln (ss);
  {}
  {... And now store the current time within the .exe as the MyInfo
       initial values ...}
  myinfo.hour := hh;
  myinfo.minute := mm;
  myinfo.second := ss;
  myinfo.sec100 := s100;
  BRANDEXE (MyInfo, SizeOf(MyInfo), status);
  if status <> 0 then
    writeln ('Branding failed, status : ', status);
end;  (* test3 *)

(* How to use the direct checksum *)
procedure TEST4;
type checksumRecordType
        = record
            chksum : longint;
            show   : boolean;
          end;
const checksumRecord
        : checksumRecordType
        = (chksum : 581581;      (* Alter chksum to match your program's *)
           show   : true);       (* Turn false for no display, see below *)
var chksum
      : longint;
begin
  chksum := CHKSUMFN (checksumRecord, SizeOf(checksumRecord));
  if checksumRecord.show then writeln ('CHECKSUM = ', chksum);
  if (chksum <> checksumRecord.chksum) and (chksum <> 0) then
    begin
      {$IFNDEF VER40}
      writeln ('Checksum error in ', paramstr(0));
      {$ELSE}
      writeln ('Checksum error in ', paramstr0);
      {$ENDIF}
    end;
end;  (* test4 *)

(* Main program *)
begin
  LOGO;
  TEST4;
  {}
  {... if you want the rest of the tests, just include them ...}
  {}
  write ('Press <ͼ'); readln;
end.  (* tsunti.tst *)
