{RAT. Mouse Driver. July,1992. By Chaitanya Bannerjee.}
{RAT.  Turbo Pascal Unit.}
{This is a set of macros for the mouse.
When compiled, it is a .TPU file that can be included in your Turbo Pascal 6.0
applications.  It has all the necessary commands for mouse programming.
If you have any questions, please contact me.
If you liked this utility, your contribution of $10 would be greatly
appreciated.  My address is:

Chaitanya Bannerjee
600, east college avenue,
Appleton, WI 54911.

Ph: 414-832 7757.
e-mail : 92231@lawrence.edu
}
unit rat;

{-------------------INTERFACE---------------------}

interface

uses dos;

var regs : registers;

function  GetMouse:boolean;
function  MouseButton : integer;
procedure ShowCursor;
procedure HideCursor;
function  LeftButton:boolean;
function  RightButton:boolean;
function  CentreButton:boolean;
procedure SetMousePosition(row,col:integer);
function  LeftButtonX:integer;
function  LeftButtonY:integer;
function  RightButtonX:integer;
function  RightButtonY:integer;
function  CentreButtonX:integer;
function  CentreButtonY:integer;
procedure DefHorizCur(mini,maxi:integer);
procedure DefVertiCur(mini,maxi:integer);
procedure DefTextCur(start,stop:integer);
procedure LightPenEmulOn;
procedure LightPenEmulOff;
procedure DefMPRatio(horiz,verti:integer);
procedure DefDubSpeed(spd : integer);
function  DSRR:integer;
procedure SetSens(hspd,vspd,dspd:integer);
function  GetSensH : integer;
function  GetSensV : integer;
function  GetSensD : integer;
procedure SetIntR(inrate:integer);
procedure DefDispPage(dp : integer);
function  GetDispPage:integer;
function  Disable : boolean;
procedure Enable;
function  MajorVersion:integer;
function  MinorVersion:integer;
function  MouseIntType:integer;
function  IRQN:integer;
procedure SetGraphicCur(hotspotx,hotspoty:integer;graphptr:pointer);

{------------------IMPLEMENTATION-----------------}

implementation


function GetMouse:boolean;
begin
   regs.ax := $0000;
   intr($33,regs);
   if regs.ax = $0000 then getmouse := false else getmouse := true;
end;

function MouseButton : integer;
begin
   regs.ax := $0000;
   intr($33,regs);
   if getmouse = false then mousebutton := -1;
   if regs.bx = $0000 then mousebutton := 0;
   if regs.bx = $0002 then mousebutton := 2;
   if regs.bx = $0003 then mousebutton := 3;
end;

procedure ShowCursor;
begin
   regs.ax := $0001;
   intr($33,regs);
end;

procedure HideCursor;
begin
   regs.ax := $0002;
   intr($33,regs);
end;

function LeftButton:boolean;
begin
   leftbutton := false;
   regs.ax := $0003;
   intr($33,regs);
   if regs.bx and $1 = 1 then leftbutton := true;
end;

function RightButton:boolean;
begin
   rightbutton := false;
   regs.ax := $0003;
   intr($33,regs);
   if regs.bx and $2 = 2 then rightbutton := true;
end;

function CentreButton:boolean;
begin
   centrebutton := false;
   regs.ax := $0003;
   intr($33,regs);
   if regs.bx and $4 = 4 then centrebutton := true;
end;

procedure SetMousePosition(row,col:integer);
begin
   regs.ax := $0004;
   regs.cx := col*8;
   regs.dx := row*8;
   intr($33,regs);
end;

function LeftButtonX:integer;
begin
   if leftbutton = true then begin
      regs.ax := $0005;
      regs.bx := 0;
      intr($33,regs);
      leftbuttonx := regs.cx div 8;
   end
   else leftbuttonx := -1;
end;

function LeftButtonY:integer;
begin
   if leftbutton = true then begin
      regs.ax := $0005;
      regs.bx := 0;
      intr($33,regs);
      leftbuttony := regs.dx div 8;
   end
   else leftbuttony := -1;
end;

function RightButtonX:integer;
begin
   if rightbutton = true then begin
      regs.ax := $0005;
      regs.bx := 1;
      intr($33,regs);
      rightbuttonx := regs.cx div 8;
   end
   else rightbuttonx := -1;
end;

function RightButtonY:integer;
begin
   if rightbutton = true then begin
      regs.ax := $0005;
      regs.bx := 1;
      intr($33,regs);
      rightbuttony := regs.dx div 8;
   end
   else rightbuttony := -1;
end;

function CentreButtonX:integer;
begin
   if centrebutton = true then begin
      regs.ax := $0005;
      regs.bx := 2;
      intr($33,regs);
      centrebuttonx := regs.cx div 8;
   end
   else centrebuttonx := -1;
end;

function CentreButtonY:integer;
begin
   if centrebutton = true then begin
      regs.ax := $0005;
      regs.bx := 2;
      intr($33,regs);
      centrebuttony := regs.dx div 8;
   end
   else centrebuttony := -1;
end;

procedure DefHorizCur(mini,maxi:integer);
begin
   regs.ax := $0007;
   regs.cx := mini*8;
   regs.dx := maxi*8;
   intr($33,regs);
end;

procedure DefVertiCur(mini,maxi:integer);
begin
   regs.ax := $0008;
   regs.cx := mini*8;
   regs.dx := maxi*8;
   intr($33,regs);
end;

procedure DefTextCur(start,stop:integer);
begin
   regs.ax := $000a;
   regs.bx := $0000;
   regs.cx := start;
   regs.dx := stop;
   intr($33,regs);
end;

procedure LightPenEmulOn;
begin
   regs.ax := $000d;
   intr($33,regs);
end;

procedure LightPenEmulOff;
begin
   regs.ax := $000e;
   intr($33,regs);
end;

procedure DefMPRatio(horiz,verti:integer);
begin
   regs.ax := $000f;
   regs.cx := horiz;
   regs.dx := verti;
   intr($33,regs);
end;

procedure DefDubSpeed(spd : integer);
begin
   regs.ax := $0013;
   regs.dx := spd;
   intr($33,regs);
end;

function DSRR:integer;
begin
   regs.ax := $0015;
   intr($33,regs);
   dsrr := regs.bx;
end;

procedure SetSens(hspd,vspd,dspd:integer);
begin
   regs.ax := $001a;
   regs.bx := hspd;
   regs.cx := vspd;
   regs.dx := dspd;
   intr($33,regs);
end;

function GetSensH : integer;
begin
   regs.ax := $001b;
   intr($33,regs);
   getsensh := regs.bx;
end;

function GetSensV : integer;
begin
   regs.ax := $001b;
   intr($33,regs);
   getsensv := regs.cx;
end;

function GetSensD : integer;
begin
   regs.ax := $001b;
   intr($33,regs);
   getsensd := regs.dx;
end;

procedure SetIntr(inrate:integer);
begin
   regs.ax := $001c;
   regs.bx := inrate;
   intr($33,regs);
end;

procedure DefDispPage(dp : integer);
begin
   regs.ax := $001d;
   regs.bx := dp;
   intr($33,regs);
end;

function GetDispPage:integer;
begin
   regs.ax := $001e;
   intr($33,regs);
   getdisppage := regs.bx;
end;

function Disable : boolean;
begin
   regs.ax := $001f;
   intr($33,regs);
   if regs.ax = $001f then disable := true;
   if regs.ax = $ffff then disable := false;
end;

procedure Enable;
begin
   regs.ax := $0020;
   intr($33,regs);
end;

function MajorVersion:integer;
begin
   regs.ax := $0024;
   intr($33,regs);
   if regs.ax = $ffff then majorversion := -1 else majorversion := regs.bh;
end;

function MinorVersion:integer;
begin
   regs.ax := $0024;
   intr($33,regs);
   if regs.ax = $ffff then minorversion := -1 else minorversion := regs.bl;
end;

function MouseIntType:integer;
begin
   regs.ax := $0024;
   intr($33,regs);
   if regs.ax = $ffff then mouseinttype := -1 else mouseinttype := regs.ch;
end;

function IRQN:integer;
begin
   regs.ax := $0024;
   intr($33,regs);
   if regs.ax = $ffff then irqn:= -1 else irqn:= regs.cl;
end;

procedure SetGraphicCur(hotspotx,hotspoty:integer;graphptr : pointer);
begin
   regs.ax := $0009;
   regs.bx := hotspotx;
   regs.cx := hotspoty;
   regs.es := seg(graphptr);
   regs.dx := ofs(graphptr);
   intr($33,regs);
end;
end.
