{ CUSTOMPA.PAS }
program CustomPattern;

{ Use this program to help you design a custom fill
  pattern. After the 8 x 8 grid displays, you can use
  the arrow keys to navigate to a specific bit, and set
  it to a 1 by pressing the 1 key, or clearing the bit
  by pressing the 0 key. Press the Esc key to terminate
  data entry and a sample filled circle is displayed on
  the screen. Press Enter to return to pattern editing,
  or press Esc key again to terminate the program.
}

uses
  Crt, Graph;

const
  { Key equates for the extended key strokes,
    plus Key0 and Key1 for 0 and 1}
  UpArrow       = 72 shl 8;
  LeftArrow     = 75 shl 8;
  RightArrow    = 77 shl 8;
  DownArrow     = 80 shl 8;
  EscapeKey     = 27;
  Key0          = 48;
  Key1          = 49;

var
  { Parameters to InitGraph }
  GraphDriver : Integer;
  GraphError  : Integer;
  GraphMode   : Integer;
  { Holds the pattern that we are designing }
  UserPattern : FillPatternType;
  { X, Y position in the matrix }
  X, Y	      : Integer;
  { The key that has been pressed }
  KeyCode     : Word;
  F           : File of Byte;

procedure BitPlot (X, Y : Integer; BitValue : Boolean );
{ Displays each bit in the pattern as a 1 or 0,
  on the display }
begin
  GotoXY ( X*4, Y * 1 );
  If BitValue then
    write('1')
  else
    write('0');
end;


procedure DisplayPattern ( APattern : FillPatternType );
{ Displays the entire pattern on the screen }
var
  X, Y : Integer;
begin
  for X := 1 to 8 do
    for Y := 1 to 8 do
    begin
      BitPlot ( X, Y, (APattern[X] and (256 shr Y)) <> 0);
    end;
end;


procedure GetChar ( var Key : Word );
{ Reads a character from the keyboard, placing
  extended bytes into the high byte of the word
  value returned }
begin
  Key := Word( ReadKey );
  if  Key = 0  then
    { Read extended byte character code }
    Key := Word( ReadKey) shl 8;
end;

{$I-}
begin
  Writeln;
  { Set the initial pattern to all 0's (no
    pattern at all) }
  FillChar ( UserPattern, SizeOf ( FillPatternType ), 0 );

  Assign( F, 'PATTERN' );
  Reset ( F );
  if IOResult = 0 then
  begin
    Write('Read in existing PATTERN file (Y/N=Cr)? ');
    GetChar ( KeyCode );
    if (KeyCode = Ord('Y')) or
       (KeyCode = Ord('y'))  then
         for X := 1 to 8 do
           Read(F,  UserPattern[X] );
    Close ( F );
  end;


  { Request autodetection of correct graphics driver }
  GraphDriver := Detect;

  { Initialize graphics system; look for driver files
    in specified directory.  You must change the directory
    to the appropriate directory for you system. }
  InitGraph ( GraphDriver, GraphMode, 'F:\BP\BGI' );

  GraphError := GraphResult;
  if GraphError <> grOk  then
  begin
    Writeln('Error occurred:', GraphErrorMsg(GraphError) );
    Halt(1);
  end;

  { Enter the editing loop }
  repeat
    RestoreCrtMode;

    DisplayPattern ( UserPattern );

    Gotoxy ( 1, 10 );
    Writeln( 'Use arrow keys to navigate.');
    Writeln(
     'Press 1 to set a bit, press 0 to clear a bit.' );
    Writeln( 'Press Esc key to see the result.' );
    Writeln(
     'Press Esc key TWICE to terminate the program');
    X := 1;
    Y := 1;
    repeat
      GotoXY ( X*4, Y * 1);
      GetChar ( KeyCode );
      case KeyCode of
        Key0:
        begin
          write('0');       { Clear the bit }
	  UserPattern[X] :=
	    UserPattern[X] and not (256 shr Y);
        end;
        Key1:
        begin
          write('1');       { Set the bit }
	  UserPattern[X] :=
	    UserPattern[X] or (256 shr Y) ;
        end;
        UpArrow:        if Y > 1 then Dec(Y);
        DownArrow:      if Y < 8 then Inc(Y);
        LeftArrow:      if X > 1 then Dec(X);
        RightArrow:     if X < 8 then Inc(X);
      end;
      Gotoxy ( X*4, Y * 1);
    until KeyCode = EscapeKey;

    { After editing the matrix, return to graphics mode
      and display an object containing the pattern. }
    SetGraphMode ( GetGraphMode );

    { Display prompt }
    SetTextJustify ( LeftText, BottomText );
    SetTextStyle ( DefaultFont, HorizDir, 1 );
    OutTextXY ( 10, GetMaxY - 10,
      'Press Esc key to stop, any other key to continue editing.');

    SetFillPattern ( UserPattern, 3 );
    FillEllipse( GetMaxX div 2, GetMaxY div 2, 75, 75 );

    GetChar( KeyCode );

  until KeyCode = EscapeKey;

  CloseGraph;
  Write('Save pattern to file PATTERN? (Y/N=CR)? ');
  GetChar(KeyCode);
  if (KeyCode = Ord('Y')) or
     (KeyCode = Ord('y'))  then
  begin
    Assign ( F, 'PATTERN' );
    Rewrite( F );
    for X := 1 to 8 do
      Write( F, UserPattern[X] );
    Close ( F );
  end;

end.
