
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0        *
; *     Real Comparison                                 *
; *                                                     *
; *     Copyright (C) 1989-1992 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   FP48CMP

             INCLUDE SE.ASM


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  CmpMantissa,CmpAbsValue,RCmp

;-------------------------------------------------------------------------------
; RealCmp compares two numbers in the TURBO-Pascal six byte real format. The
; flags are set as if two unsigned integers had been compared with the 80x86
; CMP instruction. If op1 > op2, neither carry nor zero flag are set. If
; op1 = op2 then the zero flag is set and if op1 < op2 then the carry flag is
; set. CmpAbsValue is an additional entry to the comparison routine that
; requires that both arguments are positive. Entry CmpMantissa is provided for
; arguments that are both positive and have identical exponents.
;
; INPUT:     DX:BX:AX  first number (op1)
;            DI:SI:CX  second number (op2)
;
; OUTPUT:    CF        set if op1 < op2
;            ZF        set if op1 = op2
;
; DESTROYS:  Flags
;-------------------------------------------------------------------------------

RCmp         PROC    FAR
             XOR     DX, DI            ; sign equal ?
             JNS     $sign_eq          ; yes
             XOR     DX, DI            ; restore DX
             CMP     DI, DX            ; negative number bigger, reverse compare
$exit1:      RET                       ; exit
$sign_eq:    XOR     DX, DI            ; restore DX
             JNS     $cmp_pos          ; compare exponents and mantissas
             CALL    CmpAbsValue       ; call expo. & mant. compare for neg. num
             JZ      $exit1            ; if numbers equal exit
             CMC                       ; else complement carry flag for neg. num
             RET                       ; done
$cmp_pos:    CALL    CmpAbsValue       ; compare two positive numbers
             RET                       ; done
RCmp         ENDP

             ALIGN   4

CmpAbsValue  PROC    NEAR
             CMP     AL, CL            ; compare exponents
             JNZ     $end              ; not equal, ->
             OR      AL, AL            ; equal, but both zero ?
             JZ      $end              ; yes
CmpAbsValue  ENDP

CmpMantissa  PROC    NEAR
             CMP     DX, DI            ; compare
             JNZ     $end              ;  mantissa bytes
             CMP     BX, SI            ;   from msb
             JNZ     $end              ;    to lsb and exit
             CMP     AH, CH            ;     if unequal or all equal
$end:        RET                       ; done
CmpMantissa  ENDP

             ALIGN   4

CODE         ENDS

             END
