; TPDB.asm
; Brian Corll February 17, 1989
; String functions for TPDB.pas
; Public Domain

CODE  SEGMENT BYTE PUBLIC

      Assume CS : CODE

      PUBLIC Replicate,Upper,Lower

; Function Upper(InStr : String) : String;

UpperResult EQU    DWORD PTR [BP+10]
UpperStr    EQU    DWORD PTR [BP+6]


Upper       PROC   FAR

            push bp
            mov  bp,sp
            push ds
            LDS  si,UpperStr
            LES  di,UpperResult
            CLD
            LODSB
            STOSB
            mov  cl,al
            xor  ch,ch
            JCXZ UPPER3

UPPER1:     LODSB
            CMP  al,'a'
            JB   UPPER2
            CMP  al,'z'
            JA   UPPER2
            sub  al,'a'-'A'

UPPER2:     STOSB
            LOOP UPPER1

UPPER3:     pop  ds
            pop  bp
            ret  4

Upper       ENDP


; Function Lower(InStr : String) : String;

LowerResult EQU    DWORD PTR [BP+10]
LowerStr    EQU    DWORD PTR [BP+6]


Lower       PROC   FAR

            push bp
            mov  bp,sp
            push ds
            LDS  si,LowerStr
            LES  di,LowerResult
            CLD
            LODSB
            STOSB
            mov  cl,al
            xor  ch,ch
            JCXZ LOWER3

LOWER1:     LODSB
            CMP  al,'A'
            JB   LOWER2
            CMP  al,'Z'
            JA   LOWER2
            add  al,'a'-'A'

LOWER2:     STOSB
            LOOP LOWER1

LOWER3:     pop  ds
            pop  bp
            ret  4

Lower       ENDP



; Function  Replicate(Ch : Char;Count : word) : String;
RepResult   EQU    DWORD PTR [BP+10]
RepChar     EQU    BYTE  PTR [BP+8]
RepCount    EQU    BYTE  PTR [BP+6]

Replicate   PROC   FAR
            push   bp
            mov    bp,sp

            LES    di,RepResult
            mov    al,RepCount
            CLD
            STOSB
            mov    cl,al
            xor    ch,ch
            mov    al,RepChar
            REP    STOSB
            pop    bp
            ret    4

Replicate   ENDP

CODE        ENDS
            END