{ =========================================================================== }
{ Rate55.pas - Rate timer using only low memory clock.      ver 5.5, 12-01-89 }
{                                                                             }
{ This rate timer is a highly accurate timer based on the low memory clock.   }
{ It is device independent by not accessing any special timer hardware and    }
{ does not use any interrupts.  Accuracy is +-1 repetition.                   }
{                                                                             }
{ This timer is great for timing short events (1 microsecond to .1 second) to }
{ get a Reps-per-second result.  The secret to such great accuracy is keying  }
{ in on the fact that the low memory clock is very accurate and on schedule   }
{ every time it ticks.  So, just make the event work by the clock rather than }
{ vice-versa.                                                                 }
{                                                                             }
{ The timer is set for a 1 second test.  If you can't get enough repetitions  }
{ (>100) to get any resolution, you are free to change TestTime up to 3600    }
{ seconds.                                                                    }
{                                                                             }
{ The timer even accounts for the overhead of the timer itself and any other  }
{ overhead that is a part of your event.  Just insert your code and go.  You  }
{ may experience a litter jitter while running in the integrated environment, }
{ but is solid when run as an executable file.                                }
{   Public Domain by James H. LeMay, Eagle Performance Software               }
{ =========================================================================== }
{$A+,B-,D+,E+,F-,I-,L+,N+,O-,R-,S-,V-}

program RateTimer;

uses
  Crt;

const
  TestTime = 1;  { seconds }
  TicksPerDay = 1573040.0;            { DOS timer ticks/day. }
  TicksPerSec = TicksPerDay/86400.0;

var
  LowClock: word absolute $0000:$046C;
  Tick1,Ticks:           word;
  Reps,OverheadReps:     longint;
  RepsPerSec,TickFactor: real;
  R: real absolute RepsPerSec; { Variable name is easier to Watch }
  { -- Place your variables here: -- }
  S1,S2: string;
  b:     byte;
  L1,L2,L3: longint;

procedure WaitForTick;
begin
  Tick1 := LowClock;
  repeat
  until LowClock<>Tick1;
  Tick1 := LowClock;
end;

procedure RunTime (Seconds: word);
begin
  if Seconds>3600
    then Seconds:=3600;
  Ticks := trunc(Seconds*TicksPerSec);
  TickFactor := Seconds*TicksPerSec/Ticks; { Accounts for trunc of seconds }
  WaitForTick;
end;

procedure Init;
begin
  { ** Initialize any of your variables here: ** }
  S1 := 'Now is the time to check out Eagle Performance Software Products'+
        'for speed tests';
  S2 := S1;
  L1 := 12345678;
  L2 := 100;
end;

procedure ResetVariables;
begin
  { ** Place any variables that need to be reset after each test here: ** }
  { StrMove (S2,S1); }
end;

procedure Test;
begin
  Reps := 0;
  RunTime (TestTime);
  repeat
    { ** INSERT CODE ** }
    { ** Insert your test routine here ** }
    L3 := L1 div L2;
    { ** End of test routine ** }
    ResetVariables;
    inc (Reps);
  until LowClock-Tick1>=Ticks;
end;

procedure OverHead;
begin
  OverHeadReps := 0;
  RunTime (TestTime);
  repeat
    ResetVariables;
    inc (OverHeadReps);
  until LowClock-Tick1>=Ticks;
end;

procedure CalcRate;
begin
  RepsPerSec := TickFactor/((TestTime)*(1.0/Reps-1.0/OverHeadReps));
  WriteLn ('Reps/second = ',RepsPerSec:8:0);
end;

begin
  Init;
  Test;
  OverHead;
  CalcRate;
end.
