(*********************************************)
(*                                           *)
(*     LOOPBACK.PAS      Jan 92              *)
(*                                           *)
(*  Performs UART loopback test.             *)
(*                                           *)
(*  This program is donated to the Public    *)
(*  Domain by MarshallSoft Computing, Inc.   *)
(*  It is provided as an example of the use  *)
(*  of the Personal Communications Library.  *)
(*                                           *)
(*********************************************)

program LoopBack;
uses PCL4P;

const
   BaudCode = Baud300;
var
   Buffer  : array[0..7] of Char;
   RetCode : Integer;
   Port  : Integer;
   Error : Integer;
begin   (* main program *)
   (* fetch PORT # from command line *)
   if ParamCount <> 1 then
      begin
         writeln('USAGE: "LOOPBACK <port>" where port = 1,2,3, or 4');
         halt;
      end;
   Val( ParamStr(1),Port, RetCode );
   if RetCode <> 0 then
      begin
         writeln('Port must be 1 to 4');
         Halt;
      end;
   (* COM1 = 0, COM2 = 1, COM3 = 2, COM4 = 3 *)
   Port := Port - 1;
   if (Port<COM1) or (Port>COM4) then
      begin
         writeln('Port must be 1 to 4');
         Halt
      end;
   (* reset port *)
   RetCode := SioRxBuf(Port, Ofs(Buffer), Seg(Buffer), Size8);
   RetCode := SioReset(Port,BaudCode);
   if RetCode <> 0 then
      begin
         writeln('Cannot reset COM',Port+1,', error = ',RetCode);
         Error := RetCode;
         RetCode := SioError(Error);
         RetCode := SioDone(Port);
         Halt
      end;
   (* Perform UART loopback test *)
   RetCode := SioLoopBack(Port);
   Error := RetCode;
   if RetCode = 0 then writeln('LOOPBACK: Testing COM',1+Port,' -- OK')
   else  RetCode := SioError(Error);
   RetCode := SioDone(Port);
end.
