
program SelfMod;

{
   This demonstrates a technique for creating self-modifying .EXE files. It
   has an advantage over techniques which use typed constants, in that it will
   survive LZEXEC and PkLite(tm).

   Note that if the program is run before LZEXEC is used to compress it, the
   compressed program will not have been initialized. This is because LZEXEC
   strips off the config block (and everything else) at the end of the .EXE
   file. This problem does not occur with PKLite(tm).

   To run the demo, compile the program and execute it twice. Whatever
   string you enter is written to the end of the .EXE file.

   To further demonstrate it's ablities, compress the file with PKLite(tm) or
   LZEXEC after compiling.

   Address all questions and comments to:

              PCkS Associates
              138 Frances Place
              Hillside, NJ 07205

              On CompuServe, EasyPlex to    70152,332
              On Delphi                     CHICKENJN
              On GENie                      J.NICHOLSON1


}



Uses PCkSelfM;

type ConfigBlock = string[40];

var
    MyConfig : ConfigBlock;

begin
if ConfigBlockPresent(SizeOf(ConfigBlock)) then
    if ReadConfigBlock(MyConfig,SizeOf(ConfigBlock)) then begin
        writeln('Old value of MyConfig: ',MyConfig);
        write('Enter new value: ');
        readln(MyConfig);
        if ConfigBlockRewrite(MyConfig,SizeOf(ConfigBlock)) then
            writeln('Rewrote the block.')
        else writeln('ConfigBlockRewrite failed.');
        end
    else writeln('ReadConfigBlock failed')
else begin
    write('Enter inital value for MyConfig: ');
    readln(MyConfig);
    if NewConfigBlock(MyConfig,SizeOf(ConfigBlock)) then
       writeln('Created new config block')
    else writeln('NewConfigBlock failed.');
    end;
end.


