
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 7.0        *
; *     String Deletion                                 *
; *                                                     *
; *     Copyright (C) 1990-1993 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   STDEL


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  SDelete

;-------------------------------------------------------------------------------
; Delete standard procedure: Delete (VAR S: STRING; Index, Count: INTEGER);
;
; Delete deletes Count characters in S, beginning at position Index. The
; algorithm determines if the characters are effectively deleted from the end
; of the string, in which case it simply sets the string length to Index-1. If
; characters are to be deleted from somewhere in the middle of the string, it
; calculates the number of characters in the string after the last deleted one
; and copies these characters to position Index, decrementing the string length
; by Count.
;
; On entry:  [SP+4]  Count
;            [SP+6]  Index
;            [SP+8]  Pointer to S
;-------------------------------------------------------------------------------

SDelete      PROC    FAR
             PUSH    DS                ; save TURBO-Pascal data segment
             MOV     BX, SP            ; make new framepointer
             MOV     CX, SS:[BX+6]     ; CX = count
             MOV     AX, SS:[BX+8]     ; AX = index
             DEC     AX                ; index - 1
             CWD                       ; DX = FFFFh if AX < 0 (else DX = 0)
             AND     DX, AX            ; index ( else 0)
             SUB     AX, DX            ; 0 (else index) = new index
             ADD     DX, CX            ; index + count (else count) = new count
             JLE     $end_del          ; exit, if new count <= 0
             LDS     SI, SS:[BX+10]    ; address of string
             MOV     CL, [SI]          ; length of string
             XOR     CH, CH            ; clear msb of string length
             SUB     CX, AX            ; length - index + 1
             JLE     $end_del          ; exit, if <= 0,
             SUB     CX, DX            ; length-count-index+1 = # chars to move
             JG      $continue         ; continue, if # of chars > 0
             MOV     [SI], AL          ; new length = index - 1
             JMP     $end_del          ; done
$continue:   CLD                       ; auto-increment
             MOV     DI, DS            ; let both segment register
             MOV     ES, DI            ;  hold segment of string
             SUB     [SI], DL          ; new length = length - deleted chars
             ADD     SI, AX            ; char at index
             INC     SI                ;  becomes destination
             MOV     DI, SI            ;   of move
             ADD     SI, DX            ; char behind the last that will be del.
             SHR     CX, 1             ; number of chars to move odd ?
             JNC     $even_del         ; no
             MOVSB                     ; yes, move single char
$even_del:   REP     MOVSW             ; move the rest
$end_del:    POP     DS                ; restore TURBO-Pascal data segment
             RET     8                 ; return and pop parameters
SDelete      ENDP

             ALIGN   4

CODE         ENDS

             END
