
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 7.0        *
; *     Longint Multiplication                          *
; *                                                     *
; *     Copyright (C) 1991-1993 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   LMUL


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  LongMul


;-------------------------------------------------------------------------------
; LongMul computes the product of its arguments, two LONGINT values. No check
; is made if the result overflows the LONGINT format.
;
; INPUT:     DX:AX      multiplicand
;            BX:CX      multiplicator
;
; OUTPUT:    DX:AX      product of multiplicand & multiplicator, if no overflow
;
; DESTROYS:  AX,DX,SI,DI,Flags
;-------------------------------------------------------------------------------

LongMul      PROC    FAR
             MOV     DI, DX            ; save hi-word of multiplicand
             OR      DI, BX            ; both numbers positive and < 65536?
             JZ      $short            ; single multiplication sufficient
             MOV     DI, DX            ; save hi-word of multiplicand
             MOV     SI, AX            ; save lo-word of multiplicand
             MUL     BX                ; multiplicator hi * multiplicand lo
             XCHG    AX, DI            ; save product1 lo, get m'plicand hi
             MUL     CX                ; multiplicator lo * multiplicand hi
             XCHG    AX, SI            ; save procduct2 lo, get m'plicand lo
             ADD     SI, DI            ; add product1 and product2 (result hi)
             MUL     CX                ; multiplicator lo * multiplicand lo
             ADD     DX, SI            ; add product3 hi to result hi
             RET                       ; done
$short:      MUL     CX                ; lo-word m'plicand * lo-word m'plicator
             RET                       ; done
LongMul      ENDP

             ALIGN   4

CODE         ENDS

             END
