
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 7.0        *
; *     Real Int Function                               *
; *                                                     *
; *     Copyright (C) 1989-1993 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   FPINT


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  RInt

;-------------------------------------------------------------------------------
; RInt represents the standard function Int. It computes the integral part of a
; TURBO-Pascal six byte floating point number, the result being a floating point
; number.
;
; INPUT:     DX:BX:AX  floating point number
;
; OUTPUT:    DX:BX:AX  integral part of floating point number
;
; DESTROYS:  AX,BX,CX,DX,SI,DI,Flags
;-------------------------------------------------------------------------------

RInt         PROC    FAR
             CMP     AL, 0A8h          ; is argument > 2^39 ?
             JNB     $no_change        ; yes, return number unchanged
             CMP     AL, 80h           ; argument < 1 ?
             JBE     $res_zero         ; yes, return zero
             MOV     CX, AX            ; save
             MOV     SI, BX            ;  original
             MOV     DI, DX            ;   argument
             CMP     AL, 88h           ; argument >= 2^7 ?
             SBB     DH, DH            ; yes, DH=0 (else DH=FFh)
             CMP     AL, 90h           ; argument >= 2^15 ?
             SBB     DL, DL            ; yes, DL=0 (else DL=FFh)
             CMP     AL, 98h           ; argument >= 2^23 ?
             SBB     BH, BH            ; yes, BH=0 (else BH=FFh)
             CMP     AL, 0A0h          ; argument >= 2^31 ?
             SBB     BL, BL            ; yes, BL=0 (else BL=FFh)
             NOT     DX                ; generate first
             NOT     BX                ;  32 bits of mask
             AND     AX, 7             ; clear LSB of mask, test if 1-bit shift
             JZ      $shiftr_done      ; no further shifting required

             ALIGN   4

$shift_loop: ADD     AL, 0FFh          ; dec. shift counter, set carry flag
             RCR     DX, 1             ; extend mask 1 bit
             RCR     BX, 1             ;  to the
             RCR     AH, 1             ;   right
             JNZ     $shift_loop       ; shift until counter zero
$shiftr_done:AND     DX, DI            ; mask out mantissa
             AND     BX, SI            ;  bits containing
             AND     CH, AH            ;   integral part of number
             XCHG    AX, CX            ; get back exponent
             RET                       ; done
$res_zero:   XOR     AX, AX            ; load
             MOV     BX, AX            ;   a
             CWD                       ;    zero
$no_change:  RET                       ; exit
RInt         ENDP

             ALIGN   4

CODE         ENDS

             END
