{
 This simple program demonstrates the use of the CHAIN unit.
 After compiling DEMO, call it with two command line parameters.
 The first parameter is the full name of the program to execute,
 including extension and path, if any. The second parameter is a
 command line to pass on to the program. Note that only one word
 of the command line is passed on, in the interests of simplicity.

 An interesting case to try is:
   DEMO DEMO.EXE DEMO.EXE
}

program demo;

uses
  chain;

var
  status:word;

begin
  writeln;
  writeln('Turbo Chaining Demonstration, by TurboPower Software');
  if paramcount < 1 then begin
    writeln('Usage: DEMO ProgramToChainTo CommandLineToPass');
    halt;
  end;

  writeln('memavail:',memavail);
  writeln('setting max heap to 20000 bytes');
  setmaxheap(20000);
  writeln('memavail:',memavail);

  status:=chain4(paramstr(1),paramstr(2));
  case status of
    2:writeln('file "',paramstr(1),'" not found');
    8:writeln('insufficient memory');
    30:writeln('error reading ',paramstr(1));
    152:writeln('drive not ready');
  end;
end.
