{$N+,E+}
program Test;
  {-Test ReinitEmulator, etc.}

uses
  tp8087, tpint;

const
  D : Double = 2.0;
var
  I : Word;
  UseIt : Boolean;
  AltStack : array[1..2048] of Byte;

  procedure Dummy(var Regs : IntRegisters);
    {-Dummy routine that uses emulator}
  var
    SB : SaveBuffer8087;
    D : Double;
  begin
    if UseIt then
      {reinitialize emulator}
      ReinitEmulator
    else begin
      {save 8087 registers}
      Save8087(SB);

      {reinitialize 8087}
      Reinit8087;
    end;

    {do some math}
    D := 1.0;
    D := D * 2.0;

    if not UseIt then
      {restore 8087 registers}
      Restore8087(SB);
  end;

  procedure Int1C(BP : Word); interrupt;
    {-Interrupt $1C handler}
  var
    Regs : IntRegisters absolute BP;
  begin
    {switch stacks and call Dummy routine}
    SwapStackAndCallNear(Ofs(Dummy), @AltStack[2048], Regs);
  end;

begin
  UseIt := UseEmulator;
  if UseIt then
    WriteLn('Using emulator...')
  else
    WriteLn('Using 80x87 chip...');

  {install $1C handler}
  if not InitVector($1C, 20, @Int1C) then
    Halt(1);

  WriteLn('Multiplying...');

  for I := 1 to 2000 do
    if D*D <> 4.0 then begin
      WriteLn('Error at ', I);
      Halt(1);
    end;

  WriteLn('Done...');
end.
