/* imag.h - useful declarations for doing imaging
 *
 * made 88-10-31
 */

/*************************** #define's ************************/


/* TAG FIELD INDICES: (not to be confused with actual tag values -- see
 * tiff.h for those).  Also note that I only need define the things that
 * I currently care about, to save a little space.
 *
 * this must be kept in numerical order by tag (see tiff.h), as of 88-10-12,
 * since I am writing them out in the order they appear in the IMAG array.
 */
#define X_NEWSUBFILETYPE		0
#define X_IMAGEWIDTH			1
#define X_IMAGELENGTH			2
#define X_BITSPERSAMPLE			3
#define X_COMPRESSION			4
#define X_PHOTOMETRICINTERP		5
#define X_STRIPOFFSETS			6
#define X_SAMPLES				7	/* SamplesPerPixel */
#define X_ROWSPERSTRIP			8
#define X_STRIPBYTECOUNTS		9
#define X_XRESOLUTION			10
#define X_YRESOLUTION			11
#define X_PLANAR				12	/* PlanarConfiguration */
#define	X_GRAYUNIT				13
#define	X_GRAYCURVE				14
#define X_RESOLUTIONUNIT		15
#define X_COLORCURVES			16
#define	X_PREDICTOR				17	/* 88-09-19 */

#define NTFIELDS				18	/* KEEP THIS CURRENT!!! (one more than largest value) */

/* shorthand ways of getting to field data.  Note:  assumes something has
 * converted if necessary to my standard data type for that field.  See
 * tiff.c for the code that determines the current standard type for each field.
 */
#define dwNewSubfileType			tf[X_NEWSUBFILETYPE].val.Tdword	/* 88-09-12 */

#define iImageWidth					tf[X_IMAGEWIDTH].val.Tword[0]
#define iImageLength				tf[X_IMAGELENGTH].val.Tword[0]
#define iBitsPerSample				tf[X_BITSPERSAMPLE].val.Tword[0]	/* assumes BitsPerSample values are equal! */
#define iSamples					tf[X_SAMPLES].val.Tword[0]			/* SamplesPerPixel */
#define iCompression				tf[X_COMPRESSION].val.Tword[0]
#		define PACKINTOBYTES	1
#		define CCITT1D			2
#		define COMPR5			5
#		define TIFFPACKBITS		32773	/* MacPaint scheme in TIFF file */
#define iPhotometricInterpretation	tf[X_PHOTOMETRICINTERP].val.Tword[0]
#		define WHITEZERO	0
#		define BLACKZERO	1
#		define TIFFRGB		2
#define hSTRIPOffsets				tf[X_STRIPOFFSETS].Thandle
#define iRowsPerStrip				tf[X_ROWSPERSTRIP].val.Tword[0]
#define fXResolution				tf[X_XRESOLUTION].val.Tfloat
#define fYResolution				tf[X_YRESOLUTION].val.Tfloat
#define iPlanar						tf[X_PLANAR].val.Tword[0]
#		define CHUNKY	1	/* RGB RGB RGB */
#		define PLANAR	2	/* RRR GGG BBB, in separate planes */
#define	iGrayUnit					tf[X_GRAYUNIT].val.Tword[0]
#define	hGrayCurve					tf[X_GRAYCURVE].Thandle
#define iResolutionUnit				tf[X_RESOLUTIONUNIT].val.Tword[0]
#		define RES_UNIT_NO_UNIT			1
#		define RES_UNIT_INCH			2
#		define RES_UNIT_CM				3
#define hStripByteCounts			tf[X_STRIPBYTECOUNTS].Thandle
#define hColorCurves				tf[X_COLORCURVES].Thandle
#define iPredictor					tf[X_PREDICTOR].val.Tword[0]
#		define PREDICTOR_NONE			1
#		define PREDICTOR_HDIFF			2

/* shorthands for existence flags
 */
#define eNewSubfileType				tf[X_NEWSUBFILETYPE].Texists
#define eImageWidth					tf[X_IMAGEWIDTH].Texists
#define eImageLength				tf[X_IMAGELENGTH].Texists
#define eSamples					tf[X_SAMPLES].Texists
#define eCompression				tf[X_COMPRESSION].Texists
#define ePhotometricInterpretation	tf[X_PHOTOMETRICINTERP].Texists
#define eStripOffsets				tf[X_STRIPOFFSETS].Texists
#define eXResolution				tf[X_XRESOLUTION].Texists
#define eYResolution				tf[X_YRESOLUTION].Texists
#define ePlanar						tf[X_PLANAR].Texists
#define	eGrayUnit					tf[X_GRAYUNIT].Texists
#define	eGrayCurve					tf[X_GRAYCURVE].Texists
#define eResolutionUnit				tf[X_RESOLUTIONUNIT].Texists
#define eStripByteCounts			tf[X_STRIPBYTECOUNTS].Texists
#define	eColorCurves				tf[X_COLORCURVES].Texists
#define ePredictor					tf[X_PREDICTOR].Texists

/********************* structure definitions *******************/


/* Tiff Field Structure.  An array of these things is the main part of
 * the IMAG structure, below.
 */
typedef struct {
	BOOL	Texists;
	BOOL	Talloc;		/* true if Thandle is being used */
	WORD	Ttag;
	WORD	Ttype;
	DWORD	Tlength;
	HANDLE	Thandle;	/* for things > 4 bytes, except for TIFF RATIONAL */
	union {
		BYTE	Tbyte[4];
		char	Tchar[4];
		WORD	Tword[2];	/* from TIFF SHORT */
		short	Tsigned[2];	/* from TIFF SIGNED */
		DWORD	Tdword;		/* from TIFF LONG */
		float	Tfloat;		/* from TIFF RATIONAL */
	} val;
	DWORD	Tentryoffset;	/* file/memory offset of the TIFF directory
							 * entry.
							 */
} TFIELD;


/* structure containing all available information about an image
 * this structure is never to be written to disk directly; use the 
 * TIFF routines.
 */
typedef struct {
	WORD	iFileType;
#define			INTELTIFF	 (0x4949)
#define			MOTOROLATIFF (0x4d4d)

	WORD	iVersion;
#define			VERSION42	42

	/* THE REAL TIFF FIELDS:
	 */
	TFIELD	tf[NTFIELDS];

} IMAG, FAR * LPIMAG;

/************************** function declarations *************************/

void InitImag ARGS((IMAG *));
void CloseImag ARGS((IMAG *));
RC TfStore ARGS((WORD, WORD, DWORD, LPSTR, TFIELD *));
RC TfCopy ARGS((IMAG *, IMAG *, WORD));