; 1D Modified Huffman compression module interface
; Compatible with Microsoft C

page	66,132


_compress_TEXT	 SEGMENT WORD PUBLIC 'CODE'
	ASSUME	CS:_compress_TEXT


	PUBLIC	_compress_block
	EXTRN	_COMPRESS:NEAR

;  These variables moved from Data segment


RAW_VID_PTR	DW	?		; Pointer to raw video
COMP_PTR	DW	?		; Pointer to compressed video
BYTE_COUNT	DW	?		; Number of compressed bytes
LIN_SCAN_LENGTH DW	?		; Length of one scan line
BLOK_LENGTH	DW	?		; Number of scan lines to compress


;*****************************************************************************;
;									      ;
; COMPRESS_BLOCK - Compress a block of raw image data			      ;
;									      ;
; The following subroutine is used to compress one block of image data and    ;
; to save the compressed image in a caller supplied destination buffer.  If   ;
; compression of the block will result in negative compression (more space    ;
; to store the compressed than the uncompressed image), compression halts     ;
; and a failure flag is returned.					      ;
;									      ;
; "C" calling sequence :                                                      ;
;									      ;
;	int	compress_block()	/* Image block compression routine */ ;
;	char far *raw_video[];		/* Buffer containing raw image */     ;
;	char far *comp_video[];		/* Buffer for compressed image */     ;
;	long	line_length;		/* Length of one scan line */	      ;
;	int	block_length;		/* Number of scan lines in block */   ;
;	   .								      ;
;	   .								      ;
;	   .								      ;
;	count = compress_block (raw_video, comp_video,			      ;
;				line_length, block_length);		      ;
;	if (count == 0) 						      ;
;	   /* Save raw video */ 					      ;
;	else								      ;
;	   /* Save compressed video - number of bytes is in count */	      ;
;									      ;
;*****************************************************************************;
;
_compress_block  PROC	 FAR
;
; Set up stack frame and get input parameters
;
	PUSH	BP
	MOV	BP,SP

; New change

	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES

; End change

	MOV	AX,[BP+6]
	MOV	RAW_VID_PTR,AX

; new addition

	MOV	AX,[BP+8]		; Passed segment goes into DS & ES
;9/12	MOV	DS,AX
	MOV	ES,AX

; new changes

	MOV	AX,[BP+10]		 ; used to be [bp+6]
	MOV	COMP_PTR,AX
	MOV	AX,[BP+12]		; used to be [bp+8]

;9/12	MOV	LIN_SCAN_LENGTH,AX
	mov	ds,ax

	MOV	AX,[BP+14]		; used to be [bp+10]

;9/12	MOV	BLOK_LENGTH,AX
	mov	lin_scan_length,ax

;new addition  9/12

	mov	ax,[bp+18]
	mov	blok_length,ax


; Compress scan lines in block
; Max lines in a block for now is 25.

	MOV	AX,BLOK_LENGTH		; Compute maximum number of bits
	MOV	CX,LIN_SCAN_LENGTH	;   before negative compression
	SHL	CX,1
	SHL	CX,1
	SHL	CX,1
	MUL	CX
	MOV	DX,AX

;	MOV	DX,10240
	XOR	AX,AX			; No residuals yet
	MOV	BYTE_COUNT,0
COMP_LOOP:
	MOV	DI,RAW_VID_PTR		; Set up param's to compression rtn.
	MOV	SI,COMP_PTR
	MOV	CX,LIN_SCAN_LENGTH
	CALL	_COMPRESS
	ADD	BYTE_COUNT,CX		; Update number of compressed bytes
	OR	CX,CX			; Negative compression ?
	JZ	EXIT_COMP		;   Yes, exit with indication
	ADD	COMP_PTR,CX
	MOV	BX,LIN_SCAN_LENGTH
	ADD	RAW_VID_PTR,BX
	DEC	BLOK_LENGTH
	JNZ	COMP_LOOP
;
; If any residual, then add in
;
	MOV	CX,BYTE_COUNT
	OR	AH,AH
	JZ	EXIT_COMP
	MOV	CL,8
	SUB	CL,AH
	SHL	AL,CL
	MOV	BX,COMP_PTR
	MOV	[BX],AL
	INC	BYTE_COUNT
	MOV	CX,BYTE_COUNT
EXIT_COMP:

; new addition

	POP	ES
	POP	DS
	POP	DI
	POP	SI

; end addition

	MOV	AX,CX
	POP	BP
	RET

_compress_block  ENDP

_compress_TEXT	 ENDS
	END
