/***************************************************************************\
*
* PVCS Software Configuration Management Control Information
*
* TIFFW421.C
*
* $Revision:   1.3  $
*
* $Date:   19 Apr 1988 11:06:24  $
*
* $Author:   BOBG  $
*
* $Logfile:   F:/PUBLIC/421/WORK/SRC/TIFFW421.C_V  $
*
* $Log:   F:/PUBLIC/421/WORK/SRC/TIFFW421.C_V  $
*    
*       Rev 1.3   19 Apr 1988 11:06:24   BOBG
*    revise PostScript header and trailer
*    
*       Rev 1.2   15 Apr 1988 17:20:24   BOBG
*    clean up PostScript
*    
*       Rev 1.1   06 Apr 1988 10:10:48   BOBG
*    print options revised
*    
*       Rev 1.0   20 Mar 1988 18:14:40   tomh
*    Initial revision.
*
\***************************************************************************/


/* #include "windows.h" */
/* #include "gawb.h" */
#include "tiffint.h"
/* #include "extfuncs.h" */
#include "prints.h"
#include "wintypes.h"
#include <fcntl.h>
/* #include <stdlib.h> */
#include <stdio.h> 

#undef DEBUG
#undef DBUG
#ifdef DBUG
/* #include <stdio.h> */
#endif

#define QCBUFFSZ 2048

#define L_SHORT 2
#define L_LONG	4
#define L_RATIO 8

#define THRESHOLDING_TAG	0x107

#define FARFMTLINE "%Fs\r\n"

/* Standard C library routines */

int sprintf ();
int open ();
int close ();
int read ();
int write ();
long lseek (int, long, int);
int atoi ();

/* externals from the tiff library */
extern int write_tag();
extern int write_image();
extern int tlpWrite();
extern void close_create();
extern void time();

/* statics defined here */
static int B_RS232File = 1;	/* 0=big or 1=small eps file size */
static PRINTER *pPrintS = NULL;
		
static char pathName[64];
static int sizePSStrings;
/* static int nStringEntries; */

/* forward references */
BOOL InsertPSFile(PSTR, int);
BOOL LoadPSStrings();
int SetupPSStrings();
void NCpyFar();
int GetLine();
void JumpLFCR();
BOOL IsLFCR();
void InitPSStrings();
long converttops();
void write_ps_trailer();
void write_ps_head();

/* library exports */
int TLFileSetup();
int TLImageWrite();
void TLCloseOutput();
int TLSetupPSStrings();

struct ps {
char far * BL;          /*   */
char far * SHOWPAGE;    /* showpage */
char far * GSAVE;       /* gsave  */
char far * GRESTORE;    /* grestore  */
char far * ADD;         /* add */
char far * SUB;         /* sub */
char far * NEG;         /* neg */
char far * EXCH;        /* exch */
char far * PSTYPE;      /* %%!PS-Adobe-2.0 EPSF-1.2 */
char far * BOUNDER;     /* %%%%BoundingBox: %d %d %ld %ld */
char far * CREATE;      /* %%Creator: Publish Pac 2.0  */
char far * TITLE;		/* %%%%Title: %s */
char far * CRDTE;       /* %%%%CreationDate: %s */
char far * ENDCOM;      /* %%EndComments */
char far * TRAILER;     /* %%Trailer */
char far * PIXELHEIGHT; /* /height %d def */
char far * PIXELWIDTH;  /* /width %d def */
char far * NEGHEIGHT;   /* /negheight %d neg def */
char far * DOT;         /* /xdot 72 %ld div def /ydot 72 %ld div def */
char far * GREY_LEVEL;  /* /grey %d def */
char far * THEIMAGE; 	/* /theimage */
char far * ASC_IMG_DEF; /* { width height grey [width 0 0 negheight 0 height] 
                       {currentfile picstr readhexstring pop} image} def */
char far * BIN_IMG_DEF; /* { width height grey [width 0 0 negheight 0 height]
                       {currentfile picstr readstring pop} image} def */
char far * SCALE;       /* width xdot mul %Fs height ydot mul scale */
char far * PICSTRING;   /* /picstr %d string def */
char far * IMAGE_CALL;  /* theimage */
char far * CONCATPROC;  /* /concatprocs { /proc2 exch cvlit def /proc1 exch cvlit def */
char far * CONCAT1;     /* /newproc proc1 length proc2 length add array def */
char far * CONCAT2;     /* newproc 0 proc1 putinterval \n\r newproc proc1 length proc2 putinterval */
char far * CONCAT3;     /* newproc cvx } def */
char far * EXCHV;       /* { 1 exch sub } currenttransfer concatprocs settransfer */
char far * NEGATIV;     /* currenttransfer { 1 exch sub } concatprocs settransfer */
char far * COMPRESSV;   /* { 84 mul 8 add 100 div } currenttransfer concatprocs settransfer */
char far * LIGHTENV;    /* { 90 mul 10 add 100 div } currenttransfer concatprocs settransfer */
char far * DARKENV;     /* { 9 mul 10 div } currenttransfer concatprocs settransfer */
char far * HALFTONE;    /* %d %d { dup mul exch dup mul add 1 %Fs sub } setscreen */
char far * HORZLINE;    /* %d %d { exch pop abs sqrt 2 mul 1 %Fs sub } setscreen */
char far * WAVYLINE;    /* %d %d { exch 180 mul sin .2 mul add 180 mul 4 mul sin %Fs } setscreen */
char far * PAPERCENTER; /* /xpapercntr 306 def  /ypapercntr 396 def */
char far * TRANSLATE;   /* xpapercntr width xdot mul 2 div %Fs  ypapercntr height ydot mul 2 div sub translate */
char far * BLACKNEG;    /* gsave newpath 0 0 moveto 8.5 72 mul 0 rlineto 0 11 72 mul rlineto 8.5 72 mul neg 0 rlineto closepath 
                       0 setgray fill grestore */
char far * LINEWIDTH;   /* %d %d div setlinewidth */
char far * BOXRULE;     /* newpath 0 0 moveto width xdot %Fs mul 0 rlineto 0 height ydot mul rlineto width xdot mul neg %Fs 0 rlineto 
					   closepath stroke */
char far * DOCFONT_HELVB; /* %%DocumentFonts: Helvetica-Bold */
} PS;

/* LPSTR   lpPSStrBuf = (LPSTR)NULL; */
/* HANDLE hPSStrBuf = NULL; */


/* file_setup ***************************************************
	passed parameter fd = output file handle
		       type = type of output
				FF_EPSF Encapsulated PostScript
				FF_TIFF Tiff File
		   image_att = Image Attribute structure
           pPrinterSettings = PrinterSettings struct
                      lpBuf = application-owned storage for PostScript strings
                    sizeBuf = size of Postscript strings buffer
	return parameter
			-1 = error, otherwise the file handle
*****************************************************************/
int TLFileSetup(fd,type,image_att, pPrinterSettings, lpBuf, sizeBuf)
HANDLE fd;
int type;
struct IMG_ATT *image_att;
PRINTER *pPrinterSettings;
LPSTR lpBuf;
int sizeBuf;
{
	int rv;
	int res;
	long wpt;
	long lpt;

	/* cast the file handle as a integer */
	fd = (int) fd;

	pPrintS = pPrinterSettings;

	if(type == FF_EPSF) {
		 			/* make sure buffer is adequate */
		if (lpBuf==(LPSTR)NULL || sizeBuf<sizePSStrings) {
		 	/* close (fd); */
			return (-1);
		}
		/* compute the bounding box */

		wpt = converttops(image_att->imwidth,&(image_att->xresolution));
		lpt = converttops(image_att->imlength,&(image_att->yresolution));

					/* load PostScript strings */
		if (! LoadPSStrings(lpBuf)) {
			/* close (fd); */
			return (-1); 
		}
				/* now write the postscript header to the file */
		write_ps_head(fd,(long)image_att->imwidth,
			(long)image_att->imlength,
			(long)wpt,(long)lpt,
			image_att->bits_sample * image_att->sample_pix,
			&(image_att->path[0]),
			&(image_att->xresolution),
			&(image_att->yresolution),
			image_att->photointerp);

	} else {
		/* create a tiff file */
		res = image_att->resolution;

		if((rv = write_tag(fd,res,TAG_IMWIDTH,
			(LPSTR)&image_att->imwidth,L_SHORT)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if((rv = write_tag(fd,res,TAG_IMLENGTH,
			(LPSTR) &image_att->imlength,L_SHORT)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_BITSPIX,
			(LPSTR)&image_att->bits_sample,L_SHORT)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_COMPRESS,
			(LPSTR)&image_att->compress,L_SHORT)) == NULL ) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_PHOTOINTERP,
			(LPSTR)&image_att->photointerp,L_SHORT)) == NULL ) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_FILLORD,
			(LPSTR)&image_att->fillorder,L_SHORT)) == NULL ) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_ORIENT,
			(LPSTR)&image_att->orient,L_SHORT)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_SAMPIX,
			(LPSTR)&image_att->sample_pix,L_SHORT)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_ROW_STRIP,
			(LPSTR)&image_att->rows_strip,L_LONG)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_MINSAMP,
			(LPSTR)&image_att->min_sample,L_SHORT)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_MAXSAMP,
			(LPSTR)&image_att->max_sample,L_SHORT)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_XRES,
			(LPSTR)&image_att->xresolution,L_RATIO)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if((rv=write_tag(fd,res,TAG_YRES,
			(LPSTR)&image_att->yresolution,L_RATIO)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if((rv = write_tag(fd,res,TAG_PLANAR,
			(LPSTR)&image_att->planarconfig,L_SHORT)) == NULL) {
			/* close(fd); */
			return(-1);
		}

		if(image_att->sample_pix * image_att->bits_sample > 1) {

			if((rv = write_tag(fd,res,TAG_GREYRES,
				(LPSTR)&image_att->grey_res_unit,
					L_SHORT)) == NULL)  {
				/* close(fd); */
				return(-1);
		}

			if((rv = write_tag(fd,res,TAG_GREYCRV,
					(LPSTR)image_att->grey_curve,
					L_SHORT << image_att->bits_sample)) == NULL) {
				/* close(fd); */
				return(-1);
			}
		} else if( image_att->threshhold == 2) {
			/* here is where info to write out cell width and */
			/* height should go */
			/* called only when a 1/2 tone image is output */

			/* default to 651 halftone pattern if one not */
			/* defined */

			if(image_att->cell_length == 0)
				image_att->cell_length = 4;
			if(image_att->cell_width == 0) 
				image_att->cell_width = 8;

			if((rv = write_tag(fd,res,THRESHOLDING_TAG,
				(LPSTR)&image_att->threshhold,
					L_SHORT)) == NULL) {
				/* close(fd); */
				return(-1);
			}

			if((rv = write_tag(fd,res,TAG_CELL_LENGTH,
				(LPSTR)&image_att->cell_length,
					L_SHORT)) == NULL)  {
				/* close(fd); */
				return(-1);
			}
			if((rv = write_tag(fd,res,TAG_CELL_WIDTH,
				(LPSTR)&image_att->cell_width,
					L_SHORT)) == NULL)  {
				/* close(fd); */
				return(-1);
			}
		} else {   /* this is a line art scan */
			if((rv = write_tag(fd,res,THRESHOLDING_TAG,
				(LPSTR)&image_att->threshhold,
					L_SHORT)) == NULL) {
				/* close(fd); */
				return(-1);
			}
		}
	}
	return(fd);
}

long converttops(dots,ratpt)
unsigned short dots;
RATIO *ratpt;
{

	long ldots;
	long factor;

	factor = 72L << 14;		/* multiply points per inch by 16k */

	ldots = ratpt->upper / ratpt->lower;

	ldots = factor / ldots;
	ldots *= (long) dots;

	ldots >>= 14;

	return ldots;
}

void
write_ps_head(fd,dwidth,dlength,pwidth,plength,greybit,fname,xptr,yptr,photointerp)
int fd;
long dwidth;
long dlength;
long pwidth;
long plength;
short greybit;
char *fname;
RATIO *xptr;
RATIO *yptr;
short photointerp;
{

	int num, denom;
	long ltime;
	struct tm *tmst;
	struct tm *localtime();
	char *asctime();
	int count;
	char obuf[145];
	char tbuf[145];
/*	int rotToVert = 0; */


	count = sprintf(obuf, FARFMTLINE, PS.PSTYPE);
	write(fd, obuf, count);

	sprintf(tbuf, FARFMTLINE, PS.BOUNDER);
	count = sprintf(obuf,tbuf,0,0,pwidth,plength);
	write(fd,obuf,count);	/* BOUNDING BOX */

	count = sprintf(obuf, FARFMTLINE, PS.CREATE);
	write(fd,obuf,count);  /* CREATOR */

	sprintf(tbuf, FARFMTLINE, PS.TITLE);
	count = sprintf(obuf, tbuf, fname);
	write(fd,obuf,count);  /* TITLE */

	time(&ltime);	/* get the time */
	tmst = localtime(&ltime);
	sprintf(tbuf, FARFMTLINE, PS.CRDTE);
	count = sprintf(obuf,tbuf,asctime(tmst)); /* creation time */
	write(fd,obuf,count);

	if (pPrintS && pPrintS->formatQCBar) {	/* yes there will be a QC Bar */
		count = sprintf(obuf, FARFMTLINE, PS.DOCFONT_HELVB);
		write(fd, obuf, count);
	}
	count = sprintf(obuf, FARFMTLINE, PS.ENDCOM);
	write(fd, obuf, count);

	count = sprintf (obuf, FARFMTLINE, PS.GSAVE);
	write (fd, obuf, count);

	count = sprintf (obuf, FARFMTLINE, PS.CONCATPROC);
	write (fd, obuf, count);
	count = sprintf (obuf, FARFMTLINE, PS.CONCAT1);
	write (fd, obuf, count);
	count = sprintf (obuf, FARFMTLINE, PS.CONCAT2);
	write (fd, obuf, count);
	count = sprintf (obuf, FARFMTLINE, PS.CONCAT3);
	write (fd, obuf, count);

	sprintf(tbuf, FARFMTLINE, PS.GREY_LEVEL);
	count = sprintf(obuf, tbuf, greybit);
	write(fd,obuf,count);

	sprintf(tbuf, FARFMTLINE, PS.PIXELHEIGHT);
	count = sprintf(obuf, tbuf, dlength  );
	write(fd,obuf,count);

	sprintf(tbuf, FARFMTLINE, PS.PIXELWIDTH);
	count = sprintf(obuf, tbuf, dwidth);
	write(fd,obuf,count);

	sprintf(tbuf, FARFMTLINE, PS.NEGHEIGHT);
	count = sprintf(obuf, tbuf, dlength);
	write(fd,obuf,count);

	sprintf(tbuf, FARFMTLINE, PS.DOT);
	count = sprintf(obuf, tbuf, xptr->upper, yptr->upper);
	write(fd,obuf,count);

	sprintf(tbuf, FARFMTLINE, PS.PICSTRING);
	count = sprintf(obuf, tbuf, (((dwidth * greybit) +7) / 8));
	write(fd,obuf,count);

	count = sprintf(obuf, FARFMTLINE, PS.PAPERCENTER);
	write(fd, obuf, count);


			 				/* if there is a valid printer settings pointer */
							/* halftoning, polarity, transfer are specified */
	if (pPrintS != (PRINTER *)NULL) {

		if (pPrintS->imageData == ID_DATAASCII)
			B_RS232File = 0;
		else
			B_RS232File = 1;
											/* negPrintPolarity? */
		if((pPrintS->outptPolarity == ID_NEGATIVEPOL) || 
							  (pPrintS->outptPolarity == ID_FLOPFILMNEG)) {
			count = sprintf(obuf, FARFMTLINE, PS.BLACKNEG);
			write(fd, obuf, count);
		}			

		if (pPrintS->formatQCBar)	/* yes do a QC Bar */
							/* dont fail because of InsertQCBar error */
			if (pPrintS->outptPolarity == ID_FLOPFILMNEG ||
				pPrintS->outptPolarity == ID_POSPAPERPLATE)
				InsertPSFile("QCBARPN.PS", fd);
			else
				InsertPSFile("QCBAROPQ.PS", fd);

							/*write the appropriate setscreen instructn line*/
		count = 0;
		switch (pPrintS->screenPatt) {
			case ID_SCRNHALFTONE :
			case ID_SCRNMEZZOTINT :
				sprintf(tbuf, FARFMTLINE, PS.HALFTONE);
				count = sprintf(obuf, tbuf, pPrintS->screenFreq,
						 pPrintS->screenAngl,
						 (pPrintS->outptPolarity==ID_POSITIVEPOL ||
						  pPrintS->outptPolarity==ID_POSPAPERREPRO ||
						  pPrintS->outptPolarity==ID_POSPAPERPLATE) ? 
															PS.EXCH : PS.BL );
#ifdef DBUG
fprintf(stdprn, "halftone screen function %d chars,\n\t%s\n",count ,obuf);
#endif
				break;
			case ID_SCRNLINE :
				sprintf(tbuf, FARFMTLINE, PS.HORZLINE);
				count = sprintf(obuf, tbuf, pPrintS->screenFreq,
						pPrintS->screenAngl+pPrintS->deviceRot/*+rotToVert*/,
						 (pPrintS->outptPolarity==ID_POSITIVEPOL ||
						  pPrintS->outptPolarity==ID_POSPAPERREPRO ||
						  pPrintS->outptPolarity==ID_POSPAPERPLATE) ? 
															PS.EXCH : PS.BL );
				break;
			case ID_SCRNWAVYLINE :
				sprintf(tbuf, FARFMTLINE, PS.WAVYLINE);
				count = sprintf(obuf, tbuf, (pPrintS->screenFreq + 2) / 4 ,
						pPrintS->screenAngl,
						 (pPrintS->outptPolarity==ID_POSITIVEPOL ||
						  pPrintS->outptPolarity==ID_POSPAPERREPRO ||
						  pPrintS->outptPolarity==ID_POSPAPERPLATE) ? 
															PS.EXCH : PS.BL );
				break;
#ifdef COMMENTOUT
*			case ID_SCRNDASHES :
*				count = sprintf(obuf, DASHES1, 	
*						(pPrintS->screenFreq + 2) / 3,
*						pPrintS->screenAngl,
*						pPrintS->outptPolarity==ID_POSITIVEPOL ? PS.BL : PS.NEG );
*				write (fd, obuf, count);						
*				count = sprintf(obuf, DASHES2);
*				write (fd, obuf, count);						
*				count = sprintf(obuf, DASHES3, 	
*						pPrintS->outptPolarity==ID_POSITIVEPOL ? PS.BL : PS.NEG );
*				write (fd, obuf, count);
*				count = sprintf(obuf, DASHES4); 	
*				write (fd, obuf, count);
*				count = sprintf(obuf, DASHES5, 	
*						pPrintS->outptPolarity==ID_POSITIVEPOL ? PS.BL : PS.NEG );
*				write (fd, obuf, count);	
*				count = sprintf(obuf, DASHES6); 	
*
*			case ID_SCRNELLIP.DOT :
*				count = sprintf(obuf, ELLIPDOT, pPrintS->screenFreq,
*						 pPrintS->screenAngl,
*						 pPrintS->outptPolarity==ID_POSITIVEPOL ? PS.EXCH : PS.BL );
*				break;
#endif
			default :
				break;
		}
		if (count) {
			write (fd, obuf, count);		/* setscreen instruction line */
#ifdef DBUG
fprintf(stdprn, "whatever screen function %d chars,\n\t%s\n",count ,obuf);
#endif
		}


		if((pPrintS->outptPolarity == ID_NEGATIVEPOL) || 
							  (pPrintS->outptPolarity == ID_FLOPFILMNEG)) {
			count = sprintf(obuf, FARFMTLINE, PS.NEGATIV);
			write (fd, obuf, count);		/* inverse after transfer */
		}

/* 		if (pPrintS->formatCropM) {
/*			count = sprintf(obuf, PS.LINEWIDTH, 1, 2);
/*			write(fd, obuf, count);
/*			write(fd, CROPM, strlen(CROPM));
/*		} */

		if (pPrintS->formatBox) {
			if (pPrintS->formatBox == ID_BOXMED) {
				num = 2; denom = 1;
			} else
				if (pPrintS->formatBox == ID_BOXTHICK) {
					num = 7; denom = 2;
				} else {
					num = 2; denom = 3;
				}
					
			sprintf(tbuf, FARFMTLINE, PS.LINEWIDTH);
			count = sprintf(obuf, tbuf, num, denom);
			write(fd, obuf, count);
		}
		
#ifdef DBUG
fprintf (stdprn, "just checking validity before filing GSAVE\n\t%Fs\n", PS.GSAVE);
#endif
		count = sprintf(obuf, FARFMTLINE, PS.GSAVE);
		write(fd, obuf, count);

		sprintf(tbuf, FARFMTLINE, PS.TRANSLATE);
		count = sprintf(obuf, tbuf, 
					pPrintS->outptPolarity==ID_FLOPFILMNEG ? PS.ADD : PS.SUB );
		write(fd, obuf, count);

		sprintf(tbuf, FARFMTLINE, PS.SCALE);
		count = sprintf(obuf, tbuf,
					pPrintS->outptPolarity==ID_FLOPFILMNEG ? PS.NEG : PS.BL );
		write(fd, obuf, count);

							/*write the appropriate settransfer instrn line */
		switch (pPrintS->grayExpan) {
			case ID_NORMALGRAY :
				break;
			case ID_COMPRESSGRAY :
				count = sprintf(obuf, FARFMTLINE, PS.COMPRESSV);
				write(fd, obuf, count);
				break;
			case ID_LIGHTENGRAY :
				count = sprintf(obuf, FARFMTLINE, PS.LIGHTENV);
				write(fd, obuf, count);
				break;
			case ID_DARKENGRAY :
				count = sprintf(obuf, FARFMTLINE, PS.DARKENV);
				write(fd, obuf, count);
				break;
			default :
				break;
		}
	} else {								/* no printer settings */

		count = sprintf(obuf, FARFMTLINE, PS.GSAVE);
		write(fd, obuf, count);

		sprintf(tbuf, FARFMTLINE, PS.TRANSLATE);
		count = sprintf(obuf, tbuf, PS.SUB) ;
		write(fd, obuf, count);

		sprintf(tbuf, FARFMTLINE, PS.SCALE);
		count = sprintf(obuf, tbuf, PS.BL);
		write(fd, obuf, count);
	}

	if (!photointerp) {
		count = sprintf (obuf, FARFMTLINE, PS.EXCHV); /* inverse before transfer*/
		write(fd, obuf, count);
	}

	count = sprintf (obuf, FARFMTLINE, PS.THEIMAGE);
	write(fd, obuf, count);

	if(!B_RS232File) {
		count = sprintf(obuf,FARFMTLINE, PS.ASC_IMG_DEF);
	} else {
		count = sprintf(obuf,FARFMTLINE, PS.BIN_IMG_DEF);
	}
	write(fd,obuf,count);

	count = sprintf (obuf, FARFMTLINE, PS.GSAVE);
	write(fd, obuf, count);
											       /* before data leave */
	count = sprintf (obuf, "%Fs ", PS.IMAGE_CALL); /* exactly 1 BL, no LFCR */
	write(fd, obuf, count);

}

/* image_write ***************************************************
	passed parameters  fd = integer value for file handle
			 type = Encapsulated PostScript or Tiff
			plane = PLANE_1
		     startpos = starting position within the file
			lines = number of lines handle
		      databuf = buffer from which to pull data
	       bytes_per_line = number of bytes per line
	return
		 number of lines written
******************************************************************/
int TLImageWrite(fd,type,plane,startpos,lines,databuf,bytes_per_line)
int fd;
int type;
short plane;
long startpos;
long lines;
LPSTR databuf;
long bytes_per_line;
{

	int ij,ic;
	char c;
	long retval;
	LPSTR buffer;
	LPSTR bigalloc();
	void bigfree();

	/* if encapsulated postscript, take the passed data,
	   and write it to the disk. */

	if(type == FF_EPSF) {
		retval = lines;

		/* if encapsulated postscript, take the passed data,
		   and write it to the disk. */

		/* encapsulated postscript file may not be updated,
			therefor the data that is passed to this function
			in multiple calls, must be in sequence.  That is,
			the data passed to this function to be written to
			an epsf file, should start at scan line 0.  If the
			function is passed 10 scan lines, the next call to
			the function should be passed the data for lines 11
			through 21.  And so on to the end of the image.
		*/

	/* if were sending to a laser writer over a RS-232 line, */
	/* then the data must consist of printable ascii characters */
	/* B_RS232File = 0 is big file (default) 1 is little file */

		if(!B_RS232File) {
 			buffer = (LPSTR)bigalloc(bytes_per_line * 2);
 			while(lines > 0 ) {
 				for(ic = 0, ij = 0; ic < bytes_per_line;ic++) {
 					c = (databuf[ic] >> 4) & 0xf;
 					if(c <=9) {
 						buffer[ij++] = c | 0x30;
 					} else {
 						buffer[ij++] = c + 55;
 					}
 					c = databuf[ic] & 0xf;
 					if(c <=9) {
 						buffer[ij++] = c | 0x30;
 					} else {
 						buffer[ij++] = c + 55;
 						}
 				}
 				
 				tlpWrite(fd,(LPSTR)buffer,bytes_per_line * 2);
 				databuf+=bytes_per_line;
 				lines--;
 			}
 			bigfree(buffer); 
			return((int) retval);
		} else {
	
			tlpWrite(fd,(LPSTR)databuf,bytes_per_line*lines);
			return ((int) retval);
		}
	} else {

		return((int)(write_image(fd,FULL_RES,plane,
				startpos,lines,databuf)));
	}
}

void TLCloseOutput(fdes,type)
int fdes;
int type;
{
	if ( type == FF_EPSF) {
		write_ps_trailer(fdes);
		/* close(fdes); */
		/* FreePSStrings(); */
	} else {
		close_create(fdes);
		 /* close(fdes); */
	}
}

void write_ps_trailer(fdes)
int fdes;
{
	int count;
	char obuf[145];
	char tbuf[145];

	count = sprintf (obuf, FARFMTLINE, PS.GRESTORE);
	write(fdes, obuf, count);
	count = sprintf (obuf, FARFMTLINE, PS.GRESTORE);
	write(fdes, obuf, count);
	if (pPrintS != (PRINTER *)NULL) { 
		if (pPrintS->formatBox) {
			sprintf(tbuf, FARFMTLINE, PS.TRANSLATE);
			count = sprintf(obuf, tbuf,
						pPrintS->outptPolarity==ID_FLOPFILMNEG ? PS.ADD : PS.SUB );
			write(fdes, obuf, count);
			sprintf(tbuf, FARFMTLINE, PS.BOXRULE);
			count = sprintf(obuf, tbuf,
						pPrintS->outptPolarity==ID_FLOPFILMNEG ? PS.NEG : PS.BL ,
						pPrintS->outptPolarity==ID_FLOPFILMNEG ? PS.NEG : PS.BL );
			write(fdes, obuf, count);
		} 
	}
	count = sprintf (obuf, FARFMTLINE, PS.SHOWPAGE);
	write(fdes, obuf, count);
	count = sprintf (obuf, FARFMTLINE, PS.GRESTORE);
	write(fdes, obuf, count);
	count = sprintf (obuf, FARFMTLINE, PS.TRAILER);
	write(fdes, obuf, count);

}
							/* copy an entire PostScript file to output file*/
BOOL						/* return success flag */
InsertPSFile(sInFName, fdOut)
PSTR sInFName;
int fdOut;
{
	char fileName[64];
	char pBuf[QCBUFFSZ];
	int fdIn;
	long inFLen;

	sprintf(fileName, "%s%s",  pathName, sInFName);

	if ((fdIn = open (fileName, O_RDONLY | O_BINARY)) < 0) {
#ifdef DBUG
fprintf(stdprn, "IPS open fails\n");
#endif
		return (FALSE);
	}

	inFLen = lseek(fdIn, 0L, 2);
	lseek (fdIn, 0L, 0);
	while (1)
		if (inFLen < (long)QCBUFFSZ) {
			read (fdIn, pBuf, (int)inFLen);
			write (fdOut, pBuf, (int)inFLen); 
			break;
		} else {
			read (fdIn, pBuf, QCBUFFSZ);
			write (fdOut, pBuf, QCBUFFSZ);
			inFLen -= (long)QCBUFFSZ;
			if (inFLen < 1L)
				break;
		}
	close(fdIn);
	return (TRUE);
}

void
InitPSStrings(lpPSStrBuf, countPSStrs)
LPSTR lpPSStrBuf;
int countPSStrs;
{
	int i;
	for (i = 0; i < countPSStrs; i++)
	  *((char far * *)&PS+i) = lpPSStrBuf;
}



BOOL
IsLFCR(c)
int c;
{
	return (c=='\n' || c=='\r');
}

void
JumpLFCR(pF)
FILE *pF;
{
	int c;
	while (IsLFCR(c=fgetc(pF)))
		;
	if (c != EOF)
		ungetc(c, pF);
}

   						/* get a line from file in buf*/
						/* no \n, \r */
						/* null terminate string */
						/* position on next line */
int						/* return character count */
GetLine(pF, buf)
FILE *pF;
char * buf;
{
	int c;
	char * pmB = buf;  					/* movable buffer pointer */
	while ((c = fgetc(pF)) != EOF) {
		if (! IsLFCR(c))
			*pmB++ = (char)c;
		else {
			*pmB = '\0';				/* terminate string */
			JumpLFCR(pF);
			break;
		}
	}
	return (pmB - buf);
}

void
NCpyFar(lpTo, pFrom, nMany)
char far *lpTo;
char *pFrom;
int nMany;
{
	for( ; nMany; nMany--)
		*lpTo++ = *pFrom++;
}

BOOL		   				/* return success flag */
LoadPSStrings(lpPSStrBuf)
LPSTR lpPSStrBuf;
{
	int countFileStrs = 0;
	int i;
	int bufSize = 0;
	int lineLen;
	char lineBuf[144];
	char far * lpmB;				/* movable pointer */
	FILE * pF;	
	char fileName[64];
	int cnt;

	sprintf(fileName, "%s%s",  pathName, "STRINGS.PS");

	if ((pF = fopen(fileName, "rb")) == NULL) {

		pathName[0] = '\0';
		return (FALSE);
	}
	if (GetLine(pF, lineBuf) > 0)	
		countFileStrs = atoi(lineBuf);
	InitPSStrings(lpPSStrBuf, countFileStrs);
#ifdef DOOBUG
fprintf(stdprn, "after init: ");
fprintf(stdprn, "SHOWPAGE = %s\n", PS.SHOWPAGE);
fprintf(stdprn, "ASC_IMG_DEF = %s\n", PS.ASC_IMG_DEF);
#endif

#ifdef DOOBUG
fprintf (stdprn, "Again, file string count is %d\n", atoi(lineBuf));
#endif

	lpmB = lpPSStrBuf;
	for (i = 0 ; i < countFileStrs; i++) {
		GetLine(pF, lineBuf);		/* the symbol */
		lineLen = GetLine(pF, lineBuf);	/* get the string */
		 						/* be sure not to exceed allocated buffsize */
		if (((lpmB + lineLen) - lpPSStrBuf) > sizePSStrings) {
#ifdef DBUG
fprintf (stdprn, "LoadPSStrings exceeds buffer allocation\n");
#endif
	  		fclose(pF);
			return (FALSE);
		}
	    NCpyFar (lpmB, lineBuf, lineLen);   /* copy into far strings buffer */
/* 		strncpy(lpmB, lineBuf, lineLen); */  /* copy into strings buffer */
	   *((char far **)&PS+i) = lpmB;		/* tell struct member where */

#ifdef DOOBUG
fprintf ( stdprn, "\tGot %d char line: %Fs\n", lineLen, (*((char far **)&PS +i)));
#endif
		lpmB += lineLen;			/* update pointer */
		*lpmB++ = '\0';			/* terminate string, upd ptr */
	}
	fclose (pF);
	return (TRUE);
}


		 		/* call before FileSetup for EPS files */
				/* opens, reads size, closes strings file */
				/* checks #entries against exact sizeof PS */
				/* library keeps filesize & path */
				/* return size of buffer needed for strings */
int				/* or 0 onerr */
TLSetupPSStrings (pstrPath)
PSTR pstrPath;
{
	int i;
	int nStringEntries;
	char lineBuf[144];
	FILE * pF;	
	int cnt;
	char fileName[64];

	sprintf(pathName, pstrPath);	/* save path for future reference */
	sprintf(fileName, "%s%s",  pathName, "STRINGS.PS");
#ifdef DEBUG
fprintf(stdprn, "TLSPSS got pathName %s\n", pathName);
fprintf(stdprn, "full path fileName is %s\n", fileName);
#endif
	if ((pF = fopen(fileName, "rb")) == NULL) {
#ifdef DEBUG
fprintf(stdprn, "TLSPSS fopen strings.ps failed\n");
#endif
		pathName[0] = '\0';
		return (0);
	}
	if (GetLine(pF, lineBuf) > 0)		/* make sure count is there*/
		nStringEntries = atoi(lineBuf);
	else {
		pathName[0] = '\0';
		fclose (pF);
		return (0);
	}
						/* make sure count agrees */
	if (nStringEntries != sizeof(PS) / sizeof(LPSTR)) {
#ifdef DBUG
fprintf(stdprn, "TLSPSS nStringEntries=%d disagrees with size of PS=%d\n",
					nStringEntries, sizeof(PS) / sizeof(LPSTR));
#endif
		pathName[0] = '\0';
		fclose (pF);
		return (0);
	}		
	sizePSStrings = 0;			/* initialize accumulator */
				/* measure total length PostScript strings */
	for (i = 0 ; i < nStringEntries; i++) {
		GetLine(pF, lineBuf);		/* the symbol */
		cnt = GetLine(pF, lineBuf); /* the PostScript string */
		if (cnt)			
			sizePSStrings += cnt+1;
		else {				/* unexpected end of data */
#ifdef DBUG
fprintf(stdprn, "TLSPSSunexpected end of data\n");
#endif
			sizePSStrings = 0;	/* something is wrong */
			pathName[0] = '\0';
			break;
		}
	}
	fclose (pF);				/* close for now */
	return (sizePSStrings);			/* and keep as semi-global */
}
	
