memM = 1
?WIN = 0
?PLM = 0

include cmacros.inc

	EXTRN	_bytes_processed:dword

;****************************************************************************;
;									     ;
; DECOMPRESS_BLOCK - Decompress a block of raw image data		     ;
;									     ;
; The following subroutine is used to decompress one block of image data and ;
; to save the raw image in a caller supplied destination buffer.	     ;
;									     ;
; "C" calling sequence :                                                     ;
;									     ;
;	int	decompress_block();	/* Image block compression routine */;
;	char	raw_video[];		/* Buffer containing raw image */    ;
;	char	cdata[];		/* Buffer containing compressed data ;
;	int	line_length;		/* Length of one scan line */	     ;
;	int	block_length;		/* Number of scan lines in block */  ;
;	   .								     ;
;	   .								     ;
;	   .								     ;
;	decompress_block (raw_video,cdata,line_length, block_length);	     ;
;									     ;
;****************************************************************************;
;
createSeg	_dcompres_TEXT,dcompres_TEXT,BYTE,PUBLIC,CODE

sBegin	dcompres_TEXT

	assumes	CS,_dcompres_TEXT
	assumes DS,DATA

	PUBLIC	_decompress_block
	PUBLIC	_srcbuff
	PUBLIC  _endbuff

	EXTRN	_dcompres:FAR

_srcbuff	DW	0
		DW	0
_endbuff	DW	0

cProc	decompress_block,<PUBLIC,FAR>,<si,di,es>
parmD	raw_video
parmD	cdata
parmW	line_len
parmD	blocklen
parmD	bytes_in_strip
cBegin	decompress_block

	MOV	AX,SEG_raw_video ; load the segment register with
	MOV	ES,AX		 ; the segment of the destination

	mov	ax,OFF_cdata		; get the compressed data addr
	mov	cs:_srcbuff,ax		; and put it away
	mov	ax,SEG_cdata		; 
	mov	cs:_srcbuff+2,ax		;
	mov	ax,OFF_bytes_in_strip	; get the bytes in the strip
					; so that we may tell the 
					; decompressor when to stop
	add	ax,cs:_srcbuff		; and put the value in endbuff
	mov	cs:_endbuff,ax	


;
; decompress decompresses one scan line at a time. the huffman code
; for a scan line may end in the middle of a byte.  If it does, the 
; algorithm needs to throw the remainder of that byte away before 
; starting to decompress the next scan line.  The second xor ax,ax
; does just that.
; 

;
; Decompress scan lines in block
;
	XOR	AX,AX			; No residuals yet
	MOV	WORD PTR ds:_bytes_processed,AX ; initialize byte count
	MOV	WORD PTR ds:_bytes_processed+2,AX
DECOMP_LOOP:
	XOR	AX,AX			; get rid of the residuals
	MOV	DI,OFF_raw_video	; Set up param's to compression rtn.
	MOV	CX,line_len		; move the length of the line to cx
	CALL	_DCOMPRES		; now decompress the scan line

;1/14/87
					; convert the pixels processed
	add	cx,7			; into bytecount
	shr	cx,1
	shr	cx,1
	shr	cx,1

	ADD	WORD PTR ds:_bytes_processed, CX	; increment byte count
	ADC	WORD PTR ds:_bytes_processed+2, 0

	ADD	OFF_raw_video,cx
	DEC	OFF_blocklen
	JNZ	DECOMP_LOOP
EXIT_COMP:
	MOV	AX,WORD PTR ds:_bytes_processed
	MOV	DX,WORD PTR ds:_bytes_processed+2
cEnd	decompress_block

sEnd 	dcompres_TEXT
END
