#!/bin/sh
# The shell command to remove <CR>'s (if present) from this file are:
# $ tr -d "\015" < pc2unix.sh > xx
# $ mv xx pc2unix.sh
# Or, you may use vi or any other editor.

BACKSLASH='\\'

# Run this command to remove the <CR> character from the pair <CR><LF>
# inserted in text files on the PC.
# Used to make the PC files palatable to a UNIX system.
# This program also moves the font files around, since they are handled
# diferently on an UNIX system (mainly because file name's
# on an UNIX system may be longer than on PC systems......)

FILES="./changes
./copyrt
./doc/dvnc.itx
./doc/dvng.itx
./doc/dvnc.ps
./doc/dvng.ps
./doc/flag.ips
./doc/flag.ps
./doc/idoc.itx
./doc/idoc.ps
./doc/nehru.itx
./doc/vnehru.itx
./doc/readme.doc
./doc/s1.ips
./doc/s1.itx
./doc/s2.ips
./doc/s2.itx
./doc/s3.ips
./doc/s3.itx
./doc/s4.itx
./doc/s5.itx
./doc/sgaon.itx
./doc/sgaon.ps
./doc/tamil.itx
./doc/tamil.ps
./doc/tech.tex
./doc/tlgutx.itx
./doc/tlgutx.ps
./install.pc
./install.unx
./filelist
./lib/devnac.afm
./lib/dvnc.ifm
./lib/mdvnc.ifm
./lib/dvng.ifm
./lib/dvpn10.mf
./lib/mdvng.ifm
./lib/devnac.ps
./lib/dvipsrc
./lib/itrans.pro
./lib/itrnstlg.tex
./lib/psfonts.map
./lib/readme.lib
./lib/sgaonpk.ifm
./lib/shenv
./lib/tamil.mf
./lib/tamilmax.mf
./lib/tlgutx.ifm
./lib/wntamil.mf
./lib/wntml.ifm
./lib/wntml10.mf
./lib/wntml12.mf
./lib/wntml17.mf
./psfiles
./readme
./src/deansify.c
./src/dodeans
./src/dflt_mkl.c
./src/font.c
./src/ichar.c
./src/ifm.h
./src/ilex.l
./src/imap.h
./src/iother.c
./src/itops.c
./src/itotex.c
./src/itrans.1
./src/itrans.c
./src/itrans.h
./src/itrans.man
./src/iyacc.y
./src/lexyyc
./src/makefile.bcc
./src/makefile.unx
./src/marker.c
./src/pifm.c
./src/prips
./src/prips.1
./src/prips.man
./src/tfmload.c
./src/tmil_mkl.c
./src/tlgu_mkl.c
./src/utils.c
./src/ytabc
./src/ytabh
./version.h"

echo "Removing the CR character in these files..."
for i in $FILES
do
    echo File: $i
    chmod +rw $i
    tr -d "\015" < $i > xxx.xxx
    mv xxx.xxx $i
done

echo Copying the wntmlpk files to lib from lib/300dpi
echo "(This is the Tamil font.)"

cp lib/300dpi/wntml10.pk lib/wntml10.300pk
cp lib/300dpi/wntml12.pk lib/wntml12.300pk
cp lib/300dpi/wntml17.pk lib/wntml17.300pk

# Bengali font is not bundled with ITRANS - could not contact
# original copyright holder to obtain permission, so
# users have to get the sgaon.zip package themselves.
# cp lib/300dpi/bng10rpn.pk lib/bng10rpn.300pk
# cp lib/300dpi/bn100rpn.pk lib/bn100rpn.300pk
# cp lib/300dpi/bn100ipn.pk lib/bn100ipn.300pk
# rmdir lib/300dpi

echo "pc2unix: All done"
exit 0
